// services/shape_detection/public/mojom/textdetection.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_TEXTDETECTION_MOJOM_BLINK_H_
#define SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_TEXTDETECTION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/shape_detection/public/mojom/textdetection.mojom-features.h"  // IWYU pragma: export
#include "services/shape_detection/public/mojom/textdetection.mojom-shared.h"  // IWYU pragma: export
#include "services/shape_detection/public/mojom/textdetection.mojom-blink-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace shape_detection::mojom::blink {

class TextDetectionProxy;

template <typename ImplRefTraits>
class TextDetectionStub;

class TextDetectionRequestValidator;
class TextDetectionResponseValidator;


class TextDetection
    : public TextDetectionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "shape_detection.mojom.TextDetection";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TextDetectionInterfaceBase;
  using Proxy_ = TextDetectionProxy;

  template <typename ImplRefTraits>
  using Stub_ = TextDetectionStub<ImplRefTraits>;

  using RequestValidator_ = TextDetectionRequestValidator;
  using ResponseValidator_ = TextDetectionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDetectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Detect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TextDetection() = default;

  using DetectCallback = base::OnceCallback<void(::blink::Vector<TextDetectionResultPtr>)>;
  using DetectMojoCallback = base::OnceCallback<void(::blink::Vector<TextDetectionResultPtr>)>;

  virtual void Detect(const ::SkBitmap& bitmap_data, DetectCallback callback) = 0;
};



class  TextDetectionProxy
    : public TextDetection {
 public:
  using InterfaceType = TextDetection;

  explicit TextDetectionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Detect(const ::SkBitmap& bitmap_data, DetectCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TextDetectionStubDispatch {
 public:
  static bool Accept(TextDetection* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TextDetection* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TextDetection>>
class TextDetectionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TextDetectionStub() = default;
  ~TextDetectionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TextDetectionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TextDetectionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TextDetectionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TextDetectionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  TextDetectionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TextDetectionResult, T>::value>;
  using DataView = TextDetectionResultDataView;
  using Data_ = internal::TextDetectionResult_Data;

  template <typename... Args>
  static TextDetectionResultPtr New(Args&&... args) {
    return TextDetectionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TextDetectionResultPtr From(const U& u) {
    return mojo::TypeConverter<TextDetectionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TextDetectionResult>::Convert(*this);
  }


  TextDetectionResult();

  TextDetectionResult(
      const ::blink::String& raw_value,
      const ::gfx::RectF& bounding_box,
      ::blink::Vector<::gfx::PointF> corner_points);


  ~TextDetectionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TextDetectionResultPtr>
  TextDetectionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TextDetectionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TextDetectionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TextDetectionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TextDetectionResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TextDetectionResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TextDetectionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TextDetectionResult_UnserializedMessageContext<
            UserType, TextDetectionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TextDetectionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TextDetectionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TextDetectionResult_UnserializedMessageContext<
            UserType, TextDetectionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TextDetectionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String raw_value;
  
  ::gfx::RectF bounding_box;
  
  ::blink::Vector<::gfx::PointF> corner_points;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TextDetectionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TextDetectionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TextDetectionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TextDetectionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TextDetectionResultPtr TextDetectionResult::Clone() const {
  return New(
      mojo::Clone(raw_value),
      mojo::Clone(bounding_box),
      mojo::Clone(corner_points)
  );
}

template <typename T, TextDetectionResult::EnableIfSame<T>*>
bool TextDetectionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->raw_value, other_struct.raw_value))
    return false;
  if (!mojo::Equals(this->bounding_box, other_struct.bounding_box))
    return false;
  if (!mojo::Equals(this->corner_points, other_struct.corner_points))
    return false;
  return true;
}

template <typename T, TextDetectionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.raw_value < rhs.raw_value)
    return true;
  if (rhs.raw_value < lhs.raw_value)
    return false;
  if (lhs.bounding_box < rhs.bounding_box)
    return true;
  if (rhs.bounding_box < lhs.bounding_box)
    return false;
  if (lhs.corner_points < rhs.corner_points)
    return true;
  if (rhs.corner_points < lhs.corner_points)
    return false;
  return false;
}


}  // shape_detection::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::shape_detection::mojom::blink::TextDetectionResult::DataView,
                                         ::shape_detection::mojom::blink::TextDetectionResultPtr> {
  static bool IsNull(const ::shape_detection::mojom::blink::TextDetectionResultPtr& input) { return !input; }
  static void SetToNull(::shape_detection::mojom::blink::TextDetectionResultPtr* output) { output->reset(); }

  static const decltype(::shape_detection::mojom::blink::TextDetectionResult::raw_value)& raw_value(
      const ::shape_detection::mojom::blink::TextDetectionResultPtr& input) {
    return input->raw_value;
  }

  static const decltype(::shape_detection::mojom::blink::TextDetectionResult::bounding_box)& bounding_box(
      const ::shape_detection::mojom::blink::TextDetectionResultPtr& input) {
    return input->bounding_box;
  }

  static const decltype(::shape_detection::mojom::blink::TextDetectionResult::corner_points)& corner_points(
      const ::shape_detection::mojom::blink::TextDetectionResultPtr& input) {
    return input->corner_points;
  }

  static bool Read(::shape_detection::mojom::blink::TextDetectionResult::DataView input, ::shape_detection::mojom::blink::TextDetectionResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_TEXTDETECTION_MOJOM_BLINK_H_