// services/on_device_model/public/mojom/on_device_model.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_TEST_UTILS_H_
#define SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_TEST_UTILS_H_

#include "services/on_device_model/public/mojom/on_device_model.mojom.h"


namespace on_device_model::mojom {


class  StreamingResponderInterceptorForTesting : public StreamingResponder {
  virtual StreamingResponder* GetForwardingInterface() = 0;
  void OnResponse(ResponseChunkPtr chunk) override;
  void OnComplete(ResponseSummaryPtr summary) override;
};
class  StreamingResponderAsyncWaiter {
 public:
  explicit StreamingResponderAsyncWaiter(StreamingResponder* proxy);

  StreamingResponderAsyncWaiter(const StreamingResponderAsyncWaiter&) = delete;
  StreamingResponderAsyncWaiter& operator=(const StreamingResponderAsyncWaiter&) = delete;

  ~StreamingResponderAsyncWaiter();

 private:
  StreamingResponder* const proxy_;
};


class  ContextClientInterceptorForTesting : public ContextClient {
  virtual ContextClient* GetForwardingInterface() = 0;
  void OnComplete(uint32_t tokens_processed) override;
};
class  ContextClientAsyncWaiter {
 public:
  explicit ContextClientAsyncWaiter(ContextClient* proxy);

  ContextClientAsyncWaiter(const ContextClientAsyncWaiter&) = delete;
  ContextClientAsyncWaiter& operator=(const ContextClientAsyncWaiter&) = delete;

  ~ContextClientAsyncWaiter();

 private:
  ContextClient* const proxy_;
};


class  SessionInterceptorForTesting : public Session {
  virtual Session* GetForwardingInterface() = 0;
  void Append(AppendOptionsPtr options, ::mojo::PendingRemote<ContextClient> client) override;
  void Generate(GenerateOptionsPtr options, ::mojo::PendingRemote<StreamingResponder> responder) override;
  void GetSizeInTokens(InputPtr input, GetSizeInTokensCallback callback) override;
  void Score(const std::string& text, ScoreCallback callback) override;
  void Clone(::mojo::PendingReceiver<Session> session) override;
  void GetProbabilitiesBlocking(const std::string& text, GetProbabilitiesBlockingCallback callback) override;
  void SetPriority(Priority priority) override;
  void AsrStream(AsrStreamOptionsPtr options, ::mojo::PendingReceiver<AsrStreamInput> stream, ::mojo::PendingRemote<AsrStreamResponder> responder) override;
};
class  SessionAsyncWaiter {
 public:
  explicit SessionAsyncWaiter(Session* proxy);

  SessionAsyncWaiter(const SessionAsyncWaiter&) = delete;
  SessionAsyncWaiter& operator=(const SessionAsyncWaiter&) = delete;

  ~SessionAsyncWaiter();
  void GetSizeInTokens(
      InputPtr input, uint32_t* out_size);
  uint32_t GetSizeInTokens(InputPtr input);
  void Score(
      const std::string& text, float* out_probability);
  float Score(const std::string& text);
  void GetProbabilitiesBlocking(
      const std::string& text, std::vector<float>* out_probabilities);
  std::vector<float> GetProbabilitiesBlocking(const std::string& text);

 private:
  Session* const proxy_;
};


class  OnDeviceModelInterceptorForTesting : public OnDeviceModel {
  virtual OnDeviceModel* GetForwardingInterface() = 0;
  void StartSession(::mojo::PendingReceiver<Session> session, SessionParamsPtr params) override;
  void ClassifyTextSafety(const std::string& text, ClassifyTextSafetyCallback callback) override;
  void DetectLanguage(const std::string& text, DetectLanguageCallback callback) override;
  void LoadAdaptation(LoadAdaptationParamsPtr params, ::mojo::PendingReceiver<OnDeviceModel> model, LoadAdaptationCallback callback) override;
};
class  OnDeviceModelAsyncWaiter {
 public:
  explicit OnDeviceModelAsyncWaiter(OnDeviceModel* proxy);

  OnDeviceModelAsyncWaiter(const OnDeviceModelAsyncWaiter&) = delete;
  OnDeviceModelAsyncWaiter& operator=(const OnDeviceModelAsyncWaiter&) = delete;

  ~OnDeviceModelAsyncWaiter();
  void ClassifyTextSafety(
      const std::string& text, SafetyInfoPtr* out_safety_info);
  SafetyInfoPtr ClassifyTextSafety(const std::string& text);
  void DetectLanguage(
      const std::string& text, LanguageDetectionResultPtr* out_result);
  LanguageDetectionResultPtr DetectLanguage(const std::string& text);
  void LoadAdaptation(
      LoadAdaptationParamsPtr params, ::mojo::PendingReceiver<OnDeviceModel> model, LoadModelResult* out_result);
  LoadModelResult LoadAdaptation(LoadAdaptationParamsPtr params, ::mojo::PendingReceiver<OnDeviceModel> model);

 private:
  OnDeviceModel* const proxy_;
};


class  TextSafetySessionInterceptorForTesting : public TextSafetySession {
  virtual TextSafetySession* GetForwardingInterface() = 0;
  void ClassifyTextSafety(const std::string& text, ClassifyTextSafetyCallback callback) override;
  void DetectLanguage(const std::string& text, DetectLanguageCallback callback) override;
  void Clone(::mojo::PendingReceiver<TextSafetySession> session) override;
};
class  TextSafetySessionAsyncWaiter {
 public:
  explicit TextSafetySessionAsyncWaiter(TextSafetySession* proxy);

  TextSafetySessionAsyncWaiter(const TextSafetySessionAsyncWaiter&) = delete;
  TextSafetySessionAsyncWaiter& operator=(const TextSafetySessionAsyncWaiter&) = delete;

  ~TextSafetySessionAsyncWaiter();
  void ClassifyTextSafety(
      const std::string& text, SafetyInfoPtr* out_safety_info);
  SafetyInfoPtr ClassifyTextSafety(const std::string& text);
  void DetectLanguage(
      const std::string& text, LanguageDetectionResultPtr* out_result);
  LanguageDetectionResultPtr DetectLanguage(const std::string& text);

 private:
  TextSafetySession* const proxy_;
};


class  TextSafetyModelInterceptorForTesting : public TextSafetyModel {
  virtual TextSafetyModel* GetForwardingInterface() = 0;
  void StartSession(::mojo::PendingReceiver<TextSafetySession> session) override;
};
class  TextSafetyModelAsyncWaiter {
 public:
  explicit TextSafetyModelAsyncWaiter(TextSafetyModel* proxy);

  TextSafetyModelAsyncWaiter(const TextSafetyModelAsyncWaiter&) = delete;
  TextSafetyModelAsyncWaiter& operator=(const TextSafetyModelAsyncWaiter&) = delete;

  ~TextSafetyModelAsyncWaiter();

 private:
  TextSafetyModel* const proxy_;
};


class  AsrStreamResponderInterceptorForTesting : public AsrStreamResponder {
  virtual AsrStreamResponder* GetForwardingInterface() = 0;
  void OnResponse(std::vector<SpeechRecognitionResultPtr> result) override;
};
class  AsrStreamResponderAsyncWaiter {
 public:
  explicit AsrStreamResponderAsyncWaiter(AsrStreamResponder* proxy);

  AsrStreamResponderAsyncWaiter(const AsrStreamResponderAsyncWaiter&) = delete;
  AsrStreamResponderAsyncWaiter& operator=(const AsrStreamResponderAsyncWaiter&) = delete;

  ~AsrStreamResponderAsyncWaiter();

 private:
  AsrStreamResponder* const proxy_;
};


class  AsrStreamInputInterceptorForTesting : public AsrStreamInput {
  virtual AsrStreamInput* GetForwardingInterface() = 0;
  void AddAudioChunk(AudioDataPtr data) override;
};
class  AsrStreamInputAsyncWaiter {
 public:
  explicit AsrStreamInputAsyncWaiter(AsrStreamInput* proxy);

  AsrStreamInputAsyncWaiter(const AsrStreamInputAsyncWaiter&) = delete;
  AsrStreamInputAsyncWaiter& operator=(const AsrStreamInputAsyncWaiter&) = delete;

  ~AsrStreamInputAsyncWaiter();

 private:
  AsrStreamInput* const proxy_;
};




}  // on_device_model::mojom

#endif  // SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_TEST_UTILS_H_