// services/on_device_model/public/mojom/on_device_model.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/on_device_model/public/mojom/on_device_model.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/on_device_model/public/mojom/on_device_model.mojom-params-data.h"
namespace on_device_model {
namespace mojom {

NOINLINE static const char* TokenToStringHelper(Token value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Token::kSystem:
      return "kSystem";
    case Token::kModel:
      return "kModel";
    case Token::kUser:
      return "kUser";
    case Token::kEnd:
      return "kEnd";
    default:
      return nullptr;
  }
}

std::string TokenToString(Token value) {
  const char *str = TokenToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Token value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Token value) {
  return os << TokenToString(value);
}

NOINLINE static const char* PriorityToStringHelper(Priority value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Priority::kForeground:
      return "kForeground";
    case Priority::kBackground:
      return "kBackground";
    default:
      return nullptr;
  }
}

std::string PriorityToString(Priority value) {
  const char *str = PriorityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Priority value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Priority value) {
  return os << PriorityToString(value);
}

NOINLINE static const char* PerformanceClassToStringHelper(PerformanceClass value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PerformanceClass::kError:
      return "kError";
    case PerformanceClass::kGpuBlocked:
      return "kGpuBlocked";
    case PerformanceClass::kFailedToLoadLibrary:
      return "kFailedToLoadLibrary";
    case PerformanceClass::kVeryLow:
      return "kVeryLow";
    case PerformanceClass::kLow:
      return "kLow";
    case PerformanceClass::kMedium:
      return "kMedium";
    case PerformanceClass::kHigh:
      return "kHigh";
    case PerformanceClass::kVeryHigh:
      return "kVeryHigh";
    default:
      return nullptr;
  }
}

std::string PerformanceClassToString(PerformanceClass value) {
  const char *str = PerformanceClassToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PerformanceClass value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PerformanceClass value) {
  return os << PerformanceClassToString(value);
}

NOINLINE static const char* LoadModelResultToStringHelper(LoadModelResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LoadModelResult::kSuccess:
      return "kSuccess";
    case LoadModelResult::kGpuBlocked:
      return "kGpuBlocked";
    case LoadModelResult::kFailedToLoadLibrary:
      return "kFailedToLoadLibrary";
    default:
      return nullptr;
  }
}

std::string LoadModelResultToString(LoadModelResult value) {
  const char *str = LoadModelResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LoadModelResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LoadModelResult value) {
  return os << LoadModelResultToString(value);
}

namespace internal {
// static
bool InputPiece_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const InputPiece_Data* object = static_cast<const InputPiece_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case InputPiece_Tag::kToken: {


      if (!::on_device_model::mojom::internal::Token_Data
            ::Validate(object->data.f_token, validation_context))
        return false;
      return true;
    }
    case InputPiece_Tag::kText: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_text, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_text, validation_context,
                                             &text_validate_params)) {
        return false;
      }
      return true;
    }
    case InputPiece_Tag::kBitmap: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_bitmap, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_bitmap, validation_context))
        return false;
      return true;
    }
    case InputPiece_Tag::kUnknownType: {

      return true;
    }
    case InputPiece_Tag::kAudio: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_audio, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_audio, validation_context))
        return false;
      return true;
    }
    default: {

      return true;
    }
  }
}
// static
bool ResponseConstraint_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ResponseConstraint_Data* object = static_cast<const ResponseConstraint_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ResponseConstraint_Tag::kJsonSchema: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_json_schema, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& json_schema_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_json_schema, validation_context,
                                             &json_schema_validate_params)) {
        return false;
      }
      return true;
    }
    case ResponseConstraint_Tag::kRegex: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_regex, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& regex_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_regex, validation_context,
                                             &regex_validate_params)) {
        return false;
      }
      return true;
    }
    case ResponseConstraint_Tag::kUnknownType: {

      return true;
    }
    default: {

      return true;
    }
  }
}


// static
bool AdaptationAssets_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdaptationAssets_Data* object =
      static_cast<const AdaptationAssets_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->weights, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->weights_path, validation_context))
    return false;

  return true;
}

AdaptationAssets_Data::AdaptationAssets_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LanguageDetectionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LanguageDetectionResult_Data* object =
      static_cast<const LanguageDetectionResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->code, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& code_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->code, validation_context,
                                         &code_validate_params)) {
    return false;
  }

  return true;
}

LanguageDetectionResult_Data::LanguageDetectionResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafetyInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafetyInfo_Data* object =
      static_cast<const SafetyInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->class_scores, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& class_scores_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->class_scores, validation_context,
                                         &class_scores_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->language, validation_context))
    return false;

  return true;
}

SafetyInfo_Data::SafetyInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResponseChunk_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResponseChunk_Data* object =
      static_cast<const ResponseChunk_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->safety_info, validation_context))
    return false;

  return true;
}

ResponseChunk_Data::ResponseChunk_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResponseSummary_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResponseSummary_Data* object =
      static_cast<const ResponseSummary_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->safety_info, validation_context))
    return false;

  return true;
}

ResponseSummary_Data::ResponseSummary_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LoadAdaptationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LoadAdaptationParams_Data* object =
      static_cast<const LoadAdaptationParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->assets, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->assets, validation_context))
    return false;

  return true;
}

LoadAdaptationParams_Data::LoadAdaptationParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Capabilities_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Capabilities_Data* object =
      static_cast<const Capabilities_Data*>(data);

  return true;
}

Capabilities_Data::Capabilities_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SessionParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 24 },
    { 1, 32 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SessionParams_Data* object =
      static_cast<const SessionParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->capabilities, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->capabilities, validation_context))
    return false;

  return true;
}

SessionParams_Data::SessionParams_Data()
    : header_({sizeof(*this), 1}) {}


// static
bool Input_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Input_Data* object =
      static_cast<const Input_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pieces, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pieces_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pieces, validation_context,
                                         &pieces_validate_params)) {
    return false;
  }

  return true;
}

Input_Data::Input_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppendOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppendOptions_Data* object =
      static_cast<const AppendOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input, validation_context))
    return false;

  return true;
}

AppendOptions_Data::AppendOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GenerateOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 16 },
    { 2, 32 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GenerateOptions_Data* object =
      static_cast<const GenerateOptions_Data*>(data);
  if (object->header_.version < 2)
    return true;

  if (!mojo::internal::ValidateInlinedUnion(object->constraint, validation_context))
    return false;

  return true;
}

GenerateOptions_Data::GenerateOptions_Data()
    : header_({sizeof(*this), 2}) {}


// static
bool AudioData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioData_Data* object =
      static_cast<const AudioData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

AudioData_Data::AudioData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeechRecognitionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeechRecognitionResult_Data* object =
      static_cast<const SpeechRecognitionResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transcript, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& transcript_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->transcript, validation_context,
                                         &transcript_validate_params)) {
    return false;
  }

  return true;
}

SpeechRecognitionResult_Data::SpeechRecognitionResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AsrStreamOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AsrStreamOptions_Data* object =
      static_cast<const AsrStreamOptions_Data*>(data);

  return true;
}

AsrStreamOptions_Data::AsrStreamOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePerformanceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePerformanceInfo_Data* object =
      static_cast<const DevicePerformanceInfo_Data*>(data);


  if (!::on_device_model::mojom::internal::PerformanceClass_Data
        ::Validate(object->performance_class, validation_context))
    return false;

  return true;
}

DevicePerformanceInfo_Data::DevicePerformanceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceInfo_Data* object =
      static_cast<const DeviceInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->driver_version, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& driver_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->driver_version, validation_context,
                                         &driver_version_validate_params)) {
    return false;
  }

  return true;
}

DeviceInfo_Data::DeviceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StreamingResponder_OnResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StreamingResponder_OnResponse_Params_Data* object =
      static_cast<const StreamingResponder_OnResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->chunk, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->chunk, validation_context))
    return false;

  return true;
}

StreamingResponder_OnResponse_Params_Data::StreamingResponder_OnResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StreamingResponder_OnComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StreamingResponder_OnComplete_Params_Data* object =
      static_cast<const StreamingResponder_OnComplete_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->summary, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->summary, validation_context))
    return false;

  return true;
}

StreamingResponder_OnComplete_Params_Data::StreamingResponder_OnComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContextClient_OnComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContextClient_OnComplete_Params_Data* object =
      static_cast<const ContextClient_OnComplete_Params_Data*>(data);

  return true;
}

ContextClient_OnComplete_Params_Data::ContextClient_OnComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_Append_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_Append_Params_Data* object =
      static_cast<const Session_Append_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_Append_Params_Data::Session_Append_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_Generate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_Generate_Params_Data* object =
      static_cast<const Session_Generate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->responder, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->responder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_Generate_Params_Data::Session_Generate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_GetSizeInTokens_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_GetSizeInTokens_Params_Data* object =
      static_cast<const Session_GetSizeInTokens_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input, validation_context))
    return false;

  return true;
}

Session_GetSizeInTokens_Params_Data::Session_GetSizeInTokens_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_GetSizeInTokens_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_GetSizeInTokens_ResponseParams_Data* object =
      static_cast<const Session_GetSizeInTokens_ResponseParams_Data*>(data);

  return true;
}

Session_GetSizeInTokens_ResponseParams_Data::Session_GetSizeInTokens_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_Score_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_Score_Params_Data* object =
      static_cast<const Session_Score_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

Session_Score_Params_Data::Session_Score_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_Score_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_Score_ResponseParams_Data* object =
      static_cast<const Session_Score_ResponseParams_Data*>(data);

  return true;
}

Session_Score_ResponseParams_Data::Session_Score_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_Clone_Params_Data* object =
      static_cast<const Session_Clone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->session, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->session,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_Clone_Params_Data::Session_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_GetProbabilitiesBlocking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_GetProbabilitiesBlocking_Params_Data* object =
      static_cast<const Session_GetProbabilitiesBlocking_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

Session_GetProbabilitiesBlocking_Params_Data::Session_GetProbabilitiesBlocking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_GetProbabilitiesBlocking_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_GetProbabilitiesBlocking_ResponseParams_Data* object =
      static_cast<const Session_GetProbabilitiesBlocking_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->probabilities, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& probabilities_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->probabilities, validation_context,
                                         &probabilities_validate_params)) {
    return false;
  }

  return true;
}

Session_GetProbabilitiesBlocking_ResponseParams_Data::Session_GetProbabilitiesBlocking_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_SetPriority_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_SetPriority_Params_Data* object =
      static_cast<const Session_SetPriority_Params_Data*>(data);


  if (!::on_device_model::mojom::internal::Priority_Data
        ::Validate(object->priority, validation_context))
    return false;

  return true;
}

Session_SetPriority_Params_Data::Session_SetPriority_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Session_AsrStream_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Session_AsrStream_Params_Data* object =
      static_cast<const Session_AsrStream_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->stream, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->responder, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->responder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Session_AsrStream_Params_Data::Session_AsrStream_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModel_StartSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 16 },
    { 1, 24 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModel_StartSession_Params_Data* object =
      static_cast<const OnDeviceModel_StartSession_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->session, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->session,
                                                 validation_context)) {
    return false;
  }
  if (object->header_.version < 1)
    return true;

  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

OnDeviceModel_StartSession_Params_Data::OnDeviceModel_StartSession_Params_Data()
    : header_({sizeof(*this), 1}) {}


// static
bool OnDeviceModel_ClassifyTextSafety_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModel_ClassifyTextSafety_Params_Data* object =
      static_cast<const OnDeviceModel_ClassifyTextSafety_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

OnDeviceModel_ClassifyTextSafety_Params_Data::OnDeviceModel_ClassifyTextSafety_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModel_ClassifyTextSafety_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModel_ClassifyTextSafety_ResponseParams_Data* object =
      static_cast<const OnDeviceModel_ClassifyTextSafety_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->safety_info, validation_context))
    return false;

  return true;
}

OnDeviceModel_ClassifyTextSafety_ResponseParams_Data::OnDeviceModel_ClassifyTextSafety_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModel_DetectLanguage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModel_DetectLanguage_Params_Data* object =
      static_cast<const OnDeviceModel_DetectLanguage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

OnDeviceModel_DetectLanguage_Params_Data::OnDeviceModel_DetectLanguage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModel_DetectLanguage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModel_DetectLanguage_ResponseParams_Data* object =
      static_cast<const OnDeviceModel_DetectLanguage_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

OnDeviceModel_DetectLanguage_ResponseParams_Data::OnDeviceModel_DetectLanguage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModel_LoadAdaptation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModel_LoadAdaptation_Params_Data* object =
      static_cast<const OnDeviceModel_LoadAdaptation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->model, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->model,
                                                 validation_context)) {
    return false;
  }

  return true;
}

OnDeviceModel_LoadAdaptation_Params_Data::OnDeviceModel_LoadAdaptation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModel_LoadAdaptation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModel_LoadAdaptation_ResponseParams_Data* object =
      static_cast<const OnDeviceModel_LoadAdaptation_ResponseParams_Data*>(data);


  if (!::on_device_model::mojom::internal::LoadModelResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

OnDeviceModel_LoadAdaptation_ResponseParams_Data::OnDeviceModel_LoadAdaptation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextSafetySession_ClassifyTextSafety_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextSafetySession_ClassifyTextSafety_Params_Data* object =
      static_cast<const TextSafetySession_ClassifyTextSafety_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

TextSafetySession_ClassifyTextSafety_Params_Data::TextSafetySession_ClassifyTextSafety_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextSafetySession_ClassifyTextSafety_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextSafetySession_ClassifyTextSafety_ResponseParams_Data* object =
      static_cast<const TextSafetySession_ClassifyTextSafety_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->safety_info, validation_context))
    return false;

  return true;
}

TextSafetySession_ClassifyTextSafety_ResponseParams_Data::TextSafetySession_ClassifyTextSafety_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextSafetySession_DetectLanguage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextSafetySession_DetectLanguage_Params_Data* object =
      static_cast<const TextSafetySession_DetectLanguage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

TextSafetySession_DetectLanguage_Params_Data::TextSafetySession_DetectLanguage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextSafetySession_DetectLanguage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextSafetySession_DetectLanguage_ResponseParams_Data* object =
      static_cast<const TextSafetySession_DetectLanguage_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

TextSafetySession_DetectLanguage_ResponseParams_Data::TextSafetySession_DetectLanguage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextSafetySession_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextSafetySession_Clone_Params_Data* object =
      static_cast<const TextSafetySession_Clone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->session, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->session,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TextSafetySession_Clone_Params_Data::TextSafetySession_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextSafetyModel_StartSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextSafetyModel_StartSession_Params_Data* object =
      static_cast<const TextSafetyModel_StartSession_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->session, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->session,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TextSafetyModel_StartSession_Params_Data::TextSafetyModel_StartSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AsrStreamResponder_OnResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AsrStreamResponder_OnResponse_Params_Data* object =
      static_cast<const AsrStreamResponder_OnResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

AsrStreamResponder_OnResponse_Params_Data::AsrStreamResponder_OnResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AsrStreamInput_AddAudioChunk_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AsrStreamInput_AddAudioChunk_Params_Data* object =
      static_cast<const AsrStreamInput_AddAudioChunk_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

AsrStreamInput_AddAudioChunk_Params_Data::AsrStreamInput_AddAudioChunk_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace on_device_model

namespace perfetto {

// static
void TraceFormatTraits<::on_device_model::mojom::Token>::WriteIntoTrace(
   perfetto::TracedValue context, ::on_device_model::mojom::Token value) {
  return std::move(context).WriteString(::on_device_model::mojom::TokenToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::on_device_model::mojom::Priority>::WriteIntoTrace(
   perfetto::TracedValue context, ::on_device_model::mojom::Priority value) {
  return std::move(context).WriteString(::on_device_model::mojom::PriorityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::on_device_model::mojom::PerformanceClass>::WriteIntoTrace(
   perfetto::TracedValue context, ::on_device_model::mojom::PerformanceClass value) {
  return std::move(context).WriteString(::on_device_model::mojom::PerformanceClassToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::on_device_model::mojom::LoadModelResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::on_device_model::mojom::LoadModelResult value) {
  return std::move(context).WriteString(::on_device_model::mojom::LoadModelResultToString(value));
}

} // namespace perfetto