// services/on_device_model/public/mojom/on_device_model.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_BLINK_H_
#define SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/on_device_model/public/mojom/on_device_model.mojom-features.h"  // IWYU pragma: export
#include "services/on_device_model/public/mojom/on_device_model.mojom-shared.h"  // IWYU pragma: export
#include "services/on_device_model/public/mojom/on_device_model.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom-blink.h"
#include "mojo/public/mojom/base/file_path.mojom-blink.h"
#include "skia/public/mojom/bitmap.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace on_device_model::mojom::blink {

class StreamingResponderProxy;

template <typename ImplRefTraits>
class StreamingResponderStub;

class StreamingResponderRequestValidator;


class PLATFORM_EXPORT StreamingResponder
    : public StreamingResponderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_model.mojom.StreamingResponder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StreamingResponderInterfaceBase;
  using Proxy_ = StreamingResponderProxy;

  template <typename ImplRefTraits>
  using Stub_ = StreamingResponderStub<ImplRefTraits>;

  using RequestValidator_ = StreamingResponderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnResponseMinVersion = 0,
    kOnCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~StreamingResponder() = default;

  virtual void OnResponse(ResponseChunkPtr chunk) = 0;

  virtual void OnComplete(ResponseSummaryPtr summary) = 0;
};

class ContextClientProxy;

template <typename ImplRefTraits>
class ContextClientStub;

class ContextClientRequestValidator;


class PLATFORM_EXPORT ContextClient
    : public ContextClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_model.mojom.ContextClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ContextClientInterfaceBase;
  using Proxy_ = ContextClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContextClientStub<ImplRefTraits>;

  using RequestValidator_ = ContextClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ContextClient() = default;

  virtual void OnComplete(uint32_t tokens_processed) = 0;
};

class SessionProxy;

template <typename ImplRefTraits>
class SessionStub;

class SessionRequestValidator;
class SessionResponseValidator;


class PLATFORM_EXPORT Session
    : public SessionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_model.mojom.Session";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 5;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SessionInterfaceBase;
  using Proxy_ = SessionProxy;

  template <typename ImplRefTraits>
  using Stub_ = SessionStub<ImplRefTraits>;

  using RequestValidator_ = SessionRequestValidator;
  using ResponseValidator_ = SessionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAppendMinVersion = 1,
    kGenerateMinVersion = 1,
    kGetSizeInTokensMinVersion = 0,
    kScoreMinVersion = 0,
    kCloneMinVersion = 0,
    kGetProbabilitiesBlockingMinVersion = 3,
    kSetPriorityMinVersion = 4,
    kAsrStreamMinVersion = 5,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Append_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Generate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSizeInTokens_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Score_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProbabilitiesBlocking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPriority_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AsrStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Session() = default;

  virtual void Append(AppendOptionsPtr options, ::mojo::PendingRemote<ContextClient> client) = 0;

  virtual void Generate(GenerateOptionsPtr options, ::mojo::PendingRemote<StreamingResponder> responder) = 0;

  using GetSizeInTokensCallback = base::OnceCallback<void(uint32_t)>;
  using GetSizeInTokensMojoCallback = base::OnceCallback<void(uint32_t)>;

  virtual void GetSizeInTokens(InputPtr input, GetSizeInTokensCallback callback) = 0;

  using ScoreCallback = base::OnceCallback<void(float)>;
  using ScoreMojoCallback = base::OnceCallback<void(float)>;

  virtual void Score(const ::blink::String& text, ScoreCallback callback) = 0;

  virtual void Clone(::mojo::PendingReceiver<Session> session) = 0;

  using GetProbabilitiesBlockingCallback = base::OnceCallback<void(const ::blink::Vector<float>&)>;
  using GetProbabilitiesBlockingMojoCallback = base::OnceCallback<void(const ::blink::Vector<float>&)>;

  virtual void GetProbabilitiesBlocking(const ::blink::String& text, GetProbabilitiesBlockingCallback callback) = 0;

  virtual void SetPriority(Priority priority) = 0;

  virtual void AsrStream(AsrStreamOptionsPtr options, ::mojo::PendingReceiver<AsrStreamInput> stream, ::mojo::PendingRemote<AsrStreamResponder> responder) = 0;
};

class OnDeviceModelProxy;

template <typename ImplRefTraits>
class OnDeviceModelStub;

class OnDeviceModelRequestValidator;
class OnDeviceModelResponseValidator;


class PLATFORM_EXPORT OnDeviceModel
    : public OnDeviceModelInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_model.mojom.OnDeviceModel";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 1;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = OnDeviceModelInterfaceBase;
  using Proxy_ = OnDeviceModelProxy;

  template <typename ImplRefTraits>
  using Stub_ = OnDeviceModelStub<ImplRefTraits>;

  using RequestValidator_ = OnDeviceModelRequestValidator;
  using ResponseValidator_ = OnDeviceModelResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStartSessionMinVersion = 0,
    kClassifyTextSafetyMinVersion = 0,
    kDetectLanguageMinVersion = 0,
    kLoadAdaptationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClassifyTextSafety_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DetectLanguage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadAdaptation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~OnDeviceModel() = default;

  virtual void StartSession(::mojo::PendingReceiver<Session> session, SessionParamsPtr params) = 0;

  using ClassifyTextSafetyCallback = base::OnceCallback<void(SafetyInfoPtr)>;
  using ClassifyTextSafetyMojoCallback = base::OnceCallback<void(SafetyInfoPtr)>;

  virtual void ClassifyTextSafety(const ::blink::String& text, ClassifyTextSafetyCallback callback) = 0;

  using DetectLanguageCallback = base::OnceCallback<void(LanguageDetectionResultPtr)>;
  using DetectLanguageMojoCallback = base::OnceCallback<void(LanguageDetectionResultPtr)>;

  virtual void DetectLanguage(const ::blink::String& text, DetectLanguageCallback callback) = 0;

  using LoadAdaptationCallback = base::OnceCallback<void(LoadModelResult)>;
  using LoadAdaptationMojoCallback = base::OnceCallback<void(LoadModelResult)>;

  virtual void LoadAdaptation(LoadAdaptationParamsPtr params, ::mojo::PendingReceiver<OnDeviceModel> model, LoadAdaptationCallback callback) = 0;
};

class TextSafetySessionProxy;

template <typename ImplRefTraits>
class TextSafetySessionStub;

class TextSafetySessionRequestValidator;
class TextSafetySessionResponseValidator;


class PLATFORM_EXPORT TextSafetySession
    : public TextSafetySessionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_model.mojom.TextSafetySession";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TextSafetySessionInterfaceBase;
  using Proxy_ = TextSafetySessionProxy;

  template <typename ImplRefTraits>
  using Stub_ = TextSafetySessionStub<ImplRefTraits>;

  using RequestValidator_ = TextSafetySessionRequestValidator;
  using ResponseValidator_ = TextSafetySessionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kClassifyTextSafetyMinVersion = 0,
    kDetectLanguageMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ClassifyTextSafety_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DetectLanguage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TextSafetySession() = default;

  using ClassifyTextSafetyCallback = base::OnceCallback<void(SafetyInfoPtr)>;
  using ClassifyTextSafetyMojoCallback = base::OnceCallback<void(SafetyInfoPtr)>;

  virtual void ClassifyTextSafety(const ::blink::String& text, ClassifyTextSafetyCallback callback) = 0;

  using DetectLanguageCallback = base::OnceCallback<void(LanguageDetectionResultPtr)>;
  using DetectLanguageMojoCallback = base::OnceCallback<void(LanguageDetectionResultPtr)>;

  virtual void DetectLanguage(const ::blink::String& text, DetectLanguageCallback callback) = 0;

  virtual void Clone(::mojo::PendingReceiver<TextSafetySession> session) = 0;
};

class TextSafetyModelProxy;

template <typename ImplRefTraits>
class TextSafetyModelStub;

class TextSafetyModelRequestValidator;


class PLATFORM_EXPORT TextSafetyModel
    : public TextSafetyModelInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_model.mojom.TextSafetyModel";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TextSafetyModelInterfaceBase;
  using Proxy_ = TextSafetyModelProxy;

  template <typename ImplRefTraits>
  using Stub_ = TextSafetyModelStub<ImplRefTraits>;

  using RequestValidator_ = TextSafetyModelRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartSessionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TextSafetyModel() = default;

  virtual void StartSession(::mojo::PendingReceiver<TextSafetySession> session) = 0;
};

class AsrStreamResponderProxy;

template <typename ImplRefTraits>
class AsrStreamResponderStub;

class AsrStreamResponderRequestValidator;


class PLATFORM_EXPORT AsrStreamResponder
    : public AsrStreamResponderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_model.mojom.AsrStreamResponder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AsrStreamResponderInterfaceBase;
  using Proxy_ = AsrStreamResponderProxy;

  template <typename ImplRefTraits>
  using Stub_ = AsrStreamResponderStub<ImplRefTraits>;

  using RequestValidator_ = AsrStreamResponderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnResponseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AsrStreamResponder() = default;

  virtual void OnResponse(::blink::Vector<SpeechRecognitionResultPtr> result) = 0;
};

class AsrStreamInputProxy;

template <typename ImplRefTraits>
class AsrStreamInputStub;

class AsrStreamInputRequestValidator;


class PLATFORM_EXPORT AsrStreamInput
    : public AsrStreamInputInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_model.mojom.AsrStreamInput";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AsrStreamInputInterfaceBase;
  using Proxy_ = AsrStreamInputProxy;

  template <typename ImplRefTraits>
  using Stub_ = AsrStreamInputStub<ImplRefTraits>;

  using RequestValidator_ = AsrStreamInputRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddAudioChunkMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddAudioChunk_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AsrStreamInput() = default;

  virtual void AddAudioChunk(AudioDataPtr data) = 0;
};



class PLATFORM_EXPORT StreamingResponderProxy
    : public StreamingResponder {
 public:
  using InterfaceType = StreamingResponder;

  explicit StreamingResponderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnResponse(ResponseChunkPtr chunk) final;
  
  void OnComplete(ResponseSummaryPtr summary) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT ContextClientProxy
    : public ContextClient {
 public:
  using InterfaceType = ContextClient;

  explicit ContextClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnComplete(uint32_t tokens_processed) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT SessionProxy
    : public Session {
 public:
  using InterfaceType = Session;

  explicit SessionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Append(AppendOptionsPtr options, ::mojo::PendingRemote<ContextClient> client) final;
  
  void Generate(GenerateOptionsPtr options, ::mojo::PendingRemote<StreamingResponder> responder) final;
  
  void GetSizeInTokens(InputPtr input, GetSizeInTokensCallback callback) final;
  
  void Score(const ::blink::String& text, ScoreCallback callback) final;
  
  void Clone(::mojo::PendingReceiver<Session> session) final;
  
  void GetProbabilitiesBlocking(const ::blink::String& text, GetProbabilitiesBlockingCallback callback) final;
  
  void SetPriority(Priority priority) final;
  
  void AsrStream(AsrStreamOptionsPtr options, ::mojo::PendingReceiver<AsrStreamInput> stream, ::mojo::PendingRemote<AsrStreamResponder> responder) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT OnDeviceModelProxy
    : public OnDeviceModel {
 public:
  using InterfaceType = OnDeviceModel;

  explicit OnDeviceModelProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartSession(::mojo::PendingReceiver<Session> session, SessionParamsPtr params) final;
  
  void ClassifyTextSafety(const ::blink::String& text, ClassifyTextSafetyCallback callback) final;
  
  void DetectLanguage(const ::blink::String& text, DetectLanguageCallback callback) final;
  
  void LoadAdaptation(LoadAdaptationParamsPtr params, ::mojo::PendingReceiver<OnDeviceModel> model, LoadAdaptationCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT TextSafetySessionProxy
    : public TextSafetySession {
 public:
  using InterfaceType = TextSafetySession;

  explicit TextSafetySessionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ClassifyTextSafety(const ::blink::String& text, ClassifyTextSafetyCallback callback) final;
  
  void DetectLanguage(const ::blink::String& text, DetectLanguageCallback callback) final;
  
  void Clone(::mojo::PendingReceiver<TextSafetySession> session) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT TextSafetyModelProxy
    : public TextSafetyModel {
 public:
  using InterfaceType = TextSafetyModel;

  explicit TextSafetyModelProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartSession(::mojo::PendingReceiver<TextSafetySession> session) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT AsrStreamResponderProxy
    : public AsrStreamResponder {
 public:
  using InterfaceType = AsrStreamResponder;

  explicit AsrStreamResponderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnResponse(::blink::Vector<SpeechRecognitionResultPtr> result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT AsrStreamInputProxy
    : public AsrStreamInput {
 public:
  using InterfaceType = AsrStreamInput;

  explicit AsrStreamInputProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddAudioChunk(AudioDataPtr data) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT StreamingResponderStubDispatch {
 public:
  static bool Accept(StreamingResponder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StreamingResponder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StreamingResponder>>
class StreamingResponderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StreamingResponderStub() = default;
  ~StreamingResponderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StreamingResponderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StreamingResponderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT ContextClientStubDispatch {
 public:
  static bool Accept(ContextClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContextClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContextClient>>
class ContextClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContextClientStub() = default;
  ~ContextClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContextClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContextClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT SessionStubDispatch {
 public:
  static bool Accept(Session* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Session* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Session>>
class SessionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SessionStub() = default;
  ~SessionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SessionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT OnDeviceModelStubDispatch {
 public:
  static bool Accept(OnDeviceModel* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OnDeviceModel* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OnDeviceModel>>
class OnDeviceModelStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OnDeviceModelStub() = default;
  ~OnDeviceModelStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OnDeviceModelStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OnDeviceModelStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT TextSafetySessionStubDispatch {
 public:
  static bool Accept(TextSafetySession* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TextSafetySession* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TextSafetySession>>
class TextSafetySessionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TextSafetySessionStub() = default;
  ~TextSafetySessionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TextSafetySessionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TextSafetySessionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT TextSafetyModelStubDispatch {
 public:
  static bool Accept(TextSafetyModel* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TextSafetyModel* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TextSafetyModel>>
class TextSafetyModelStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TextSafetyModelStub() = default;
  ~TextSafetyModelStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TextSafetyModelStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TextSafetyModelStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AsrStreamResponderStubDispatch {
 public:
  static bool Accept(AsrStreamResponder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AsrStreamResponder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AsrStreamResponder>>
class AsrStreamResponderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AsrStreamResponderStub() = default;
  ~AsrStreamResponderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AsrStreamResponderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AsrStreamResponderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AsrStreamInputStubDispatch {
 public:
  static bool Accept(AsrStreamInput* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AsrStreamInput* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AsrStreamInput>>
class AsrStreamInputStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AsrStreamInputStub() = default;
  ~AsrStreamInputStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AsrStreamInputStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AsrStreamInputStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT StreamingResponderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT ContextClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT SessionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT OnDeviceModelRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT TextSafetySessionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT TextSafetyModelRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT AsrStreamResponderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT AsrStreamInputRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT SessionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT OnDeviceModelResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT TextSafetySessionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class PLATFORM_EXPORT LanguageDetectionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LanguageDetectionResult, T>::value>;
  using DataView = LanguageDetectionResultDataView;
  using Data_ = internal::LanguageDetectionResult_Data;

  template <typename... Args>
  static LanguageDetectionResultPtr New(Args&&... args) {
    return LanguageDetectionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LanguageDetectionResultPtr From(const U& u) {
    return mojo::TypeConverter<LanguageDetectionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LanguageDetectionResult>::Convert(*this);
  }


  LanguageDetectionResult();

  LanguageDetectionResult(
      const ::blink::String& code,
      float reliability);


  ~LanguageDetectionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LanguageDetectionResultPtr>
  LanguageDetectionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LanguageDetectionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LanguageDetectionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LanguageDetectionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LanguageDetectionResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LanguageDetectionResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LanguageDetectionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LanguageDetectionResult_UnserializedMessageContext<
            UserType, LanguageDetectionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LanguageDetectionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LanguageDetectionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LanguageDetectionResult_UnserializedMessageContext<
            UserType, LanguageDetectionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LanguageDetectionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String code;
  
  float reliability;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LanguageDetectionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LanguageDetectionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LanguageDetectionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LanguageDetectionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class PLATFORM_EXPORT Capabilities {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Capabilities, T>::value>;
  using DataView = CapabilitiesDataView;
  using Data_ = internal::Capabilities_Data;

  template <typename... Args>
  static CapabilitiesPtr New(Args&&... args) {
    return CapabilitiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CapabilitiesPtr From(const U& u) {
    return mojo::TypeConverter<CapabilitiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Capabilities>::Convert(*this);
  }


  Capabilities();

  Capabilities(
      bool image_input,
      bool audio_input);


  ~Capabilities();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CapabilitiesPtr>
  CapabilitiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Capabilities::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Capabilities::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Capabilities::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Capabilities::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Capabilities::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Capabilities::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Capabilities_UnserializedMessageContext<
            UserType, Capabilities::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Capabilities::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Capabilities::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Capabilities_UnserializedMessageContext<
            UserType, Capabilities::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Capabilities::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool image_input;
  
  bool audio_input;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Capabilities::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Capabilities::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Capabilities::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Capabilities::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class PLATFORM_EXPORT SpeechRecognitionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechRecognitionResult, T>::value>;
  using DataView = SpeechRecognitionResultDataView;
  using Data_ = internal::SpeechRecognitionResult_Data;

  template <typename... Args>
  static SpeechRecognitionResultPtr New(Args&&... args) {
    return SpeechRecognitionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechRecognitionResultPtr From(const U& u) {
    return mojo::TypeConverter<SpeechRecognitionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechRecognitionResult>::Convert(*this);
  }


  SpeechRecognitionResult();

  SpeechRecognitionResult(
      const ::blink::String& transcript,
      bool is_final);


  ~SpeechRecognitionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechRecognitionResultPtr>
  SpeechRecognitionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechRecognitionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechRecognitionResult_UnserializedMessageContext<
            UserType, SpeechRecognitionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpeechRecognitionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpeechRecognitionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechRecognitionResult_UnserializedMessageContext<
            UserType, SpeechRecognitionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechRecognitionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String transcript;
  
  bool is_final;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AsrStreamOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AsrStreamOptions, T>::value>;
  using DataView = AsrStreamOptionsDataView;
  using Data_ = internal::AsrStreamOptions_Data;

  template <typename... Args>
  static AsrStreamOptionsPtr New(Args&&... args) {
    return AsrStreamOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AsrStreamOptionsPtr From(const U& u) {
    return mojo::TypeConverter<AsrStreamOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AsrStreamOptions>::Convert(*this);
  }


  AsrStreamOptions();

  explicit AsrStreamOptions(
      uint32_t sample_rate_hz);


  ~AsrStreamOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AsrStreamOptionsPtr>
  AsrStreamOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AsrStreamOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AsrStreamOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AsrStreamOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AsrStreamOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AsrStreamOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AsrStreamOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AsrStreamOptions_UnserializedMessageContext<
            UserType, AsrStreamOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AsrStreamOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AsrStreamOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AsrStreamOptions_UnserializedMessageContext<
            UserType, AsrStreamOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AsrStreamOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t sample_rate_hz;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AsrStreamOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AsrStreamOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AsrStreamOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AsrStreamOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DevicePerformanceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DevicePerformanceInfo, T>::value>;
  using DataView = DevicePerformanceInfoDataView;
  using Data_ = internal::DevicePerformanceInfo_Data;

  template <typename... Args>
  static DevicePerformanceInfoPtr New(Args&&... args) {
    return DevicePerformanceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DevicePerformanceInfoPtr From(const U& u) {
    return mojo::TypeConverter<DevicePerformanceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DevicePerformanceInfo>::Convert(*this);
  }


  DevicePerformanceInfo();

  DevicePerformanceInfo(
      PerformanceClass performance_class,
      uint64_t vram_mb);


  ~DevicePerformanceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DevicePerformanceInfoPtr>
  DevicePerformanceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DevicePerformanceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DevicePerformanceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DevicePerformanceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DevicePerformanceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DevicePerformanceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DevicePerformanceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DevicePerformanceInfo_UnserializedMessageContext<
            UserType, DevicePerformanceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DevicePerformanceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DevicePerformanceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DevicePerformanceInfo_UnserializedMessageContext<
            UserType, DevicePerformanceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DevicePerformanceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PerformanceClass performance_class;
  
  uint64_t vram_mb;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DevicePerformanceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DevicePerformanceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DevicePerformanceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DevicePerformanceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT DeviceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceInfo, T>::value>;
  using DataView = DeviceInfoDataView;
  using Data_ = internal::DeviceInfo_Data;

  template <typename... Args>
  static DeviceInfoPtr New(Args&&... args) {
    return DeviceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceInfoPtr From(const U& u) {
    return mojo::TypeConverter<DeviceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceInfo>::Convert(*this);
  }


  DeviceInfo();

  DeviceInfo(
      int32_t vendor_id,
      int32_t device_id,
      const ::blink::String& driver_version,
      bool supports_fp16);


  ~DeviceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceInfoPtr>
  DeviceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceInfo_UnserializedMessageContext<
            UserType, DeviceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceInfo_UnserializedMessageContext<
            UserType, DeviceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t vendor_id;
  
  int32_t device_id;
  
  ::blink::String driver_version;
  
  bool supports_fp16;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT InputPiece {
 public:
  using DataView = InputPieceDataView;
  using Data_ = internal::InputPiece_Data;
  using Tag = Data_::InputPiece_Tag;

  template <typename... Args>
  static InputPiecePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |token|.
  static InputPiecePtr NewToken(
      Token value);
  // Construct an instance holding |text|.
  static InputPiecePtr NewText(
      const ::blink::String& value);
  // Construct an instance holding |bitmap|.
  static InputPiecePtr NewBitmap(
      const ::SkBitmap& value);
  // Construct an instance holding |unknown_type|.
  static InputPiecePtr NewUnknownType(
      bool value);
  // Construct an instance holding |audio|.
  static InputPiecePtr NewAudio(
      AudioDataPtr value);

  template <typename U>
  static InputPiecePtr From(const U& u) {
    return mojo::TypeConverter<InputPiecePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InputPiece>::Convert(*this);
  }
  ~InputPiece();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  InputPiece(const InputPiece& other) = delete;
  InputPiece& operator=(const InputPiece& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = InputPiecePtr>
  InputPiecePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, InputPiece>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, InputPiece>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_token() const { return tag_ == Tag::kToken; }
  Token get_token() const {
    CHECK(tag_ == Tag::kToken);
    return data_.token;
  }
  void set_token(Token token);

  bool is_text() const { return tag_ == Tag::kText; }
  const ::blink::String& get_text() const {
    CHECK(tag_ == Tag::kText);
    return data_.text;
  }
  ::blink::String& get_text() {
    CHECK(tag_ == Tag::kText);
    return data_.text;
  }
  void set_text(const ::blink::String& text);

  bool is_bitmap() const { return tag_ == Tag::kBitmap; }
  const ::SkBitmap& get_bitmap() const {
    CHECK(tag_ == Tag::kBitmap);
    return data_.bitmap;
  }
  ::SkBitmap& get_bitmap() {
    CHECK(tag_ == Tag::kBitmap);
    return data_.bitmap;
  }
  void set_bitmap(const ::SkBitmap& bitmap);

  bool is_unknown_type() const { return tag_ == Tag::kUnknownType; }
  bool get_unknown_type() const {
    CHECK(tag_ == Tag::kUnknownType);
    return data_.unknown_type;
  }
  void set_unknown_type(bool unknown_type);

  bool is_audio() const { return tag_ == Tag::kAudio; }
  const AudioDataPtr& get_audio() const {
    CHECK(tag_ == Tag::kAudio);
    return data_.audio;
  }
  AudioDataPtr& get_audio() {
    CHECK(tag_ == Tag::kAudio);
    return data_.audio;
  }
  void set_audio(AudioDataPtr audio);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InputPiece::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<InputPiece::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kToken)>,
        Token value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
        const ::blink::String& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBitmap)>,
        const ::SkBitmap& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUnknownType)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAudio)>,
        AudioDataPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    Token token;
    ::blink::String text;
    ::SkBitmap bitmap;
    bool unknown_type;
    AudioDataPtr audio;
  };

  InputPiece(
      std::in_place_index_t<static_cast<size_t>(Tag::kToken)>,
      Token value);
  InputPiece(
      std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
      const ::blink::String& value);
  InputPiece(
      std::in_place_index_t<static_cast<size_t>(Tag::kBitmap)>,
      const ::SkBitmap& value);
  InputPiece(
      std::in_place_index_t<static_cast<size_t>(Tag::kUnknownType)>,
      bool value);
  InputPiece(
      std::in_place_index_t<static_cast<size_t>(Tag::kAudio)>,
      AudioDataPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class PLATFORM_EXPORT ResponseConstraint {
 public:
  using DataView = ResponseConstraintDataView;
  using Data_ = internal::ResponseConstraint_Data;
  using Tag = Data_::ResponseConstraint_Tag;

  template <typename... Args>
  static ResponseConstraintPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |json_schema|.
  static ResponseConstraintPtr NewJsonSchema(
      const ::blink::String& value);
  // Construct an instance holding |regex|.
  static ResponseConstraintPtr NewRegex(
      const ::blink::String& value);
  // Construct an instance holding |unknown_type|.
  static ResponseConstraintPtr NewUnknownType(
      bool value);

  template <typename U>
  static ResponseConstraintPtr From(const U& u) {
    return mojo::TypeConverter<ResponseConstraintPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResponseConstraint>::Convert(*this);
  }
  ~ResponseConstraint();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ResponseConstraint(const ResponseConstraint& other) = delete;
  ResponseConstraint& operator=(const ResponseConstraint& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ResponseConstraintPtr>
  ResponseConstraintPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ResponseConstraint>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ResponseConstraint>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_json_schema() const { return tag_ == Tag::kJsonSchema; }
  const ::blink::String& get_json_schema() const {
    CHECK(tag_ == Tag::kJsonSchema);
    return data_.json_schema;
  }
  ::blink::String& get_json_schema() {
    CHECK(tag_ == Tag::kJsonSchema);
    return data_.json_schema;
  }
  void set_json_schema(const ::blink::String& json_schema);

  bool is_regex() const { return tag_ == Tag::kRegex; }
  const ::blink::String& get_regex() const {
    CHECK(tag_ == Tag::kRegex);
    return data_.regex;
  }
  ::blink::String& get_regex() {
    CHECK(tag_ == Tag::kRegex);
    return data_.regex;
  }
  void set_regex(const ::blink::String& regex);

  bool is_unknown_type() const { return tag_ == Tag::kUnknownType; }
  bool get_unknown_type() const {
    CHECK(tag_ == Tag::kUnknownType);
    return data_.unknown_type;
  }
  void set_unknown_type(bool unknown_type);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResponseConstraint::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ResponseConstraint::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kJsonSchema)>,
        const ::blink::String& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRegex)>,
        const ::blink::String& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUnknownType)>,
        bool value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::String json_schema;
    ::blink::String regex;
    bool unknown_type;
  };

  ResponseConstraint(
      std::in_place_index_t<static_cast<size_t>(Tag::kJsonSchema)>,
      const ::blink::String& value);
  ResponseConstraint(
      std::in_place_index_t<static_cast<size_t>(Tag::kRegex)>,
      const ::blink::String& value);
  ResponseConstraint(
      std::in_place_index_t<static_cast<size_t>(Tag::kUnknownType)>,
      bool value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class PLATFORM_EXPORT AdaptationAssets {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdaptationAssets, T>::value>;
  using DataView = AdaptationAssetsDataView;
  using Data_ = internal::AdaptationAssets_Data;

  template <typename... Args>
  static AdaptationAssetsPtr New(Args&&... args) {
    return AdaptationAssetsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdaptationAssetsPtr From(const U& u) {
    return mojo::TypeConverter<AdaptationAssetsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdaptationAssets>::Convert(*this);
  }


  AdaptationAssets();

  AdaptationAssets(
      ::base::File weights,
      const std::optional<::base::FilePath>& weights_path);

AdaptationAssets(const AdaptationAssets&) = delete;
AdaptationAssets& operator=(const AdaptationAssets&) = delete;

  ~AdaptationAssets();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdaptationAssetsPtr>
  AdaptationAssetsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdaptationAssets::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdaptationAssets::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdaptationAssets::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdaptationAssets::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdaptationAssets_UnserializedMessageContext<
            UserType, AdaptationAssets::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdaptationAssets::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdaptationAssets::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdaptationAssets_UnserializedMessageContext<
            UserType, AdaptationAssets::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdaptationAssets::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::File weights;
  
  std::optional<::base::FilePath> weights_path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdaptationAssets::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdaptationAssets::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdaptationAssets::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdaptationAssets::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT SafetyInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SafetyInfo, T>::value>;
  using DataView = SafetyInfoDataView;
  using Data_ = internal::SafetyInfo_Data;

  template <typename... Args>
  static SafetyInfoPtr New(Args&&... args) {
    return SafetyInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SafetyInfoPtr From(const U& u) {
    return mojo::TypeConverter<SafetyInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SafetyInfo>::Convert(*this);
  }


  SafetyInfo();

  SafetyInfo(
      ::blink::Vector<float> class_scores,
      LanguageDetectionResultPtr language);

SafetyInfo(const SafetyInfo&) = delete;
SafetyInfo& operator=(const SafetyInfo&) = delete;

  ~SafetyInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SafetyInfoPtr>
  SafetyInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SafetyInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SafetyInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SafetyInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SafetyInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SafetyInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SafetyInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SafetyInfo_UnserializedMessageContext<
            UserType, SafetyInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SafetyInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SafetyInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SafetyInfo_UnserializedMessageContext<
            UserType, SafetyInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SafetyInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<float> class_scores;
  
  LanguageDetectionResultPtr language;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SafetyInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SafetyInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SafetyInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SafetyInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ResponseChunk {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResponseChunk, T>::value>;
  using DataView = ResponseChunkDataView;
  using Data_ = internal::ResponseChunk_Data;

  template <typename... Args>
  static ResponseChunkPtr New(Args&&... args) {
    return ResponseChunkPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResponseChunkPtr From(const U& u) {
    return mojo::TypeConverter<ResponseChunkPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResponseChunk>::Convert(*this);
  }


  ResponseChunk();

  ResponseChunk(
      const ::blink::String& text,
      SafetyInfoPtr safety_info);

ResponseChunk(const ResponseChunk&) = delete;
ResponseChunk& operator=(const ResponseChunk&) = delete;

  ~ResponseChunk();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResponseChunkPtr>
  ResponseChunkPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResponseChunk::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ResponseChunk::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ResponseChunk::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResponseChunk::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResponseChunk::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResponseChunk::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResponseChunk_UnserializedMessageContext<
            UserType, ResponseChunk::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ResponseChunk::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ResponseChunk::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResponseChunk_UnserializedMessageContext<
            UserType, ResponseChunk::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResponseChunk::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String text;
  
  SafetyInfoPtr safety_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResponseChunk::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResponseChunk::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResponseChunk::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResponseChunk::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ResponseSummary {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResponseSummary, T>::value>;
  using DataView = ResponseSummaryDataView;
  using Data_ = internal::ResponseSummary_Data;

  template <typename... Args>
  static ResponseSummaryPtr New(Args&&... args) {
    return ResponseSummaryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResponseSummaryPtr From(const U& u) {
    return mojo::TypeConverter<ResponseSummaryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResponseSummary>::Convert(*this);
  }


  ResponseSummary();

  ResponseSummary(
      SafetyInfoPtr safety_info,
      uint32_t output_token_count);

ResponseSummary(const ResponseSummary&) = delete;
ResponseSummary& operator=(const ResponseSummary&) = delete;

  ~ResponseSummary();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResponseSummaryPtr>
  ResponseSummaryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResponseSummary::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ResponseSummary::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ResponseSummary::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResponseSummary::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResponseSummary::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResponseSummary::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResponseSummary_UnserializedMessageContext<
            UserType, ResponseSummary::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ResponseSummary::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ResponseSummary::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResponseSummary_UnserializedMessageContext<
            UserType, ResponseSummary::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResponseSummary::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SafetyInfoPtr safety_info;
  
  uint32_t output_token_count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResponseSummary::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResponseSummary::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResponseSummary::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResponseSummary::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT LoadAdaptationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoadAdaptationParams, T>::value>;
  using DataView = LoadAdaptationParamsDataView;
  using Data_ = internal::LoadAdaptationParams_Data;

  template <typename... Args>
  static LoadAdaptationParamsPtr New(Args&&... args) {
    return LoadAdaptationParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoadAdaptationParamsPtr From(const U& u) {
    return mojo::TypeConverter<LoadAdaptationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoadAdaptationParams>::Convert(*this);
  }


  LoadAdaptationParams();

  explicit LoadAdaptationParams(
      AdaptationAssetsPtr assets);

LoadAdaptationParams(const LoadAdaptationParams&) = delete;
LoadAdaptationParams& operator=(const LoadAdaptationParams&) = delete;

  ~LoadAdaptationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoadAdaptationParamsPtr>
  LoadAdaptationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoadAdaptationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LoadAdaptationParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LoadAdaptationParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoadAdaptationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoadAdaptationParams_UnserializedMessageContext<
            UserType, LoadAdaptationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LoadAdaptationParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LoadAdaptationParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoadAdaptationParams_UnserializedMessageContext<
            UserType, LoadAdaptationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoadAdaptationParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AdaptationAssetsPtr assets;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoadAdaptationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoadAdaptationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoadAdaptationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoadAdaptationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT SessionParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SessionParams, T>::value>;
  using DataView = SessionParamsDataView;
  using Data_ = internal::SessionParams_Data;

  template <typename... Args>
  static SessionParamsPtr New(Args&&... args) {
    return SessionParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SessionParamsPtr From(const U& u) {
    return mojo::TypeConverter<SessionParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SessionParams>::Convert(*this);
  }


  SessionParams();

  SessionParams(
      uint32_t max_tokens,
      CapabilitiesPtr capabilities);

  SessionParams(
      uint32_t max_tokens,
      CapabilitiesPtr capabilities,
      uint32_t top_k,
      float temperature);

SessionParams(const SessionParams&) = delete;
SessionParams& operator=(const SessionParams&) = delete;

  ~SessionParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SessionParamsPtr>
  SessionParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SessionParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SessionParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SessionParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SessionParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SessionParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SessionParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SessionParams_UnserializedMessageContext<
            UserType, SessionParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SessionParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SessionParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SessionParams_UnserializedMessageContext<
            UserType, SessionParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SessionParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t max_tokens;
  
  CapabilitiesPtr capabilities;
  
  uint32_t top_k;
  
  float temperature;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SessionParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SessionParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SessionParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SessionParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT Input {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Input, T>::value>;
  using DataView = InputDataView;
  using Data_ = internal::Input_Data;

  template <typename... Args>
  static InputPtr New(Args&&... args) {
    return InputPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InputPtr From(const U& u) {
    return mojo::TypeConverter<InputPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Input>::Convert(*this);
  }


  Input();

  explicit Input(
      ::blink::Vector<InputPiecePtr> pieces);

Input(const Input&) = delete;
Input& operator=(const Input&) = delete;

  ~Input();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InputPtr>
  InputPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Input::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Input::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Input::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Input::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Input_UnserializedMessageContext<
            UserType, Input::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Input::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Input::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Input_UnserializedMessageContext<
            UserType, Input::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Input::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<InputPiecePtr> pieces;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Input::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Input::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Input::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Input::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AppendOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AppendOptions, T>::value>;
  using DataView = AppendOptionsDataView;
  using Data_ = internal::AppendOptions_Data;

  template <typename... Args>
  static AppendOptionsPtr New(Args&&... args) {
    return AppendOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AppendOptionsPtr From(const U& u) {
    return mojo::TypeConverter<AppendOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AppendOptions>::Convert(*this);
  }


  AppendOptions();

  AppendOptions(
      InputPtr input,
      uint32_t max_tokens);

AppendOptions(const AppendOptions&) = delete;
AppendOptions& operator=(const AppendOptions&) = delete;

  ~AppendOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AppendOptionsPtr>
  AppendOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AppendOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AppendOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AppendOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AppendOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AppendOptions_UnserializedMessageContext<
            UserType, AppendOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AppendOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AppendOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AppendOptions_UnserializedMessageContext<
            UserType, AppendOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AppendOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  InputPtr input;
  
  uint32_t max_tokens;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AppendOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AppendOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AppendOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AppendOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT GenerateOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GenerateOptions, T>::value>;
  using DataView = GenerateOptionsDataView;
  using Data_ = internal::GenerateOptions_Data;

  template <typename... Args>
  static GenerateOptionsPtr New(Args&&... args) {
    return GenerateOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GenerateOptionsPtr From(const U& u) {
    return mojo::TypeConverter<GenerateOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GenerateOptions>::Convert(*this);
  }


  GenerateOptions();

  explicit GenerateOptions(
      uint32_t max_output_tokens);

  GenerateOptions(
      uint32_t max_output_tokens,
      ResponseConstraintPtr constraint);

GenerateOptions(const GenerateOptions&) = delete;
GenerateOptions& operator=(const GenerateOptions&) = delete;

  ~GenerateOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GenerateOptionsPtr>
  GenerateOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GenerateOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GenerateOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GenerateOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GenerateOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GenerateOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GenerateOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GenerateOptions_UnserializedMessageContext<
            UserType, GenerateOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GenerateOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GenerateOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GenerateOptions_UnserializedMessageContext<
            UserType, GenerateOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GenerateOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t max_output_tokens;
  
  ResponseConstraintPtr constraint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GenerateOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GenerateOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GenerateOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GenerateOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AudioData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioData, T>::value>;
  using DataView = AudioDataDataView;
  using Data_ = internal::AudioData_Data;

  template <typename... Args>
  static AudioDataPtr New(Args&&... args) {
    return AudioDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioDataPtr From(const U& u) {
    return mojo::TypeConverter<AudioDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioData>::Convert(*this);
  }


  AudioData();

  AudioData(
      int32_t channel_count,
      int32_t sample_rate,
      int32_t frame_count,
      ::blink::Vector<float> data);


  ~AudioData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioDataPtr>
  AudioDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioData_UnserializedMessageContext<
            UserType, AudioData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioData_UnserializedMessageContext<
            UserType, AudioData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t channel_count;
  
  int32_t sample_rate;
  
  int32_t frame_count;
  
  ::blink::Vector<float> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





template <typename UnionPtrType>
InputPiecePtr InputPiece::Clone() const {
  switch (tag_) {
    case Tag::kToken:
      return NewToken(
          mojo::Clone(data_.token));
    case Tag::kText:
      return NewText(
          mojo::Clone(data_.text));
    case Tag::kBitmap:
      return NewBitmap(
          mojo::Clone(data_.bitmap));
    case Tag::kUnknownType:
      return NewUnknownType(
          mojo::Clone(data_.unknown_type));
    case Tag::kAudio:
      return NewAudio(
          mojo::Clone(data_.audio));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, InputPiece>::value>::type*>
bool InputPiece::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kToken:
      return mojo::Equals(data_.token, other.data_.token);
    case Tag::kText:
      return mojo::Equals(data_.text, other.data_.text);
    case Tag::kBitmap:
      return mojo::Equals(data_.bitmap, other.data_.bitmap);
    case Tag::kUnknownType:
      return mojo::Equals(data_.unknown_type, other.data_.unknown_type);
    case Tag::kAudio:
      return mojo::Equals(data_.audio, other.data_.audio);
  }

  return false;
}
template <typename UnionPtrType>
ResponseConstraintPtr ResponseConstraint::Clone() const {
  switch (tag_) {
    case Tag::kJsonSchema:
      return NewJsonSchema(
          mojo::Clone(data_.json_schema));
    case Tag::kRegex:
      return NewRegex(
          mojo::Clone(data_.regex));
    case Tag::kUnknownType:
      return NewUnknownType(
          mojo::Clone(data_.unknown_type));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ResponseConstraint>::value>::type*>
bool ResponseConstraint::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kJsonSchema:
      return mojo::Equals(data_.json_schema, other.data_.json_schema);
    case Tag::kRegex:
      return mojo::Equals(data_.regex, other.data_.regex);
    case Tag::kUnknownType:
      return mojo::Equals(data_.unknown_type, other.data_.unknown_type);
  }

  return false;
}
template <typename StructPtrType>
AdaptationAssetsPtr AdaptationAssets::Clone() const {
  return New(
      mojo::Clone(weights),
      mojo::Clone(weights_path)
  );
}

template <typename T, AdaptationAssets::EnableIfSame<T>*>
bool AdaptationAssets::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->weights, other_struct.weights))
    return false;
  if (!mojo::Equals(this->weights_path, other_struct.weights_path))
    return false;
  return true;
}

template <typename T, AdaptationAssets::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.weights < rhs.weights)
    return true;
  if (rhs.weights < lhs.weights)
    return false;
  if (lhs.weights_path < rhs.weights_path)
    return true;
  if (rhs.weights_path < lhs.weights_path)
    return false;
  return false;
}
template <typename StructPtrType>
LanguageDetectionResultPtr LanguageDetectionResult::Clone() const {
  return New(
      mojo::Clone(code),
      mojo::Clone(reliability)
  );
}

template <typename T, LanguageDetectionResult::EnableIfSame<T>*>
bool LanguageDetectionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->reliability, other_struct.reliability))
    return false;
  return true;
}

template <typename T, LanguageDetectionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  if (lhs.reliability < rhs.reliability)
    return true;
  if (rhs.reliability < lhs.reliability)
    return false;
  return false;
}
template <typename StructPtrType>
SafetyInfoPtr SafetyInfo::Clone() const {
  return New(
      mojo::Clone(class_scores),
      mojo::Clone(language)
  );
}

template <typename T, SafetyInfo::EnableIfSame<T>*>
bool SafetyInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->class_scores, other_struct.class_scores))
    return false;
  if (!mojo::Equals(this->language, other_struct.language))
    return false;
  return true;
}

template <typename T, SafetyInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.class_scores < rhs.class_scores)
    return true;
  if (rhs.class_scores < lhs.class_scores)
    return false;
  if (lhs.language < rhs.language)
    return true;
  if (rhs.language < lhs.language)
    return false;
  return false;
}
template <typename StructPtrType>
ResponseChunkPtr ResponseChunk::Clone() const {
  return New(
      mojo::Clone(text),
      mojo::Clone(safety_info)
  );
}

template <typename T, ResponseChunk::EnableIfSame<T>*>
bool ResponseChunk::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->safety_info, other_struct.safety_info))
    return false;
  return true;
}

template <typename T, ResponseChunk::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.safety_info < rhs.safety_info)
    return true;
  if (rhs.safety_info < lhs.safety_info)
    return false;
  return false;
}
template <typename StructPtrType>
ResponseSummaryPtr ResponseSummary::Clone() const {
  return New(
      mojo::Clone(safety_info),
      mojo::Clone(output_token_count)
  );
}

template <typename T, ResponseSummary::EnableIfSame<T>*>
bool ResponseSummary::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->safety_info, other_struct.safety_info))
    return false;
  if (!mojo::Equals(this->output_token_count, other_struct.output_token_count))
    return false;
  return true;
}

template <typename T, ResponseSummary::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.safety_info < rhs.safety_info)
    return true;
  if (rhs.safety_info < lhs.safety_info)
    return false;
  if (lhs.output_token_count < rhs.output_token_count)
    return true;
  if (rhs.output_token_count < lhs.output_token_count)
    return false;
  return false;
}
template <typename StructPtrType>
LoadAdaptationParamsPtr LoadAdaptationParams::Clone() const {
  return New(
      mojo::Clone(assets)
  );
}

template <typename T, LoadAdaptationParams::EnableIfSame<T>*>
bool LoadAdaptationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->assets, other_struct.assets))
    return false;
  return true;
}

template <typename T, LoadAdaptationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.assets < rhs.assets)
    return true;
  if (rhs.assets < lhs.assets)
    return false;
  return false;
}
template <typename StructPtrType>
CapabilitiesPtr Capabilities::Clone() const {
  return New(
      mojo::Clone(image_input),
      mojo::Clone(audio_input)
  );
}

template <typename T, Capabilities::EnableIfSame<T>*>
bool Capabilities::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_input, other_struct.image_input))
    return false;
  if (!mojo::Equals(this->audio_input, other_struct.audio_input))
    return false;
  return true;
}

template <typename T, Capabilities::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_input < rhs.image_input)
    return true;
  if (rhs.image_input < lhs.image_input)
    return false;
  if (lhs.audio_input < rhs.audio_input)
    return true;
  if (rhs.audio_input < lhs.audio_input)
    return false;
  return false;
}
template <typename StructPtrType>
SessionParamsPtr SessionParams::Clone() const {
  return New(
      mojo::Clone(max_tokens),
      mojo::Clone(capabilities),
      mojo::Clone(top_k),
      mojo::Clone(temperature)
  );
}

template <typename T, SessionParams::EnableIfSame<T>*>
bool SessionParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->max_tokens, other_struct.max_tokens))
    return false;
  if (!mojo::Equals(this->capabilities, other_struct.capabilities))
    return false;
  if (!mojo::Equals(this->top_k, other_struct.top_k))
    return false;
  if (!mojo::Equals(this->temperature, other_struct.temperature))
    return false;
  return true;
}

template <typename T, SessionParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.max_tokens < rhs.max_tokens)
    return true;
  if (rhs.max_tokens < lhs.max_tokens)
    return false;
  if (lhs.capabilities < rhs.capabilities)
    return true;
  if (rhs.capabilities < lhs.capabilities)
    return false;
  if (lhs.top_k < rhs.top_k)
    return true;
  if (rhs.top_k < lhs.top_k)
    return false;
  if (lhs.temperature < rhs.temperature)
    return true;
  if (rhs.temperature < lhs.temperature)
    return false;
  return false;
}
template <typename StructPtrType>
InputPtr Input::Clone() const {
  return New(
      mojo::Clone(pieces)
  );
}

template <typename T, Input::EnableIfSame<T>*>
bool Input::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pieces, other_struct.pieces))
    return false;
  return true;
}

template <typename T, Input::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pieces < rhs.pieces)
    return true;
  if (rhs.pieces < lhs.pieces)
    return false;
  return false;
}
template <typename StructPtrType>
AppendOptionsPtr AppendOptions::Clone() const {
  return New(
      mojo::Clone(input),
      mojo::Clone(max_tokens)
  );
}

template <typename T, AppendOptions::EnableIfSame<T>*>
bool AppendOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input, other_struct.input))
    return false;
  if (!mojo::Equals(this->max_tokens, other_struct.max_tokens))
    return false;
  return true;
}

template <typename T, AppendOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input < rhs.input)
    return true;
  if (rhs.input < lhs.input)
    return false;
  if (lhs.max_tokens < rhs.max_tokens)
    return true;
  if (rhs.max_tokens < lhs.max_tokens)
    return false;
  return false;
}
template <typename StructPtrType>
GenerateOptionsPtr GenerateOptions::Clone() const {
  return New(
      mojo::Clone(max_output_tokens),
      mojo::Clone(constraint)
  );
}

template <typename T, GenerateOptions::EnableIfSame<T>*>
bool GenerateOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->max_output_tokens, other_struct.max_output_tokens))
    return false;
  if (!mojo::Equals(this->constraint, other_struct.constraint))
    return false;
  return true;
}

template <typename T, GenerateOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.max_output_tokens < rhs.max_output_tokens)
    return true;
  if (rhs.max_output_tokens < lhs.max_output_tokens)
    return false;
  if (lhs.constraint < rhs.constraint)
    return true;
  if (rhs.constraint < lhs.constraint)
    return false;
  return false;
}
template <typename StructPtrType>
AudioDataPtr AudioData::Clone() const {
  return New(
      mojo::Clone(channel_count),
      mojo::Clone(sample_rate),
      mojo::Clone(frame_count),
      mojo::Clone(data)
  );
}

template <typename T, AudioData::EnableIfSame<T>*>
bool AudioData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->channel_count, other_struct.channel_count))
    return false;
  if (!mojo::Equals(this->sample_rate, other_struct.sample_rate))
    return false;
  if (!mojo::Equals(this->frame_count, other_struct.frame_count))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, AudioData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.channel_count < rhs.channel_count)
    return true;
  if (rhs.channel_count < lhs.channel_count)
    return false;
  if (lhs.sample_rate < rhs.sample_rate)
    return true;
  if (rhs.sample_rate < lhs.sample_rate)
    return false;
  if (lhs.frame_count < rhs.frame_count)
    return true;
  if (rhs.frame_count < lhs.frame_count)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
SpeechRecognitionResultPtr SpeechRecognitionResult::Clone() const {
  return New(
      mojo::Clone(transcript),
      mojo::Clone(is_final)
  );
}

template <typename T, SpeechRecognitionResult::EnableIfSame<T>*>
bool SpeechRecognitionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->transcript, other_struct.transcript))
    return false;
  if (!mojo::Equals(this->is_final, other_struct.is_final))
    return false;
  return true;
}

template <typename T, SpeechRecognitionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.transcript < rhs.transcript)
    return true;
  if (rhs.transcript < lhs.transcript)
    return false;
  if (lhs.is_final < rhs.is_final)
    return true;
  if (rhs.is_final < lhs.is_final)
    return false;
  return false;
}
template <typename StructPtrType>
AsrStreamOptionsPtr AsrStreamOptions::Clone() const {
  return New(
      mojo::Clone(sample_rate_hz)
  );
}

template <typename T, AsrStreamOptions::EnableIfSame<T>*>
bool AsrStreamOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sample_rate_hz, other_struct.sample_rate_hz))
    return false;
  return true;
}

template <typename T, AsrStreamOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sample_rate_hz < rhs.sample_rate_hz)
    return true;
  if (rhs.sample_rate_hz < lhs.sample_rate_hz)
    return false;
  return false;
}
template <typename StructPtrType>
DevicePerformanceInfoPtr DevicePerformanceInfo::Clone() const {
  return New(
      mojo::Clone(performance_class),
      mojo::Clone(vram_mb)
  );
}

template <typename T, DevicePerformanceInfo::EnableIfSame<T>*>
bool DevicePerformanceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->performance_class, other_struct.performance_class))
    return false;
  if (!mojo::Equals(this->vram_mb, other_struct.vram_mb))
    return false;
  return true;
}

template <typename T, DevicePerformanceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.performance_class < rhs.performance_class)
    return true;
  if (rhs.performance_class < lhs.performance_class)
    return false;
  if (lhs.vram_mb < rhs.vram_mb)
    return true;
  if (rhs.vram_mb < lhs.vram_mb)
    return false;
  return false;
}
template <typename StructPtrType>
DeviceInfoPtr DeviceInfo::Clone() const {
  return New(
      mojo::Clone(vendor_id),
      mojo::Clone(device_id),
      mojo::Clone(driver_version),
      mojo::Clone(supports_fp16)
  );
}

template <typename T, DeviceInfo::EnableIfSame<T>*>
bool DeviceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->vendor_id, other_struct.vendor_id))
    return false;
  if (!mojo::Equals(this->device_id, other_struct.device_id))
    return false;
  if (!mojo::Equals(this->driver_version, other_struct.driver_version))
    return false;
  if (!mojo::Equals(this->supports_fp16, other_struct.supports_fp16))
    return false;
  return true;
}

template <typename T, DeviceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.vendor_id < rhs.vendor_id)
    return true;
  if (rhs.vendor_id < lhs.vendor_id)
    return false;
  if (lhs.device_id < rhs.device_id)
    return true;
  if (rhs.device_id < lhs.device_id)
    return false;
  if (lhs.driver_version < rhs.driver_version)
    return true;
  if (rhs.driver_version < lhs.driver_version)
    return false;
  if (lhs.supports_fp16 < rhs.supports_fp16)
    return true;
  if (rhs.supports_fp16 < lhs.supports_fp16)
    return false;
  return false;
}


}  // on_device_model::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::AdaptationAssets::DataView,
                                         ::on_device_model::mojom::blink::AdaptationAssetsPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::AdaptationAssetsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::AdaptationAssetsPtr* output) { output->reset(); }

  static  decltype(::on_device_model::mojom::blink::AdaptationAssets::weights)& weights(
       ::on_device_model::mojom::blink::AdaptationAssetsPtr& input) {
    return input->weights;
  }

  static const decltype(::on_device_model::mojom::blink::AdaptationAssets::weights_path)& weights_path(
      const ::on_device_model::mojom::blink::AdaptationAssetsPtr& input) {
    return input->weights_path;
  }

  static bool Read(::on_device_model::mojom::blink::AdaptationAssets::DataView input, ::on_device_model::mojom::blink::AdaptationAssetsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::LanguageDetectionResult::DataView,
                                         ::on_device_model::mojom::blink::LanguageDetectionResultPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::LanguageDetectionResultPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::LanguageDetectionResultPtr* output) { output->reset(); }

  static const decltype(::on_device_model::mojom::blink::LanguageDetectionResult::code)& code(
      const ::on_device_model::mojom::blink::LanguageDetectionResultPtr& input) {
    return input->code;
  }

  static decltype(::on_device_model::mojom::blink::LanguageDetectionResult::reliability) reliability(
      const ::on_device_model::mojom::blink::LanguageDetectionResultPtr& input) {
    return input->reliability;
  }

  static bool Read(::on_device_model::mojom::blink::LanguageDetectionResult::DataView input, ::on_device_model::mojom::blink::LanguageDetectionResultPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::SafetyInfo::DataView,
                                         ::on_device_model::mojom::blink::SafetyInfoPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::SafetyInfoPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::SafetyInfoPtr* output) { output->reset(); }

  static const decltype(::on_device_model::mojom::blink::SafetyInfo::class_scores)& class_scores(
      const ::on_device_model::mojom::blink::SafetyInfoPtr& input) {
    return input->class_scores;
  }

  static const decltype(::on_device_model::mojom::blink::SafetyInfo::language)& language(
      const ::on_device_model::mojom::blink::SafetyInfoPtr& input) {
    return input->language;
  }

  static bool Read(::on_device_model::mojom::blink::SafetyInfo::DataView input, ::on_device_model::mojom::blink::SafetyInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::ResponseChunk::DataView,
                                         ::on_device_model::mojom::blink::ResponseChunkPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::ResponseChunkPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::ResponseChunkPtr* output) { output->reset(); }

  static const decltype(::on_device_model::mojom::blink::ResponseChunk::text)& text(
      const ::on_device_model::mojom::blink::ResponseChunkPtr& input) {
    return input->text;
  }

  static const decltype(::on_device_model::mojom::blink::ResponseChunk::safety_info)& safety_info(
      const ::on_device_model::mojom::blink::ResponseChunkPtr& input) {
    return input->safety_info;
  }

  static bool Read(::on_device_model::mojom::blink::ResponseChunk::DataView input, ::on_device_model::mojom::blink::ResponseChunkPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::ResponseSummary::DataView,
                                         ::on_device_model::mojom::blink::ResponseSummaryPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::ResponseSummaryPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::ResponseSummaryPtr* output) { output->reset(); }

  static const decltype(::on_device_model::mojom::blink::ResponseSummary::safety_info)& safety_info(
      const ::on_device_model::mojom::blink::ResponseSummaryPtr& input) {
    return input->safety_info;
  }

  static decltype(::on_device_model::mojom::blink::ResponseSummary::output_token_count) output_token_count(
      const ::on_device_model::mojom::blink::ResponseSummaryPtr& input) {
    return input->output_token_count;
  }

  static bool Read(::on_device_model::mojom::blink::ResponseSummary::DataView input, ::on_device_model::mojom::blink::ResponseSummaryPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::LoadAdaptationParams::DataView,
                                         ::on_device_model::mojom::blink::LoadAdaptationParamsPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::LoadAdaptationParamsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::LoadAdaptationParamsPtr* output) { output->reset(); }

  static  decltype(::on_device_model::mojom::blink::LoadAdaptationParams::assets)& assets(
       ::on_device_model::mojom::blink::LoadAdaptationParamsPtr& input) {
    return input->assets;
  }

  static bool Read(::on_device_model::mojom::blink::LoadAdaptationParams::DataView input, ::on_device_model::mojom::blink::LoadAdaptationParamsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::Capabilities::DataView,
                                         ::on_device_model::mojom::blink::CapabilitiesPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::CapabilitiesPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::CapabilitiesPtr* output) { output->reset(); }

  static decltype(::on_device_model::mojom::blink::Capabilities::image_input) image_input(
      const ::on_device_model::mojom::blink::CapabilitiesPtr& input) {
    return input->image_input;
  }

  static decltype(::on_device_model::mojom::blink::Capabilities::audio_input) audio_input(
      const ::on_device_model::mojom::blink::CapabilitiesPtr& input) {
    return input->audio_input;
  }

  static bool Read(::on_device_model::mojom::blink::Capabilities::DataView input, ::on_device_model::mojom::blink::CapabilitiesPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::SessionParams::DataView,
                                         ::on_device_model::mojom::blink::SessionParamsPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::SessionParamsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::SessionParamsPtr* output) { output->reset(); }

  static decltype(::on_device_model::mojom::blink::SessionParams::max_tokens) max_tokens(
      const ::on_device_model::mojom::blink::SessionParamsPtr& input) {
    return input->max_tokens;
  }

  static const decltype(::on_device_model::mojom::blink::SessionParams::capabilities)& capabilities(
      const ::on_device_model::mojom::blink::SessionParamsPtr& input) {
    return input->capabilities;
  }

  static decltype(::on_device_model::mojom::blink::SessionParams::top_k) top_k(
      const ::on_device_model::mojom::blink::SessionParamsPtr& input) {
    return input->top_k;
  }

  static decltype(::on_device_model::mojom::blink::SessionParams::temperature) temperature(
      const ::on_device_model::mojom::blink::SessionParamsPtr& input) {
    return input->temperature;
  }

  static bool Read(::on_device_model::mojom::blink::SessionParams::DataView input, ::on_device_model::mojom::blink::SessionParamsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::Input::DataView,
                                         ::on_device_model::mojom::blink::InputPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::InputPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::InputPtr* output) { output->reset(); }

  static  decltype(::on_device_model::mojom::blink::Input::pieces)& pieces(
       ::on_device_model::mojom::blink::InputPtr& input) {
    return input->pieces;
  }

  static bool Read(::on_device_model::mojom::blink::Input::DataView input, ::on_device_model::mojom::blink::InputPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::AppendOptions::DataView,
                                         ::on_device_model::mojom::blink::AppendOptionsPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::AppendOptionsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::AppendOptionsPtr* output) { output->reset(); }

  static  decltype(::on_device_model::mojom::blink::AppendOptions::input)& input(
       ::on_device_model::mojom::blink::AppendOptionsPtr& input) {
    return input->input;
  }

  static decltype(::on_device_model::mojom::blink::AppendOptions::max_tokens) max_tokens(
      const ::on_device_model::mojom::blink::AppendOptionsPtr& input) {
    return input->max_tokens;
  }

  static bool Read(::on_device_model::mojom::blink::AppendOptions::DataView input, ::on_device_model::mojom::blink::AppendOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::GenerateOptions::DataView,
                                         ::on_device_model::mojom::blink::GenerateOptionsPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::GenerateOptionsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::GenerateOptionsPtr* output) { output->reset(); }

  static decltype(::on_device_model::mojom::blink::GenerateOptions::max_output_tokens) max_output_tokens(
      const ::on_device_model::mojom::blink::GenerateOptionsPtr& input) {
    return input->max_output_tokens;
  }

  static const decltype(::on_device_model::mojom::blink::GenerateOptions::constraint)& constraint(
      const ::on_device_model::mojom::blink::GenerateOptionsPtr& input) {
    return input->constraint;
  }

  static bool Read(::on_device_model::mojom::blink::GenerateOptions::DataView input, ::on_device_model::mojom::blink::GenerateOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::AudioData::DataView,
                                         ::on_device_model::mojom::blink::AudioDataPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::AudioDataPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::AudioDataPtr* output) { output->reset(); }

  static decltype(::on_device_model::mojom::blink::AudioData::channel_count) channel_count(
      const ::on_device_model::mojom::blink::AudioDataPtr& input) {
    return input->channel_count;
  }

  static decltype(::on_device_model::mojom::blink::AudioData::sample_rate) sample_rate(
      const ::on_device_model::mojom::blink::AudioDataPtr& input) {
    return input->sample_rate;
  }

  static decltype(::on_device_model::mojom::blink::AudioData::frame_count) frame_count(
      const ::on_device_model::mojom::blink::AudioDataPtr& input) {
    return input->frame_count;
  }

  static const decltype(::on_device_model::mojom::blink::AudioData::data)& data(
      const ::on_device_model::mojom::blink::AudioDataPtr& input) {
    return input->data;
  }

  static bool Read(::on_device_model::mojom::blink::AudioData::DataView input, ::on_device_model::mojom::blink::AudioDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::SpeechRecognitionResult::DataView,
                                         ::on_device_model::mojom::blink::SpeechRecognitionResultPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::SpeechRecognitionResultPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::SpeechRecognitionResultPtr* output) { output->reset(); }

  static const decltype(::on_device_model::mojom::blink::SpeechRecognitionResult::transcript)& transcript(
      const ::on_device_model::mojom::blink::SpeechRecognitionResultPtr& input) {
    return input->transcript;
  }

  static decltype(::on_device_model::mojom::blink::SpeechRecognitionResult::is_final) is_final(
      const ::on_device_model::mojom::blink::SpeechRecognitionResultPtr& input) {
    return input->is_final;
  }

  static bool Read(::on_device_model::mojom::blink::SpeechRecognitionResult::DataView input, ::on_device_model::mojom::blink::SpeechRecognitionResultPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::AsrStreamOptions::DataView,
                                         ::on_device_model::mojom::blink::AsrStreamOptionsPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::AsrStreamOptionsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::AsrStreamOptionsPtr* output) { output->reset(); }

  static decltype(::on_device_model::mojom::blink::AsrStreamOptions::sample_rate_hz) sample_rate_hz(
      const ::on_device_model::mojom::blink::AsrStreamOptionsPtr& input) {
    return input->sample_rate_hz;
  }

  static bool Read(::on_device_model::mojom::blink::AsrStreamOptions::DataView input, ::on_device_model::mojom::blink::AsrStreamOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::DevicePerformanceInfo::DataView,
                                         ::on_device_model::mojom::blink::DevicePerformanceInfoPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::DevicePerformanceInfoPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::DevicePerformanceInfoPtr* output) { output->reset(); }

  static decltype(::on_device_model::mojom::blink::DevicePerformanceInfo::performance_class) performance_class(
      const ::on_device_model::mojom::blink::DevicePerformanceInfoPtr& input) {
    return input->performance_class;
  }

  static decltype(::on_device_model::mojom::blink::DevicePerformanceInfo::vram_mb) vram_mb(
      const ::on_device_model::mojom::blink::DevicePerformanceInfoPtr& input) {
    return input->vram_mb;
  }

  static bool Read(::on_device_model::mojom::blink::DevicePerformanceInfo::DataView input, ::on_device_model::mojom::blink::DevicePerformanceInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::on_device_model::mojom::blink::DeviceInfo::DataView,
                                         ::on_device_model::mojom::blink::DeviceInfoPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::DeviceInfoPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::DeviceInfoPtr* output) { output->reset(); }

  static decltype(::on_device_model::mojom::blink::DeviceInfo::vendor_id) vendor_id(
      const ::on_device_model::mojom::blink::DeviceInfoPtr& input) {
    return input->vendor_id;
  }

  static decltype(::on_device_model::mojom::blink::DeviceInfo::device_id) device_id(
      const ::on_device_model::mojom::blink::DeviceInfoPtr& input) {
    return input->device_id;
  }

  static const decltype(::on_device_model::mojom::blink::DeviceInfo::driver_version)& driver_version(
      const ::on_device_model::mojom::blink::DeviceInfoPtr& input) {
    return input->driver_version;
  }

  static decltype(::on_device_model::mojom::blink::DeviceInfo::supports_fp16) supports_fp16(
      const ::on_device_model::mojom::blink::DeviceInfoPtr& input) {
    return input->supports_fp16;
  }

  static bool Read(::on_device_model::mojom::blink::DeviceInfo::DataView input, ::on_device_model::mojom::blink::DeviceInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::on_device_model::mojom::blink::InputPiece::DataView,
                                        ::on_device_model::mojom::blink::InputPiecePtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::InputPiecePtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::InputPiecePtr* output) { output->reset(); }

  static ::on_device_model::mojom::blink::InputPiece::Tag GetTag(const ::on_device_model::mojom::blink::InputPiecePtr& input) {
    return input->which();
  }

  static  ::on_device_model::mojom::blink::Token token(const ::on_device_model::mojom::blink::InputPiecePtr& input) {
    return input->get_token();
  }

  static const ::blink::String& text(const ::on_device_model::mojom::blink::InputPiecePtr& input) {
    return input->get_text();
  }

  static  ::SkBitmap& bitmap( ::on_device_model::mojom::blink::InputPiecePtr& input) {
    return input->get_bitmap();
  }

  static  bool unknown_type(const ::on_device_model::mojom::blink::InputPiecePtr& input) {
    return input->get_unknown_type();
  }

  static const ::on_device_model::mojom::blink::AudioDataPtr& audio(const ::on_device_model::mojom::blink::InputPiecePtr& input) {
    return input->get_audio();
  }

  static bool Read(::on_device_model::mojom::blink::InputPiece::DataView input, ::on_device_model::mojom::blink::InputPiecePtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::on_device_model::mojom::blink::ResponseConstraint::DataView,
                                        ::on_device_model::mojom::blink::ResponseConstraintPtr> {
  static bool IsNull(const ::on_device_model::mojom::blink::ResponseConstraintPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::blink::ResponseConstraintPtr* output) { output->reset(); }

  static ::on_device_model::mojom::blink::ResponseConstraint::Tag GetTag(const ::on_device_model::mojom::blink::ResponseConstraintPtr& input) {
    return input->which();
  }

  static const ::blink::String& json_schema(const ::on_device_model::mojom::blink::ResponseConstraintPtr& input) {
    return input->get_json_schema();
  }

  static const ::blink::String& regex(const ::on_device_model::mojom::blink::ResponseConstraintPtr& input) {
    return input->get_regex();
  }

  static  bool unknown_type(const ::on_device_model::mojom::blink::ResponseConstraintPtr& input) {
    return input->get_unknown_type();
  }

  static bool Read(::on_device_model::mojom::blink::ResponseConstraint::DataView input, ::on_device_model::mojom::blink::ResponseConstraintPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_MOJOM_BLINK_H_