// services/network/public/mojom/url_response_head.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/url_response_head.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/alternate_protocol_usage.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "services/network/public/mojom/cors.mojom-shared.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"
#include "services/network/public/mojom/encoded_body_length.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/load_timing_internal_info.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/network/public/mojom/parsed_request_cookie.mojom-shared.h"
#include "services/network/public/mojom/service_worker_router_info.mojom-shared.h"
#include "services/network/public/mojom/source_type.mojom-shared.h"
#include "services/network/public/mojom/unencoded_digest.mojom-shared.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace network::mojom {
class URLResponseHeadDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::URLResponseHeadDataView> {
  using Data = ::network::mojom::internal::URLResponseHead_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class NavigationDeliveryType : int32_t {
  
  kDefault = 0,
  
  kNavigationalPrefetch = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, NavigationDeliveryType value);
inline bool IsKnownEnumValue(NavigationDeliveryType value) {
  return internal::NavigationDeliveryType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class URLResponseHeadDataView {
 public:
  URLResponseHeadDataView() = default;

  URLResponseHeadDataView(
      internal::URLResponseHead_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestTime(UserType* output) {
    
    auto* pointer = data_->request_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetResponseTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseTime(UserType* output) {
    
    auto* pointer = data_->response_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetOriginalResponseTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginalResponseTime(UserType* output) {
    
    auto* pointer = data_->original_response_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      ::network::mojom::HttpResponseHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpResponseHeadersDataView>(
        pointer, output, message_);
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCharsetDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCharset(UserType* output) {
    
    auto* pointer = data_->charset.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t content_length() const {
    return data_->content_length;
  }
  int64_t encoded_data_length() const {
    return data_->encoded_data_length;
  }
  inline void GetEncodedBodyLengthDataView(
      ::network::mojom::EncodedBodyLengthDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncodedBodyLength(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::EncodedBodyLengthDataView, UserType>(),
    "Attempting to read the optional `encoded_body_length` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEncodedBodyLength` instead "
    "of `ReadEncodedBodyLength if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->encoded_body_length.Get();
    return mojo::internal::Deserialize<::network::mojom::EncodedBodyLengthDataView>(
        pointer, output, message_);
  }
  bool network_accessed() const {
    return data_->network_accessed;
  }
  inline void GetLoadTimingDataView(
      ::network::mojom::LoadTimingInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLoadTiming(UserType* output) {
    
    auto* pointer = data_->load_timing.Get();
    return mojo::internal::Deserialize<::network::mojom::LoadTimingInfoDataView>(
        pointer, output, message_);
  }
  inline void GetLoadTimingInternalInfoDataView(
      ::network::mojom::LoadTimingInternalInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLoadTimingInternalInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::LoadTimingInternalInfoDataView, UserType>(),
    "Attempting to read the optional `load_timing_internal_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLoadTimingInternalInfo` instead "
    "of `ReadLoadTimingInternalInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->load_timing_internal_info.Get();
    return mojo::internal::Deserialize<::network::mojom::LoadTimingInternalInfoDataView>(
        pointer, output, message_);
  }
  bool emitted_extra_info() const {
    return data_->emitted_extra_info;
  }
  bool was_fetched_via_spdy() const {
    return data_->was_fetched_via_spdy;
  }
  bool was_alpn_negotiated() const {
    return data_->was_alpn_negotiated;
  }
  bool was_alternate_protocol_available() const {
    return data_->was_alternate_protocol_available;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadConnectionInfo(UserType* output) const {
    auto data_value = data_->connection_info;
    return mojo::internal::Deserialize<::network::mojom::ConnectionInfo>(
        data_value, output);
  }
  ::network::mojom::ConnectionInfo connection_info() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ConnectionInfo>(data_->connection_info));
  }
  inline void GetAlpnNegotiatedProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlpnNegotiatedProtocol(UserType* output) {
    
    auto* pointer = data_->alpn_negotiated_protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAlternateProtocolUsage(UserType* output) const {
    auto data_value = data_->alternate_protocol_usage;
    return mojo::internal::Deserialize<::network::mojom::AlternateProtocolUsage>(
        data_value, output);
  }
  ::network::mojom::AlternateProtocolUsage alternate_protocol_usage() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AlternateProtocolUsage>(data_->alternate_protocol_usage));
  }
  inline void GetRemoteEndpointDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteEndpoint(UserType* output) {
    
    auto* pointer = data_->remote_endpoint.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadClientAddressSpace(UserType* output) const {
    auto data_value = data_->client_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace client_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->client_address_space));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResponseAddressSpace(UserType* output) const {
    auto data_value = data_->response_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace response_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->response_address_space));
  }
  bool is_validated() const {
    return data_->is_validated;
  }
  bool was_fetched_via_cache() const {
    return data_->was_fetched_via_cache;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNavigationDeliveryType(UserType* output) const {
    auto data_value = data_->navigation_delivery_type;
    return mojo::internal::Deserialize<::network::mojom::NavigationDeliveryType>(
        data_value, output);
  }
  NavigationDeliveryType navigation_delivery_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::NavigationDeliveryType>(data_->navigation_delivery_type));
  }
  inline void GetProxyChainDataView(
      ::network::mojom::ProxyChainDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxyChain(UserType* output) {
    
    auto* pointer = data_->proxy_chain.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyChainDataView>(
        pointer, output, message_);
  }
  bool was_fetched_via_service_worker() const {
    return data_->was_fetched_via_service_worker;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerResponseSource(UserType* output) const {
    auto data_value = data_->service_worker_response_source;
    return mojo::internal::Deserialize<::network::mojom::FetchResponseSource>(
        data_value, output);
  }
  ::network::mojom::FetchResponseSource service_worker_response_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::FetchResponseSource>(data_->service_worker_response_source));
  }
  inline void GetUrlListViaServiceWorkerDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlListViaServiceWorker(UserType* output) {
    
    auto* pointer = data_->url_list_via_service_worker.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitialServiceWorkerStatus(UserType* output) const {
    if (!data_->initial_service_worker_status_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::network::mojom::ServiceWorkerStatus>(
        data_->initial_service_worker_status_$value, &output->emplace());
  }
  std::optional<::network::mojom::ServiceWorkerStatus> initial_service_worker_status() const {
    if (!data_->initial_service_worker_status_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ServiceWorkerStatus>(data_->initial_service_worker_status_$value));
  }
  inline void GetServiceWorkerRouterInfoDataView(
      ::network::mojom::ServiceWorkerRouterInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerRouterInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ServiceWorkerRouterInfoDataView, UserType>(),
    "Attempting to read the optional `service_worker_router_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServiceWorkerRouterInfo` instead "
    "of `ReadServiceWorkerRouterInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->service_worker_router_info.Get();
    return mojo::internal::Deserialize<::network::mojom::ServiceWorkerRouterInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResponseType(UserType* output) const {
    auto data_value = data_->response_type;
    return mojo::internal::Deserialize<::network::mojom::FetchResponseType>(
        data_value, output);
  }
  ::network::mojom::FetchResponseType response_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::FetchResponseType>(data_->response_type));
  }
  int64_t padding() const {
    return data_->padding;
  }
  inline void GetCacheStorageCacheNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCacheStorageCacheName(UserType* output) {
    
    auto* pointer = data_->cache_storage_cache_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t cert_status() const {
    return data_->cert_status;
  }
  inline void GetSslInfoDataView(
      ::network::mojom::SSLInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSslInfo(UserType* output) {
    
    auto* pointer = data_->ssl_info.Get();
    return mojo::internal::Deserialize<::network::mojom::SSLInfoDataView>(
        pointer, output, message_);
  }
  inline void GetRequestCookiesDataView(
      mojo::ArrayDataView<::network::mojom::ParsedRequestCookieDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestCookies(UserType* output) {
    
    auto* pointer = data_->request_cookies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ParsedRequestCookieDataView>>(
        pointer, output, message_);
  }
  inline void GetCorsExposedHeaderNamesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCorsExposedHeaderNames(UserType* output) {
    
    auto* pointer = data_->cors_exposed_header_names.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool did_service_worker_navigation_preload() const {
    return data_->did_service_worker_navigation_preload;
  }
  bool async_revalidation_requested() const {
    return data_->async_revalidation_requested;
  }
  bool did_mime_sniff() const {
    return data_->did_mime_sniff;
  }
  bool is_signed_exchange_inner_response() const {
    return data_->is_signed_exchange_inner_response;
  }
  bool is_web_bundle_inner_response() const {
    return data_->is_web_bundle_inner_response;
  }
  bool was_in_prefetch_cache() const {
    return data_->was_in_prefetch_cache;
  }
  bool is_prefetch_with_cross_site_contamination() const {
    return data_->is_prefetch_with_cross_site_contamination;
  }
  bool was_cookie_in_request() const {
    return data_->was_cookie_in_request;
  }
  bool intercepted_by_plugin() const {
    return data_->intercepted_by_plugin;
  }
  bool has_range_requested() const {
    return data_->has_range_requested;
  }
  bool timing_allow_passed() const {
    return data_->timing_allow_passed;
  }
  inline void GetAuthChallengeInfoDataView(
      ::network::mojom::AuthChallengeInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuthChallengeInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::AuthChallengeInfoDataView, UserType>(),
    "Attempting to read the optional `auth_challenge_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAuthChallengeInfo` instead "
    "of `ReadAuthChallengeInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->auth_challenge_info.Get();
    return mojo::internal::Deserialize<::network::mojom::AuthChallengeInfoDataView>(
        pointer, output, message_);
  }
  inline void GetRequestStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestStart(UserType* output) {
    
    auto* pointer = data_->request_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetResponseStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseStart(UserType* output) {
    
    auto* pointer = data_->response_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetParsedHeadersDataView(
      ::network::mojom::ParsedHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParsedHeaders(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ParsedHeadersDataView, UserType>(),
    "Attempting to read the optional `parsed_headers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParsedHeaders` instead "
    "of `ReadParsedHeaders if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parsed_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::ParsedHeadersDataView>(
        pointer, output, message_);
  }
  inline void GetRecursivePrefetchTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecursivePrefetchToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `recursive_prefetch_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecursivePrefetchToken` instead "
    "of `ReadRecursivePrefetchToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->recursive_prefetch_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetDnsAliasesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDnsAliases(UserType* output) {
    
    auto* pointer = data_->dns_aliases.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool has_authorization_covered_by_wildcard_on_preflight() const {
    return data_->has_authorization_covered_by_wildcard_on_preflight;
  }
  bool request_include_credentials() const {
    return data_->request_include_credentials;
  }
  bool should_use_source_hash_for_js_code_cache() const {
    return data_->should_use_source_hash_for_js_code_cache;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrivateNetworkAccessPreflightResult(UserType* output) const {
    auto data_value = data_->private_network_access_preflight_result;
    return mojo::internal::Deserialize<::network::mojom::PrivateNetworkAccessPreflightResult>(
        data_value, output);
  }
  ::network::mojom::PrivateNetworkAccessPreflightResult private_network_access_preflight_result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::PrivateNetworkAccessPreflightResult>(data_->private_network_access_preflight_result));
  }
  bool did_use_shared_dictionary() const {
    return data_->did_use_shared_dictionary;
  }
  bool load_with_storage_access() const {
    return data_->load_with_storage_access;
  }
  inline void GetClientSideContentDecodingTypesDataView(
      mojo::ArrayDataView<::network::mojom::SourceType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientSideContentDecodingTypes(UserType* output) {
    
    auto* pointer = data_->client_side_content_decoding_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SourceType>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDeviceBoundSessionUsage(UserType* output) const {
    auto data_value = data_->device_bound_session_usage;
    return mojo::internal::Deserialize<::network::mojom::DeviceBoundSessionUsage>(
        data_value, output);
  }
  ::network::mojom::DeviceBoundSessionUsage device_bound_session_usage() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DeviceBoundSessionUsage>(data_->device_bound_session_usage));
  }
  bool from_synthetic_response() const {
    return data_->from_synthetic_response;
  }
  bool bypass_redirect_checks() const {
    return data_->bypass_redirect_checks;
  }
  inline void GetUnencodedDigestsDataView(
      ::network::mojom::UnencodedDigestsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnencodedDigests(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::UnencodedDigestsDataView, UserType>(),
    "Attempting to read the optional `unencoded_digests` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUnencodedDigests` instead "
    "of `ReadUnencodedDigests if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->unencoded_digests.Get();
    return mojo::internal::Deserialize<::network::mojom::UnencodedDigestsDataView>(
        pointer, output, message_);
  }
  bool did_use_server_http_auth() const {
    return data_->did_use_server_http_auth;
  }
 private:
  internal::URLResponseHead_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_DATA_VIEW_H_