// services/network/public/mojom/url_loader_network_service_observer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/url_loader_network_service_observer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var ad_auction$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ad_auction.mojom', 'ad_auction.mojom.js');
  }
  var cookie_partition_key$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_partition_key.mojom', 'cookie_partition_key.mojom.js');
  }
  var ip_address$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_address.mojom', 'ip_address.mojom.js');
  }
  var ip_address_space$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_address_space.mojom', 'ip_address_space.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }
  var shared_storage$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/shared_storage.mojom', 'shared_storage.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }



  function LoadInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LoadInfo.prototype.initDefaults_ = function() {
    this.timestamp = null;
    this.host = null;
    this.loadState = 0;
    this.stateParam = null;
    this.uploadPosition = 0;
    this.uploadSize = 0;
  };
  LoadInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LoadInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadInfo.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadInfo.host
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate LoadInfo.stateParam
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  LoadInfo.encodedSize = codec.kStructHeaderSize + 48;

  LoadInfo.decode = function(decoder) {
    var packed;
    var val = new LoadInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.timestamp =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.host =
        decoder.decodeStruct(codec.String);
    val.loadState =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.stateParam =
        decoder.decodeStructPointer(string16$.String16);
    val.uploadPosition =
        decoder.decodeStruct(codec.Uint64);
    val.uploadSize =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  LoadInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LoadInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeTicks, val.timestamp);
    encoder.encodeStruct(codec.String, val.host);
    encoder.encodeStruct(codec.Uint32, val.loadState);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(string16$.String16, val.stateParam);
    encoder.encodeStruct(codec.Uint64, val.uploadPosition);
    encoder.encodeStruct(codec.Uint64, val.uploadSize);
  };
  function ClientCertificateResponder_ContinueWithCertificate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClientCertificateResponder_ContinueWithCertificate_Params.prototype.initDefaults_ = function() {
    this.x509Certificate = null;
    this.providerName = null;
    this.algorithmPreferences = null;
    this.sslPrivateKey = new SSLPrivateKeyPtr();
  };
  ClientCertificateResponder_ContinueWithCertificate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClientCertificateResponder_ContinueWithCertificate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClientCertificateResponder_ContinueWithCertificate_Params.x509Certificate
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.X509Certificate, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClientCertificateResponder_ContinueWithCertificate_Params.providerName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClientCertificateResponder_ContinueWithCertificate_Params.algorithmPreferences
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 2, codec.Uint16, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClientCertificateResponder_ContinueWithCertificate_Params.sslPrivateKey
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 24, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClientCertificateResponder_ContinueWithCertificate_Params.encodedSize = codec.kStructHeaderSize + 32;

  ClientCertificateResponder_ContinueWithCertificate_Params.decode = function(decoder) {
    var packed;
    var val = new ClientCertificateResponder_ContinueWithCertificate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.x509Certificate =
        decoder.decodeStructPointer(network_param$.X509Certificate);
    val.providerName =
        decoder.decodeStruct(codec.String);
    val.algorithmPreferences =
        decoder.decodeArrayPointer(codec.Uint16);
    val.sslPrivateKey =
        decoder.decodeStruct(new codec.Interface(SSLPrivateKeyPtr));
    return val;
  };

  ClientCertificateResponder_ContinueWithCertificate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClientCertificateResponder_ContinueWithCertificate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.X509Certificate, val.x509Certificate);
    encoder.encodeStruct(codec.String, val.providerName);
    encoder.encodeArrayPointer(codec.Uint16, val.algorithmPreferences);
    encoder.encodeStruct(new codec.Interface(SSLPrivateKeyPtr), val.sslPrivateKey);
  };
  function ClientCertificateResponder_ContinueWithoutCertificate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClientCertificateResponder_ContinueWithoutCertificate_Params.prototype.initDefaults_ = function() {
  };
  ClientCertificateResponder_ContinueWithoutCertificate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClientCertificateResponder_ContinueWithoutCertificate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClientCertificateResponder_ContinueWithoutCertificate_Params.encodedSize = codec.kStructHeaderSize + 0;

  ClientCertificateResponder_ContinueWithoutCertificate_Params.decode = function(decoder) {
    var packed;
    var val = new ClientCertificateResponder_ContinueWithoutCertificate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ClientCertificateResponder_ContinueWithoutCertificate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClientCertificateResponder_ContinueWithoutCertificate_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ClientCertificateResponder_CancelRequest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClientCertificateResponder_CancelRequest_Params.prototype.initDefaults_ = function() {
  };
  ClientCertificateResponder_CancelRequest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClientCertificateResponder_CancelRequest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClientCertificateResponder_CancelRequest_Params.encodedSize = codec.kStructHeaderSize + 0;

  ClientCertificateResponder_CancelRequest_Params.decode = function(decoder) {
    var packed;
    var val = new ClientCertificateResponder_CancelRequest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ClientCertificateResponder_CancelRequest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClientCertificateResponder_CancelRequest_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SSLPrivateKey_Sign_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SSLPrivateKey_Sign_Params.prototype.initDefaults_ = function() {
    this.algorithm = 0;
    this.input = null;
  };
  SSLPrivateKey_Sign_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SSLPrivateKey_Sign_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SSLPrivateKey_Sign_Params.input
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SSLPrivateKey_Sign_Params.encodedSize = codec.kStructHeaderSize + 16;

  SSLPrivateKey_Sign_Params.decode = function(decoder) {
    var packed;
    var val = new SSLPrivateKey_Sign_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.algorithm =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.input =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  SSLPrivateKey_Sign_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SSLPrivateKey_Sign_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint16, val.algorithm);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.input);
  };
  function SSLPrivateKey_Sign_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SSLPrivateKey_Sign_ResponseParams.prototype.initDefaults_ = function() {
    this.netError = 0;
    this.signature = null;
  };
  SSLPrivateKey_Sign_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SSLPrivateKey_Sign_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SSLPrivateKey_Sign_ResponseParams.signature
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SSLPrivateKey_Sign_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SSLPrivateKey_Sign_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SSLPrivateKey_Sign_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.netError =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.signature =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  SSLPrivateKey_Sign_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SSLPrivateKey_Sign_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.netError);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.signature);
  };
  function AuthChallengeResponder_OnAuthCredentials_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuthChallengeResponder_OnAuthCredentials_Params.prototype.initDefaults_ = function() {
    this.credentials = null;
  };
  AuthChallengeResponder_OnAuthCredentials_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuthChallengeResponder_OnAuthCredentials_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuthChallengeResponder_OnAuthCredentials_Params.credentials
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, network_param$.AuthCredentials, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AuthChallengeResponder_OnAuthCredentials_Params.encodedSize = codec.kStructHeaderSize + 8;

  AuthChallengeResponder_OnAuthCredentials_Params.decode = function(decoder) {
    var packed;
    var val = new AuthChallengeResponder_OnAuthCredentials_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.credentials =
        decoder.decodeStructPointer(network_param$.AuthCredentials);
    return val;
  };

  AuthChallengeResponder_OnAuthCredentials_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuthChallengeResponder_OnAuthCredentials_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(network_param$.AuthCredentials, val.credentials);
  };
  function URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.netError = 0;
    this.fatal = false;
    this.sslInfo = null;
  };
  URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params.sslInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, network_param$.SSLInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params.encodedSize = codec.kStructHeaderSize + 24;

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.netError =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.fatal = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sslInfo =
        decoder.decodeStructPointer(network_param$.SSLInfo);
    return val;
  };

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.Int32, val.netError);
    packed = 0;
    packed |= (val.fatal & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(network_param$.SSLInfo, val.sslInfo);
  };
  function URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams.prototype.initDefaults_ = function() {
    this.netError = 0;
  };
  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.netError =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.netError);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function URLLoaderNetworkServiceObserver_OnCertificateRequested_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnCertificateRequested_Params.prototype.initDefaults_ = function() {
    this.windowId = null;
    this.certInfo = null;
    this.certResponder = new ClientCertificateResponderPtr();
  };
  URLLoaderNetworkServiceObserver_OnCertificateRequested_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnCertificateRequested_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnCertificateRequested_Params.windowId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnCertificateRequested_Params.certInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_param$.SSLCertRequestInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnCertificateRequested_Params.certResponder
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnCertificateRequested_Params.encodedSize = codec.kStructHeaderSize + 24;

  URLLoaderNetworkServiceObserver_OnCertificateRequested_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnCertificateRequested_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.windowId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.certInfo =
        decoder.decodeStructPointer(network_param$.SSLCertRequestInfo);
    val.certResponder =
        decoder.decodeStruct(new codec.Interface(ClientCertificateResponderPtr));
    return val;
  };

  URLLoaderNetworkServiceObserver_OnCertificateRequested_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnCertificateRequested_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.windowId);
    encoder.encodeStructPointer(network_param$.SSLCertRequestInfo, val.certInfo);
    encoder.encodeStruct(new codec.Interface(ClientCertificateResponderPtr), val.certResponder);
  };
  function URLLoaderNetworkServiceObserver_OnAuthRequired_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnAuthRequired_Params.prototype.initDefaults_ = function() {
    this.windowId = null;
    this.requestId = 0;
    this.firstAuthAttempt = false;
    this.url = null;
    this.authInfo = null;
    this.headHeaders = null;
    this.authChallengeResponder = new AuthChallengeResponderPtr();
  };
  URLLoaderNetworkServiceObserver_OnAuthRequired_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnAuthRequired_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnAuthRequired_Params.windowId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLLoaderNetworkServiceObserver_OnAuthRequired_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLLoaderNetworkServiceObserver_OnAuthRequired_Params.authInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, network_param$.AuthChallengeInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnAuthRequired_Params.headHeaders
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, network_param$.HttpResponseHeaders, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnAuthRequired_Params.authChallengeResponder
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 40, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnAuthRequired_Params.encodedSize = codec.kStructHeaderSize + 48;

  URLLoaderNetworkServiceObserver_OnAuthRequired_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnAuthRequired_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.windowId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.firstAuthAttempt = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.authInfo =
        decoder.decodeStructPointer(network_param$.AuthChallengeInfo);
    val.headHeaders =
        decoder.decodeStructPointer(network_param$.HttpResponseHeaders);
    val.authChallengeResponder =
        decoder.decodeStruct(new codec.Interface(AuthChallengeResponderPtr));
    return val;
  };

  URLLoaderNetworkServiceObserver_OnAuthRequired_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnAuthRequired_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.windowId);
    encoder.encodeStruct(codec.Int32, val.requestId);
    packed = 0;
    packed |= (val.firstAuthAttempt & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(network_param$.AuthChallengeInfo, val.authInfo);
    encoder.encodeStructPointer(network_param$.HttpResponseHeaders, val.headHeaders);
    encoder.encodeStruct(new codec.Interface(AuthChallengeResponderPtr), val.authChallengeResponder);
  };
  function URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params.prototype.initDefaults_ = function() {
  };
  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params.encodedSize = codec.kStructHeaderSize + 0;

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams.prototype.initDefaults_ = function() {
    this.permissionGranted = false;
  };
  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.permissionGranted = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.permissionGranted & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function URLLoaderNetworkServiceObserver_OnClearSiteData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnClearSiteData_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.headerValue = null;
    this.loadFlags = 0;
    this.partitionedStateAllowedOnly = false;
    this.cookiePartitionKey = null;
  };
  URLLoaderNetworkServiceObserver_OnClearSiteData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnClearSiteData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnClearSiteData_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnClearSiteData_Params.headerValue
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLLoaderNetworkServiceObserver_OnClearSiteData_Params.cookiePartitionKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, cookie_partition_key$.CookiePartitionKey, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnClearSiteData_Params.encodedSize = codec.kStructHeaderSize + 32;

  URLLoaderNetworkServiceObserver_OnClearSiteData_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnClearSiteData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.headerValue =
        decoder.decodeStruct(codec.String);
    val.loadFlags =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.partitionedStateAllowedOnly = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.cookiePartitionKey =
        decoder.decodeStructPointer(cookie_partition_key$.CookiePartitionKey);
    return val;
  };

  URLLoaderNetworkServiceObserver_OnClearSiteData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnClearSiteData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.headerValue);
    encoder.encodeStruct(codec.Int32, val.loadFlags);
    packed = 0;
    packed |= (val.partitionedStateAllowedOnly & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(cookie_partition_key$.CookiePartitionKey, val.cookiePartitionKey);
  };
  function URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams.prototype.initDefaults_ = function() {
  };
  URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params.prototype.initDefaults_ = function() {
    this.info = null;
  };
  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, LoadInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params.encodedSize = codec.kStructHeaderSize + 8;

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(LoadInfo);
    return val;
  };

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(LoadInfo, val.info);
  };
  function URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams.prototype.initDefaults_ = function() {
  };
  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params.prototype.initDefaults_ = function() {
    this.networkTrafficAnnotationIdHash = 0;
    this.recvBytes = 0;
    this.sentBytes = 0;
  };
  URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params.encodedSize = codec.kStructHeaderSize + 24;

  URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.networkTrafficAnnotationIdHash =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.recvBytes =
        decoder.decodeStruct(codec.Int64);
    val.sentBytes =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.networkTrafficAnnotationIdHash);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.recvBytes);
    encoder.encodeStruct(codec.Int64, val.sentBytes);
  };
  function URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params.prototype.initDefaults_ = function() {
    this.requestOrigin = null;
    this.methodsWithOptions = null;
    this.withLock = null;
  };
  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params.requestOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params.methodsWithOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, shared_storage$.SharedStorageBatchUpdateMethodsArgument, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params.withLock
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, shared_storage$.LockName, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params.encodedSize = codec.kStructHeaderSize + 24;

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.methodsWithOptions =
        decoder.decodeStructPointer(shared_storage$.SharedStorageBatchUpdateMethodsArgument);
    val.withLock =
        decoder.decodeStructPointer(shared_storage$.LockName);
    return val;
  };

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.requestOrigin);
    encoder.encodeStructPointer(shared_storage$.SharedStorageBatchUpdateMethodsArgument, val.methodsWithOptions);
    encoder.encodeStructPointer(shared_storage$.LockName, val.withLock);
  };
  function URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams.prototype.initDefaults_ = function() {
  };
  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params.prototype.initDefaults_ = function() {
    this.adAuctionEventRecord = null;
    this.topFrameOrigin = null;
  };
  URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params.adAuctionEventRecord
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ad_auction$.AdAuctionEventRecord, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params.topFrameOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params.encodedSize = codec.kStructHeaderSize + 16;

  URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.adAuctionEventRecord =
        decoder.decodeStructPointer(ad_auction$.AdAuctionEventRecord);
    val.topFrameOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ad_auction$.AdAuctionEventRecord, val.adAuctionEventRecord);
    encoder.encodeStructPointer(origin$.Origin, val.topFrameOrigin);
  };
  function URLLoaderNetworkServiceObserver_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_Clone_Params.prototype.initDefaults_ = function() {
    this.listener = new bindings.InterfaceRequest();
  };
  URLLoaderNetworkServiceObserver_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_Clone_Params.listener
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  URLLoaderNetworkServiceObserver_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.listener =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  URLLoaderNetworkServiceObserver_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.listener);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params.prototype.initDefaults_ = function() {
    this.requestUrl = null;
    this.ipAddressSpace = 0;
  };
  URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params.requestUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params.ipAddressSpace
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, ip_address_space$.IPAddressSpace);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params.encodedSize = codec.kStructHeaderSize + 16;

  URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestUrl =
        decoder.decodeStructPointer(url$.Url);
    val.ipAddressSpace =
        decoder.decodeStruct(new codec.Enum(ip_address_space$.IPAddressSpace));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.requestUrl);
    encoder.encodeStruct(codec.Int32, val.ipAddressSpace);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params.prototype.initDefaults_ = function() {
    this.requestUrl = null;
    this.responseAddressSpace = 0;
    this.clientAddressSpace = 0;
    this.targetAddressSpace = 0;
  };
  URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params.requestUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params.responseAddressSpace
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, ip_address_space$.IPAddressSpace);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params.clientAddressSpace
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, ip_address_space$.IPAddressSpace);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params.targetAddressSpace
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, ip_address_space$.IPAddressSpace);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params.encodedSize = codec.kStructHeaderSize + 24;

  URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params.decode = function(decoder) {
    var packed;
    var val = new URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestUrl =
        decoder.decodeStructPointer(url$.Url);
    val.responseAddressSpace =
        decoder.decodeStruct(new codec.Enum(ip_address_space$.IPAddressSpace));
    val.clientAddressSpace =
        decoder.decodeStruct(new codec.Enum(ip_address_space$.IPAddressSpace));
    val.targetAddressSpace =
        decoder.decodeStruct(new codec.Enum(ip_address_space$.IPAddressSpace));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.requestUrl);
    encoder.encodeStruct(codec.Int32, val.responseAddressSpace);
    encoder.encodeStruct(codec.Int32, val.clientAddressSpace);
    encoder.encodeStruct(codec.Int32, val.targetAddressSpace);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kClientCertificateResponder_ContinueWithCertificate_Name = 0;
  var kClientCertificateResponder_ContinueWithoutCertificate_Name = 1;
  var kClientCertificateResponder_CancelRequest_Name = 2;

  function ClientCertificateResponderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ClientCertificateResponder,
                                                   handleOrPtrInfo);
  }

  function ClientCertificateResponderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ClientCertificateResponder, associatedInterfacePtrInfo);
  }

  ClientCertificateResponderAssociatedPtr.prototype =
      Object.create(ClientCertificateResponderPtr.prototype);
  ClientCertificateResponderAssociatedPtr.prototype.constructor =
      ClientCertificateResponderAssociatedPtr;

  function ClientCertificateResponderProxy(receiver) {
    this.receiver_ = receiver;
  }
  ClientCertificateResponderPtr.prototype.continueWithCertificate = function() {
    return ClientCertificateResponderProxy.prototype.continueWithCertificate
        .apply(this.ptr.getProxy(), arguments);
  };

  ClientCertificateResponderProxy.prototype.continueWithCertificate = function(x509Certificate, providerName, algorithmPreferences, sslPrivateKey) {
    var params_ = new ClientCertificateResponder_ContinueWithCertificate_Params();
    params_.x509Certificate = x509Certificate;
    params_.providerName = providerName;
    params_.algorithmPreferences = algorithmPreferences;
    params_.sslPrivateKey = sslPrivateKey;
    var builder = new codec.MessageV0Builder(
        kClientCertificateResponder_ContinueWithCertificate_Name,
        codec.align(ClientCertificateResponder_ContinueWithCertificate_Params.encodedSize));
    builder.encodeStruct(ClientCertificateResponder_ContinueWithCertificate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClientCertificateResponderPtr.prototype.continueWithoutCertificate = function() {
    return ClientCertificateResponderProxy.prototype.continueWithoutCertificate
        .apply(this.ptr.getProxy(), arguments);
  };

  ClientCertificateResponderProxy.prototype.continueWithoutCertificate = function() {
    var params_ = new ClientCertificateResponder_ContinueWithoutCertificate_Params();
    var builder = new codec.MessageV0Builder(
        kClientCertificateResponder_ContinueWithoutCertificate_Name,
        codec.align(ClientCertificateResponder_ContinueWithoutCertificate_Params.encodedSize));
    builder.encodeStruct(ClientCertificateResponder_ContinueWithoutCertificate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClientCertificateResponderPtr.prototype.cancelRequest = function() {
    return ClientCertificateResponderProxy.prototype.cancelRequest
        .apply(this.ptr.getProxy(), arguments);
  };

  ClientCertificateResponderProxy.prototype.cancelRequest = function() {
    var params_ = new ClientCertificateResponder_CancelRequest_Params();
    var builder = new codec.MessageV0Builder(
        kClientCertificateResponder_CancelRequest_Name,
        codec.align(ClientCertificateResponder_CancelRequest_Params.encodedSize));
    builder.encodeStruct(ClientCertificateResponder_CancelRequest_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ClientCertificateResponderStub(delegate) {
    this.delegate_ = delegate;
  }
  ClientCertificateResponderStub.prototype.continueWithCertificate = function(x509Certificate, providerName, algorithmPreferences, sslPrivateKey) {
    return this.delegate_ && this.delegate_.continueWithCertificate && this.delegate_.continueWithCertificate(x509Certificate, providerName, algorithmPreferences, sslPrivateKey);
  }
  ClientCertificateResponderStub.prototype.continueWithoutCertificate = function() {
    return this.delegate_ && this.delegate_.continueWithoutCertificate && this.delegate_.continueWithoutCertificate();
  }
  ClientCertificateResponderStub.prototype.cancelRequest = function() {
    return this.delegate_ && this.delegate_.cancelRequest && this.delegate_.cancelRequest();
  }

  ClientCertificateResponderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kClientCertificateResponder_ContinueWithCertificate_Name:
      var params = reader.decodeStruct(ClientCertificateResponder_ContinueWithCertificate_Params);
      this.continueWithCertificate(params.x509Certificate, params.providerName, params.algorithmPreferences, params.sslPrivateKey);
      return true;
    case kClientCertificateResponder_ContinueWithoutCertificate_Name:
      var params = reader.decodeStruct(ClientCertificateResponder_ContinueWithoutCertificate_Params);
      this.continueWithoutCertificate();
      return true;
    case kClientCertificateResponder_CancelRequest_Name:
      var params = reader.decodeStruct(ClientCertificateResponder_CancelRequest_Params);
      this.cancelRequest();
      return true;
    default:
      return false;
    }
  };

  ClientCertificateResponderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateClientCertificateResponderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kClientCertificateResponder_ContinueWithCertificate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClientCertificateResponder_ContinueWithCertificate_Params;
      break;
      case kClientCertificateResponder_ContinueWithoutCertificate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClientCertificateResponder_ContinueWithoutCertificate_Params;
      break;
      case kClientCertificateResponder_CancelRequest_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClientCertificateResponder_CancelRequest_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateClientCertificateResponderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ClientCertificateResponder = {
    name: 'network.mojom.ClientCertificateResponder',
    kVersion: 0,
    ptrClass: ClientCertificateResponderPtr,
    proxyClass: ClientCertificateResponderProxy,
    stubClass: ClientCertificateResponderStub,
    validateRequest: validateClientCertificateResponderRequest,
    validateResponse: null,
  };
  ClientCertificateResponderStub.prototype.validator = validateClientCertificateResponderRequest;
  ClientCertificateResponderProxy.prototype.validator = null;
  var kSSLPrivateKey_Sign_Name = 0;

  function SSLPrivateKeyPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SSLPrivateKey,
                                                   handleOrPtrInfo);
  }

  function SSLPrivateKeyAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SSLPrivateKey, associatedInterfacePtrInfo);
  }

  SSLPrivateKeyAssociatedPtr.prototype =
      Object.create(SSLPrivateKeyPtr.prototype);
  SSLPrivateKeyAssociatedPtr.prototype.constructor =
      SSLPrivateKeyAssociatedPtr;

  function SSLPrivateKeyProxy(receiver) {
    this.receiver_ = receiver;
  }
  SSLPrivateKeyPtr.prototype.sign = function() {
    return SSLPrivateKeyProxy.prototype.sign
        .apply(this.ptr.getProxy(), arguments);
  };

  SSLPrivateKeyProxy.prototype.sign = function(algorithm, input) {
    var params_ = new SSLPrivateKey_Sign_Params();
    params_.algorithm = algorithm;
    params_.input = input;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSSLPrivateKey_Sign_Name,
          codec.align(SSLPrivateKey_Sign_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SSLPrivateKey_Sign_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SSLPrivateKey_Sign_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SSLPrivateKeyStub(delegate) {
    this.delegate_ = delegate;
  }
  SSLPrivateKeyStub.prototype.sign = function(algorithm, input) {
    return this.delegate_ && this.delegate_.sign && this.delegate_.sign(algorithm, input);
  }

  SSLPrivateKeyStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SSLPrivateKeyStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSSLPrivateKey_Sign_Name:
      var params = reader.decodeStruct(SSLPrivateKey_Sign_Params);
      this.sign(params.algorithm, params.input).then(function(response) {
        var responseParams =
            new SSLPrivateKey_Sign_ResponseParams();
        responseParams.netError = response.netError;
        responseParams.signature = response.signature;
        var builder = new codec.MessageV1Builder(
            kSSLPrivateKey_Sign_Name,
            codec.align(SSLPrivateKey_Sign_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SSLPrivateKey_Sign_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSSLPrivateKeyRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSSLPrivateKey_Sign_Name:
        if (message.expectsResponse())
          paramsClass = SSLPrivateKey_Sign_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSSLPrivateKeyResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSSLPrivateKey_Sign_Name:
        if (message.isResponse())
          paramsClass = SSLPrivateKey_Sign_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SSLPrivateKey = {
    name: 'network.mojom.SSLPrivateKey',
    kVersion: 0,
    ptrClass: SSLPrivateKeyPtr,
    proxyClass: SSLPrivateKeyProxy,
    stubClass: SSLPrivateKeyStub,
    validateRequest: validateSSLPrivateKeyRequest,
    validateResponse: validateSSLPrivateKeyResponse,
  };
  SSLPrivateKeyStub.prototype.validator = validateSSLPrivateKeyRequest;
  SSLPrivateKeyProxy.prototype.validator = validateSSLPrivateKeyResponse;
  var kAuthChallengeResponder_OnAuthCredentials_Name = 0;

  function AuthChallengeResponderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AuthChallengeResponder,
                                                   handleOrPtrInfo);
  }

  function AuthChallengeResponderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AuthChallengeResponder, associatedInterfacePtrInfo);
  }

  AuthChallengeResponderAssociatedPtr.prototype =
      Object.create(AuthChallengeResponderPtr.prototype);
  AuthChallengeResponderAssociatedPtr.prototype.constructor =
      AuthChallengeResponderAssociatedPtr;

  function AuthChallengeResponderProxy(receiver) {
    this.receiver_ = receiver;
  }
  AuthChallengeResponderPtr.prototype.onAuthCredentials = function() {
    return AuthChallengeResponderProxy.prototype.onAuthCredentials
        .apply(this.ptr.getProxy(), arguments);
  };

  AuthChallengeResponderProxy.prototype.onAuthCredentials = function(credentials) {
    var params_ = new AuthChallengeResponder_OnAuthCredentials_Params();
    params_.credentials = credentials;
    var builder = new codec.MessageV0Builder(
        kAuthChallengeResponder_OnAuthCredentials_Name,
        codec.align(AuthChallengeResponder_OnAuthCredentials_Params.encodedSize));
    builder.encodeStruct(AuthChallengeResponder_OnAuthCredentials_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AuthChallengeResponderStub(delegate) {
    this.delegate_ = delegate;
  }
  AuthChallengeResponderStub.prototype.onAuthCredentials = function(credentials) {
    return this.delegate_ && this.delegate_.onAuthCredentials && this.delegate_.onAuthCredentials(credentials);
  }

  AuthChallengeResponderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAuthChallengeResponder_OnAuthCredentials_Name:
      var params = reader.decodeStruct(AuthChallengeResponder_OnAuthCredentials_Params);
      this.onAuthCredentials(params.credentials);
      return true;
    default:
      return false;
    }
  };

  AuthChallengeResponderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAuthChallengeResponderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAuthChallengeResponder_OnAuthCredentials_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AuthChallengeResponder_OnAuthCredentials_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAuthChallengeResponderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AuthChallengeResponder = {
    name: 'network.mojom.AuthChallengeResponder',
    kVersion: 0,
    ptrClass: AuthChallengeResponderPtr,
    proxyClass: AuthChallengeResponderProxy,
    stubClass: AuthChallengeResponderStub,
    validateRequest: validateAuthChallengeResponderRequest,
    validateResponse: null,
  };
  AuthChallengeResponderStub.prototype.validator = validateAuthChallengeResponderRequest;
  AuthChallengeResponderProxy.prototype.validator = null;
  var kURLLoaderNetworkServiceObserver_OnSSLCertificateError_Name = 0;
  var kURLLoaderNetworkServiceObserver_OnCertificateRequested_Name = 1;
  var kURLLoaderNetworkServiceObserver_OnAuthRequired_Name = 2;
  var kURLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Name = 3;
  var kURLLoaderNetworkServiceObserver_OnClearSiteData_Name = 4;
  var kURLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Name = 5;
  var kURLLoaderNetworkServiceObserver_OnDataUseUpdate_Name = 6;
  var kURLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Name = 7;
  var kURLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Name = 8;
  var kURLLoaderNetworkServiceObserver_Clone_Name = 9;
  var kURLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Name = 10;
  var kURLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Name = 11;

  function URLLoaderNetworkServiceObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(URLLoaderNetworkServiceObserver,
                                                   handleOrPtrInfo);
  }

  function URLLoaderNetworkServiceObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        URLLoaderNetworkServiceObserver, associatedInterfacePtrInfo);
  }

  URLLoaderNetworkServiceObserverAssociatedPtr.prototype =
      Object.create(URLLoaderNetworkServiceObserverPtr.prototype);
  URLLoaderNetworkServiceObserverAssociatedPtr.prototype.constructor =
      URLLoaderNetworkServiceObserverAssociatedPtr;

  function URLLoaderNetworkServiceObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  URLLoaderNetworkServiceObserverPtr.prototype.onSSLCertificateError = function() {
    return URLLoaderNetworkServiceObserverProxy.prototype.onSSLCertificateError
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderNetworkServiceObserverProxy.prototype.onSSLCertificateError = function(url, netError, sslInfo, fatal) {
    var params_ = new URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params();
    params_.url = url;
    params_.netError = netError;
    params_.sslInfo = sslInfo;
    params_.fatal = fatal;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kURLLoaderNetworkServiceObserver_OnSSLCertificateError_Name,
          codec.align(URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  URLLoaderNetworkServiceObserverPtr.prototype.onCertificateRequested = function() {
    return URLLoaderNetworkServiceObserverProxy.prototype.onCertificateRequested
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderNetworkServiceObserverProxy.prototype.onCertificateRequested = function(windowId, certInfo, certResponder) {
    var params_ = new URLLoaderNetworkServiceObserver_OnCertificateRequested_Params();
    params_.windowId = windowId;
    params_.certInfo = certInfo;
    params_.certResponder = certResponder;
    var builder = new codec.MessageV0Builder(
        kURLLoaderNetworkServiceObserver_OnCertificateRequested_Name,
        codec.align(URLLoaderNetworkServiceObserver_OnCertificateRequested_Params.encodedSize));
    builder.encodeStruct(URLLoaderNetworkServiceObserver_OnCertificateRequested_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  URLLoaderNetworkServiceObserverPtr.prototype.onAuthRequired = function() {
    return URLLoaderNetworkServiceObserverProxy.prototype.onAuthRequired
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderNetworkServiceObserverProxy.prototype.onAuthRequired = function(windowId, requestId, url, firstAuthAttempt, authInfo, headHeaders, authChallengeResponder) {
    var params_ = new URLLoaderNetworkServiceObserver_OnAuthRequired_Params();
    params_.windowId = windowId;
    params_.requestId = requestId;
    params_.url = url;
    params_.firstAuthAttempt = firstAuthAttempt;
    params_.authInfo = authInfo;
    params_.headHeaders = headHeaders;
    params_.authChallengeResponder = authChallengeResponder;
    var builder = new codec.MessageV0Builder(
        kURLLoaderNetworkServiceObserver_OnAuthRequired_Name,
        codec.align(URLLoaderNetworkServiceObserver_OnAuthRequired_Params.encodedSize));
    builder.encodeStruct(URLLoaderNetworkServiceObserver_OnAuthRequired_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  URLLoaderNetworkServiceObserverPtr.prototype.onLocalNetworkAccessPermissionRequired = function() {
    return URLLoaderNetworkServiceObserverProxy.prototype.onLocalNetworkAccessPermissionRequired
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderNetworkServiceObserverProxy.prototype.onLocalNetworkAccessPermissionRequired = function() {
    var params_ = new URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kURLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Name,
          codec.align(URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  URLLoaderNetworkServiceObserverPtr.prototype.onClearSiteData = function() {
    return URLLoaderNetworkServiceObserverProxy.prototype.onClearSiteData
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderNetworkServiceObserverProxy.prototype.onClearSiteData = function(url, headerValue, loadFlags, cookiePartitionKey, partitionedStateAllowedOnly) {
    var params_ = new URLLoaderNetworkServiceObserver_OnClearSiteData_Params();
    params_.url = url;
    params_.headerValue = headerValue;
    params_.loadFlags = loadFlags;
    params_.cookiePartitionKey = cookiePartitionKey;
    params_.partitionedStateAllowedOnly = partitionedStateAllowedOnly;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kURLLoaderNetworkServiceObserver_OnClearSiteData_Name,
          codec.align(URLLoaderNetworkServiceObserver_OnClearSiteData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(URLLoaderNetworkServiceObserver_OnClearSiteData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  URLLoaderNetworkServiceObserverPtr.prototype.onLoadingStateUpdate = function() {
    return URLLoaderNetworkServiceObserverProxy.prototype.onLoadingStateUpdate
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderNetworkServiceObserverProxy.prototype.onLoadingStateUpdate = function(info) {
    var params_ = new URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params();
    params_.info = info;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kURLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Name,
          codec.align(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  URLLoaderNetworkServiceObserverPtr.prototype.onDataUseUpdate = function() {
    return URLLoaderNetworkServiceObserverProxy.prototype.onDataUseUpdate
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderNetworkServiceObserverProxy.prototype.onDataUseUpdate = function(networkTrafficAnnotationIdHash, recvBytes, sentBytes) {
    var params_ = new URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params();
    params_.networkTrafficAnnotationIdHash = networkTrafficAnnotationIdHash;
    params_.recvBytes = recvBytes;
    params_.sentBytes = sentBytes;
    var builder = new codec.MessageV0Builder(
        kURLLoaderNetworkServiceObserver_OnDataUseUpdate_Name,
        codec.align(URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params.encodedSize));
    builder.encodeStruct(URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  URLLoaderNetworkServiceObserverPtr.prototype.onSharedStorageHeaderReceived = function() {
    return URLLoaderNetworkServiceObserverProxy.prototype.onSharedStorageHeaderReceived
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderNetworkServiceObserverProxy.prototype.onSharedStorageHeaderReceived = function(requestOrigin, methodsWithOptions, withLock) {
    var params_ = new URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params();
    params_.requestOrigin = requestOrigin;
    params_.methodsWithOptions = methodsWithOptions;
    params_.withLock = withLock;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kURLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Name,
          codec.align(URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  URLLoaderNetworkServiceObserverPtr.prototype.onAdAuctionEventRecordHeaderReceived = function() {
    return URLLoaderNetworkServiceObserverProxy.prototype.onAdAuctionEventRecordHeaderReceived
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderNetworkServiceObserverProxy.prototype.onAdAuctionEventRecordHeaderReceived = function(adAuctionEventRecord, topFrameOrigin) {
    var params_ = new URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params();
    params_.adAuctionEventRecord = adAuctionEventRecord;
    params_.topFrameOrigin = topFrameOrigin;
    var builder = new codec.MessageV0Builder(
        kURLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Name,
        codec.align(URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params.encodedSize));
    builder.encodeStruct(URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  URLLoaderNetworkServiceObserverPtr.prototype.clone = function() {
    return URLLoaderNetworkServiceObserverProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderNetworkServiceObserverProxy.prototype.clone = function(listener) {
    var params_ = new URLLoaderNetworkServiceObserver_Clone_Params();
    params_.listener = listener;
    var builder = new codec.MessageV0Builder(
        kURLLoaderNetworkServiceObserver_Clone_Name,
        codec.align(URLLoaderNetworkServiceObserver_Clone_Params.encodedSize));
    builder.encodeStruct(URLLoaderNetworkServiceObserver_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  URLLoaderNetworkServiceObserverPtr.prototype.onWebSocketConnectedToPrivateNetwork = function() {
    return URLLoaderNetworkServiceObserverProxy.prototype.onWebSocketConnectedToPrivateNetwork
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderNetworkServiceObserverProxy.prototype.onWebSocketConnectedToPrivateNetwork = function(requestUrl, ipAddressSpace) {
    var params_ = new URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params();
    params_.requestUrl = requestUrl;
    params_.ipAddressSpace = ipAddressSpace;
    var builder = new codec.MessageV0Builder(
        kURLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Name,
        codec.align(URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params.encodedSize));
    builder.encodeStruct(URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  URLLoaderNetworkServiceObserverPtr.prototype.onUrlLoaderConnectedToPrivateNetwork = function() {
    return URLLoaderNetworkServiceObserverProxy.prototype.onUrlLoaderConnectedToPrivateNetwork
        .apply(this.ptr.getProxy(), arguments);
  };

  URLLoaderNetworkServiceObserverProxy.prototype.onUrlLoaderConnectedToPrivateNetwork = function(requestUrl, responseAddressSpace, clientAddressSpace, targetAddressSpace) {
    var params_ = new URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params();
    params_.requestUrl = requestUrl;
    params_.responseAddressSpace = responseAddressSpace;
    params_.clientAddressSpace = clientAddressSpace;
    params_.targetAddressSpace = targetAddressSpace;
    var builder = new codec.MessageV0Builder(
        kURLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Name,
        codec.align(URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params.encodedSize));
    builder.encodeStruct(URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function URLLoaderNetworkServiceObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  URLLoaderNetworkServiceObserverStub.prototype.onSSLCertificateError = function(url, netError, sslInfo, fatal) {
    return this.delegate_ && this.delegate_.onSSLCertificateError && this.delegate_.onSSLCertificateError(url, netError, sslInfo, fatal);
  }
  URLLoaderNetworkServiceObserverStub.prototype.onCertificateRequested = function(windowId, certInfo, certResponder) {
    return this.delegate_ && this.delegate_.onCertificateRequested && this.delegate_.onCertificateRequested(windowId, certInfo, certResponder);
  }
  URLLoaderNetworkServiceObserverStub.prototype.onAuthRequired = function(windowId, requestId, url, firstAuthAttempt, authInfo, headHeaders, authChallengeResponder) {
    return this.delegate_ && this.delegate_.onAuthRequired && this.delegate_.onAuthRequired(windowId, requestId, url, firstAuthAttempt, authInfo, headHeaders, authChallengeResponder);
  }
  URLLoaderNetworkServiceObserverStub.prototype.onLocalNetworkAccessPermissionRequired = function() {
    return this.delegate_ && this.delegate_.onLocalNetworkAccessPermissionRequired && this.delegate_.onLocalNetworkAccessPermissionRequired();
  }
  URLLoaderNetworkServiceObserverStub.prototype.onClearSiteData = function(url, headerValue, loadFlags, cookiePartitionKey, partitionedStateAllowedOnly) {
    return this.delegate_ && this.delegate_.onClearSiteData && this.delegate_.onClearSiteData(url, headerValue, loadFlags, cookiePartitionKey, partitionedStateAllowedOnly);
  }
  URLLoaderNetworkServiceObserverStub.prototype.onLoadingStateUpdate = function(info) {
    return this.delegate_ && this.delegate_.onLoadingStateUpdate && this.delegate_.onLoadingStateUpdate(info);
  }
  URLLoaderNetworkServiceObserverStub.prototype.onDataUseUpdate = function(networkTrafficAnnotationIdHash, recvBytes, sentBytes) {
    return this.delegate_ && this.delegate_.onDataUseUpdate && this.delegate_.onDataUseUpdate(networkTrafficAnnotationIdHash, recvBytes, sentBytes);
  }
  URLLoaderNetworkServiceObserverStub.prototype.onSharedStorageHeaderReceived = function(requestOrigin, methodsWithOptions, withLock) {
    return this.delegate_ && this.delegate_.onSharedStorageHeaderReceived && this.delegate_.onSharedStorageHeaderReceived(requestOrigin, methodsWithOptions, withLock);
  }
  URLLoaderNetworkServiceObserverStub.prototype.onAdAuctionEventRecordHeaderReceived = function(adAuctionEventRecord, topFrameOrigin) {
    return this.delegate_ && this.delegate_.onAdAuctionEventRecordHeaderReceived && this.delegate_.onAdAuctionEventRecordHeaderReceived(adAuctionEventRecord, topFrameOrigin);
  }
  URLLoaderNetworkServiceObserverStub.prototype.clone = function(listener) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(listener);
  }
  URLLoaderNetworkServiceObserverStub.prototype.onWebSocketConnectedToPrivateNetwork = function(requestUrl, ipAddressSpace) {
    return this.delegate_ && this.delegate_.onWebSocketConnectedToPrivateNetwork && this.delegate_.onWebSocketConnectedToPrivateNetwork(requestUrl, ipAddressSpace);
  }
  URLLoaderNetworkServiceObserverStub.prototype.onUrlLoaderConnectedToPrivateNetwork = function(requestUrl, responseAddressSpace, clientAddressSpace, targetAddressSpace) {
    return this.delegate_ && this.delegate_.onUrlLoaderConnectedToPrivateNetwork && this.delegate_.onUrlLoaderConnectedToPrivateNetwork(requestUrl, responseAddressSpace, clientAddressSpace, targetAddressSpace);
  }

  URLLoaderNetworkServiceObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kURLLoaderNetworkServiceObserver_OnCertificateRequested_Name:
      var params = reader.decodeStruct(URLLoaderNetworkServiceObserver_OnCertificateRequested_Params);
      this.onCertificateRequested(params.windowId, params.certInfo, params.certResponder);
      return true;
    case kURLLoaderNetworkServiceObserver_OnAuthRequired_Name:
      var params = reader.decodeStruct(URLLoaderNetworkServiceObserver_OnAuthRequired_Params);
      this.onAuthRequired(params.windowId, params.requestId, params.url, params.firstAuthAttempt, params.authInfo, params.headHeaders, params.authChallengeResponder);
      return true;
    case kURLLoaderNetworkServiceObserver_OnDataUseUpdate_Name:
      var params = reader.decodeStruct(URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params);
      this.onDataUseUpdate(params.networkTrafficAnnotationIdHash, params.recvBytes, params.sentBytes);
      return true;
    case kURLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Name:
      var params = reader.decodeStruct(URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params);
      this.onAdAuctionEventRecordHeaderReceived(params.adAuctionEventRecord, params.topFrameOrigin);
      return true;
    case kURLLoaderNetworkServiceObserver_Clone_Name:
      var params = reader.decodeStruct(URLLoaderNetworkServiceObserver_Clone_Params);
      this.clone(params.listener);
      return true;
    case kURLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Name:
      var params = reader.decodeStruct(URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params);
      this.onWebSocketConnectedToPrivateNetwork(params.requestUrl, params.ipAddressSpace);
      return true;
    case kURLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Name:
      var params = reader.decodeStruct(URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params);
      this.onUrlLoaderConnectedToPrivateNetwork(params.requestUrl, params.responseAddressSpace, params.clientAddressSpace, params.targetAddressSpace);
      return true;
    default:
      return false;
    }
  };

  URLLoaderNetworkServiceObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kURLLoaderNetworkServiceObserver_OnSSLCertificateError_Name:
      var params = reader.decodeStruct(URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params);
      this.onSSLCertificateError(params.url, params.netError, params.sslInfo, params.fatal).then(function(response) {
        var responseParams =
            new URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams();
        responseParams.netError = response.netError;
        var builder = new codec.MessageV1Builder(
            kURLLoaderNetworkServiceObserver_OnSSLCertificateError_Name,
            codec.align(URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kURLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Name:
      var params = reader.decodeStruct(URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params);
      this.onLocalNetworkAccessPermissionRequired().then(function(response) {
        var responseParams =
            new URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams();
        responseParams.permissionGranted = response.permissionGranted;
        var builder = new codec.MessageV1Builder(
            kURLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Name,
            codec.align(URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kURLLoaderNetworkServiceObserver_OnClearSiteData_Name:
      var params = reader.decodeStruct(URLLoaderNetworkServiceObserver_OnClearSiteData_Params);
      this.onClearSiteData(params.url, params.headerValue, params.loadFlags, params.cookiePartitionKey, params.partitionedStateAllowedOnly).then(function(response) {
        var responseParams =
            new URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kURLLoaderNetworkServiceObserver_OnClearSiteData_Name,
            codec.align(URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kURLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Name:
      var params = reader.decodeStruct(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params);
      this.onLoadingStateUpdate(params.info).then(function(response) {
        var responseParams =
            new URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kURLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Name,
            codec.align(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kURLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Name:
      var params = reader.decodeStruct(URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params);
      this.onSharedStorageHeaderReceived(params.requestOrigin, params.methodsWithOptions, params.withLock).then(function(response) {
        var responseParams =
            new URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kURLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Name,
            codec.align(URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateURLLoaderNetworkServiceObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kURLLoaderNetworkServiceObserver_OnSSLCertificateError_Name:
        if (message.expectsResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params;
      break;
      case kURLLoaderNetworkServiceObserver_OnCertificateRequested_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnCertificateRequested_Params;
      break;
      case kURLLoaderNetworkServiceObserver_OnAuthRequired_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnAuthRequired_Params;
      break;
      case kURLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Name:
        if (message.expectsResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params;
      break;
      case kURLLoaderNetworkServiceObserver_OnClearSiteData_Name:
        if (message.expectsResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnClearSiteData_Params;
      break;
      case kURLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Name:
        if (message.expectsResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params;
      break;
      case kURLLoaderNetworkServiceObserver_OnDataUseUpdate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params;
      break;
      case kURLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Name:
        if (message.expectsResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params;
      break;
      case kURLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params;
      break;
      case kURLLoaderNetworkServiceObserver_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderNetworkServiceObserver_Clone_Params;
      break;
      case kURLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params;
      break;
      case kURLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateURLLoaderNetworkServiceObserverResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kURLLoaderNetworkServiceObserver_OnSSLCertificateError_Name:
        if (message.isResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams;
        break;
      case kURLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Name:
        if (message.isResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams;
        break;
      case kURLLoaderNetworkServiceObserver_OnClearSiteData_Name:
        if (message.isResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams;
        break;
      case kURLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Name:
        if (message.isResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams;
        break;
      case kURLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Name:
        if (message.isResponse())
          paramsClass = URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var URLLoaderNetworkServiceObserver = {
    name: 'network.mojom.URLLoaderNetworkServiceObserver',
    kVersion: 0,
    ptrClass: URLLoaderNetworkServiceObserverPtr,
    proxyClass: URLLoaderNetworkServiceObserverProxy,
    stubClass: URLLoaderNetworkServiceObserverStub,
    validateRequest: validateURLLoaderNetworkServiceObserverRequest,
    validateResponse: validateURLLoaderNetworkServiceObserverResponse,
  };
  URLLoaderNetworkServiceObserverStub.prototype.validator = validateURLLoaderNetworkServiceObserverRequest;
  URLLoaderNetworkServiceObserverProxy.prototype.validator = validateURLLoaderNetworkServiceObserverResponse;
  exports.LoadInfo = LoadInfo;
  exports.ClientCertificateResponder = ClientCertificateResponder;
  exports.ClientCertificateResponderPtr = ClientCertificateResponderPtr;
  exports.ClientCertificateResponderAssociatedPtr = ClientCertificateResponderAssociatedPtr;
  exports.SSLPrivateKey = SSLPrivateKey;
  exports.SSLPrivateKeyPtr = SSLPrivateKeyPtr;
  exports.SSLPrivateKeyAssociatedPtr = SSLPrivateKeyAssociatedPtr;
  exports.AuthChallengeResponder = AuthChallengeResponder;
  exports.AuthChallengeResponderPtr = AuthChallengeResponderPtr;
  exports.AuthChallengeResponderAssociatedPtr = AuthChallengeResponderAssociatedPtr;
  exports.URLLoaderNetworkServiceObserver = URLLoaderNetworkServiceObserver;
  exports.URLLoaderNetworkServiceObserverPtr = URLLoaderNetworkServiceObserverPtr;
  exports.URLLoaderNetworkServiceObserverAssociatedPtr = URLLoaderNetworkServiceObserverAssociatedPtr;
})();