// services/network/public/mojom/url_loader_network_service_observer.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.ClientCertificateResponderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.ClientCertificateResponder.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.ClientCertificateResponderInterface }
 */
network.mojom.ClientCertificateResponderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.ClientCertificateResponderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.ClientCertificateResponderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.ClientCertificateResponderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.X509Certificate } x509Certificate
   * @param { !string } providerName
   * @param { !Array<!number> } algorithmPreferences
   * @param { !network.mojom.SSLPrivateKeyRemote } sslPrivateKey
   */

  continueWithCertificate(
      x509Certificate,
      providerName,
      algorithmPreferences,
      sslPrivateKey) {
    this.proxy.sendMessage(
        0,
        network.mojom.ClientCertificateResponder_ContinueWithCertificate_ParamsSpec.$,
        null,
        [
          x509Certificate,
          providerName,
          algorithmPreferences,
          sslPrivateKey
        ],
        false);
  }

  
  /**
   */

  continueWithoutCertificate() {
    this.proxy.sendMessage(
        1,
        network.mojom.ClientCertificateResponder_ContinueWithoutCertificate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  cancelRequest() {
    this.proxy.sendMessage(
        2,
        network.mojom.ClientCertificateResponder_CancelRequest_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ClientCertificateResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.ClientCertificateResponderReceiver = class {
  /**
   * @param {!network.mojom.ClientCertificateResponderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.ClientCertificateResponderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.ClientCertificateResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ClientCertificateResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.ClientCertificateResponder_ContinueWithCertificate_ParamsSpec.$,
        null,
        impl.continueWithCertificate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.ClientCertificateResponder_ContinueWithoutCertificate_ParamsSpec.$,
        null,
        impl.continueWithoutCertificate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.ClientCertificateResponder_CancelRequest_ParamsSpec.$,
        null,
        impl.cancelRequest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.ClientCertificateResponder = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ClientCertificateResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.ClientCertificateResponderRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.ClientCertificateResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ClientCertificateResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.ClientCertificateResponderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.ClientCertificateResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.ClientCertificateResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.continueWithCertificate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.ClientCertificateResponder_ContinueWithCertificate_ParamsSpec.$,
        null,
        this.continueWithCertificate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.continueWithoutCertificate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.ClientCertificateResponder_ContinueWithoutCertificate_ParamsSpec.$,
        null,
        this.continueWithoutCertificate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.ClientCertificateResponder_CancelRequest_ParamsSpec.$,
        null,
        this.cancelRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.SSLPrivateKeyPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.SSLPrivateKey.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.SSLPrivateKeyInterface }
 */
network.mojom.SSLPrivateKeyRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.SSLPrivateKeyPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.SSLPrivateKeyPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.SSLPrivateKeyPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } algorithm
   * @param { !Array<!number> } input
   * @return {!Promise<{
        netError: !number,
        signature: !Array<!number>,
   *  }>}
   */

  sign(
      algorithm,
      input) {
    return this.proxy.sendMessage(
        0,
        network.mojom.SSLPrivateKey_Sign_ParamsSpec.$,
        network.mojom.SSLPrivateKey_Sign_ResponseParamsSpec.$,
        [
          algorithm,
          input
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SSLPrivateKey
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.SSLPrivateKeyReceiver = class {
  /**
   * @param {!network.mojom.SSLPrivateKeyInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.SSLPrivateKeyRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.SSLPrivateKeyRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SSLPrivateKeyRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.SSLPrivateKey_Sign_ParamsSpec.$,
        network.mojom.SSLPrivateKey_Sign_ResponseParamsSpec.$,
        impl.sign.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.SSLPrivateKey = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SSLPrivateKey";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.SSLPrivateKeyRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.SSLPrivateKeyRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SSLPrivateKey
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.SSLPrivateKeyCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.SSLPrivateKeyRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SSLPrivateKeyRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sign =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.SSLPrivateKey_Sign_ParamsSpec.$,
        network.mojom.SSLPrivateKey_Sign_ResponseParamsSpec.$,
        this.sign.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.AuthChallengeResponderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.AuthChallengeResponder.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.AuthChallengeResponderInterface }
 */
network.mojom.AuthChallengeResponderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.AuthChallengeResponderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.AuthChallengeResponderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.AuthChallengeResponderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?network.mojom.AuthCredentials } credentials
   */

  onAuthCredentials(
      credentials) {
    this.proxy.sendMessage(
        0,
        network.mojom.AuthChallengeResponder_OnAuthCredentials_ParamsSpec.$,
        null,
        [
          credentials
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AuthChallengeResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.AuthChallengeResponderReceiver = class {
  /**
   * @param {!network.mojom.AuthChallengeResponderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.AuthChallengeResponderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.AuthChallengeResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.AuthChallengeResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.AuthChallengeResponder_OnAuthCredentials_ParamsSpec.$,
        null,
        impl.onAuthCredentials.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.AuthChallengeResponder = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.AuthChallengeResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.AuthChallengeResponderRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.AuthChallengeResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AuthChallengeResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.AuthChallengeResponderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.AuthChallengeResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.AuthChallengeResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAuthCredentials =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.AuthChallengeResponder_OnAuthCredentials_ParamsSpec.$,
        null,
        this.onAuthCredentials.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.URLLoaderNetworkServiceObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.URLLoaderNetworkServiceObserverInterface }
 */
network.mojom.URLLoaderNetworkServiceObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.URLLoaderNetworkServiceObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.URLLoaderNetworkServiceObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.URLLoaderNetworkServiceObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !number } netError
   * @param { !network.mojom.SSLInfo } sslInfo
   * @param { !boolean } fatal
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  onSSLCertificateError(
      url,
      netError,
      sslInfo,
      fatal) {
    return this.proxy.sendMessage(
        0,
        network.mojom.URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsSpec.$,
        [
          url,
          netError,
          sslInfo,
          fatal
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase.mojom.UnguessableToken } windowId
   * @param { !network.mojom.SSLCertRequestInfo } certInfo
   * @param { !network.mojom.ClientCertificateResponderRemote } certResponder
   */

  onCertificateRequested(
      windowId,
      certInfo,
      certResponder) {
    this.proxy.sendMessage(
        1,
        network.mojom.URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsSpec.$,
        null,
        [
          windowId,
          certInfo,
          certResponder
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase.mojom.UnguessableToken } windowId
   * @param { !number } requestId
   * @param { !url.mojom.Url } url
   * @param { !boolean } firstAuthAttempt
   * @param { !network.mojom.AuthChallengeInfo } authInfo
   * @param { ?network.mojom.HttpResponseHeaders } headHeaders
   * @param { !network.mojom.AuthChallengeResponderRemote } authChallengeResponder
   */

  onAuthRequired(
      windowId,
      requestId,
      url,
      firstAuthAttempt,
      authInfo,
      headHeaders,
      authChallengeResponder) {
    this.proxy.sendMessage(
        2,
        network.mojom.URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsSpec.$,
        null,
        [
          windowId,
          requestId,
          url,
          firstAuthAttempt,
          authInfo,
          headHeaders,
          authChallengeResponder
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        permissionGranted: !boolean,
   *  }>}
   */

  onLocalNetworkAccessPermissionRequired() {
    return this.proxy.sendMessage(
        3,
        network.mojom.URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } headerValue
   * @param { !number } loadFlags
   * @param { ?network.mojom.CookiePartitionKey } cookiePartitionKey
   * @param { !boolean } partitionedStateAllowedOnly
   * @return {!Promise}
   */

  onClearSiteData(
      url,
      headerValue,
      loadFlags,
      cookiePartitionKey,
      partitionedStateAllowedOnly) {
    return this.proxy.sendMessage(
        4,
        network.mojom.URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsSpec.$,
        [
          url,
          headerValue,
          loadFlags,
          cookiePartitionKey,
          partitionedStateAllowedOnly
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.LoadInfo } info
   * @return {!Promise}
   */

  onLoadingStateUpdate(
      info) {
    return this.proxy.sendMessage(
        5,
        network.mojom.URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsSpec.$,
        [
          info
        ],
        false);
  }

  
  /**
   * @param { !number } networkTrafficAnnotationIdHash
   * @param { !bigint } recvBytes
   * @param { !bigint } sentBytes
   */

  onDataUseUpdate(
      networkTrafficAnnotationIdHash,
      recvBytes,
      sentBytes) {
    this.proxy.sendMessage(
        6,
        network.mojom.URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsSpec.$,
        null,
        [
          networkTrafficAnnotationIdHash,
          recvBytes,
          sentBytes
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Origin } requestOrigin
   * @param { !network.mojom.SharedStorageBatchUpdateMethodsArgument } methodsWithOptions
   * @param { ?network.mojom.LockName } withLock
   * @return {!Promise}
   */

  onSharedStorageHeaderReceived(
      requestOrigin,
      methodsWithOptions,
      withLock) {
    return this.proxy.sendMessage(
        7,
        network.mojom.URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsSpec.$,
        [
          requestOrigin,
          methodsWithOptions,
          withLock
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.AdAuctionEventRecord } adAuctionEventRecord
   * @param { ?url.mojom.Origin } topFrameOrigin
   */

  onAdAuctionEventRecordHeaderReceived(
      adAuctionEventRecord,
      topFrameOrigin) {
    this.proxy.sendMessage(
        8,
        network.mojom.URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsSpec.$,
        null,
        [
          adAuctionEventRecord,
          topFrameOrigin
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.URLLoaderNetworkServiceObserverPendingReceiver } listener
   */

  clone(
      listener) {
    this.proxy.sendMessage(
        9,
        network.mojom.URLLoaderNetworkServiceObserver_Clone_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } requestUrl
   * @param { !network.mojom.IPAddressSpace } ipAddressSpace
   */

  onWebSocketConnectedToPrivateNetwork(
      requestUrl,
      ipAddressSpace) {
    this.proxy.sendMessage(
        10,
        network.mojom.URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsSpec.$,
        null,
        [
          requestUrl,
          ipAddressSpace
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } requestUrl
   * @param { !network.mojom.IPAddressSpace } responseAddressSpace
   * @param { !network.mojom.IPAddressSpace } clientAddressSpace
   * @param { !network.mojom.IPAddressSpace } targetAddressSpace
   */

  onUrlLoaderConnectedToPrivateNetwork(
      requestUrl,
      responseAddressSpace,
      clientAddressSpace,
      targetAddressSpace) {
    this.proxy.sendMessage(
        11,
        network.mojom.URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsSpec.$,
        null,
        [
          requestUrl,
          responseAddressSpace,
          clientAddressSpace,
          targetAddressSpace
        ],
        false);
  }
};

/**
 * An object which receives request messages for the URLLoaderNetworkServiceObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserverReceiver = class {
  /**
   * @param {!network.mojom.URLLoaderNetworkServiceObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.URLLoaderNetworkServiceObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.URLLoaderNetworkServiceObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.URLLoaderNetworkServiceObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsSpec.$,
        impl.onSSLCertificateError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsSpec.$,
        null,
        impl.onCertificateRequested.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsSpec.$,
        null,
        impl.onAuthRequired.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsSpec.$,
        impl.onLocalNetworkAccessPermissionRequired.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsSpec.$,
        impl.onClearSiteData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsSpec.$,
        impl.onLoadingStateUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        network.mojom.URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsSpec.$,
        null,
        impl.onDataUseUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        network.mojom.URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsSpec.$,
        impl.onSharedStorageHeaderReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        network.mojom.URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsSpec.$,
        null,
        impl.onAdAuctionEventRecordHeaderReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        network.mojom.URLLoaderNetworkServiceObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        network.mojom.URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsSpec.$,
        null,
        impl.onWebSocketConnectedToPrivateNetwork.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        network.mojom.URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsSpec.$,
        null,
        impl.onUrlLoaderConnectedToPrivateNetwork.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.URLLoaderNetworkServiceObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.URLLoaderNetworkServiceObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.URLLoaderNetworkServiceObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.URLLoaderNetworkServiceObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the URLLoaderNetworkServiceObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.URLLoaderNetworkServiceObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.URLLoaderNetworkServiceObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSSLCertificateError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsSpec.$,
        this.onSSLCertificateError.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCertificateRequested =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsSpec.$,
        null,
        this.onCertificateRequested.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAuthRequired =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsSpec.$,
        null,
        this.onAuthRequired.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLocalNetworkAccessPermissionRequired =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsSpec.$,
        this.onLocalNetworkAccessPermissionRequired.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClearSiteData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsSpec.$,
        this.onClearSiteData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLoadingStateUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsSpec.$,
        this.onLoadingStateUpdate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDataUseUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        network.mojom.URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsSpec.$,
        null,
        this.onDataUseUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSharedStorageHeaderReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        network.mojom.URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsSpec.$,
        network.mojom.URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsSpec.$,
        this.onSharedStorageHeaderReceived.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAdAuctionEventRecordHeaderReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        network.mojom.URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsSpec.$,
        null,
        this.onAdAuctionEventRecordHeaderReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        network.mojom.URLLoaderNetworkServiceObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWebSocketConnectedToPrivateNetwork =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        network.mojom.URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsSpec.$,
        null,
        this.onWebSocketConnectedToPrivateNetwork.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onUrlLoaderConnectedToPrivateNetwork =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        network.mojom.URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsSpec.$,
        null,
        this.onUrlLoaderConnectedToPrivateNetwork.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.LoadInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ClientCertificateResponder_ContinueWithCertificate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ClientCertificateResponder_ContinueWithoutCertificate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ClientCertificateResponder_CancelRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SSLPrivateKey_Sign_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SSLPrivateKey_Sign_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.AuthChallengeResponder_OnAuthCredentials_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.LoadInfoSpec.$,
    'LoadInfo',
    [
      mojo.internal.StructField(
        'timestamp', 0,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'host', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'loadState', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stateParam', 24,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uploadPosition', 32,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uploadSize', 40,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
network.mojom.LoadInfo = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.timestamp;
    /** @export { !string } */
    this.host;
    /** @export { !number } */
    this.loadState;
    /** @export { !mojoBase.mojom.String16 } */
    this.stateParam;
    /** @export { !bigint } */
    this.uploadPosition;
    /** @export { !bigint } */
    this.uploadSize;
  }
};



mojo.internal.Struct(
    network.mojom.ClientCertificateResponder_ContinueWithCertificate_ParamsSpec.$,
    'ClientCertificateResponder_ContinueWithCertificate_Params',
    [
      mojo.internal.StructField(
        'x509Certificate', 0,
        0,
        network.mojom.X509CertificateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'providerName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'algorithmPreferences', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint16, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sslPrivateKey', 24,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SSLPrivateKeyRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.ClientCertificateResponder_ContinueWithCertificate_Params = class {
  constructor() {
    /** @export { !network.mojom.X509Certificate } */
    this.x509Certificate;
    /** @export { !string } */
    this.providerName;
    /** @export { !Array<!number> } */
    this.algorithmPreferences;
    /** @export { !network.mojom.SSLPrivateKeyRemote } */
    this.sslPrivateKey;
  }
};



mojo.internal.Struct(
    network.mojom.ClientCertificateResponder_ContinueWithoutCertificate_ParamsSpec.$,
    'ClientCertificateResponder_ContinueWithoutCertificate_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.ClientCertificateResponder_ContinueWithoutCertificate_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.ClientCertificateResponder_CancelRequest_ParamsSpec.$,
    'ClientCertificateResponder_CancelRequest_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.ClientCertificateResponder_CancelRequest_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.SSLPrivateKey_Sign_ParamsSpec.$,
    'SSLPrivateKey_Sign_Params',
    [
      mojo.internal.StructField(
        'algorithm', 0,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'input', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.SSLPrivateKey_Sign_Params = class {
  constructor() {
    /** @export { !number } */
    this.algorithm;
    /** @export { !Array<!number> } */
    this.input;
  }
};



mojo.internal.Struct(
    network.mojom.SSLPrivateKey_Sign_ResponseParamsSpec.$,
    'SSLPrivateKey_Sign_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'signature', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.SSLPrivateKey_Sign_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.netError;
    /** @export { !Array<!number> } */
    this.signature;
  }
};



mojo.internal.Struct(
    network.mojom.AuthChallengeResponder_OnAuthCredentials_ParamsSpec.$,
    'AuthChallengeResponder_OnAuthCredentials_Params',
    [
      mojo.internal.StructField(
        'credentials', 0,
        0,
        network.mojom.AuthCredentialsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.AuthChallengeResponder_OnAuthCredentials_Params = class {
  constructor() {
    /** @export { (network.mojom.AuthCredentials|undefined) } */
    this.credentials;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnSSLCertificateError_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'netError', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sslInfo', 16,
        0,
        network.mojom.SSLInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fatal', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnSSLCertificateError_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !number } */
    this.netError;
    /** @export { !network.mojom.SSLInfo } */
    this.sslInfo;
    /** @export { !boolean } */
    this.fatal;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnSSLCertificateError_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.netError;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnCertificateRequested_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnCertificateRequested_Params',
    [
      mojo.internal.StructField(
        'windowId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'certInfo', 8,
        0,
        network.mojom.SSLCertRequestInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'certResponder', 16,
        0,
        mojo.internal.InterfaceProxy(network.mojom.ClientCertificateResponderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnCertificateRequested_Params = class {
  constructor() {
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.windowId;
    /** @export { !network.mojom.SSLCertRequestInfo } */
    this.certInfo;
    /** @export { !network.mojom.ClientCertificateResponderRemote } */
    this.certResponder;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnAuthRequired_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnAuthRequired_Params',
    [
      mojo.internal.StructField(
        'windowId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestId', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'firstAuthAttempt', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'authInfo', 24,
        0,
        network.mojom.AuthChallengeInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headHeaders', 32,
        0,
        network.mojom.HttpResponseHeadersSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'authChallengeResponder', 40,
        0,
        mojo.internal.InterfaceProxy(network.mojom.AuthChallengeResponderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnAuthRequired_Params = class {
  constructor() {
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.windowId;
    /** @export { !number } */
    this.requestId;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !boolean } */
    this.firstAuthAttempt;
    /** @export { !network.mojom.AuthChallengeInfo } */
    this.authInfo;
    /** @export { (network.mojom.HttpResponseHeaders|undefined) } */
    this.headHeaders;
    /** @export { !network.mojom.AuthChallengeResponderRemote } */
    this.authChallengeResponder;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams',
    [
      mojo.internal.StructField(
        'permissionGranted', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnLocalNetworkAccessPermissionRequired_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.permissionGranted;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnClearSiteData_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnClearSiteData_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headerValue', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'loadFlags', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookiePartitionKey', 24,
        0,
        network.mojom.CookiePartitionKeySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'partitionedStateAllowedOnly', 20,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnClearSiteData_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.headerValue;
    /** @export { !number } */
    this.loadFlags;
    /** @export { (network.mojom.CookiePartitionKey|undefined) } */
    this.cookiePartitionKey;
    /** @export { !boolean } */
    this.partitionedStateAllowedOnly;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnClearSiteData_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        network.mojom.LoadInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_Params = class {
  constructor() {
    /** @export { !network.mojom.LoadInfo } */
    this.info;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnLoadingStateUpdate_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnDataUseUpdate_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params',
    [
      mojo.internal.StructField(
        'networkTrafficAnnotationIdHash', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'recvBytes', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sentBytes', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnDataUseUpdate_Params = class {
  constructor() {
    /** @export { !number } */
    this.networkTrafficAnnotationIdHash;
    /** @export { !bigint } */
    this.recvBytes;
    /** @export { !bigint } */
    this.sentBytes;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params',
    [
      mojo.internal.StructField(
        'requestOrigin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'methodsWithOptions', 8,
        0,
        network.mojom.SharedStorageBatchUpdateMethodsArgumentSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'withLock', 16,
        0,
        network.mojom.LockNameSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.requestOrigin;
    /** @export { !network.mojom.SharedStorageBatchUpdateMethodsArgument } */
    this.methodsWithOptions;
    /** @export { (network.mojom.LockName|undefined) } */
    this.withLock;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnSharedStorageHeaderReceived_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params',
    [
      mojo.internal.StructField(
        'adAuctionEventRecord', 0,
        0,
        network.mojom.AdAuctionEventRecordSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnAdAuctionEventRecordHeaderReceived_Params = class {
  constructor() {
    /** @export { !network.mojom.AdAuctionEventRecord } */
    this.adAuctionEventRecord;
    /** @export { (url.mojom.Origin|undefined) } */
    this.topFrameOrigin;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_Clone_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.URLLoaderNetworkServiceObserverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_Clone_Params = class {
  constructor() {
    /** @export { !network.mojom.URLLoaderNetworkServiceObserverPendingReceiver } */
    this.listener;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params',
    [
      mojo.internal.StructField(
        'requestUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ipAddressSpace', 8,
        0,
        network.mojom.IPAddressSpaceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnWebSocketConnectedToPrivateNetwork_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.requestUrl;
    /** @export { !network.mojom.IPAddressSpace } */
    this.ipAddressSpace;
  }
};



mojo.internal.Struct(
    network.mojom.URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_ParamsSpec.$,
    'URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params',
    [
      mojo.internal.StructField(
        'requestUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseAddressSpace', 8,
        0,
        network.mojom.IPAddressSpaceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientAddressSpace', 12,
        0,
        network.mojom.IPAddressSpaceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetAddressSpace', 16,
        0,
        network.mojom.IPAddressSpaceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
network.mojom.URLLoaderNetworkServiceObserver_OnUrlLoaderConnectedToPrivateNetwork_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.requestUrl;
    /** @export { !network.mojom.IPAddressSpace } */
    this.responseAddressSpace;
    /** @export { !network.mojom.IPAddressSpace } */
    this.clientAddressSpace;
    /** @export { !network.mojom.IPAddressSpace } */
    this.targetAddressSpace;
  }
};

