// services/network/public/mojom/unencoded_digest.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/unencoded_digest.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/unencoded_digest.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* UnencodedDigestIssueToStringHelper(UnencodedDigestIssue value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UnencodedDigestIssue::kMalformedDictionary:
      return "kMalformedDictionary";
    case UnencodedDigestIssue::kUnknownAlgorithm:
      return "kUnknownAlgorithm";
    case UnencodedDigestIssue::kIncorrectDigestType:
      return "kIncorrectDigestType";
    case UnencodedDigestIssue::kIncorrectDigestLength:
      return "kIncorrectDigestLength";
    default:
      return nullptr;
  }
}

std::string UnencodedDigestIssueToString(UnencodedDigestIssue value) {
  const char *str = UnencodedDigestIssueToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UnencodedDigestIssue value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UnencodedDigestIssue value) {
  return os << UnencodedDigestIssueToString(value);
}

namespace internal {


// static
bool UnencodedDigests_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnencodedDigests_Data* object =
      static_cast<const UnencodedDigests_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->digests, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& digests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->digests, validation_context,
                                         &digests_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->issues, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& issues_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::UnencodedDigestIssue_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->issues, validation_context,
                                         &issues_validate_params)) {
    return false;
  }

  return true;
}

UnencodedDigests_Data::UnencodedDigests_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::UnencodedDigestIssue>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::UnencodedDigestIssue value) {
  return std::move(context).WriteString(::network::mojom::UnencodedDigestIssueToString(value));
}

} // namespace perfetto