// services/network/public/mojom/trust_tokens.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TrustTokenProtocolVersionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TrustTokenProtocolVersion = {
  
  kTrustTokenV3Pmb: 0,
  kTrustTokenV3Voprf: 1,
  kPrivateStateTokenV1Pmb: 2,
  kPrivateStateTokenV1Voprf: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TrustTokenOperationStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TrustTokenOperationStatus = {
  
  kOk: 0,
  kInvalidArgument: 1,
  kMissingIssuerKeys: 2,
  kFailedPrecondition: 3,
  kResourceExhausted: 4,
  kAlreadyExists: 5,
  kResourceLimited: 6,
  kUnauthorized: 7,
  kBadResponse: 8,
  kInternalError: 9,
  kUnknownError: 10,
  kOperationSuccessfullyFulfilledLocally: 11,
  kSiteIssuerLimit: 12,
  MIN_VALUE: 0,
  MAX_VALUE: 12,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TrustTokenOperationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TrustTokenOperationType = {
  
  kIssuance: 0,
  kRedemption: 1,
  kSigning: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TrustTokenRefreshPolicySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TrustTokenRefreshPolicy = {
  
  kUseCached: 0,
  kRefresh: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TrustTokenSignRequestDataSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TrustTokenSignRequestData = {
  
  kOmit: 0,
  kHeadersOnly: 1,
  kInclude: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DeleteStoredTrustTokensStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DeleteStoredTrustTokensStatus = {
  
  kSuccessTokensDeleted: 0,
  kSuccessNoTokensDeleted: 1,
  kFailureFeatureDisabled: 2,
  kFailureInvalidOrigin: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TrustTokenQueryAnswererPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.TrustTokenQueryAnswerer', scope);
  }
}

/** @interface */
export class TrustTokenQueryAnswererInterface {
  
  /**
   * @param { !url_mojom_Origin } issuer
   * @return {!Promise<{
        result: !HasTrustTokensResult,
   *  }>}
   */

  hasTrustTokens(issuer) {}
  
  /**
   * @param { !url_mojom_Origin } issuer
   * @return {!Promise<{
        result: !HasRedemptionRecordResult,
   *  }>}
   */

  hasRedemptionRecord(issuer) {}
}

/**
 * @implements { TrustTokenQueryAnswererInterface }
 */
export class TrustTokenQueryAnswererRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TrustTokenQueryAnswererPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TrustTokenQueryAnswererPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TrustTokenQueryAnswererPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Origin } issuer
   * @return {!Promise<{
        result: !HasTrustTokensResult,
   *  }>}
   */

  hasTrustTokens(
      issuer) {
    return this.proxy.sendMessage(
        0,
        TrustTokenQueryAnswerer_HasTrustTokens_ParamsSpec.$,
        TrustTokenQueryAnswerer_HasTrustTokens_ResponseParamsSpec.$,
        [
          issuer
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Origin } issuer
   * @return {!Promise<{
        result: !HasRedemptionRecordResult,
   *  }>}
   */

  hasRedemptionRecord(
      issuer) {
    return this.proxy.sendMessage(
        1,
        TrustTokenQueryAnswerer_HasRedemptionRecord_ParamsSpec.$,
        TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParamsSpec.$,
        [
          issuer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TrustTokenQueryAnswerer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TrustTokenQueryAnswererReceiver {
  /**
   * @param {!TrustTokenQueryAnswererInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TrustTokenQueryAnswererRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TrustTokenQueryAnswererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TrustTokenQueryAnswererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TrustTokenQueryAnswerer_HasTrustTokens_ParamsSpec.$,
        TrustTokenQueryAnswerer_HasTrustTokens_ResponseParamsSpec.$,
        impl.hasTrustTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TrustTokenQueryAnswerer_HasRedemptionRecord_ParamsSpec.$,
        TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParamsSpec.$,
        impl.hasRedemptionRecord.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TrustTokenQueryAnswerer {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TrustTokenQueryAnswerer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TrustTokenQueryAnswererRemote}
   */
  static getRemote() {
    let remote = new TrustTokenQueryAnswererRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TrustTokenQueryAnswerer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TrustTokenQueryAnswererCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TrustTokenQueryAnswererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TrustTokenQueryAnswererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasTrustTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TrustTokenQueryAnswerer_HasTrustTokens_ParamsSpec.$,
        TrustTokenQueryAnswerer_HasTrustTokens_ResponseParamsSpec.$,
        this.hasTrustTokens.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hasRedemptionRecord =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TrustTokenQueryAnswerer_HasRedemptionRecord_ParamsSpec.$,
        TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParamsSpec.$,
        this.hasRedemptionRecord.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HasTrustTokensResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HasRedemptionRecordResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenVerificationKeySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenKeyCommitmentResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FulfillTrustTokenIssuanceRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FulfillTrustTokenIssuanceAnswerSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenOperationResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StoredTrustTokensForIssuerSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ToplevelRedemptionRecordSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenQueryAnswerer_HasTrustTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenQueryAnswerer_HasTrustTokens_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenQueryAnswerer_HasRedemptionRecord_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TrustTokenParamsSpec.$,
    'TrustTokenParams',
    [
      mojo.internal.StructField(
        'operation', 0,
        0,
        TrustTokenOperationTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'refreshPolicy', 4,
        0,
        TrustTokenRefreshPolicySpec.$,
        TrustTokenRefreshPolicy.kUseCached,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'customKeyCommitment', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'customIssuer', 16,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'signRequestData', 24,
        0,
        TrustTokenSignRequestDataSpec.$,
        TrustTokenSignRequestData.kOmit,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeTimestampHeader', 28,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'issuers', 32,
        0,
        mojo.internal.Array(url_mojom_OriginSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'additionalSignedHeaders', 40,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'possiblyUnsafeAdditionalSigningData', 48,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class TrustTokenParams {
  constructor() {
    /** @type { !TrustTokenOperationType } */
    this.operation;
    /** @type { !TrustTokenRefreshPolicy } */
    this.refreshPolicy;
    /** @type { (string|undefined) } */
    this.customKeyCommitment;
    /** @type { (url_mojom_Origin|undefined) } */
    this.customIssuer;
    /** @type { !TrustTokenSignRequestData } */
    this.signRequestData;
    /** @type { !boolean } */
    this.includeTimestampHeader;
    /** @type { !Array<!url_mojom_Origin> } */
    this.issuers;
    /** @type { !Array<!string> } */
    this.additionalSignedHeaders;
    /** @type { (string|undefined) } */
    this.possiblyUnsafeAdditionalSigningData;
  }
}



mojo.internal.Struct(
    HasTrustTokensResultSpec.$,
    'HasTrustTokensResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        TrustTokenOperationStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasTrustTokens', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HasTrustTokensResult {
  constructor() {
    /** @type { !TrustTokenOperationStatus } */
    this.status;
    /** @type { !boolean } */
    this.hasTrustTokens;
  }
}



mojo.internal.Struct(
    HasRedemptionRecordResultSpec.$,
    'HasRedemptionRecordResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        TrustTokenOperationStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasRedemptionRecord', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HasRedemptionRecordResult {
  constructor() {
    /** @type { !TrustTokenOperationStatus } */
    this.status;
    /** @type { !boolean } */
    this.hasRedemptionRecord;
  }
}



mojo.internal.Struct(
    TrustTokenVerificationKeySpec.$,
    'TrustTokenVerificationKey',
    [
      mojo.internal.StructField(
        'body', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expiry', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TrustTokenVerificationKey {
  constructor() {
    /** @type { !string } */
    this.body;
    /** @type { !mojoBase_mojom_Time } */
    this.expiry;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TrustTokenKeyCommitmentResult_OsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TrustTokenKeyCommitmentResult_Os = {
  
  kAndroid: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallbackSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback = {
  
  kWebIssuance: 0,
  kReturnWithError: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    TrustTokenKeyCommitmentResultSpec.$,
    'TrustTokenKeyCommitmentResult',
    [
      mojo.internal.StructField(
        'protocolVersion', 0,
        0,
        TrustTokenProtocolVersionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'batchSize', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keys', 16,
        0,
        mojo.internal.Array(TrustTokenVerificationKeySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestIssuanceLocallyOn', 24,
        0,
        mojo.internal.Array(TrustTokenKeyCommitmentResult_OsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unavailableLocalOperationFallback', 12,
        0,
        TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallbackSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class TrustTokenKeyCommitmentResult {
  constructor() {
    /** @type { !TrustTokenProtocolVersion } */
    this.protocolVersion;
    /** @type { !number } */
    this.id;
    /** @type { !number } */
    this.batchSize;
    /** @type { !Array<!TrustTokenVerificationKey> } */
    this.keys;
    /** @type { !Array<!TrustTokenKeyCommitmentResult_Os> } */
    this.requestIssuanceLocallyOn;
    /** @type { !TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback } */
    this.unavailableLocalOperationFallback;
  }
}



mojo.internal.Struct(
    FulfillTrustTokenIssuanceRequestSpec.$,
    'FulfillTrustTokenIssuanceRequest',
    [
      mojo.internal.StructField(
        'issuer', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'request', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FulfillTrustTokenIssuanceRequest {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.issuer;
    /** @type { !string } */
    this.request;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FulfillTrustTokenIssuanceAnswer_StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FulfillTrustTokenIssuanceAnswer_Status = {
  
  kOk: 0,
  kNotFound: 1,
  kUnknownError: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


mojo.internal.Struct(
    FulfillTrustTokenIssuanceAnswerSpec.$,
    'FulfillTrustTokenIssuanceAnswer',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        FulfillTrustTokenIssuanceAnswer_StatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FulfillTrustTokenIssuanceAnswer {
  constructor() {
    /** @type { !FulfillTrustTokenIssuanceAnswer_Status } */
    this.status;
    /** @type { !string } */
    this.response;
  }
}



mojo.internal.Struct(
    TrustTokenOperationResultSpec.$,
    'TrustTokenOperationResult',
    [
      mojo.internal.StructField(
        'operation', 0,
        0,
        TrustTokenOperationTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 4,
        0,
        TrustTokenOperationStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'issuer', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'topLevelOrigin', 16,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'issuedTokenCount', 24,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class TrustTokenOperationResult {
  constructor() {
    /** @type { !TrustTokenOperationType } */
    this.operation;
    /** @type { !TrustTokenOperationStatus } */
    this.status;
    /** @type { (url_mojom_Origin|undefined) } */
    this.issuer;
    /** @type { (url_mojom_Origin|undefined) } */
    this.topLevelOrigin;
    /** @type { !number } */
    this.issuedTokenCount;
  }
}



mojo.internal.Struct(
    StoredTrustTokensForIssuerSpec.$,
    'StoredTrustTokensForIssuer',
    [
      mojo.internal.StructField(
        'issuer', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'count', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class StoredTrustTokensForIssuer {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.issuer;
    /** @type { !number } */
    this.count;
  }
}



mojo.internal.Struct(
    ToplevelRedemptionRecordSpec.$,
    'ToplevelRedemptionRecord',
    [
      mojo.internal.StructField(
        'toplevelOrigin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastRedemption', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ToplevelRedemptionRecord {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.toplevelOrigin;
    /** @type { !mojoBase_mojom_Time } */
    this.lastRedemption;
  }
}



mojo.internal.Struct(
    TrustTokenQueryAnswerer_HasTrustTokens_ParamsSpec.$,
    'TrustTokenQueryAnswerer_HasTrustTokens_Params',
    [
      mojo.internal.StructField(
        'issuer', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TrustTokenQueryAnswerer_HasTrustTokens_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.issuer;
  }
}



mojo.internal.Struct(
    TrustTokenQueryAnswerer_HasTrustTokens_ResponseParamsSpec.$,
    'TrustTokenQueryAnswerer_HasTrustTokens_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        HasTrustTokensResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TrustTokenQueryAnswerer_HasTrustTokens_ResponseParams {
  constructor() {
    /** @type { !HasTrustTokensResult } */
    this.result;
  }
}



mojo.internal.Struct(
    TrustTokenQueryAnswerer_HasRedemptionRecord_ParamsSpec.$,
    'TrustTokenQueryAnswerer_HasRedemptionRecord_Params',
    [
      mojo.internal.StructField(
        'issuer', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TrustTokenQueryAnswerer_HasRedemptionRecord_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.issuer;
  }
}



mojo.internal.Struct(
    TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParamsSpec.$,
    'TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        HasRedemptionRecordResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParams {
  constructor() {
    /** @type { !HasRedemptionRecordResult } */
    this.result;
  }
}

