// services/network/public/mojom/trust_tokens.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/trust_tokens.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "services/network/public/mojom/trust_tokens.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::TrustTokenProtocolVersion, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::TrustTokenOperationStatus, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::TrustTokenOperationType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::TrustTokenRefreshPolicy, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::TrustTokenSignRequestData, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::DeleteStoredTrustTokensStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::TrustTokenParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::TrustTokenOperationType>(
        Traits::operation(input),
        &fragment->operation);

      
      mojo::internal::Serialize<::network::mojom::TrustTokenRefreshPolicy>(
        Traits::refresh_policy(input),
        &fragment->refresh_policy);

      decltype(Traits::custom_key_commitment(input)) in_custom_key_commitment = Traits::custom_key_commitment(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->custom_key_commitment)::BaseType> custom_key_commitment_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_custom_key_commitment,
        custom_key_commitment_fragment);

      fragment->custom_key_commitment.Set(
          custom_key_commitment_fragment.is_null() ? nullptr : custom_key_commitment_fragment.data());

      decltype(Traits::custom_issuer(input)) in_custom_issuer = Traits::custom_issuer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->custom_issuer)::BaseType> custom_issuer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_custom_issuer,
        custom_issuer_fragment);

      fragment->custom_issuer.Set(
          custom_issuer_fragment.is_null() ? nullptr : custom_issuer_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::TrustTokenSignRequestData>(
        Traits::sign_request_data(input),
        &fragment->sign_request_data);

      fragment->include_timestamp_header = Traits::include_timestamp_header(input);

      decltype(Traits::issuers(input)) in_issuers = Traits::issuers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->issuers)::BaseType>
          issuers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& issuers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>, send_validation>(
        in_issuers,
        issuers_fragment,
        &issuers_validate_params);

      fragment->issuers.Set(
          issuers_fragment.is_null() ? nullptr : issuers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->issuers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null issuers in TrustTokenParams struct");

      decltype(Traits::additional_signed_headers(input)) in_additional_signed_headers = Traits::additional_signed_headers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->additional_signed_headers)::BaseType>
          additional_signed_headers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& additional_signed_headers_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_additional_signed_headers,
        additional_signed_headers_fragment,
        &additional_signed_headers_validate_params);

      fragment->additional_signed_headers.Set(
          additional_signed_headers_fragment.is_null() ? nullptr : additional_signed_headers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->additional_signed_headers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null additional_signed_headers in TrustTokenParams struct");

      decltype(Traits::possibly_unsafe_additional_signing_data(input)) in_possibly_unsafe_additional_signing_data = Traits::possibly_unsafe_additional_signing_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->possibly_unsafe_additional_signing_data)::BaseType> possibly_unsafe_additional_signing_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_possibly_unsafe_additional_signing_data,
        possibly_unsafe_additional_signing_data_fragment);

      fragment->possibly_unsafe_additional_signing_data.Set(
          possibly_unsafe_additional_signing_data_fragment.is_null() ? nullptr : possibly_unsafe_additional_signing_data_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::HasTrustTokensResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HasTrustTokensResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HasTrustTokensResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::TrustTokenOperationStatus>(
        Traits::status(input),
        &fragment->status);

      fragment->has_trust_tokens = Traits::has_trust_tokens(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::HasRedemptionRecordResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HasRedemptionRecordResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HasRedemptionRecordResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::TrustTokenOperationStatus>(
        Traits::status(input),
        &fragment->status);

      fragment->has_redemption_record = Traits::has_redemption_record(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::TrustTokenVerificationKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenVerificationKeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenVerificationKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::body(input)) in_body = Traits::body(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->body)::BaseType> body_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_body,
        body_fragment);

      fragment->body.Set(
          body_fragment.is_null() ? nullptr : body_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->body.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null body in TrustTokenVerificationKey struct");

      decltype(Traits::expiry(input)) in_expiry = Traits::expiry(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->expiry)::BaseType> expiry_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_expiry,
        expiry_fragment);

      fragment->expiry.Set(
          expiry_fragment.is_null() ? nullptr : expiry_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->expiry.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiry in TrustTokenVerificationKey struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::TrustTokenKeyCommitmentResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenKeyCommitmentResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenKeyCommitmentResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::TrustTokenProtocolVersion>(
        Traits::protocol_version(input),
        &fragment->protocol_version);

      fragment->id = Traits::id(input);

      fragment->batch_size = Traits::batch_size(input);

      decltype(Traits::keys(input)) in_keys = Traits::keys(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->keys)::BaseType>
          keys_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::TrustTokenVerificationKeyDataView>, send_validation>(
        in_keys,
        keys_fragment,
        &keys_validate_params);

      fragment->keys.Set(
          keys_fragment.is_null() ? nullptr : keys_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->keys.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null keys in TrustTokenKeyCommitmentResult struct");

      decltype(Traits::request_issuance_locally_on(input)) in_request_issuance_locally_on = Traits::request_issuance_locally_on(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->request_issuance_locally_on)::BaseType>
          request_issuance_locally_on_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& request_issuance_locally_on_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::TrustTokenKeyCommitmentResult_Os_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::TrustTokenKeyCommitmentResult_Os>, send_validation>(
        in_request_issuance_locally_on,
        request_issuance_locally_on_fragment,
        &request_issuance_locally_on_validate_params);

      fragment->request_issuance_locally_on.Set(
          request_issuance_locally_on_fragment.is_null() ? nullptr : request_issuance_locally_on_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->request_issuance_locally_on.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_issuance_locally_on in TrustTokenKeyCommitmentResult struct");

      
      mojo::internal::Serialize<::network::mojom::TrustTokenKeyCommitmentResult_UnavailableLocalOperationFallback>(
        Traits::unavailable_local_operation_fallback(input),
        &fragment->unavailable_local_operation_fallback);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::FulfillTrustTokenIssuanceRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FulfillTrustTokenIssuanceRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FulfillTrustTokenIssuanceRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->issuer)::BaseType> issuer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_issuer,
        issuer_fragment);

      fragment->issuer.Set(
          issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->issuer.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null issuer in FulfillTrustTokenIssuanceRequest struct");

      decltype(Traits::request(input)) in_request = Traits::request(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->request)::BaseType> request_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_request,
        request_fragment);

      fragment->request.Set(
          request_fragment.is_null() ? nullptr : request_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->request.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request in FulfillTrustTokenIssuanceRequest struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::FulfillTrustTokenIssuanceAnswerDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FulfillTrustTokenIssuanceAnswerDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FulfillTrustTokenIssuanceAnswer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::FulfillTrustTokenIssuanceAnswer_Status>(
        Traits::status(input),
        &fragment->status);

      decltype(Traits::response(input)) in_response = Traits::response(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->response)::BaseType> response_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_response,
        response_fragment);

      fragment->response.Set(
          response_fragment.is_null() ? nullptr : response_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->response.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response in FulfillTrustTokenIssuanceAnswer struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::TrustTokenOperationResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenOperationResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenOperationResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::TrustTokenOperationType>(
        Traits::operation(input),
        &fragment->operation);

      
      mojo::internal::Serialize<::network::mojom::TrustTokenOperationStatus>(
        Traits::status(input),
        &fragment->status);

      decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->issuer)::BaseType> issuer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_issuer,
        issuer_fragment);

      fragment->issuer.Set(
          issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

      decltype(Traits::top_level_origin(input)) in_top_level_origin = Traits::top_level_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->top_level_origin)::BaseType> top_level_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_top_level_origin,
        top_level_origin_fragment);

      fragment->top_level_origin.Set(
          top_level_origin_fragment.is_null() ? nullptr : top_level_origin_fragment.data());

      fragment->issued_token_count = Traits::issued_token_count(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::StoredTrustTokensForIssuerDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::StoredTrustTokensForIssuerDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::StoredTrustTokensForIssuer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->issuer)::BaseType> issuer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_issuer,
        issuer_fragment);

      fragment->issuer.Set(
          issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->issuer.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null issuer in StoredTrustTokensForIssuer struct");

      fragment->count = Traits::count(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ToplevelRedemptionRecordDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ToplevelRedemptionRecordDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ToplevelRedemptionRecord_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::toplevel_origin(input)) in_toplevel_origin = Traits::toplevel_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->toplevel_origin)::BaseType> toplevel_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_toplevel_origin,
        toplevel_origin_fragment);

      fragment->toplevel_origin.Set(
          toplevel_origin_fragment.is_null() ? nullptr : toplevel_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->toplevel_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null toplevel_origin in ToplevelRedemptionRecord struct");

      decltype(Traits::last_redemption(input)) in_last_redemption = Traits::last_redemption(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_redemption)::BaseType> last_redemption_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_redemption,
        last_redemption_fragment);

      fragment->last_redemption.Set(
          last_redemption_fragment.is_null() ? nullptr : last_redemption_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_redemption.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_redemption in ToplevelRedemptionRecord struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_SEND_VALIDATION_H_