// services/network/public/mojom/tcp_socket.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_TEST_UTILS_H_

#include "services/network/public/mojom/tcp_socket.mojom.h"


namespace network::mojom {


class  TCPBoundSocketInterceptorForTesting : public TCPBoundSocket {
  virtual TCPBoundSocket* GetForwardingInterface() = 0;
  void Listen(uint32_t backlog, ::mojo::PendingReceiver<TCPServerSocket> socket, ListenCallback callback) override;
  void Connect(const ::net::AddressList& remote_addr_list, TCPConnectedSocketOptionsPtr tcp_connected_socket_options, ::mojo::PendingReceiver<TCPConnectedSocket> socket, ::mojo::PendingRemote<SocketObserver> observer, ConnectCallback callback) override;
};
class  TCPBoundSocketAsyncWaiter {
 public:
  explicit TCPBoundSocketAsyncWaiter(TCPBoundSocket* proxy);

  TCPBoundSocketAsyncWaiter(const TCPBoundSocketAsyncWaiter&) = delete;
  TCPBoundSocketAsyncWaiter& operator=(const TCPBoundSocketAsyncWaiter&) = delete;

  ~TCPBoundSocketAsyncWaiter();
  void Listen(
      uint32_t backlog, ::mojo::PendingReceiver<TCPServerSocket> socket, int32_t* out_net_error);
  int32_t Listen(uint32_t backlog, ::mojo::PendingReceiver<TCPServerSocket> socket);
  void Connect(
      const ::net::AddressList& remote_addr_list, TCPConnectedSocketOptionsPtr tcp_connected_socket_options, ::mojo::PendingReceiver<TCPConnectedSocket> socket, ::mojo::PendingRemote<SocketObserver> observer, int32_t* out_net_error, std::optional<::net::IPEndPoint>* out_local_addr, std::optional<::net::IPEndPoint>* out_peer_addr, ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream, ::mojo::ScopedDataPipeProducerHandle* out_send_stream);
  

 private:
  TCPBoundSocket* const proxy_;
};


class  TCPConnectedSocketInterceptorForTesting : public TCPConnectedSocket {
  virtual TCPConnectedSocket* GetForwardingInterface() = 0;
  void UpgradeToTLS(const ::net::HostPortPair& host_port_pair, ::network::mojom::TLSClientSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TLSClientSocket> receiver, ::mojo::PendingRemote<SocketObserver> observer, UpgradeToTLSCallback callback) override;
  void SetSendBufferSize(int32_t send_buffer_size, SetSendBufferSizeCallback callback) override;
  void SetReceiveBufferSize(int32_t receive_buffer_size, SetReceiveBufferSizeCallback callback) override;
  void SetNoDelay(bool no_delay, SetNoDelayCallback callback) override;
  void SetKeepAlive(bool enable, int32_t delay_secs, SetKeepAliveCallback callback) override;
};
class  TCPConnectedSocketAsyncWaiter {
 public:
  explicit TCPConnectedSocketAsyncWaiter(TCPConnectedSocket* proxy);

  TCPConnectedSocketAsyncWaiter(const TCPConnectedSocketAsyncWaiter&) = delete;
  TCPConnectedSocketAsyncWaiter& operator=(const TCPConnectedSocketAsyncWaiter&) = delete;

  ~TCPConnectedSocketAsyncWaiter();
  void UpgradeToTLS(
      const ::net::HostPortPair& host_port_pair, ::network::mojom::TLSClientSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TLSClientSocket> receiver, ::mojo::PendingRemote<SocketObserver> observer, int32_t* out_net_error, ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream, ::mojo::ScopedDataPipeProducerHandle* out_send_stream, std::optional<::net::SSLInfo>* out_ssl_info);
  
  void SetSendBufferSize(
      int32_t send_buffer_size, int32_t* out_net_error);
  int32_t SetSendBufferSize(int32_t send_buffer_size);
  void SetReceiveBufferSize(
      int32_t receive_buffer_size, int32_t* out_net_error);
  int32_t SetReceiveBufferSize(int32_t receive_buffer_size);
  void SetNoDelay(
      bool no_delay, bool* out_success);
  bool SetNoDelay(bool no_delay);
  void SetKeepAlive(
      bool enable, int32_t delay_secs, bool* out_success);
  bool SetKeepAlive(bool enable, int32_t delay_secs);

 private:
  TCPConnectedSocket* const proxy_;
};


class  SocketObserverInterceptorForTesting : public SocketObserver {
  virtual SocketObserver* GetForwardingInterface() = 0;
  void OnReadError(int32_t net_error) override;
  void OnWriteError(int32_t net_error) override;
};
class  SocketObserverAsyncWaiter {
 public:
  explicit SocketObserverAsyncWaiter(SocketObserver* proxy);

  SocketObserverAsyncWaiter(const SocketObserverAsyncWaiter&) = delete;
  SocketObserverAsyncWaiter& operator=(const SocketObserverAsyncWaiter&) = delete;

  ~SocketObserverAsyncWaiter();

 private:
  SocketObserver* const proxy_;
};


class  TCPServerSocketInterceptorForTesting : public TCPServerSocket {
  virtual TCPServerSocket* GetForwardingInterface() = 0;
  void Accept(::mojo::PendingRemote<SocketObserver> observer, AcceptCallback callback) override;
};
class  TCPServerSocketAsyncWaiter {
 public:
  explicit TCPServerSocketAsyncWaiter(TCPServerSocket* proxy);

  TCPServerSocketAsyncWaiter(const TCPServerSocketAsyncWaiter&) = delete;
  TCPServerSocketAsyncWaiter& operator=(const TCPServerSocketAsyncWaiter&) = delete;

  ~TCPServerSocketAsyncWaiter();
  void Accept(
      ::mojo::PendingRemote<SocketObserver> observer, int32_t* out_net_error, std::optional<::net::IPEndPoint>* out_remote_addr, ::mojo::PendingRemote<TCPConnectedSocket>* out_connected_socket, ::mojo::ScopedDataPipeConsumerHandle* out_send_stream, ::mojo::ScopedDataPipeProducerHandle* out_receive_stream);
  

 private:
  TCPServerSocket* const proxy_;
};




}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_TEST_UTILS_H_