// services/network/public/mojom/system_dns_resolution.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.AddressFamily');
goog.require('network.mojom.AddressList');






goog.provide('network.mojom.SystemDnsResolver');
goog.provide('network.mojom.SystemDnsResolverReceiver');
goog.provide('network.mojom.SystemDnsResolverCallbackRouter');
goog.provide('network.mojom.SystemDnsResolverInterface');
goog.provide('network.mojom.SystemDnsResolverRemote');
goog.provide('network.mojom.SystemDnsResolverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.SystemDnsResolverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.SystemDnsResolver.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.SystemDnsResolverInterface = class {
  
  /**
   * @param { ?string } hostname
   * @param { !network.mojom.AddressFamily } addrFamily
   * @param { !number } flags
   * @param { !bigint } network
   * @return {!Promise<{
        addrList: !network.mojom.AddressList,
        osError: !number,
        netError: !number,
   *  }>}
   */

  resolve(hostname, addrFamily, flags, network) {}
};

/**
 * @export
 * @implements { network.mojom.SystemDnsResolverInterface }
 */
network.mojom.SystemDnsResolverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.SystemDnsResolverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.SystemDnsResolverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.SystemDnsResolverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?string } hostname
   * @param { !network.mojom.AddressFamily } addrFamily
   * @param { !number } flags
   * @param { !bigint } network
   * @return {!Promise<{
        addrList: !network.mojom.AddressList,
        osError: !number,
        netError: !number,
   *  }>}
   */

  resolve(
      hostname,
      addrFamily,
      flags,
      network) {
    return this.proxy.sendMessage(
        0,
        network.mojom.SystemDnsResolver_Resolve_ParamsSpec.$,
        network.mojom.SystemDnsResolver_Resolve_ResponseParamsSpec.$,
        [
          hostname,
          addrFamily,
          flags,
          network
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SystemDnsResolver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.SystemDnsResolverReceiver = class {
  /**
   * @param {!network.mojom.SystemDnsResolverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.SystemDnsResolverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.SystemDnsResolverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SystemDnsResolverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.SystemDnsResolver_Resolve_ParamsSpec.$,
        network.mojom.SystemDnsResolver_Resolve_ResponseParamsSpec.$,
        impl.resolve.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.SystemDnsResolver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SystemDnsResolver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.SystemDnsResolverRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.SystemDnsResolverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SystemDnsResolver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.SystemDnsResolverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.SystemDnsResolverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SystemDnsResolverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolve =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.SystemDnsResolver_Resolve_ParamsSpec.$,
        network.mojom.SystemDnsResolver_Resolve_ResponseParamsSpec.$,
        this.resolve.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.SystemDnsResolver_Resolve_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SystemDnsResolver_Resolve_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SystemDnsResolver_Resolve_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SystemDnsResolver_Resolve_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.SystemDnsResolver_Resolve_ParamsSpec.$,
    'SystemDnsResolver_Resolve_Params',
    [
      mojo.internal.StructField(
        'hostname', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'addrFamily', 8,
        0,
        network.mojom.AddressFamilySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'flags', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'network', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.SystemDnsResolver_Resolve_Params');

/** @record */
network.mojom.SystemDnsResolver_Resolve_Params = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.hostname;
    /** @export { !network.mojom.AddressFamily } */
    this.addrFamily;
    /** @export { !number } */
    this.flags;
    /** @export { !bigint } */
    this.network;
  }
};



mojo.internal.Struct(
    network.mojom.SystemDnsResolver_Resolve_ResponseParamsSpec.$,
    'SystemDnsResolver_Resolve_ResponseParams',
    [
      mojo.internal.StructField(
        'addrList', 0,
        0,
        network.mojom.AddressListSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'osError', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'netError', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.SystemDnsResolver_Resolve_ResponseParams');

/** @record */
network.mojom.SystemDnsResolver_Resolve_ResponseParams = class {
  constructor() {
    /** @export { !network.mojom.AddressList } */
    this.addrList;
    /** @export { !number } */
    this.osError;
    /** @export { !number } */
    this.netError;
  }
};

