// services/network/public/mojom/supports_loading_mode.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SUPPORTS_LOADING_MODE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SUPPORTS_LOADING_MODE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/supports_loading_mode.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/supports_loading_mode.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/supports_loading_mode.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace network::mojom {








class  SupportsLoadingMode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SupportsLoadingMode, T>::value>;
  using DataView = SupportsLoadingModeDataView;
  using Data_ = internal::SupportsLoadingMode_Data;

  template <typename... Args>
  static SupportsLoadingModePtr New(Args&&... args) {
    return SupportsLoadingModePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SupportsLoadingModePtr From(const U& u) {
    return mojo::TypeConverter<SupportsLoadingModePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SupportsLoadingMode>::Convert(*this);
  }


  SupportsLoadingMode();

  explicit SupportsLoadingMode(
      std::vector<LoadingMode> supported_modes);


  ~SupportsLoadingMode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SupportsLoadingModePtr>
  SupportsLoadingModePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SupportsLoadingMode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SupportsLoadingMode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SupportsLoadingMode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupportsLoadingMode::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupportsLoadingMode::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SupportsLoadingMode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SupportsLoadingMode_UnserializedMessageContext<
            UserType, SupportsLoadingMode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SupportsLoadingMode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SupportsLoadingMode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SupportsLoadingMode_UnserializedMessageContext<
            UserType, SupportsLoadingMode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SupportsLoadingMode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<LoadingMode> supported_modes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SupportsLoadingMode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SupportsLoadingMode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SupportsLoadingMode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SupportsLoadingMode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SupportsLoadingModePtr SupportsLoadingMode::Clone() const {
  return New(
      mojo::Clone(supported_modes)
  );
}

template <typename T, SupportsLoadingMode::EnableIfSame<T>*>
bool SupportsLoadingMode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->supported_modes, other_struct.supported_modes))
    return false;
  return true;
}

template <typename T, SupportsLoadingMode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.supported_modes < rhs.supported_modes)
    return true;
  if (rhs.supported_modes < lhs.supported_modes)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::SupportsLoadingMode::DataView,
                                         ::network::mojom::SupportsLoadingModePtr> {
  static bool IsNull(const ::network::mojom::SupportsLoadingModePtr& input) { return !input; }
  static void SetToNull(::network::mojom::SupportsLoadingModePtr* output) { output->reset(); }

  static const decltype(::network::mojom::SupportsLoadingMode::supported_modes)& supported_modes(
      const ::network::mojom::SupportsLoadingModePtr& input) {
    return input->supported_modes;
  }

  static bool Read(::network::mojom::SupportsLoadingMode::DataView input, ::network::mojom::SupportsLoadingModePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SUPPORTS_LOADING_MODE_MOJOM_H_