// services/network/public/mojom/shared_storage.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/shared_storage.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../mojo/public/mojom/base/string16.mojom.js');
  }



  function SharedStorageKeyArgument(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageKeyArgument.prototype.initDefaults_ = function() {
    this.data = null;
  };
  SharedStorageKeyArgument.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageKeyArgument.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageKeyArgument.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageKeyArgument.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageKeyArgument.decode = function(decoder) {
    var packed;
    var val = new SharedStorageKeyArgument();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  SharedStorageKeyArgument.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageKeyArgument.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.data);
  };
  function SharedStorageValueArgument(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageValueArgument.prototype.initDefaults_ = function() {
    this.data = null;
  };
  SharedStorageValueArgument.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageValueArgument.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageValueArgument.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageValueArgument.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageValueArgument.decode = function(decoder) {
    var packed;
    var val = new SharedStorageValueArgument();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  SharedStorageValueArgument.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageValueArgument.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.data);
  };
  function LockName(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LockName.prototype.initDefaults_ = function() {
    this.data = null;
  };
  LockName.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LockName.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LockName.data
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LockName.encodedSize = codec.kStructHeaderSize + 8;

  LockName.decode = function(decoder) {
    var packed;
    var val = new LockName();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStruct(codec.String);
    return val;
  };

  LockName.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LockName.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.data);
  };
  function SharedStorageSetMethod(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageSetMethod.prototype.initDefaults_ = function() {
    this.key = null;
    this.value = null;
    this.ignoreIfPresent = false;
  };
  SharedStorageSetMethod.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageSetMethod.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageSetMethod.key
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SharedStorageKeyArgument, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageSetMethod.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SharedStorageValueArgument, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SharedStorageSetMethod.encodedSize = codec.kStructHeaderSize + 24;

  SharedStorageSetMethod.decode = function(decoder) {
    var packed;
    var val = new SharedStorageSetMethod();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStructPointer(SharedStorageKeyArgument);
    val.value =
        decoder.decodeStructPointer(SharedStorageValueArgument);
    packed = decoder.readUint8();
    val.ignoreIfPresent = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SharedStorageSetMethod.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageSetMethod.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SharedStorageKeyArgument, val.key);
    encoder.encodeStructPointer(SharedStorageValueArgument, val.value);
    packed = 0;
    packed |= (val.ignoreIfPresent & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SharedStorageAppendMethod(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageAppendMethod.prototype.initDefaults_ = function() {
    this.key = null;
    this.value = null;
  };
  SharedStorageAppendMethod.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageAppendMethod.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageAppendMethod.key
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SharedStorageKeyArgument, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageAppendMethod.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SharedStorageValueArgument, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageAppendMethod.encodedSize = codec.kStructHeaderSize + 16;

  SharedStorageAppendMethod.decode = function(decoder) {
    var packed;
    var val = new SharedStorageAppendMethod();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStructPointer(SharedStorageKeyArgument);
    val.value =
        decoder.decodeStructPointer(SharedStorageValueArgument);
    return val;
  };

  SharedStorageAppendMethod.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageAppendMethod.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SharedStorageKeyArgument, val.key);
    encoder.encodeStructPointer(SharedStorageValueArgument, val.value);
  };
  function SharedStorageDeleteMethod(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageDeleteMethod.prototype.initDefaults_ = function() {
    this.key = null;
  };
  SharedStorageDeleteMethod.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageDeleteMethod.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageDeleteMethod.key
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SharedStorageKeyArgument, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageDeleteMethod.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageDeleteMethod.decode = function(decoder) {
    var packed;
    var val = new SharedStorageDeleteMethod();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStructPointer(SharedStorageKeyArgument);
    return val;
  };

  SharedStorageDeleteMethod.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageDeleteMethod.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SharedStorageKeyArgument, val.key);
  };
  function SharedStorageClearMethod(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageClearMethod.prototype.initDefaults_ = function() {
  };
  SharedStorageClearMethod.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageClearMethod.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageClearMethod.encodedSize = codec.kStructHeaderSize + 0;

  SharedStorageClearMethod.decode = function(decoder) {
    var packed;
    var val = new SharedStorageClearMethod();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SharedStorageClearMethod.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageClearMethod.encodedSize);
    encoder.writeUint32(0);
  };
  function SharedStorageModifierMethodWithOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageModifierMethodWithOptions.prototype.initDefaults_ = function() {
    this.method = null;
    this.withLock = null;
  };
  SharedStorageModifierMethodWithOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageModifierMethodWithOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageModifierMethodWithOptions.method
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SharedStorageModifierMethod, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageModifierMethodWithOptions.withLock
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, LockName, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageModifierMethodWithOptions.encodedSize = codec.kStructHeaderSize + 24;

  SharedStorageModifierMethodWithOptions.decode = function(decoder) {
    var packed;
    var val = new SharedStorageModifierMethodWithOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.method =
        decoder.decodeStruct(SharedStorageModifierMethod);
    val.withLock =
        decoder.decodeStructPointer(LockName);
    return val;
  };

  SharedStorageModifierMethodWithOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageModifierMethodWithOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SharedStorageModifierMethod, val.method);
    encoder.encodeStructPointer(LockName, val.withLock);
  };
  function SharedStorageBatchUpdateMethodsArgument(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageBatchUpdateMethodsArgument.prototype.initDefaults_ = function() {
    this.data = null;
  };
  SharedStorageBatchUpdateMethodsArgument.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageBatchUpdateMethodsArgument.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageBatchUpdateMethodsArgument.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SharedStorageModifierMethodWithOptions), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageBatchUpdateMethodsArgument.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageBatchUpdateMethodsArgument.decode = function(decoder) {
    var packed;
    var val = new SharedStorageBatchUpdateMethodsArgument();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeArrayPointer(new codec.PointerTo(SharedStorageModifierMethodWithOptions));
    return val;
  };

  SharedStorageBatchUpdateMethodsArgument.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageBatchUpdateMethodsArgument.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SharedStorageModifierMethodWithOptions), val.data);
  };

  function SharedStorageModifierMethod(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SharedStorageModifierMethod.Tags = {
    setMethod: 0,
    appendMethod: 1,
    deleteMethod: 2,
    clearMethod: 3,
  };

  SharedStorageModifierMethod.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SharedStorageModifierMethod.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "setMethod",
        "appendMethod",
        "deleteMethod",
        "clearMethod",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SharedStorageModifierMethod member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SharedStorageModifierMethod.prototype, "setMethod", {
    get: function() {
      if (this.$tag != SharedStorageModifierMethod.Tags.setMethod) {
        throw new ReferenceError(
            "SharedStorageModifierMethod.setMethod is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SharedStorageModifierMethod.Tags.setMethod;
      this.$data = value;
    }
  });
  Object.defineProperty(SharedStorageModifierMethod.prototype, "appendMethod", {
    get: function() {
      if (this.$tag != SharedStorageModifierMethod.Tags.appendMethod) {
        throw new ReferenceError(
            "SharedStorageModifierMethod.appendMethod is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SharedStorageModifierMethod.Tags.appendMethod;
      this.$data = value;
    }
  });
  Object.defineProperty(SharedStorageModifierMethod.prototype, "deleteMethod", {
    get: function() {
      if (this.$tag != SharedStorageModifierMethod.Tags.deleteMethod) {
        throw new ReferenceError(
            "SharedStorageModifierMethod.deleteMethod is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SharedStorageModifierMethod.Tags.deleteMethod;
      this.$data = value;
    }
  });
  Object.defineProperty(SharedStorageModifierMethod.prototype, "clearMethod", {
    get: function() {
      if (this.$tag != SharedStorageModifierMethod.Tags.clearMethod) {
        throw new ReferenceError(
            "SharedStorageModifierMethod.clearMethod is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SharedStorageModifierMethod.Tags.clearMethod;
      this.$data = value;
    }
  });


    SharedStorageModifierMethod.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SharedStorageModifierMethod.Tags.setMethod:
          encoder.encodeStructPointer(SharedStorageSetMethod, val.setMethod);
          break;
        case SharedStorageModifierMethod.Tags.appendMethod:
          encoder.encodeStructPointer(SharedStorageAppendMethod, val.appendMethod);
          break;
        case SharedStorageModifierMethod.Tags.deleteMethod:
          encoder.encodeStructPointer(SharedStorageDeleteMethod, val.deleteMethod);
          break;
        case SharedStorageModifierMethod.Tags.clearMethod:
          encoder.encodeStructPointer(SharedStorageClearMethod, val.clearMethod);
          break;
      }
      encoder.align();
    };


    SharedStorageModifierMethod.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SharedStorageModifierMethod();
      var tag = decoder.readUint32();
      switch (tag) {
        case SharedStorageModifierMethod.Tags.setMethod:
          result.setMethod = decoder.decodeStructPointer(SharedStorageSetMethod);
          break;
        case SharedStorageModifierMethod.Tags.appendMethod:
          result.appendMethod = decoder.decodeStructPointer(SharedStorageAppendMethod);
          break;
        case SharedStorageModifierMethod.Tags.deleteMethod:
          result.deleteMethod = decoder.decodeStructPointer(SharedStorageDeleteMethod);
          break;
        case SharedStorageModifierMethod.Tags.clearMethod:
          result.clearMethod = decoder.decodeStructPointer(SharedStorageClearMethod);
          break;
      }
      decoder.align();

      return result;
    };


    SharedStorageModifierMethod.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SharedStorageModifierMethod.Tags.setMethod:
          

    // validate SharedStorageModifierMethod.setMethod
    err = messageValidator.validateStructPointer(data_offset, SharedStorageSetMethod, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SharedStorageModifierMethod.Tags.appendMethod:
          

    // validate SharedStorageModifierMethod.appendMethod
    err = messageValidator.validateStructPointer(data_offset, SharedStorageAppendMethod, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SharedStorageModifierMethod.Tags.deleteMethod:
          

    // validate SharedStorageModifierMethod.deleteMethod
    err = messageValidator.validateStructPointer(data_offset, SharedStorageDeleteMethod, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SharedStorageModifierMethod.Tags.clearMethod:
          

    // validate SharedStorageModifierMethod.clearMethod
    err = messageValidator.validateStructPointer(data_offset, SharedStorageClearMethod, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SharedStorageModifierMethod.encodedSize = 16;
  exports.SharedStorageKeyArgument = SharedStorageKeyArgument;
  exports.SharedStorageValueArgument = SharedStorageValueArgument;
  exports.LockName = LockName;
  exports.SharedStorageSetMethod = SharedStorageSetMethod;
  exports.SharedStorageAppendMethod = SharedStorageAppendMethod;
  exports.SharedStorageDeleteMethod = SharedStorageDeleteMethod;
  exports.SharedStorageClearMethod = SharedStorageClearMethod;
  exports.SharedStorageModifierMethodWithOptions = SharedStorageModifierMethodWithOptions;
  exports.SharedStorageBatchUpdateMethodsArgument = SharedStorageBatchUpdateMethodsArgument;
  exports.SharedStorageModifierMethod = SharedStorageModifierMethod;
})();