// services/network/public/mojom/shared_dictionary_usage_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/shared_dictionary_usage_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/shared_dictionary_usage_info.mojom-params-data.h"
#include "services/network/public/mojom/shared_dictionary_usage_info.mojom-shared-message-ids.h"

#include "services/network/public/mojom/shared_dictionary_usage_info.mojom-import-headers.h"
#include "services/network/public/mojom/shared_dictionary_usage_info.mojom-test-utils.h"


namespace network::mojom {
SharedDictionaryUsageInfo::SharedDictionaryUsageInfo()
    : isolation_key(),
      total_size_bytes() {}

SharedDictionaryUsageInfo::SharedDictionaryUsageInfo(
    const ::net::SharedDictionaryIsolationKey& isolation_key_in,
    uint64_t total_size_bytes_in)
    : isolation_key(std::move(isolation_key_in)),
      total_size_bytes(std::move(total_size_bytes_in)) {}

SharedDictionaryUsageInfo::~SharedDictionaryUsageInfo() = default;

void SharedDictionaryUsageInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isolation_key"), this->isolation_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::SharedDictionaryIsolationKey&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_size_bytes"), this->total_size_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedDictionaryUsageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::SharedDictionaryUsageInfo::DataView, ::network::mojom::SharedDictionaryUsageInfoPtr>::Read(
    ::network::mojom::SharedDictionaryUsageInfo::DataView input,
    ::network::mojom::SharedDictionaryUsageInfoPtr* output) {
  bool success = true;
  ::network::mojom::SharedDictionaryUsageInfoPtr result(::network::mojom::SharedDictionaryUsageInfo::New());
  
      if (success && !input.ReadIsolationKey(&result->isolation_key))
        success = false;
      if (success)
        result->total_size_bytes = input.total_size_bytes();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif