// services/network/public/mojom/shared_dictionary_access_observer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  SharedDictionaryIsolationKey as network_mojom_SharedDictionaryIsolationKey,
  SharedDictionaryIsolationKeySpec as network_mojom_SharedDictionaryIsolationKeySpec
} from './shared_dictionary_isolation_key.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SharedDictionaryAccessObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.SharedDictionaryAccessObserver', scope);
  }
}

/** @interface */
export class SharedDictionaryAccessObserverInterface {
  
  /**
   * @param { !SharedDictionaryAccessDetails } details
   */

  onSharedDictionaryAccessed(details) {}
  
  /**
   * @param { !SharedDictionaryAccessObserverPendingReceiver } observer
   */

  clone(observer) {}
}

/**
 * @implements { SharedDictionaryAccessObserverInterface }
 */
export class SharedDictionaryAccessObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SharedDictionaryAccessObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SharedDictionaryAccessObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SharedDictionaryAccessObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SharedDictionaryAccessDetails } details
   */

  onSharedDictionaryAccessed(
      details) {
    this.proxy.sendMessage(
        0,
        SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }

  
  /**
   * @param { !SharedDictionaryAccessObserverPendingReceiver } observer
   */

  clone(
      observer) {
    this.proxy.sendMessage(
        1,
        SharedDictionaryAccessObserver_Clone_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SharedDictionaryAccessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SharedDictionaryAccessObserverReceiver {
  /**
   * @param {!SharedDictionaryAccessObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SharedDictionaryAccessObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SharedDictionaryAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedDictionaryAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_ParamsSpec.$,
        null,
        impl.onSharedDictionaryAccessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SharedDictionaryAccessObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SharedDictionaryAccessObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SharedDictionaryAccessObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SharedDictionaryAccessObserverRemote}
   */
  static getRemote() {
    let remote = new SharedDictionaryAccessObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SharedDictionaryAccessObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SharedDictionaryAccessObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SharedDictionaryAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedDictionaryAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSharedDictionaryAccessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_ParamsSpec.$,
        null,
        this.onSharedDictionaryAccessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SharedDictionaryAccessObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedDictionaryAccessDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedDictionaryAccessObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };



/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SharedDictionaryAccessDetails_TypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SharedDictionaryAccessDetails_Type = {
  
  kRead: 0,
  kWrite: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    SharedDictionaryAccessDetailsSpec.$,
    'SharedDictionaryAccessDetails',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        SharedDictionaryAccessDetails_TypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isolationKey', 16,
        0,
        network_mojom_SharedDictionaryIsolationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isBlocked', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SharedDictionaryAccessDetails {
  constructor() {
    /** @type { !SharedDictionaryAccessDetails_Type } */
    this.type;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_SharedDictionaryIsolationKey } */
    this.isolationKey;
    /** @type { !boolean } */
    this.isBlocked;
  }
}



mojo.internal.Struct(
    SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_ParamsSpec.$,
    'SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        SharedDictionaryAccessDetailsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_Params {
  constructor() {
    /** @type { !SharedDictionaryAccessDetails } */
    this.details;
  }
}



mojo.internal.Struct(
    SharedDictionaryAccessObserver_Clone_ParamsSpec.$,
    'SharedDictionaryAccessObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceRequest(SharedDictionaryAccessObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedDictionaryAccessObserver_Clone_Params {
  constructor() {
    /** @type { !SharedDictionaryAccessObserverPendingReceiver } */
    this.observer;
  }
}

