// services/network/public/mojom/shared_dictionary_access_observer.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ACCESS_OBSERVER_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ACCESS_OBSERVER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom-blink.h"
#include "url/mojom/origin.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class SharedDictionaryAccessObserverProxy;

template <typename ImplRefTraits>
class SharedDictionaryAccessObserverStub;

class SharedDictionaryAccessObserverRequestValidator;


class BLINK_PLATFORM_EXPORT SharedDictionaryAccessObserver
    : public SharedDictionaryAccessObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.SharedDictionaryAccessObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SharedDictionaryAccessObserverInterfaceBase;
  using Proxy_ = SharedDictionaryAccessObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = SharedDictionaryAccessObserverStub<ImplRefTraits>;

  using RequestValidator_ = SharedDictionaryAccessObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSharedDictionaryAccessedMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnSharedDictionaryAccessed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SharedDictionaryAccessObserver() = default;

  virtual void OnSharedDictionaryAccessed(SharedDictionaryAccessDetailsPtr details) = 0;

  virtual void Clone(::mojo::PendingReceiver<SharedDictionaryAccessObserver> observer) = 0;
};



class BLINK_PLATFORM_EXPORT SharedDictionaryAccessObserverProxy
    : public SharedDictionaryAccessObserver {
 public:
  using InterfaceType = SharedDictionaryAccessObserver;

  explicit SharedDictionaryAccessObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSharedDictionaryAccessed(SharedDictionaryAccessDetailsPtr details) final;
  
  void Clone(::mojo::PendingReceiver<SharedDictionaryAccessObserver> observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT SharedDictionaryAccessObserverStubDispatch {
 public:
  static bool Accept(SharedDictionaryAccessObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SharedDictionaryAccessObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SharedDictionaryAccessObserver>>
class SharedDictionaryAccessObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SharedDictionaryAccessObserverStub() = default;
  ~SharedDictionaryAccessObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedDictionaryAccessObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedDictionaryAccessObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT SharedDictionaryAccessObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_PLATFORM_EXPORT SharedDictionaryAccessDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedDictionaryAccessDetails, T>::value>;
  using DataView = SharedDictionaryAccessDetailsDataView;
  using Data_ = internal::SharedDictionaryAccessDetails_Data;
  using Type = SharedDictionaryAccessDetails_Type;

  template <typename... Args>
  static SharedDictionaryAccessDetailsPtr New(Args&&... args) {
    return SharedDictionaryAccessDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedDictionaryAccessDetailsPtr From(const U& u) {
    return mojo::TypeConverter<SharedDictionaryAccessDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedDictionaryAccessDetails>::Convert(*this);
  }


  SharedDictionaryAccessDetails();

  SharedDictionaryAccessDetails(
      SharedDictionaryAccessDetails::Type type,
      const ::blink::KURL& url,
      ::network::mojom::blink::SharedDictionaryIsolationKeyPtr isolation_key,
      bool is_blocked);

SharedDictionaryAccessDetails(const SharedDictionaryAccessDetails&) = delete;
SharedDictionaryAccessDetails& operator=(const SharedDictionaryAccessDetails&) = delete;

  ~SharedDictionaryAccessDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedDictionaryAccessDetailsPtr>
  SharedDictionaryAccessDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedDictionaryAccessDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedDictionaryAccessDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedDictionaryAccessDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedDictionaryAccessDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedDictionaryAccessDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedDictionaryAccessDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedDictionaryAccessDetails_UnserializedMessageContext<
            UserType, SharedDictionaryAccessDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedDictionaryAccessDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedDictionaryAccessDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedDictionaryAccessDetails_UnserializedMessageContext<
            UserType, SharedDictionaryAccessDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedDictionaryAccessDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SharedDictionaryAccessDetails::Type type;
  
  ::blink::KURL url;
  
  ::network::mojom::blink::SharedDictionaryIsolationKeyPtr isolation_key;
  
  bool is_blocked;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedDictionaryAccessDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedDictionaryAccessDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedDictionaryAccessDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedDictionaryAccessDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SharedDictionaryAccessDetailsPtr SharedDictionaryAccessDetails::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(url),
      mojo::Clone(isolation_key),
      mojo::Clone(is_blocked)
  );
}

template <typename T, SharedDictionaryAccessDetails::EnableIfSame<T>*>
bool SharedDictionaryAccessDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->isolation_key, other_struct.isolation_key))
    return false;
  if (!mojo::Equals(this->is_blocked, other_struct.is_blocked))
    return false;
  return true;
}

template <typename T, SharedDictionaryAccessDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.isolation_key < rhs.isolation_key)
    return true;
  if (rhs.isolation_key < lhs.isolation_key)
    return false;
  if (lhs.is_blocked < rhs.is_blocked)
    return true;
  if (rhs.is_blocked < lhs.is_blocked)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::SharedDictionaryAccessDetails::DataView,
                                         ::network::mojom::blink::SharedDictionaryAccessDetailsPtr> {
  static bool IsNull(const ::network::mojom::blink::SharedDictionaryAccessDetailsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::SharedDictionaryAccessDetailsPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::SharedDictionaryAccessDetails::type) type(
      const ::network::mojom::blink::SharedDictionaryAccessDetailsPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::blink::SharedDictionaryAccessDetails::url)& url(
      const ::network::mojom::blink::SharedDictionaryAccessDetailsPtr& input) {
    return input->url;
  }

  static const decltype(::network::mojom::blink::SharedDictionaryAccessDetails::isolation_key)& isolation_key(
      const ::network::mojom::blink::SharedDictionaryAccessDetailsPtr& input) {
    return input->isolation_key;
  }

  static decltype(::network::mojom::blink::SharedDictionaryAccessDetails::is_blocked) is_blocked(
      const ::network::mojom::blink::SharedDictionaryAccessDetailsPtr& input) {
    return input->is_blocked;
  }

  static bool Read(::network::mojom::blink::SharedDictionaryAccessDetails::DataView input, ::network::mojom::blink::SharedDictionaryAccessDetailsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ACCESS_OBSERVER_MOJOM_BLINK_H_