// services/network/public/mojom/service_worker_router_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SERVICE_WORKER_ROUTER_INFO_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SERVICE_WORKER_ROUTER_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/service_worker_router_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace network::mojom {
class ServiceWorkerRouterInfoDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ServiceWorkerRouterInfoDataView> {
  using Data = ::network::mojom::internal::ServiceWorkerRouterInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class ServiceWorkerRouterSourceType : int32_t {
  
  kNetwork = 0,
  
  kRaceNetworkAndFetchEvent = 1,
  
  kFetchEvent = 2,
  
  kCache = 3,
  
  kRaceNetworkAndCache = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ServiceWorkerRouterSourceType value);
inline bool IsKnownEnumValue(ServiceWorkerRouterSourceType value) {
  return internal::ServiceWorkerRouterSourceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ServiceWorkerStatus : int32_t {
  
  kRunning = 0,
  
  kStarting = 1,
  
  kStopping = 2,
  
  kStopped = 3,
  
  kWarmingUp = 4,
  
  kWarmedUp = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, ServiceWorkerStatus value);
inline bool IsKnownEnumValue(ServiceWorkerStatus value) {
  return internal::ServiceWorkerStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ServiceWorkerRouterInfoDataView {
 public:
  ServiceWorkerRouterInfoDataView() = default;

  ServiceWorkerRouterInfoDataView(
      internal::ServiceWorkerRouterInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  std::optional<uint32_t> rule_id_matched() const {

    return data_->rule_id_matched_$flag
        ? std::make_optional(data_->rule_id_matched_$value)
        : std::nullopt;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMatchedSourceType(UserType* output) const {
    if (!data_->matched_source_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::network::mojom::ServiceWorkerRouterSourceType>(
        data_->matched_source_type_$value, &output->emplace());
  }
  std::optional<ServiceWorkerRouterSourceType> matched_source_type() const {
    if (!data_->matched_source_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ServiceWorkerRouterSourceType>(data_->matched_source_type_$value));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadActualSourceType(UserType* output) const {
    if (!data_->actual_source_type_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::network::mojom::ServiceWorkerRouterSourceType>(
        data_->actual_source_type_$value, &output->emplace());
  }
  std::optional<ServiceWorkerRouterSourceType> actual_source_type() const {
    if (!data_->actual_source_type_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ServiceWorkerRouterSourceType>(data_->actual_source_type_$value));
  }
  uint64_t route_rule_num() const {
    return data_->route_rule_num;
  }
  inline void GetRouterEvaluationTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouterEvaluationTime(UserType* output) {
    
    auto* pointer = data_->router_evaluation_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetCacheLookupTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCacheLookupTime(UserType* output) {
    
    auto* pointer = data_->cache_lookup_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEvaluationWorkerStatus(UserType* output) const {
    if (!data_->evaluation_worker_status_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::network::mojom::ServiceWorkerStatus>(
        data_->evaluation_worker_status_$value, &output->emplace());
  }
  std::optional<ServiceWorkerStatus> evaluation_worker_status() const {
    if (!data_->evaluation_worker_status_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ServiceWorkerStatus>(data_->evaluation_worker_status_$value));
  }
 private:
  internal::ServiceWorkerRouterInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SERVICE_WORKER_ROUTER_INFO_MOJOM_DATA_VIEW_H_