// services/network/public/mojom/restricted_udp_socket.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_UDP_SOCKET_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_UDP_SOCKET_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/restricted_udp_socket.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/restricted_udp_socket.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/restricted_udp_socket.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/read_only_buffer.mojom-blink.h"
#include "services/network/public/mojom/host_resolver.mojom-blink.h"
#include "services/network/public/mojom/network_param.mojom-blink.h"
#include "services/network/public/mojom/udp_socket.mojom-blink.h"
#include "services/network/public/mojom/ip_address.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class RestrictedUDPSocketProxy;

template <typename ImplRefTraits>
class RestrictedUDPSocketStub;

class RestrictedUDPSocketRequestValidator;
class RestrictedUDPSocketResponseValidator;


class BLINK_PLATFORM_EXPORT RestrictedUDPSocket
    : public RestrictedUDPSocketInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.RestrictedUDPSocket";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RestrictedUDPSocketInterfaceBase;
  using Proxy_ = RestrictedUDPSocketProxy;

  template <typename ImplRefTraits>
  using Stub_ = RestrictedUDPSocketStub<ImplRefTraits>;

  using RequestValidator_ = RestrictedUDPSocketRequestValidator;
  using ResponseValidator_ = RestrictedUDPSocketResponseValidator;
  enum MethodMinVersions : uint32_t {
    kJoinGroupMinVersion = 0,
    kLeaveGroupMinVersion = 0,
    kReceiveMoreMinVersion = 0,
    kSendMinVersion = 0,
    kSendToMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct JoinGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LeaveGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReceiveMore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Send_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendTo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RestrictedUDPSocket() = default;

  using JoinGroupCallback = base::OnceCallback<void(int32_t)>;
  using JoinGroupMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void JoinGroup(const ::net::IPAddress& group_address, JoinGroupCallback callback) = 0;

  using LeaveGroupCallback = base::OnceCallback<void(int32_t)>;
  using LeaveGroupMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void LeaveGroup(const ::net::IPAddress& group_address, LeaveGroupCallback callback) = 0;

  virtual void ReceiveMore(uint32_t num_additional_datagrams) = 0;

  using SendCallback = base::OnceCallback<void(int32_t)>;
  using SendMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void Send(::base::span<const ::uint8_t> data, SendCallback callback) = 0;

  using SendToCallback = base::OnceCallback<void(int32_t)>;
  using SendToMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void SendTo(::base::span<const ::uint8_t> data, const ::net::HostPortPair& dest_addr, ::net::DnsQueryType dns_query_type, SendToCallback callback) = 0;
};



class BLINK_PLATFORM_EXPORT RestrictedUDPSocketProxy
    : public RestrictedUDPSocket {
 public:
  using InterfaceType = RestrictedUDPSocket;

  explicit RestrictedUDPSocketProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void JoinGroup(const ::net::IPAddress& group_address, JoinGroupCallback callback) final;
  
  void LeaveGroup(const ::net::IPAddress& group_address, LeaveGroupCallback callback) final;
  
  void ReceiveMore(uint32_t num_additional_datagrams) final;
  
  void Send(::base::span<const ::uint8_t> data, SendCallback callback) final;
  
  void SendTo(::base::span<const ::uint8_t> data, const ::net::HostPortPair& dest_addr, ::net::DnsQueryType dns_query_type, SendToCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT RestrictedUDPSocketStubDispatch {
 public:
  static bool Accept(RestrictedUDPSocket* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RestrictedUDPSocket* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RestrictedUDPSocket>>
class RestrictedUDPSocketStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RestrictedUDPSocketStub() = default;
  ~RestrictedUDPSocketStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RestrictedUDPSocketStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RestrictedUDPSocketStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT RestrictedUDPSocketRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT RestrictedUDPSocketResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_PLATFORM_EXPORT RestrictedUDPSocketParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RestrictedUDPSocketParams, T>::value>;
  using DataView = RestrictedUDPSocketParamsDataView;
  using Data_ = internal::RestrictedUDPSocketParams_Data;

  template <typename... Args>
  static RestrictedUDPSocketParamsPtr New(Args&&... args) {
    return RestrictedUDPSocketParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RestrictedUDPSocketParamsPtr From(const U& u) {
    return mojo::TypeConverter<RestrictedUDPSocketParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RestrictedUDPSocketParams>::Convert(*this);
  }


  RestrictedUDPSocketParams();

  explicit RestrictedUDPSocketParams(
      ::network::mojom::blink::UDPSocketOptionsPtr socket_options);

RestrictedUDPSocketParams(const RestrictedUDPSocketParams&) = delete;
RestrictedUDPSocketParams& operator=(const RestrictedUDPSocketParams&) = delete;

  ~RestrictedUDPSocketParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RestrictedUDPSocketParamsPtr>
  RestrictedUDPSocketParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RestrictedUDPSocketParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RestrictedUDPSocketParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RestrictedUDPSocketParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RestrictedUDPSocketParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RestrictedUDPSocketParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RestrictedUDPSocketParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RestrictedUDPSocketParams_UnserializedMessageContext<
            UserType, RestrictedUDPSocketParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RestrictedUDPSocketParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RestrictedUDPSocketParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RestrictedUDPSocketParams_UnserializedMessageContext<
            UserType, RestrictedUDPSocketParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RestrictedUDPSocketParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::mojom::blink::UDPSocketOptionsPtr socket_options;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RestrictedUDPSocketParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RestrictedUDPSocketParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RestrictedUDPSocketParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RestrictedUDPSocketParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RestrictedUDPSocketParamsPtr RestrictedUDPSocketParams::Clone() const {
  return New(
      mojo::Clone(socket_options)
  );
}

template <typename T, RestrictedUDPSocketParams::EnableIfSame<T>*>
bool RestrictedUDPSocketParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->socket_options, other_struct.socket_options))
    return false;
  return true;
}

template <typename T, RestrictedUDPSocketParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.socket_options < rhs.socket_options)
    return true;
  if (rhs.socket_options < lhs.socket_options)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::RestrictedUDPSocketParams::DataView,
                                         ::network::mojom::blink::RestrictedUDPSocketParamsPtr> {
  static bool IsNull(const ::network::mojom::blink::RestrictedUDPSocketParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::RestrictedUDPSocketParamsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::RestrictedUDPSocketParams::socket_options)& socket_options(
      const ::network::mojom::blink::RestrictedUDPSocketParamsPtr& input) {
    return input->socket_options;
  }

  static bool Read(::network::mojom::blink::RestrictedUDPSocketParams::DataView input, ::network::mojom::blink::RestrictedUDPSocketParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_UDP_SOCKET_MOJOM_BLINK_H_