// services/network/public/mojom/reporting_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  DictionaryValue as mojoBase_mojom_DictionaryValue,
  DictionaryValueSpec as mojoBase_mojom_DictionaryValueSpec
} from '../../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  NetworkAnonymizationKey as network_mojom_NetworkAnonymizationKey,
  NetworkAnonymizationKeySpec as network_mojom_NetworkAnonymizationKeySpec
} from './network_anonymization_key.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ReportingApiReportStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ReportingApiReportStatus = {
  
  kQueued: 0,
  kPending: 1,
  kDoomed: 2,
  kSuccess: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ReportingApiObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.ReportingApiObserver', scope);
  }
}

/** @interface */
export class ReportingApiObserverInterface {
  
  /**
   * @param { !ReportingApiReport } report
   */

  onReportAdded(report) {}
  
  /**
   * @param { !ReportingApiReport } report
   */

  onReportUpdated(report) {}
  
  /**
   * @param { !Array<!ReportingApiEndpoint> } endpoints
   */

  onEndpointsUpdatedForOrigin(endpoints) {}
}

/**
 * @implements { ReportingApiObserverInterface }
 */
export class ReportingApiObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ReportingApiObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ReportingApiObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ReportingApiObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ReportingApiReport } report
   */

  onReportAdded(
      report) {
    this.proxy.sendMessage(
        0,
        ReportingApiObserver_OnReportAdded_ParamsSpec.$,
        null,
        [
          report
        ],
        false);
  }

  
  /**
   * @param { !ReportingApiReport } report
   */

  onReportUpdated(
      report) {
    this.proxy.sendMessage(
        1,
        ReportingApiObserver_OnReportUpdated_ParamsSpec.$,
        null,
        [
          report
        ],
        false);
  }

  
  /**
   * @param { !Array<!ReportingApiEndpoint> } endpoints
   */

  onEndpointsUpdatedForOrigin(
      endpoints) {
    this.proxy.sendMessage(
        2,
        ReportingApiObserver_OnEndpointsUpdatedForOrigin_ParamsSpec.$,
        null,
        [
          endpoints
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ReportingApiObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ReportingApiObserverReceiver {
  /**
   * @param {!ReportingApiObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ReportingApiObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ReportingApiObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ReportingApiObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ReportingApiObserver_OnReportAdded_ParamsSpec.$,
        null,
        impl.onReportAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ReportingApiObserver_OnReportUpdated_ParamsSpec.$,
        null,
        impl.onReportUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ReportingApiObserver_OnEndpointsUpdatedForOrigin_ParamsSpec.$,
        null,
        impl.onEndpointsUpdatedForOrigin.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ReportingApiObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ReportingApiObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ReportingApiObserverRemote}
   */
  static getRemote() {
    let remote = new ReportingApiObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ReportingApiObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ReportingApiObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ReportingApiObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ReportingApiObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReportAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ReportingApiObserver_OnReportAdded_ParamsSpec.$,
        null,
        this.onReportAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReportUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ReportingApiObserver_OnReportUpdated_ParamsSpec.$,
        null,
        this.onReportUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEndpointsUpdatedForOrigin =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ReportingApiObserver_OnEndpointsUpdatedForOrigin_ParamsSpec.$,
        null,
        this.onEndpointsUpdatedForOrigin.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingApiReportSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingApiEndpointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingApiObserver_OnReportAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingApiObserver_OnReportUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ReportingApiObserver_OnEndpointsUpdatedForOrigin_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ReportingApiReportSpec.$,
    'ReportingApiReport',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'group', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timestamp', 32,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'depth', 40,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attempts', 44,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'body', 48,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 56,
        0,
        ReportingApiReportStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class ReportingApiReport {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.id;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.group;
    /** @type { !string } */
    this.type;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.timestamp;
    /** @type { !number } */
    this.depth;
    /** @type { !number } */
    this.attempts;
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.body;
    /** @type { !ReportingApiReportStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ReportingApiEndpointSpec.$,
    'ReportingApiEndpoint',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attemptedUploads', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'successfulUploads', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attemptedReports', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'successfulReports', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priority', 24,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'weight', 28,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'origin', 32,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'groupName', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 48,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportingSource', 64,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class ReportingApiEndpoint {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !number } */
    this.attemptedUploads;
    /** @type { !number } */
    this.successfulUploads;
    /** @type { !number } */
    this.attemptedReports;
    /** @type { !number } */
    this.successfulReports;
    /** @type { !number } */
    this.priority;
    /** @type { !number } */
    this.weight;
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !string } */
    this.groupName;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.reportingSource;
  }
}



mojo.internal.Struct(
    ReportingApiObserver_OnReportAdded_ParamsSpec.$,
    'ReportingApiObserver_OnReportAdded_Params',
    [
      mojo.internal.StructField(
        'report', 0,
        0,
        ReportingApiReportSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ReportingApiObserver_OnReportAdded_Params {
  constructor() {
    /** @type { !ReportingApiReport } */
    this.report;
  }
}



mojo.internal.Struct(
    ReportingApiObserver_OnReportUpdated_ParamsSpec.$,
    'ReportingApiObserver_OnReportUpdated_Params',
    [
      mojo.internal.StructField(
        'report', 0,
        0,
        ReportingApiReportSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ReportingApiObserver_OnReportUpdated_Params {
  constructor() {
    /** @type { !ReportingApiReport } */
    this.report;
  }
}



mojo.internal.Struct(
    ReportingApiObserver_OnEndpointsUpdatedForOrigin_ParamsSpec.$,
    'ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params',
    [
      mojo.internal.StructField(
        'endpoints', 0,
        0,
        mojo.internal.Array(ReportingApiEndpointSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params {
  constructor() {
    /** @type { !Array<!ReportingApiEndpoint> } */
    this.endpoints;
  }
}

