// services/network/public/mojom/proxy_config.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/proxy_config.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_string.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"

#include "services/network/public/mojom/proxy_config.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::ProxyRulesType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::IpProtectionProxyBypassPolicy, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ProxyBypassRulesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyBypassRulesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyBypassRules_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::rules(input)) in_rules = Traits::rules(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rules)::BaseType>
          rules_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& rules_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_rules,
        rules_fragment,
        &rules_validate_params);

      fragment->rules.Set(
          rules_fragment.is_null() ? nullptr : rules_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->rules.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rules in ProxyBypassRules struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ProxyListDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyListDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyList_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::proxies(input)) in_proxies = Traits::proxies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->proxies)::BaseType>
          proxies_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& proxies_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ProxyChainDataView>, send_validation>(
        in_proxies,
        proxies_fragment,
        &proxies_validate_params);

      fragment->proxies.Set(
          proxies_fragment.is_null() ? nullptr : proxies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->proxies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxies in ProxyList struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ProxyRulesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyRulesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyRules_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bypass_rules(input)) in_bypass_rules = Traits::bypass_rules(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bypass_rules)::BaseType> bypass_rules_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ProxyBypassRulesDataView, send_validation>(
        in_bypass_rules,
        bypass_rules_fragment);

      fragment->bypass_rules.Set(
          bypass_rules_fragment.is_null() ? nullptr : bypass_rules_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bypass_rules.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bypass_rules in ProxyRules struct");

      fragment->reverse_bypass = Traits::reverse_bypass(input);

      
      mojo::internal::Serialize<::network::mojom::ProxyRulesType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::single_proxies(input)) in_single_proxies = Traits::single_proxies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->single_proxies)::BaseType> single_proxies_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ProxyListDataView, send_validation>(
        in_single_proxies,
        single_proxies_fragment);

      fragment->single_proxies.Set(
          single_proxies_fragment.is_null() ? nullptr : single_proxies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->single_proxies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null single_proxies in ProxyRules struct");

      decltype(Traits::proxies_for_http(input)) in_proxies_for_http = Traits::proxies_for_http(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->proxies_for_http)::BaseType> proxies_for_http_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ProxyListDataView, send_validation>(
        in_proxies_for_http,
        proxies_for_http_fragment);

      fragment->proxies_for_http.Set(
          proxies_for_http_fragment.is_null() ? nullptr : proxies_for_http_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->proxies_for_http.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxies_for_http in ProxyRules struct");

      decltype(Traits::proxies_for_https(input)) in_proxies_for_https = Traits::proxies_for_https(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->proxies_for_https)::BaseType> proxies_for_https_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ProxyListDataView, send_validation>(
        in_proxies_for_https,
        proxies_for_https_fragment);

      fragment->proxies_for_https.Set(
          proxies_for_https_fragment.is_null() ? nullptr : proxies_for_https_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->proxies_for_https.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxies_for_https in ProxyRules struct");

      decltype(Traits::proxies_for_ftp(input)) in_proxies_for_ftp = Traits::proxies_for_ftp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->proxies_for_ftp)::BaseType> proxies_for_ftp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ProxyListDataView, send_validation>(
        in_proxies_for_ftp,
        proxies_for_ftp_fragment);

      fragment->proxies_for_ftp.Set(
          proxies_for_ftp_fragment.is_null() ? nullptr : proxies_for_ftp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->proxies_for_ftp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxies_for_ftp in ProxyRules struct");

      decltype(Traits::fallback_proxies(input)) in_fallback_proxies = Traits::fallback_proxies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fallback_proxies)::BaseType> fallback_proxies_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ProxyListDataView, send_validation>(
        in_fallback_proxies,
        fallback_proxies_fragment);

      fragment->fallback_proxies.Set(
          fallback_proxies_fragment.is_null() ? nullptr : fallback_proxies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->fallback_proxies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fallback_proxies in ProxyRules struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ProxyConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->auto_detect = Traits::auto_detect(input);

      fragment->from_system = Traits::from_system(input);

      decltype(Traits::pac_url(input)) in_pac_url = Traits::pac_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pac_url)::BaseType> pac_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::BigStringDataView, send_validation>(
        in_pac_url,
        pac_url_fragment);

      fragment->pac_url.Set(
          pac_url_fragment.is_null() ? nullptr : pac_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pac_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pac_url in ProxyConfig struct");

      fragment->pac_mandatory = Traits::pac_mandatory(input);

      decltype(Traits::proxy_rules(input)) in_proxy_rules = Traits::proxy_rules(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->proxy_rules)::BaseType> proxy_rules_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ProxyRulesDataView, send_validation>(
        in_proxy_rules,
        proxy_rules_fragment);

      fragment->proxy_rules.Set(
          proxy_rules_fragment.is_null() ? nullptr : proxy_rules_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->proxy_rules.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxy_rules in ProxyConfig struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_MOJOM_SEND_VALIDATION_H_