// services/network/public/mojom/network_service_test.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_TEST_UTILS_H_

#include "services/network/public/mojom/network_service_test.mojom.h"


namespace network::mojom {


class  SimpleCacheEntryInterceptorForTesting : public SimpleCacheEntry {
  virtual SimpleCacheEntry* GetForwardingInterface() = 0;
  void WriteData(int32_t index, int32_t offset, const std::vector<uint8_t>& data, bool truncate, WriteDataCallback callback) override;
  void ReadData(int32_t index, int32_t offset, uint32_t length, ReadDataCallback callback) override;
  void WriteSparseData(int32_t offset, const std::vector<uint8_t>& data, WriteSparseDataCallback callback) override;
  void ReadSparseData(int32_t offset, uint32_t length, ReadSparseDataCallback callback) override;
  void Close(CloseCallback callback) override;
};
class  SimpleCacheEntryAsyncWaiter {
 public:
  explicit SimpleCacheEntryAsyncWaiter(SimpleCacheEntry* proxy);

  SimpleCacheEntryAsyncWaiter(const SimpleCacheEntryAsyncWaiter&) = delete;
  SimpleCacheEntryAsyncWaiter& operator=(const SimpleCacheEntryAsyncWaiter&) = delete;

  ~SimpleCacheEntryAsyncWaiter();
  void WriteData(
      int32_t index, int32_t offset, const std::vector<uint8_t>& data, bool truncate, int32_t* out_result);
  int32_t WriteData(int32_t index, int32_t offset, const std::vector<uint8_t>& data, bool truncate);
  void ReadData(
      int32_t index, int32_t offset, uint32_t length, std::vector<uint8_t>* out_data, int32_t* out_result);
  
  void WriteSparseData(
      int32_t offset, const std::vector<uint8_t>& data, int32_t* out_result);
  int32_t WriteSparseData(int32_t offset, const std::vector<uint8_t>& data);
  void ReadSparseData(
      int32_t offset, uint32_t length, std::vector<uint8_t>* out_data, int32_t* out_result);
  
  void Close(
      );
  

 private:
  SimpleCacheEntry* const proxy_;
};


class  SimpleCacheEntryEnumeratorInterceptorForTesting : public SimpleCacheEntryEnumerator {
  virtual SimpleCacheEntryEnumerator* GetForwardingInterface() = 0;
  void GetNext(GetNextCallback callback) override;
};
class  SimpleCacheEntryEnumeratorAsyncWaiter {
 public:
  explicit SimpleCacheEntryEnumeratorAsyncWaiter(SimpleCacheEntryEnumerator* proxy);

  SimpleCacheEntryEnumeratorAsyncWaiter(const SimpleCacheEntryEnumeratorAsyncWaiter&) = delete;
  SimpleCacheEntryEnumeratorAsyncWaiter& operator=(const SimpleCacheEntryEnumeratorAsyncWaiter&) = delete;

  ~SimpleCacheEntryEnumeratorAsyncWaiter();
  void GetNext(
      SimpleCacheOpenEntryResultPtr* out_result);
  SimpleCacheOpenEntryResultPtr GetNext();

 private:
  SimpleCacheEntryEnumerator* const proxy_;
};


class  SimpleCacheInterceptorForTesting : public SimpleCache {
  virtual SimpleCache* GetForwardingInterface() = 0;
  void CreateEntry(const std::string& key, CreateEntryCallback callback) override;
  void OpenEntry(const std::string& key, OpenEntryCallback callback) override;
  void DoomEntry(const std::string& key, DoomEntryCallback callback) override;
  void DoomAllEntries(DoomAllEntriesCallback callback) override;
  void EnumerateEntries(::mojo::PendingReceiver<SimpleCacheEntryEnumerator> receiver) override;
  void Detach(DetachCallback callback) override;
};
class  SimpleCacheAsyncWaiter {
 public:
  explicit SimpleCacheAsyncWaiter(SimpleCache* proxy);

  SimpleCacheAsyncWaiter(const SimpleCacheAsyncWaiter&) = delete;
  SimpleCacheAsyncWaiter& operator=(const SimpleCacheAsyncWaiter&) = delete;

  ~SimpleCacheAsyncWaiter();
  void CreateEntry(
      const std::string& key, ::mojo::PendingRemote<SimpleCacheEntry>* out_entry, int32_t* out_error);
  
  void OpenEntry(
      const std::string& key, ::mojo::PendingRemote<SimpleCacheEntry>* out_entry, int32_t* out_error);
  
  void DoomEntry(
      const std::string& key, int32_t* out_result);
  int32_t DoomEntry(const std::string& key);
  void DoomAllEntries(
      int32_t* out_result);
  int32_t DoomAllEntries();
  void Detach(
      );
  

 private:
  SimpleCache* const proxy_;
};


class  NetworkServiceTestInterceptorForTesting : public NetworkServiceTest {
  virtual NetworkServiceTest* GetForwardingInterface() = 0;
  void AddRules(std::vector<RulePtr> rules, AddRulesCallback callback) override;
  void SimulateNetworkChange(::network::mojom::ConnectionType type, SimulateNetworkChangeCallback callback) override;
  void SimulateNetworkQualityChange(::net::EffectiveConnectionType type, SimulateNetworkQualityChangeCallback callback) override;
  void ForceNetworkQualityEstimatorReportWifiAsSlow2G(ForceNetworkQualityEstimatorReportWifiAsSlow2GCallback callback) override;
  void SimulateCrash() override;
  void MockCertVerifierSetDefaultResult(int32_t default_result, MockCertVerifierSetDefaultResultCallback callback) override;
  void MockCertVerifierAddResultForCertAndHost(const ::scoped_refptr<::net::X509Certificate>& cert, const std::string& host_pattern, const ::net::CertVerifyResult& verify_result, int32_t rv, MockCertVerifierAddResultForCertAndHostCallback callback) override;
  void SetTransportSecurityStateTestSource(bool enable_unittest_source, SetTransportSecurityStateTestSourceCallback callback) override;
  void SetAllowNetworkAccessToHostResolutions(SetAllowNetworkAccessToHostResolutionsCallback callback) override;
  void ReplaceSystemDnsConfig(ReplaceSystemDnsConfigCallback callback) override;
  void SetTestDohConfig(::net::SecureDnsMode secure_dns_mode, const ::net::DnsOverHttpsConfig& doh_config, SetTestDohConfigCallback callback) override;
  void CrashOnResolveHost(const std::string& host) override;
  void CrashOnGetCookieList() override;
  void GetLatestMemoryPressureLevel(GetLatestMemoryPressureLevelCallback callback) override;
  void GetPeerToPeerConnectionsCountChange(GetPeerToPeerConnectionsCountChangeCallback callback) override;
  void GetEnvironmentVariableValue(const std::string& name, GetEnvironmentVariableValueCallback callback) override;
  void Log(const std::string& message, LogCallback callback) override;
  void ActivateFieldTrial(const std::string& field_trial_name) override;
  void SetSCTAuditingRetryDelay(std::optional<::base::TimeDelta> delay, SetSCTAuditingRetryDelayCallback callback) override;
  void OpenFile(const ::base::FilePath& path, OpenFileCallback callback) override;
  void EnumerateFiles(const ::base::FilePath& path, ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> factory, EnumerateFilesCallback callback) override;
  void CreateSimpleCache(::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> factory, const ::base::FilePath& path, bool reset, CreateSimpleCacheCallback callback) override;
  void MakeRequestToServer(::network::TransferableSocket s, const ::net::IPEndPoint& endpoint, MakeRequestToServerCallback callback) override;
  void ResolveOwnHostnameWithSystemDns(ResolveOwnHostnameWithSystemDnsCallback callback) override;
  void SetIPv6ProbeResult(bool success, SetIPv6ProbeResultCallback callback) override;
  void AllowsGSSAPILibraryLoad(AllowsGSSAPILibraryLoadCallback callback) override;
  void IsHappyEyeballsV3Enabled(IsHappyEyeballsV3EnabledCallback callback) override;
};
class  NetworkServiceTestAsyncWaiter {
 public:
  explicit NetworkServiceTestAsyncWaiter(NetworkServiceTest* proxy);

  NetworkServiceTestAsyncWaiter(const NetworkServiceTestAsyncWaiter&) = delete;
  NetworkServiceTestAsyncWaiter& operator=(const NetworkServiceTestAsyncWaiter&) = delete;

  ~NetworkServiceTestAsyncWaiter();
  void AddRules(
      std::vector<RulePtr> rules);
  
  void SimulateNetworkChange(
      ::network::mojom::ConnectionType type);
  
  void SimulateNetworkQualityChange(
      ::net::EffectiveConnectionType type);
  
  void ForceNetworkQualityEstimatorReportWifiAsSlow2G(
      );
  
  void MockCertVerifierSetDefaultResult(
      int32_t default_result);
  
  void MockCertVerifierAddResultForCertAndHost(
      const ::scoped_refptr<::net::X509Certificate>& cert, const std::string& host_pattern, const ::net::CertVerifyResult& verify_result, int32_t rv);
  
  void SetTransportSecurityStateTestSource(
      bool enable_unittest_source);
  
  void SetAllowNetworkAccessToHostResolutions(
      );
  
  void ReplaceSystemDnsConfig(
      );
  
  void SetTestDohConfig(
      ::net::SecureDnsMode secure_dns_mode, const ::net::DnsOverHttpsConfig& doh_config);
  
  void GetLatestMemoryPressureLevel(
      ::base::MemoryPressureLevel* out_memory_pressure_level);
  ::base::MemoryPressureLevel GetLatestMemoryPressureLevel();
  void GetPeerToPeerConnectionsCountChange(
      uint32_t* out_connection_count);
  uint32_t GetPeerToPeerConnectionsCountChange();
  void GetEnvironmentVariableValue(
      const std::string& name, std::string* out_value);
  std::string GetEnvironmentVariableValue(const std::string& name);
  void Log(
      const std::string& message);
  
  void SetSCTAuditingRetryDelay(
      std::optional<::base::TimeDelta> delay);
  
  void OpenFile(
      const ::base::FilePath& path, bool* out_result);
  bool OpenFile(const ::base::FilePath& path);
  void EnumerateFiles(
      const ::base::FilePath& path, ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> factory, std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry>* out_entries, bool* out_error);
  
  void CreateSimpleCache(
      ::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> factory, const ::base::FilePath& path, bool reset, ::mojo::PendingRemote<SimpleCache>* out_backend);
  ::mojo::PendingRemote<SimpleCache> CreateSimpleCache(::mojo::PendingRemote<::network::mojom::HttpCacheBackendFileOperationsFactory> factory, const ::base::FilePath& path, bool reset);
  void MakeRequestToServer(
      ::network::TransferableSocket s, const ::net::IPEndPoint& endpoint, bool* out_result);
  bool MakeRequestToServer(::network::TransferableSocket s, const ::net::IPEndPoint& endpoint);
  void ResolveOwnHostnameWithSystemDns(
      ::net::AddressList* out_addr_list, int32_t* out_os_error, int32_t* out_net_error);
  
  void SetIPv6ProbeResult(
      bool success);
  
  void AllowsGSSAPILibraryLoad(
      bool* out_allow_gssapi_library_load);
  bool AllowsGSSAPILibraryLoad();
  void IsHappyEyeballsV3Enabled(
      bool* out_is_happy_eyeballs_v3_enabled);
  bool IsHappyEyeballsV3Enabled();

 private:
  NetworkServiceTest* const proxy_;
};




}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_TEST_UTILS_H_