// services/network/public/mojom/network_service_test.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.ConnectionType');
goog.require('network.mojom.EffectiveConnectionType');
goog.require('mojoBase.mojom.MemoryPressureLevel');
goog.require('network.mojom.SecureDnsMode');
goog.require('network.mojom.HttpCacheBackendFileOperationsFactory');
goog.require('network.mojom.AddressList');
goog.require('network.mojom.CertVerifyResult');
goog.require('network.mojom.DnsOverHttpsConfig');
goog.require('network.mojom.FileEnumerationEntry');
goog.require('mojoBase.mojom.FilePath');
goog.require('network.mojom.IPEndPoint');
goog.require('mojoBase.mojom.TimeDelta');
goog.require('network.mojom.TransferableSocket');
goog.require('network.mojom.X509Certificate');




goog.provide('network.mojom.ResolverType');
goog.provide('network.mojom.ResolverTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.ResolverTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.ResolverType = {
  
  kResolverTypeFail: 0,
  kResolverTypeFailTimeout: 1,
  kResolverTypeSystem: 2,
  kResolverTypeIPLiteral: 3,
  kResolverTypeDirectLookup: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



goog.provide('network.mojom.SimpleCacheEntry');
goog.provide('network.mojom.SimpleCacheEntryReceiver');
goog.provide('network.mojom.SimpleCacheEntryCallbackRouter');
goog.provide('network.mojom.SimpleCacheEntryInterface');
goog.provide('network.mojom.SimpleCacheEntryRemote');
goog.provide('network.mojom.SimpleCacheEntryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.SimpleCacheEntryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.SimpleCacheEntry.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.SimpleCacheEntryInterface = class {
  
  /**
   * @param { !number } index
   * @param { !number } offset
   * @param { !Array<!number> } data
   * @param { !boolean } truncate
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  writeData(index, offset, data, truncate) {}
  
  /**
   * @param { !number } index
   * @param { !number } offset
   * @param { !number } length
   * @return {!Promise<{
        data: !Array<!number>,
        result: !number,
   *  }>}
   */

  readData(index, offset, length) {}
  
  /**
   * @param { !number } offset
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  writeSparseData(offset, data) {}
  
  /**
   * @param { !number } offset
   * @param { !number } length
   * @return {!Promise<{
        data: !Array<!number>,
        result: !number,
   *  }>}
   */

  readSparseData(offset, length) {}
  
  /**
   * @return {!Promise}
   */

  close() {}
};

/**
 * @export
 * @implements { network.mojom.SimpleCacheEntryInterface }
 */
network.mojom.SimpleCacheEntryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.SimpleCacheEntryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.SimpleCacheEntryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.SimpleCacheEntryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } index
   * @param { !number } offset
   * @param { !Array<!number> } data
   * @param { !boolean } truncate
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  writeData(
      index,
      offset,
      data,
      truncate) {
    return this.proxy.sendMessage(
        0,
        network.mojom.SimpleCacheEntry_WriteData_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_WriteData_ResponseParamsSpec.$,
        [
          index,
          offset,
          data,
          truncate
        ],
        false);
  }

  
  /**
   * @param { !number } index
   * @param { !number } offset
   * @param { !number } length
   * @return {!Promise<{
        data: !Array<!number>,
        result: !number,
   *  }>}
   */

  readData(
      index,
      offset,
      length) {
    return this.proxy.sendMessage(
        1,
        network.mojom.SimpleCacheEntry_ReadData_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_ReadData_ResponseParamsSpec.$,
        [
          index,
          offset,
          length
        ],
        false);
  }

  
  /**
   * @param { !number } offset
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  writeSparseData(
      offset,
      data) {
    return this.proxy.sendMessage(
        2,
        network.mojom.SimpleCacheEntry_WriteSparseData_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_WriteSparseData_ResponseParamsSpec.$,
        [
          offset,
          data
        ],
        false);
  }

  
  /**
   * @param { !number } offset
   * @param { !number } length
   * @return {!Promise<{
        data: !Array<!number>,
        result: !number,
   *  }>}
   */

  readSparseData(
      offset,
      length) {
    return this.proxy.sendMessage(
        3,
        network.mojom.SimpleCacheEntry_ReadSparseData_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_ReadSparseData_ResponseParamsSpec.$,
        [
          offset,
          length
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  close() {
    return this.proxy.sendMessage(
        4,
        network.mojom.SimpleCacheEntry_Close_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_Close_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SimpleCacheEntry
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.SimpleCacheEntryReceiver = class {
  /**
   * @param {!network.mojom.SimpleCacheEntryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.SimpleCacheEntryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.SimpleCacheEntryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SimpleCacheEntryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.SimpleCacheEntry_WriteData_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_WriteData_ResponseParamsSpec.$,
        impl.writeData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.SimpleCacheEntry_ReadData_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_ReadData_ResponseParamsSpec.$,
        impl.readData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.SimpleCacheEntry_WriteSparseData_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_WriteSparseData_ResponseParamsSpec.$,
        impl.writeSparseData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.SimpleCacheEntry_ReadSparseData_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_ReadSparseData_ResponseParamsSpec.$,
        impl.readSparseData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.SimpleCacheEntry_Close_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_Close_ResponseParamsSpec.$,
        impl.close.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.SimpleCacheEntry = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SimpleCacheEntry";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.SimpleCacheEntryRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.SimpleCacheEntryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SimpleCacheEntry
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.SimpleCacheEntryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.SimpleCacheEntryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SimpleCacheEntryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.SimpleCacheEntry_WriteData_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_WriteData_ResponseParamsSpec.$,
        this.writeData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.SimpleCacheEntry_ReadData_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_ReadData_ResponseParamsSpec.$,
        this.readData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeSparseData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.SimpleCacheEntry_WriteSparseData_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_WriteSparseData_ResponseParamsSpec.$,
        this.writeSparseData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readSparseData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.SimpleCacheEntry_ReadSparseData_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_ReadSparseData_ResponseParamsSpec.$,
        this.readSparseData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.SimpleCacheEntry_Close_ParamsSpec.$,
        network.mojom.SimpleCacheEntry_Close_ResponseParamsSpec.$,
        this.close.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.SimpleCacheEntryEnumerator');
goog.provide('network.mojom.SimpleCacheEntryEnumeratorReceiver');
goog.provide('network.mojom.SimpleCacheEntryEnumeratorCallbackRouter');
goog.provide('network.mojom.SimpleCacheEntryEnumeratorInterface');
goog.provide('network.mojom.SimpleCacheEntryEnumeratorRemote');
goog.provide('network.mojom.SimpleCacheEntryEnumeratorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.SimpleCacheEntryEnumeratorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.SimpleCacheEntryEnumerator.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.SimpleCacheEntryEnumeratorInterface = class {
  
  /**
   * @return {!Promise<{
        result: !network.mojom.SimpleCacheOpenEntryResult,
   *  }>}
   */

  getNext() {}
};

/**
 * @export
 * @implements { network.mojom.SimpleCacheEntryEnumeratorInterface }
 */
network.mojom.SimpleCacheEntryEnumeratorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.SimpleCacheEntryEnumeratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.SimpleCacheEntryEnumeratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.SimpleCacheEntryEnumeratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !network.mojom.SimpleCacheOpenEntryResult,
   *  }>}
   */

  getNext() {
    return this.proxy.sendMessage(
        0,
        network.mojom.SimpleCacheEntryEnumerator_GetNext_ParamsSpec.$,
        network.mojom.SimpleCacheEntryEnumerator_GetNext_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SimpleCacheEntryEnumerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.SimpleCacheEntryEnumeratorReceiver = class {
  /**
   * @param {!network.mojom.SimpleCacheEntryEnumeratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.SimpleCacheEntryEnumeratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.SimpleCacheEntryEnumeratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SimpleCacheEntryEnumeratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.SimpleCacheEntryEnumerator_GetNext_ParamsSpec.$,
        network.mojom.SimpleCacheEntryEnumerator_GetNext_ResponseParamsSpec.$,
        impl.getNext.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.SimpleCacheEntryEnumerator = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SimpleCacheEntryEnumerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.SimpleCacheEntryEnumeratorRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.SimpleCacheEntryEnumeratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SimpleCacheEntryEnumerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.SimpleCacheEntryEnumeratorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.SimpleCacheEntryEnumeratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SimpleCacheEntryEnumeratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.SimpleCacheEntryEnumerator_GetNext_ParamsSpec.$,
        network.mojom.SimpleCacheEntryEnumerator_GetNext_ResponseParamsSpec.$,
        this.getNext.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.SimpleCache');
goog.provide('network.mojom.SimpleCacheReceiver');
goog.provide('network.mojom.SimpleCacheCallbackRouter');
goog.provide('network.mojom.SimpleCacheInterface');
goog.provide('network.mojom.SimpleCacheRemote');
goog.provide('network.mojom.SimpleCachePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.SimpleCachePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.SimpleCache.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.SimpleCacheInterface = class {
  
  /**
   * @param { !string } key
   * @return {!Promise<{
        entry: ?network.mojom.SimpleCacheEntryRemote,
        error: !number,
   *  }>}
   */

  createEntry(key) {}
  
  /**
   * @param { !string } key
   * @return {!Promise<{
        entry: ?network.mojom.SimpleCacheEntryRemote,
        error: !number,
   *  }>}
   */

  openEntry(key) {}
  
  /**
   * @param { !string } key
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  doomEntry(key) {}
  
  /**
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  doomAllEntries() {}
  
  /**
   * @param { !network.mojom.SimpleCacheEntryEnumeratorPendingReceiver } receiver
   */

  enumerateEntries(receiver) {}
  
  /**
   * @return {!Promise}
   */

  detach() {}
};

/**
 * @export
 * @implements { network.mojom.SimpleCacheInterface }
 */
network.mojom.SimpleCacheRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.SimpleCachePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.SimpleCachePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.SimpleCachePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } key
   * @return {!Promise<{
        entry: ?network.mojom.SimpleCacheEntryRemote,
        error: !number,
   *  }>}
   */

  createEntry(
      key) {
    return this.proxy.sendMessage(
        0,
        network.mojom.SimpleCache_CreateEntry_ParamsSpec.$,
        network.mojom.SimpleCache_CreateEntry_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }

  
  /**
   * @param { !string } key
   * @return {!Promise<{
        entry: ?network.mojom.SimpleCacheEntryRemote,
        error: !number,
   *  }>}
   */

  openEntry(
      key) {
    return this.proxy.sendMessage(
        1,
        network.mojom.SimpleCache_OpenEntry_ParamsSpec.$,
        network.mojom.SimpleCache_OpenEntry_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }

  
  /**
   * @param { !string } key
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  doomEntry(
      key) {
    return this.proxy.sendMessage(
        2,
        network.mojom.SimpleCache_DoomEntry_ParamsSpec.$,
        network.mojom.SimpleCache_DoomEntry_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  doomAllEntries() {
    return this.proxy.sendMessage(
        3,
        network.mojom.SimpleCache_DoomAllEntries_ParamsSpec.$,
        network.mojom.SimpleCache_DoomAllEntries_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SimpleCacheEntryEnumeratorPendingReceiver } receiver
   */

  enumerateEntries(
      receiver) {
    this.proxy.sendMessage(
        4,
        network.mojom.SimpleCache_EnumerateEntries_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  detach() {
    return this.proxy.sendMessage(
        5,
        network.mojom.SimpleCache_Detach_ParamsSpec.$,
        network.mojom.SimpleCache_Detach_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SimpleCache
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.SimpleCacheReceiver = class {
  /**
   * @param {!network.mojom.SimpleCacheInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.SimpleCacheRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.SimpleCacheRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SimpleCacheRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.SimpleCache_CreateEntry_ParamsSpec.$,
        network.mojom.SimpleCache_CreateEntry_ResponseParamsSpec.$,
        impl.createEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.SimpleCache_OpenEntry_ParamsSpec.$,
        network.mojom.SimpleCache_OpenEntry_ResponseParamsSpec.$,
        impl.openEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.SimpleCache_DoomEntry_ParamsSpec.$,
        network.mojom.SimpleCache_DoomEntry_ResponseParamsSpec.$,
        impl.doomEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.SimpleCache_DoomAllEntries_ParamsSpec.$,
        network.mojom.SimpleCache_DoomAllEntries_ResponseParamsSpec.$,
        impl.doomAllEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.SimpleCache_EnumerateEntries_ParamsSpec.$,
        null,
        impl.enumerateEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.SimpleCache_Detach_ParamsSpec.$,
        network.mojom.SimpleCache_Detach_ResponseParamsSpec.$,
        impl.detach.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.SimpleCache = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SimpleCache";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.SimpleCacheRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.SimpleCacheRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SimpleCache
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.SimpleCacheCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.SimpleCacheRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SimpleCacheRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.SimpleCache_CreateEntry_ParamsSpec.$,
        network.mojom.SimpleCache_CreateEntry_ResponseParamsSpec.$,
        this.createEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.SimpleCache_OpenEntry_ParamsSpec.$,
        network.mojom.SimpleCache_OpenEntry_ResponseParamsSpec.$,
        this.openEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.doomEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.SimpleCache_DoomEntry_ParamsSpec.$,
        network.mojom.SimpleCache_DoomEntry_ResponseParamsSpec.$,
        this.doomEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.doomAllEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.SimpleCache_DoomAllEntries_ParamsSpec.$,
        network.mojom.SimpleCache_DoomAllEntries_ResponseParamsSpec.$,
        this.doomAllEntries.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.SimpleCache_EnumerateEntries_ParamsSpec.$,
        null,
        this.enumerateEntries.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detach =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.SimpleCache_Detach_ParamsSpec.$,
        network.mojom.SimpleCache_Detach_ResponseParamsSpec.$,
        this.detach.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.NetworkServiceTest');
goog.provide('network.mojom.NetworkServiceTestReceiver');
goog.provide('network.mojom.NetworkServiceTestCallbackRouter');
goog.provide('network.mojom.NetworkServiceTestInterface');
goog.provide('network.mojom.NetworkServiceTestRemote');
goog.provide('network.mojom.NetworkServiceTestPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.NetworkServiceTestPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.NetworkServiceTest.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.NetworkServiceTestInterface = class {
  
  /**
   * @param { !Array<!network.mojom.Rule> } rules
   * @return {!Promise}
   */

  addRules(rules) {}
  
  /**
   * @param { !network.mojom.ConnectionType } type
   * @return {!Promise}
   */

  simulateNetworkChange(type) {}
  
  /**
   * @param { !network.mojom.EffectiveConnectionType } type
   * @return {!Promise}
   */

  simulateNetworkQualityChange(type) {}
  
  /**
   * @return {!Promise}
   */

  forceNetworkQualityEstimatorReportWifiAsSlow2G() {}
  
  /**
   */

  simulateCrash() {}
  
  /**
   * @param { !number } defaultResult
   * @return {!Promise}
   */

  mockCertVerifierSetDefaultResult(defaultResult) {}
  
  /**
   * @param { !network.mojom.X509Certificate } cert
   * @param { !string } hostPattern
   * @param { !network.mojom.CertVerifyResult } verifyResult
   * @param { !number } rv
   * @return {!Promise}
   */

  mockCertVerifierAddResultForCertAndHost(cert, hostPattern, verifyResult, rv) {}
  
  /**
   * @param { !boolean } enableUnittestSource
   * @return {!Promise}
   */

  setTransportSecurityStateTestSource(enableUnittestSource) {}
  
  /**
   * @return {!Promise}
   */

  setAllowNetworkAccessToHostResolutions() {}
  
  /**
   * @return {!Promise}
   */

  replaceSystemDnsConfig() {}
  
  /**
   * @param { !network.mojom.SecureDnsMode } secureDnsMode
   * @param { !network.mojom.DnsOverHttpsConfig } dohConfig
   * @return {!Promise}
   */

  setTestDohConfig(secureDnsMode, dohConfig) {}
  
  /**
   * @param { !string } host
   */

  crashOnResolveHost(host) {}
  
  /**
   */

  crashOnGetCookieList() {}
  
  /**
   * @return {!Promise<{
        memoryPressureLevel: !mojoBase.mojom.MemoryPressureLevel,
   *  }>}
   */

  getLatestMemoryPressureLevel() {}
  
  /**
   * @return {!Promise<{
        connectionCount: !number,
   *  }>}
   */

  getPeerToPeerConnectionsCountChange() {}
  
  /**
   * @param { !string } name
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  getEnvironmentVariableValue(name) {}
  
  /**
   * @param { !string } message
   * @return {!Promise}
   */

  log(message) {}
  
  /**
   * @param { !string } fieldTrialName
   */

  activateFieldTrial(fieldTrialName) {}
  
  /**
   * @param { ?mojoBase.mojom.TimeDelta } delay
   * @return {!Promise}
   */

  setSCTAuditingRetryDelay(delay) {}
  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  openFile(path) {}
  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @param { !network.mojom.HttpCacheBackendFileOperationsFactoryRemote } factory
   * @return {!Promise<{
        entries: !Array<!network.mojom.FileEnumerationEntry>,
        error: !boolean,
   *  }>}
   */

  enumerateFiles(path, factory) {}
  
  /**
   * @param { !network.mojom.HttpCacheBackendFileOperationsFactoryRemote } factory
   * @param { !mojoBase.mojom.FilePath } path
   * @param { !boolean } reset
   * @return {!Promise<{
        backend: ?network.mojom.SimpleCacheRemote,
   *  }>}
   */

  createSimpleCache(factory, path, reset) {}
  
  /**
   * @param { !network.mojom.TransferableSocket } s
   * @param { !network.mojom.IPEndPoint } endpoint
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  makeRequestToServer(s, endpoint) {}
  
  /**
   * @return {!Promise<{
        addrList: !network.mojom.AddressList,
        osError: !number,
        netError: !number,
   *  }>}
   */

  resolveOwnHostnameWithSystemDns() {}
  
  /**
   * @param { !boolean } success
   * @return {!Promise}
   */

  setIPv6ProbeResult(success) {}
  
  /**
   * @return {!Promise<{
        allowGssapiLibraryLoad: !boolean,
   *  }>}
   */

  allowsGSSAPILibraryLoad() {}
  
  /**
   * @return {!Promise<{
        isHappyEyeballsV3Enabled: !boolean,
   *  }>}
   */

  isHappyEyeballsV3Enabled() {}
};

/**
 * @export
 * @implements { network.mojom.NetworkServiceTestInterface }
 */
network.mojom.NetworkServiceTestRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.NetworkServiceTestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.NetworkServiceTestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.NetworkServiceTestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!network.mojom.Rule> } rules
   * @return {!Promise}
   */

  addRules(
      rules) {
    return this.proxy.sendMessage(
        0,
        network.mojom.NetworkServiceTest_AddRules_ParamsSpec.$,
        network.mojom.NetworkServiceTest_AddRules_ResponseParamsSpec.$,
        [
          rules
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.ConnectionType } type
   * @return {!Promise}
   */

  simulateNetworkChange(
      type) {
    return this.proxy.sendMessage(
        1,
        network.mojom.NetworkServiceTest_SimulateNetworkChange_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SimulateNetworkChange_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.EffectiveConnectionType } type
   * @return {!Promise}
   */

  simulateNetworkQualityChange(
      type) {
    return this.proxy.sendMessage(
        2,
        network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  forceNetworkQualityEstimatorReportWifiAsSlow2G() {
    return this.proxy.sendMessage(
        3,
        network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ParamsSpec.$,
        network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   */

  simulateCrash() {
    this.proxy.sendMessage(
        4,
        network.mojom.NetworkServiceTest_SimulateCrash_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } defaultResult
   * @return {!Promise}
   */

  mockCertVerifierSetDefaultResult(
      defaultResult) {
    return this.proxy.sendMessage(
        5,
        network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsSpec.$,
        network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsSpec.$,
        [
          defaultResult
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.X509Certificate } cert
   * @param { !string } hostPattern
   * @param { !network.mojom.CertVerifyResult } verifyResult
   * @param { !number } rv
   * @return {!Promise}
   */

  mockCertVerifierAddResultForCertAndHost(
      cert,
      hostPattern,
      verifyResult,
      rv) {
    return this.proxy.sendMessage(
        6,
        network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsSpec.$,
        network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsSpec.$,
        [
          cert,
          hostPattern,
          verifyResult,
          rv
        ],
        false);
  }

  
  /**
   * @param { !boolean } enableUnittestSource
   * @return {!Promise}
   */

  setTransportSecurityStateTestSource(
      enableUnittestSource) {
    return this.proxy.sendMessage(
        7,
        network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParamsSpec.$,
        [
          enableUnittestSource
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  setAllowNetworkAccessToHostResolutions() {
    return this.proxy.sendMessage(
        8,
        network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  replaceSystemDnsConfig() {
    return this.proxy.sendMessage(
        9,
        network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ParamsSpec.$,
        network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SecureDnsMode } secureDnsMode
   * @param { !network.mojom.DnsOverHttpsConfig } dohConfig
   * @return {!Promise}
   */

  setTestDohConfig(
      secureDnsMode,
      dohConfig) {
    return this.proxy.sendMessage(
        10,
        network.mojom.NetworkServiceTest_SetTestDohConfig_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetTestDohConfig_ResponseParamsSpec.$,
        [
          secureDnsMode,
          dohConfig
        ],
        false);
  }

  
  /**
   * @param { !string } host
   */

  crashOnResolveHost(
      host) {
    this.proxy.sendMessage(
        11,
        network.mojom.NetworkServiceTest_CrashOnResolveHost_ParamsSpec.$,
        null,
        [
          host
        ],
        false);
  }

  
  /**
   */

  crashOnGetCookieList() {
    this.proxy.sendMessage(
        12,
        network.mojom.NetworkServiceTest_CrashOnGetCookieList_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        memoryPressureLevel: !mojoBase.mojom.MemoryPressureLevel,
   *  }>}
   */

  getLatestMemoryPressureLevel() {
    return this.proxy.sendMessage(
        13,
        network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsSpec.$,
        network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        connectionCount: !number,
   *  }>}
   */

  getPeerToPeerConnectionsCountChange() {
    return this.proxy.sendMessage(
        14,
        network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsSpec.$,
        network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @return {!Promise<{
        value: !string,
   *  }>}
   */

  getEnvironmentVariableValue(
      name) {
    return this.proxy.sendMessage(
        15,
        network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ParamsSpec.$,
        network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsSpec.$,
        [
          name
        ],
        false);
  }

  
  /**
   * @param { !string } message
   * @return {!Promise}
   */

  log(
      message) {
    return this.proxy.sendMessage(
        16,
        network.mojom.NetworkServiceTest_Log_ParamsSpec.$,
        network.mojom.NetworkServiceTest_Log_ResponseParamsSpec.$,
        [
          message
        ],
        false);
  }

  
  /**
   * @param { !string } fieldTrialName
   */

  activateFieldTrial(
      fieldTrialName) {
    this.proxy.sendMessage(
        17,
        network.mojom.NetworkServiceTest_ActivateFieldTrial_ParamsSpec.$,
        null,
        [
          fieldTrialName
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase.mojom.TimeDelta } delay
   * @return {!Promise}
   */

  setSCTAuditingRetryDelay(
      delay) {
    return this.proxy.sendMessage(
        18,
        network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsSpec.$,
        [
          delay
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  openFile(
      path) {
    return this.proxy.sendMessage(
        19,
        network.mojom.NetworkServiceTest_OpenFile_ParamsSpec.$,
        network.mojom.NetworkServiceTest_OpenFile_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } path
   * @param { !network.mojom.HttpCacheBackendFileOperationsFactoryRemote } factory
   * @return {!Promise<{
        entries: !Array<!network.mojom.FileEnumerationEntry>,
        error: !boolean,
   *  }>}
   */

  enumerateFiles(
      path,
      factory) {
    return this.proxy.sendMessage(
        20,
        network.mojom.NetworkServiceTest_EnumerateFiles_ParamsSpec.$,
        network.mojom.NetworkServiceTest_EnumerateFiles_ResponseParamsSpec.$,
        [
          path,
          factory
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.HttpCacheBackendFileOperationsFactoryRemote } factory
   * @param { !mojoBase.mojom.FilePath } path
   * @param { !boolean } reset
   * @return {!Promise<{
        backend: ?network.mojom.SimpleCacheRemote,
   *  }>}
   */

  createSimpleCache(
      factory,
      path,
      reset) {
    return this.proxy.sendMessage(
        21,
        network.mojom.NetworkServiceTest_CreateSimpleCache_ParamsSpec.$,
        network.mojom.NetworkServiceTest_CreateSimpleCache_ResponseParamsSpec.$,
        [
          factory,
          path,
          reset
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.TransferableSocket } s
   * @param { !network.mojom.IPEndPoint } endpoint
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  makeRequestToServer(
      s,
      endpoint) {
    return this.proxy.sendMessage(
        22,
        network.mojom.NetworkServiceTest_MakeRequestToServer_ParamsSpec.$,
        network.mojom.NetworkServiceTest_MakeRequestToServer_ResponseParamsSpec.$,
        [
          s,
          endpoint
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        addrList: !network.mojom.AddressList,
        osError: !number,
        netError: !number,
   *  }>}
   */

  resolveOwnHostnameWithSystemDns() {
    return this.proxy.sendMessage(
        23,
        network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ParamsSpec.$,
        network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } success
   * @return {!Promise}
   */

  setIPv6ProbeResult(
      success) {
    return this.proxy.sendMessage(
        24,
        network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ResponseParamsSpec.$,
        [
          success
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        allowGssapiLibraryLoad: !boolean,
   *  }>}
   */

  allowsGSSAPILibraryLoad() {
    return this.proxy.sendMessage(
        25,
        network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ParamsSpec.$,
        network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        isHappyEyeballsV3Enabled: !boolean,
   *  }>}
   */

  isHappyEyeballsV3Enabled() {
    return this.proxy.sendMessage(
        26,
        network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ParamsSpec.$,
        network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NetworkServiceTest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.NetworkServiceTestReceiver = class {
  /**
   * @param {!network.mojom.NetworkServiceTestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.NetworkServiceTestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.NetworkServiceTestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.NetworkServiceTestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.NetworkServiceTest_AddRules_ParamsSpec.$,
        network.mojom.NetworkServiceTest_AddRules_ResponseParamsSpec.$,
        impl.addRules.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.NetworkServiceTest_SimulateNetworkChange_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SimulateNetworkChange_ResponseParamsSpec.$,
        impl.simulateNetworkChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsSpec.$,
        impl.simulateNetworkQualityChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ParamsSpec.$,
        network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParamsSpec.$,
        impl.forceNetworkQualityEstimatorReportWifiAsSlow2G.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.NetworkServiceTest_SimulateCrash_ParamsSpec.$,
        null,
        impl.simulateCrash.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsSpec.$,
        network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsSpec.$,
        impl.mockCertVerifierSetDefaultResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsSpec.$,
        network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsSpec.$,
        impl.mockCertVerifierAddResultForCertAndHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParamsSpec.$,
        impl.setTransportSecurityStateTestSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsSpec.$,
        impl.setAllowNetworkAccessToHostResolutions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ParamsSpec.$,
        network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsSpec.$,
        impl.replaceSystemDnsConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        network.mojom.NetworkServiceTest_SetTestDohConfig_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetTestDohConfig_ResponseParamsSpec.$,
        impl.setTestDohConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        network.mojom.NetworkServiceTest_CrashOnResolveHost_ParamsSpec.$,
        null,
        impl.crashOnResolveHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        network.mojom.NetworkServiceTest_CrashOnGetCookieList_ParamsSpec.$,
        null,
        impl.crashOnGetCookieList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsSpec.$,
        network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsSpec.$,
        impl.getLatestMemoryPressureLevel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsSpec.$,
        network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsSpec.$,
        impl.getPeerToPeerConnectionsCountChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ParamsSpec.$,
        network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsSpec.$,
        impl.getEnvironmentVariableValue.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        network.mojom.NetworkServiceTest_Log_ParamsSpec.$,
        network.mojom.NetworkServiceTest_Log_ResponseParamsSpec.$,
        impl.log.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        network.mojom.NetworkServiceTest_ActivateFieldTrial_ParamsSpec.$,
        null,
        impl.activateFieldTrial.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsSpec.$,
        impl.setSCTAuditingRetryDelay.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        network.mojom.NetworkServiceTest_OpenFile_ParamsSpec.$,
        network.mojom.NetworkServiceTest_OpenFile_ResponseParamsSpec.$,
        impl.openFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        network.mojom.NetworkServiceTest_EnumerateFiles_ParamsSpec.$,
        network.mojom.NetworkServiceTest_EnumerateFiles_ResponseParamsSpec.$,
        impl.enumerateFiles.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        network.mojom.NetworkServiceTest_CreateSimpleCache_ParamsSpec.$,
        network.mojom.NetworkServiceTest_CreateSimpleCache_ResponseParamsSpec.$,
        impl.createSimpleCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        network.mojom.NetworkServiceTest_MakeRequestToServer_ParamsSpec.$,
        network.mojom.NetworkServiceTest_MakeRequestToServer_ResponseParamsSpec.$,
        impl.makeRequestToServer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ParamsSpec.$,
        network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParamsSpec.$,
        impl.resolveOwnHostnameWithSystemDns.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ResponseParamsSpec.$,
        impl.setIPv6ProbeResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ParamsSpec.$,
        network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsSpec.$,
        impl.allowsGSSAPILibraryLoad.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ParamsSpec.$,
        network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParamsSpec.$,
        impl.isHappyEyeballsV3Enabled.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.NetworkServiceTest = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkServiceTest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.NetworkServiceTestRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.NetworkServiceTestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NetworkServiceTest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.NetworkServiceTestCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.NetworkServiceTestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.NetworkServiceTestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addRules =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.NetworkServiceTest_AddRules_ParamsSpec.$,
        network.mojom.NetworkServiceTest_AddRules_ResponseParamsSpec.$,
        this.addRules.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateNetworkChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.NetworkServiceTest_SimulateNetworkChange_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SimulateNetworkChange_ResponseParamsSpec.$,
        this.simulateNetworkChange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateNetworkQualityChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsSpec.$,
        this.simulateNetworkQualityChange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forceNetworkQualityEstimatorReportWifiAsSlow2G =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ParamsSpec.$,
        network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParamsSpec.$,
        this.forceNetworkQualityEstimatorReportWifiAsSlow2G.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.simulateCrash =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.NetworkServiceTest_SimulateCrash_ParamsSpec.$,
        null,
        this.simulateCrash.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mockCertVerifierSetDefaultResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsSpec.$,
        network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsSpec.$,
        this.mockCertVerifierSetDefaultResult.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mockCertVerifierAddResultForCertAndHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsSpec.$,
        network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsSpec.$,
        this.mockCertVerifierAddResultForCertAndHost.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTransportSecurityStateTestSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParamsSpec.$,
        this.setTransportSecurityStateTestSource.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAllowNetworkAccessToHostResolutions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsSpec.$,
        this.setAllowNetworkAccessToHostResolutions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replaceSystemDnsConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ParamsSpec.$,
        network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsSpec.$,
        this.replaceSystemDnsConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTestDohConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        network.mojom.NetworkServiceTest_SetTestDohConfig_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetTestDohConfig_ResponseParamsSpec.$,
        this.setTestDohConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.crashOnResolveHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        network.mojom.NetworkServiceTest_CrashOnResolveHost_ParamsSpec.$,
        null,
        this.crashOnResolveHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.crashOnGetCookieList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        network.mojom.NetworkServiceTest_CrashOnGetCookieList_ParamsSpec.$,
        null,
        this.crashOnGetCookieList.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getLatestMemoryPressureLevel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsSpec.$,
        network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsSpec.$,
        this.getLatestMemoryPressureLevel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPeerToPeerConnectionsCountChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsSpec.$,
        network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsSpec.$,
        this.getPeerToPeerConnectionsCountChange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getEnvironmentVariableValue =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ParamsSpec.$,
        network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsSpec.$,
        this.getEnvironmentVariableValue.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.log =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        network.mojom.NetworkServiceTest_Log_ParamsSpec.$,
        network.mojom.NetworkServiceTest_Log_ResponseParamsSpec.$,
        this.log.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.activateFieldTrial =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        network.mojom.NetworkServiceTest_ActivateFieldTrial_ParamsSpec.$,
        null,
        this.activateFieldTrial.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSCTAuditingRetryDelay =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsSpec.$,
        this.setSCTAuditingRetryDelay.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        network.mojom.NetworkServiceTest_OpenFile_ParamsSpec.$,
        network.mojom.NetworkServiceTest_OpenFile_ResponseParamsSpec.$,
        this.openFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateFiles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        network.mojom.NetworkServiceTest_EnumerateFiles_ParamsSpec.$,
        network.mojom.NetworkServiceTest_EnumerateFiles_ResponseParamsSpec.$,
        this.enumerateFiles.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSimpleCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        network.mojom.NetworkServiceTest_CreateSimpleCache_ParamsSpec.$,
        network.mojom.NetworkServiceTest_CreateSimpleCache_ResponseParamsSpec.$,
        this.createSimpleCache.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.makeRequestToServer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        network.mojom.NetworkServiceTest_MakeRequestToServer_ParamsSpec.$,
        network.mojom.NetworkServiceTest_MakeRequestToServer_ResponseParamsSpec.$,
        this.makeRequestToServer.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveOwnHostnameWithSystemDns =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ParamsSpec.$,
        network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParamsSpec.$,
        this.resolveOwnHostnameWithSystemDns.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIPv6ProbeResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ParamsSpec.$,
        network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ResponseParamsSpec.$,
        this.setIPv6ProbeResult.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.allowsGSSAPILibraryLoad =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ParamsSpec.$,
        network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsSpec.$,
        this.allowsGSSAPILibraryLoad.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isHappyEyeballsV3Enabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ParamsSpec.$,
        network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParamsSpec.$,
        this.isHappyEyeballsV3Enabled.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.RuleSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.RuleSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheOpenEntryResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheOpenEntryResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheEntry_WriteData_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheEntry_WriteData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheEntry_WriteData_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheEntry_WriteData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheEntry_ReadData_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheEntry_ReadData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheEntry_ReadData_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheEntry_ReadData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheEntry_WriteSparseData_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheEntry_WriteSparseData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheEntry_WriteSparseData_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheEntry_WriteSparseData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheEntry_ReadSparseData_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheEntry_ReadSparseData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheEntry_ReadSparseData_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheEntry_ReadSparseData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheEntry_Close_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheEntry_Close_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheEntry_Close_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheEntry_Close_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheEntryEnumerator_GetNext_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheEntryEnumerator_GetNext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCacheEntryEnumerator_GetNext_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCacheEntryEnumerator_GetNext_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCache_CreateEntry_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCache_CreateEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCache_CreateEntry_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCache_CreateEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCache_OpenEntry_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCache_OpenEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCache_OpenEntry_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCache_OpenEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCache_DoomEntry_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCache_DoomEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCache_DoomEntry_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCache_DoomEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCache_DoomAllEntries_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCache_DoomAllEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCache_DoomAllEntries_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCache_DoomAllEntries_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCache_EnumerateEntries_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCache_EnumerateEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCache_Detach_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCache_Detach_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SimpleCache_Detach_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SimpleCache_Detach_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_AddRules_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_AddRules_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_AddRules_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_AddRules_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SimulateNetworkChange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SimulateNetworkChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SimulateNetworkChange_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SimulateNetworkChange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SimulateCrash_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SimulateCrash_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SetTestDohConfig_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SetTestDohConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SetTestDohConfig_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SetTestDohConfig_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_CrashOnResolveHost_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_CrashOnResolveHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_CrashOnGetCookieList_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_CrashOnGetCookieList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_Log_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_Log_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_Log_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_Log_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_ActivateFieldTrial_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_ActivateFieldTrial_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_OpenFile_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_OpenFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_OpenFile_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_OpenFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_EnumerateFiles_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_EnumerateFiles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_EnumerateFiles_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_EnumerateFiles_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_CreateSimpleCache_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_CreateSimpleCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_CreateSimpleCache_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_CreateSimpleCache_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_MakeRequestToServer_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_MakeRequestToServer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_MakeRequestToServer_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_MakeRequestToServer_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.RuleSpec.$,
    'Rule',
    [
      mojo.internal.StructField(
        'resolverType', 0,
        0,
        network.mojom.ResolverTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostPattern', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'replacement', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostResolverFlags', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dnsAliases', 24,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.Rule');

/** @record */
network.mojom.Rule = class {
  constructor() {
    /** @export { !network.mojom.ResolverType } */
    this.resolverType;
    /** @export { !string } */
    this.hostPattern;
    /** @export { !string } */
    this.replacement;
    /** @export { !number } */
    this.hostResolverFlags;
    /** @export { !Array<!string> } */
    this.dnsAliases;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheOpenEntryResultSpec.$,
    'SimpleCacheOpenEntryResult',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'key', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'entry', 16,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SimpleCacheEntryRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.SimpleCacheOpenEntryResult');

/** @record */
network.mojom.SimpleCacheOpenEntryResult = class {
  constructor() {
    /** @export { !number } */
    this.error;
    /** @export { !string } */
    this.key;
    /** @export { (network.mojom.SimpleCacheEntryRemote|undefined) } */
    this.entry;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheEntry_WriteData_ParamsSpec.$,
    'SimpleCacheEntry_WriteData_Params',
    [
      mojo.internal.StructField(
        'index', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'offset', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'truncate', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.SimpleCacheEntry_WriteData_Params');

/** @record */
network.mojom.SimpleCacheEntry_WriteData_Params = class {
  constructor() {
    /** @export { !number } */
    this.index;
    /** @export { !number } */
    this.offset;
    /** @export { !Array<!number> } */
    this.data;
    /** @export { !boolean } */
    this.truncate;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheEntry_WriteData_ResponseParamsSpec.$,
    'SimpleCacheEntry_WriteData_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SimpleCacheEntry_WriteData_ResponseParams');

/** @record */
network.mojom.SimpleCacheEntry_WriteData_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheEntry_ReadData_ParamsSpec.$,
    'SimpleCacheEntry_ReadData_Params',
    [
      mojo.internal.StructField(
        'index', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'offset', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'length', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.SimpleCacheEntry_ReadData_Params');

/** @record */
network.mojom.SimpleCacheEntry_ReadData_Params = class {
  constructor() {
    /** @export { !number } */
    this.index;
    /** @export { !number } */
    this.offset;
    /** @export { !number } */
    this.length;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheEntry_ReadData_ResponseParamsSpec.$,
    'SimpleCacheEntry_ReadData_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.SimpleCacheEntry_ReadData_ResponseParams');

/** @record */
network.mojom.SimpleCacheEntry_ReadData_ResponseParams = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.data;
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheEntry_WriteSparseData_ParamsSpec.$,
    'SimpleCacheEntry_WriteSparseData_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.SimpleCacheEntry_WriteSparseData_Params');

/** @record */
network.mojom.SimpleCacheEntry_WriteSparseData_Params = class {
  constructor() {
    /** @export { !number } */
    this.offset;
    /** @export { !Array<!number> } */
    this.data;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheEntry_WriteSparseData_ResponseParamsSpec.$,
    'SimpleCacheEntry_WriteSparseData_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SimpleCacheEntry_WriteSparseData_ResponseParams');

/** @record */
network.mojom.SimpleCacheEntry_WriteSparseData_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheEntry_ReadSparseData_ParamsSpec.$,
    'SimpleCacheEntry_ReadSparseData_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'length', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SimpleCacheEntry_ReadSparseData_Params');

/** @record */
network.mojom.SimpleCacheEntry_ReadSparseData_Params = class {
  constructor() {
    /** @export { !number } */
    this.offset;
    /** @export { !number } */
    this.length;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheEntry_ReadSparseData_ResponseParamsSpec.$,
    'SimpleCacheEntry_ReadSparseData_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.SimpleCacheEntry_ReadSparseData_ResponseParams');

/** @record */
network.mojom.SimpleCacheEntry_ReadSparseData_ResponseParams = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.data;
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheEntry_Close_ParamsSpec.$,
    'SimpleCacheEntry_Close_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.SimpleCacheEntry_Close_Params');

/** @record */
network.mojom.SimpleCacheEntry_Close_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheEntry_Close_ResponseParamsSpec.$,
    'SimpleCacheEntry_Close_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.SimpleCacheEntry_Close_ResponseParams');

/** @record */
network.mojom.SimpleCacheEntry_Close_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheEntryEnumerator_GetNext_ParamsSpec.$,
    'SimpleCacheEntryEnumerator_GetNext_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.SimpleCacheEntryEnumerator_GetNext_Params');

/** @record */
network.mojom.SimpleCacheEntryEnumerator_GetNext_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCacheEntryEnumerator_GetNext_ResponseParamsSpec.$,
    'SimpleCacheEntryEnumerator_GetNext_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        network.mojom.SimpleCacheOpenEntryResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SimpleCacheEntryEnumerator_GetNext_ResponseParams');

/** @record */
network.mojom.SimpleCacheEntryEnumerator_GetNext_ResponseParams = class {
  constructor() {
    /** @export { !network.mojom.SimpleCacheOpenEntryResult } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCache_CreateEntry_ParamsSpec.$,
    'SimpleCache_CreateEntry_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SimpleCache_CreateEntry_Params');

/** @record */
network.mojom.SimpleCache_CreateEntry_Params = class {
  constructor() {
    /** @export { !string } */
    this.key;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCache_CreateEntry_ResponseParamsSpec.$,
    'SimpleCache_CreateEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'entry', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SimpleCacheEntryRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.SimpleCache_CreateEntry_ResponseParams');

/** @record */
network.mojom.SimpleCache_CreateEntry_ResponseParams = class {
  constructor() {
    /** @export { (network.mojom.SimpleCacheEntryRemote|undefined) } */
    this.entry;
    /** @export { !number } */
    this.error;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCache_OpenEntry_ParamsSpec.$,
    'SimpleCache_OpenEntry_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SimpleCache_OpenEntry_Params');

/** @record */
network.mojom.SimpleCache_OpenEntry_Params = class {
  constructor() {
    /** @export { !string } */
    this.key;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCache_OpenEntry_ResponseParamsSpec.$,
    'SimpleCache_OpenEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'entry', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SimpleCacheEntryRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.SimpleCache_OpenEntry_ResponseParams');

/** @record */
network.mojom.SimpleCache_OpenEntry_ResponseParams = class {
  constructor() {
    /** @export { (network.mojom.SimpleCacheEntryRemote|undefined) } */
    this.entry;
    /** @export { !number } */
    this.error;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCache_DoomEntry_ParamsSpec.$,
    'SimpleCache_DoomEntry_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SimpleCache_DoomEntry_Params');

/** @record */
network.mojom.SimpleCache_DoomEntry_Params = class {
  constructor() {
    /** @export { !string } */
    this.key;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCache_DoomEntry_ResponseParamsSpec.$,
    'SimpleCache_DoomEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SimpleCache_DoomEntry_ResponseParams');

/** @record */
network.mojom.SimpleCache_DoomEntry_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCache_DoomAllEntries_ParamsSpec.$,
    'SimpleCache_DoomAllEntries_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.SimpleCache_DoomAllEntries_Params');

/** @record */
network.mojom.SimpleCache_DoomAllEntries_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCache_DoomAllEntries_ResponseParamsSpec.$,
    'SimpleCache_DoomAllEntries_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SimpleCache_DoomAllEntries_ResponseParams');

/** @record */
network.mojom.SimpleCache_DoomAllEntries_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCache_EnumerateEntries_ParamsSpec.$,
    'SimpleCache_EnumerateEntries_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.SimpleCacheEntryEnumeratorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SimpleCache_EnumerateEntries_Params');

/** @record */
network.mojom.SimpleCache_EnumerateEntries_Params = class {
  constructor() {
    /** @export { !network.mojom.SimpleCacheEntryEnumeratorPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCache_Detach_ParamsSpec.$,
    'SimpleCache_Detach_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.SimpleCache_Detach_Params');

/** @record */
network.mojom.SimpleCache_Detach_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.SimpleCache_Detach_ResponseParamsSpec.$,
    'SimpleCache_Detach_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.SimpleCache_Detach_ResponseParams');

/** @record */
network.mojom.SimpleCache_Detach_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_AddRules_ParamsSpec.$,
    'NetworkServiceTest_AddRules_Params',
    [
      mojo.internal.StructField(
        'rules', 0,
        0,
        mojo.internal.Array(network.mojom.RuleSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_AddRules_Params');

/** @record */
network.mojom.NetworkServiceTest_AddRules_Params = class {
  constructor() {
    /** @export { !Array<!network.mojom.Rule> } */
    this.rules;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_AddRules_ResponseParamsSpec.$,
    'NetworkServiceTest_AddRules_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_AddRules_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_AddRules_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SimulateNetworkChange_ParamsSpec.$,
    'NetworkServiceTest_SimulateNetworkChange_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        network.mojom.ConnectionTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_SimulateNetworkChange_Params');

/** @record */
network.mojom.NetworkServiceTest_SimulateNetworkChange_Params = class {
  constructor() {
    /** @export { !network.mojom.ConnectionType } */
    this.type;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SimulateNetworkChange_ResponseParamsSpec.$,
    'NetworkServiceTest_SimulateNetworkChange_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_SimulateNetworkChange_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_SimulateNetworkChange_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ParamsSpec.$,
    'NetworkServiceTest_SimulateNetworkQualityChange_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        network.mojom.EffectiveConnectionTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_Params');

/** @record */
network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_Params = class {
  constructor() {
    /** @export { !network.mojom.EffectiveConnectionType } */
    this.type;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ResponseParamsSpec.$,
    'NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_SimulateNetworkQualityChange_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ParamsSpec.$,
    'NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params');

/** @record */
network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParamsSpec.$,
    'NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_ForceNetworkQualityEstimatorReportWifiAsSlow2G_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SimulateCrash_ParamsSpec.$,
    'NetworkServiceTest_SimulateCrash_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_SimulateCrash_Params');

/** @record */
network.mojom.NetworkServiceTest_SimulateCrash_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ParamsSpec.$,
    'NetworkServiceTest_MockCertVerifierSetDefaultResult_Params',
    [
      mojo.internal.StructField(
        'defaultResult', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_Params');

/** @record */
network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_Params = class {
  constructor() {
    /** @export { !number } */
    this.defaultResult;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParamsSpec.$,
    'NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_MockCertVerifierSetDefaultResult_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ParamsSpec.$,
    'NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params',
    [
      mojo.internal.StructField(
        'cert', 0,
        0,
        network.mojom.X509CertificateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostPattern', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'verifyResult', 16,
        0,
        network.mojom.CertVerifyResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rv', 24,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params');

/** @record */
network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_Params = class {
  constructor() {
    /** @export { !network.mojom.X509Certificate } */
    this.cert;
    /** @export { !string } */
    this.hostPattern;
    /** @export { !network.mojom.CertVerifyResult } */
    this.verifyResult;
    /** @export { !number } */
    this.rv;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParamsSpec.$,
    'NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_MockCertVerifierAddResultForCertAndHost_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ParamsSpec.$,
    'NetworkServiceTest_SetTransportSecurityStateTestSource_Params',
    [
      mojo.internal.StructField(
        'enableUnittestSource', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_Params');

/** @record */
network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enableUnittestSource;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParamsSpec.$,
    'NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_SetTransportSecurityStateTestSource_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ParamsSpec.$,
    'NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params');

/** @record */
network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParamsSpec.$,
    'NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_SetAllowNetworkAccessToHostResolutions_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ParamsSpec.$,
    'NetworkServiceTest_ReplaceSystemDnsConfig_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_Params');

/** @record */
network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParamsSpec.$,
    'NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_ReplaceSystemDnsConfig_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SetTestDohConfig_ParamsSpec.$,
    'NetworkServiceTest_SetTestDohConfig_Params',
    [
      mojo.internal.StructField(
        'secureDnsMode', 0,
        0,
        network.mojom.SecureDnsModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dohConfig', 8,
        0,
        network.mojom.DnsOverHttpsConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkServiceTest_SetTestDohConfig_Params');

/** @record */
network.mojom.NetworkServiceTest_SetTestDohConfig_Params = class {
  constructor() {
    /** @export { !network.mojom.SecureDnsMode } */
    this.secureDnsMode;
    /** @export { !network.mojom.DnsOverHttpsConfig } */
    this.dohConfig;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SetTestDohConfig_ResponseParamsSpec.$,
    'NetworkServiceTest_SetTestDohConfig_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_SetTestDohConfig_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_SetTestDohConfig_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_CrashOnResolveHost_ParamsSpec.$,
    'NetworkServiceTest_CrashOnResolveHost_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_CrashOnResolveHost_Params');

/** @record */
network.mojom.NetworkServiceTest_CrashOnResolveHost_Params = class {
  constructor() {
    /** @export { !string } */
    this.host;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_CrashOnGetCookieList_ParamsSpec.$,
    'NetworkServiceTest_CrashOnGetCookieList_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_CrashOnGetCookieList_Params');

/** @record */
network.mojom.NetworkServiceTest_CrashOnGetCookieList_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ParamsSpec.$,
    'NetworkServiceTest_GetLatestMemoryPressureLevel_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_Params');

/** @record */
network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParamsSpec.$,
    'NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams',
    [
      mojo.internal.StructField(
        'memoryPressureLevel', 0,
        0,
        mojoBase.mojom.MemoryPressureLevelSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_GetLatestMemoryPressureLevel_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.MemoryPressureLevel } */
    this.memoryPressureLevel;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ParamsSpec.$,
    'NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params');

/** @record */
network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParamsSpec.$,
    'NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams',
    [
      mojo.internal.StructField(
        'connectionCount', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_GetPeerToPeerConnectionsCountChange_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.connectionCount;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ParamsSpec.$,
    'NetworkServiceTest_GetEnvironmentVariableValue_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_Params');

/** @record */
network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_Params = class {
  constructor() {
    /** @export { !string } */
    this.name;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ResponseParamsSpec.$,
    'NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_GetEnvironmentVariableValue_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_Log_ParamsSpec.$,
    'NetworkServiceTest_Log_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_Log_Params');

/** @record */
network.mojom.NetworkServiceTest_Log_Params = class {
  constructor() {
    /** @export { !string } */
    this.message;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_Log_ResponseParamsSpec.$,
    'NetworkServiceTest_Log_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_Log_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_Log_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_ActivateFieldTrial_ParamsSpec.$,
    'NetworkServiceTest_ActivateFieldTrial_Params',
    [
      mojo.internal.StructField(
        'fieldTrialName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_ActivateFieldTrial_Params');

/** @record */
network.mojom.NetworkServiceTest_ActivateFieldTrial_Params = class {
  constructor() {
    /** @export { !string } */
    this.fieldTrialName;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ParamsSpec.$,
    'NetworkServiceTest_SetSCTAuditingRetryDelay_Params',
    [
      mojo.internal.StructField(
        'delay', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_Params');

/** @record */
network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_Params = class {
  constructor() {
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.delay;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParamsSpec.$,
    'NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_SetSCTAuditingRetryDelay_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_OpenFile_ParamsSpec.$,
    'NetworkServiceTest_OpenFile_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_OpenFile_Params');

/** @record */
network.mojom.NetworkServiceTest_OpenFile_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_OpenFile_ResponseParamsSpec.$,
    'NetworkServiceTest_OpenFile_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_OpenFile_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_OpenFile_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_EnumerateFiles_ParamsSpec.$,
    'NetworkServiceTest_EnumerateFiles_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'factory', 8,
        0,
        mojo.internal.InterfaceProxy(network.mojom.HttpCacheBackendFileOperationsFactoryRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkServiceTest_EnumerateFiles_Params');

/** @record */
network.mojom.NetworkServiceTest_EnumerateFiles_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
    /** @export { !network.mojom.HttpCacheBackendFileOperationsFactoryRemote } */
    this.factory;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_EnumerateFiles_ResponseParamsSpec.$,
    'NetworkServiceTest_EnumerateFiles_ResponseParams',
    [
      mojo.internal.StructField(
        'entries', 0,
        0,
        mojo.internal.Array(network.mojom.FileEnumerationEntrySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkServiceTest_EnumerateFiles_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_EnumerateFiles_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.FileEnumerationEntry> } */
    this.entries;
    /** @export { !boolean } */
    this.error;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_CreateSimpleCache_ParamsSpec.$,
    'NetworkServiceTest_CreateSimpleCache_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.HttpCacheBackendFileOperationsFactoryRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'path', 8,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reset', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.NetworkServiceTest_CreateSimpleCache_Params');

/** @record */
network.mojom.NetworkServiceTest_CreateSimpleCache_Params = class {
  constructor() {
    /** @export { !network.mojom.HttpCacheBackendFileOperationsFactoryRemote } */
    this.factory;
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
    /** @export { !boolean } */
    this.reset;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_CreateSimpleCache_ResponseParamsSpec.$,
    'NetworkServiceTest_CreateSimpleCache_ResponseParams',
    [
      mojo.internal.StructField(
        'backend', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SimpleCacheRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_CreateSimpleCache_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_CreateSimpleCache_ResponseParams = class {
  constructor() {
    /** @export { (network.mojom.SimpleCacheRemote|undefined) } */
    this.backend;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_MakeRequestToServer_ParamsSpec.$,
    'NetworkServiceTest_MakeRequestToServer_Params',
    [
      mojo.internal.StructField(
        's', 0,
        0,
        network.mojom.TransferableSocketSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endpoint', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkServiceTest_MakeRequestToServer_Params');

/** @record */
network.mojom.NetworkServiceTest_MakeRequestToServer_Params = class {
  constructor() {
    /** @export { !network.mojom.TransferableSocket } */
    this.s;
    /** @export { !network.mojom.IPEndPoint } */
    this.endpoint;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_MakeRequestToServer_ResponseParamsSpec.$,
    'NetworkServiceTest_MakeRequestToServer_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_MakeRequestToServer_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_MakeRequestToServer_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ParamsSpec.$,
    'NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params');

/** @record */
network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParamsSpec.$,
    'NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams',
    [
      mojo.internal.StructField(
        'addrList', 0,
        0,
        network.mojom.AddressListSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'osError', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'netError', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_ResolveOwnHostnameWithSystemDns_ResponseParams = class {
  constructor() {
    /** @export { !network.mojom.AddressList } */
    this.addrList;
    /** @export { !number } */
    this.osError;
    /** @export { !number } */
    this.netError;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ParamsSpec.$,
    'NetworkServiceTest_SetIPv6ProbeResult_Params',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_SetIPv6ProbeResult_Params');

/** @record */
network.mojom.NetworkServiceTest_SetIPv6ProbeResult_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ResponseParamsSpec.$,
    'NetworkServiceTest_SetIPv6ProbeResult_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_SetIPv6ProbeResult_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ParamsSpec.$,
    'NetworkServiceTest_AllowsGSSAPILibraryLoad_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_Params');

/** @record */
network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParamsSpec.$,
    'NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams',
    [
      mojo.internal.StructField(
        'allowGssapiLibraryLoad', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_AllowsGSSAPILibraryLoad_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.allowGssapiLibraryLoad;
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ParamsSpec.$,
    'NetworkServiceTest_IsHappyEyeballsV3Enabled_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_Params');

/** @record */
network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParamsSpec.$,
    'NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams',
    [
      mojo.internal.StructField(
        'isHappyEyeballsV3Enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams');

/** @record */
network.mojom.NetworkServiceTest_IsHappyEyeballsV3Enabled_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.isHappyEyeballsV3Enabled;
  }
};

