// services/network/public/mojom/network_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_service.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_service.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_service.mojom-forward.h"  // IWYU pragma: export
#include "components/content_settings/core/common/content_settings.mojom.h"
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "services/network/public/mojom/client_security_state.mojom-forward.h"
#include "services/network/public/mojom/first_party_sets.mojom.h"
#include "services/network/public/mojom/host_resolver.mojom.h"
#include "services/network/public/mojom/http_raw_headers.mojom-forward.h"
#include "services/network/public/mojom/ip_address_space.mojom-forward.h"
#include "services/network/public/mojom/key_pinning.mojom-forward.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.h"
#include "services/network/public/mojom/net_log.mojom.h"
#include "services/network/public/mojom/network_annotation_monitor.mojom-forward.h"
#include "services/network/public/mojom/network_change_manager.mojom-forward.h"
#include "services/network/public/mojom/network_context.mojom-forward.h"
#include "services/network/public/mojom/network_interface.mojom.h"
#include "services/network/public/mojom/network_interface_change_listener.mojom-forward.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/network_quality_estimator_manager.mojom-forward.h"
#include "services/network/public/mojom/network_service_test.mojom-forward.h"
#include "services/network/public/mojom/parsed_headers.mojom-forward.h"
#include "services/network/public/mojom/proxy_config.mojom-forward.h"
#include "services/network/public/mojom/schemeful_site.mojom-forward.h"
#include "services/network/public/mojom/source_type.mojom.h"
#include "services/network/public/mojom/system_dns_resolution.mojom-forward.h"
#include "services/network/public/mojom/trust_tokens.mojom-forward.h"
#include "services/network/public/mojom/url_loader.mojom-forward.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-forward.h"
#include "services/network/public/mojom/url_response_head.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include "services/network/public/mojom/ct_log_info.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace network::mojom {

class NetworkServiceProxy;

template <typename ImplRefTraits>
class NetworkServiceStub;

class NetworkServiceRequestValidator;
class NetworkServiceResponseValidator;


class NetworkService
    : public NetworkServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.NetworkService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kNetwork;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetworkServiceInterfaceBase;
  using Proxy_ = NetworkServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkServiceStub<ImplRefTraits>;

  using RequestValidator_ = NetworkServiceRequestValidator;
  using ResponseValidator_ = NetworkServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetParamsMinVersion = 0,
    kStartNetLogMinVersion = 0,
    kAttachNetLogProxyMinVersion = 0,
    kSetSSLKeyLogFileMinVersion = 0,
    kCreateNetworkContextMinVersion = 0,
    kConfigureStubHostResolverMinVersion = 0,
    kDisableQuicMinVersion = 0,
    kSetUpHttpAuthMinVersion = 0,
    kConfigureHttpAuthPrefsMinVersion = 0,
    kSetRawHeadersAccessMinVersion = 0,
    kSetMaxConnectionsPerProxyChainMinVersion = 0,
    kGetNetworkChangeManagerMinVersion = 0,
    kGetNetworkQualityEstimatorManagerMinVersion = 0,
    kGetDnsConfigChangeManagerMinVersion = 0,
    kGetNetworkListMinVersion = 0,
    kOnTrustStoreChangedMinVersion = 0,
    kOnClientCertStoreChangedMinVersion = 0,
    kSetEncryptionKeyMinVersion = 0,
    kOnMemoryPressureMinVersion = 0,
    kOnPeerToPeerConnectionsCountChangeMinVersion = 0,
    kSetTrustTokenKeyCommitmentsMinVersion = 0,
    kClearSCTAuditingCacheMinVersion = 0,
    kConfigureSCTAuditingMinVersion = 0,
    kUpdateCtLogListMinVersion = 0,
    kUpdateCtKnownPopularSCTsMinVersion = 0,
    kSetCtEnforcementEnabledMinVersion = 0,
    kUpdateKeyPinsListMinVersion = 0,
    kBindTestInterfaceForTestingMinVersion = 0,
    kSetFirstPartySetsMinVersion = 0,
    kSetExplicitlyAllowedPortsMinVersion = 0,
    kUpdateMaskedDomainListMinVersion = 0,
    kUpdateProbabilisticRevealTokenRegistryMinVersion = 0,
    kParseHeadersMinVersion = 0,
    kEnableDataUseUpdatesMinVersion = 0,
    kSetIPv6ReachabilityOverrideMinVersion = 0,
    kSetNetworkAnnotationMonitorMinVersion = 0,
    kSetTpcdMetadataGrantsMinVersion = 0,
    kInterceptUrlLoaderForBodyDecodingMinVersion = 0,
    kDecodeContentEncodingMinVersion = 0,
    kSetTLS13EarlyDataEnabledMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetParams_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartNetLog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AttachNetLogProxy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSSLKeyLogFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateNetworkContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConfigureStubHostResolver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableQuic_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUpHttpAuth_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConfigureHttpAuthPrefs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetRawHeadersAccess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMaxConnectionsPerProxyChain_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetNetworkChangeManager_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetNetworkQualityEstimatorManager_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDnsConfigChangeManager_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetNetworkList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTrustStoreChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnClientCertStoreChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetEncryptionKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMemoryPressure_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPeerToPeerConnectionsCountChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTrustTokenKeyCommitments_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearSCTAuditingCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConfigureSCTAuditing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateCtLogList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateCtKnownPopularSCTs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCtEnforcementEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateKeyPinsList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindTestInterfaceForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFirstPartySets_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetExplicitlyAllowedPorts_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateMaskedDomainList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateProbabilisticRevealTokenRegistry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ParseHeaders_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableDataUseUpdates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIPv6ReachabilityOverride_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNetworkAnnotationMonitor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTpcdMetadataGrants_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InterceptUrlLoaderForBodyDecoding_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DecodeContentEncoding_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTLS13EarlyDataEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NetworkService() = default;

  virtual void SetParams(NetworkServiceParamsPtr params) = 0;

  virtual void StartNetLog(::base::File file, uint64_t max_total_size, ::net::NetLogCaptureMode capture_mode, ::base::Value::Dict constants, std::optional<::base::TimeDelta> duration) = 0;

  virtual void AttachNetLogProxy(::mojo::PendingRemote<::network::mojom::NetLogProxySource> proxy_source, ::mojo::PendingReceiver<::network::mojom::NetLogProxySink> proxy_sink) = 0;

  virtual void SetSSLKeyLogFile(::base::File file) = 0;

  virtual void CreateNetworkContext(::mojo::PendingReceiver<::network::mojom::NetworkContext> context, ::network::mojom::NetworkContextParamsPtr params) = 0;

  virtual void ConfigureStubHostResolver(bool insecure_dns_client_enabled, bool happy_eyeballs_v3_enabled, ::net::SecureDnsMode secure_dns_mode, const ::net::DnsOverHttpsConfig& dns_over_https_config, bool additional_dns_types_enabled) = 0;

  virtual void DisableQuic() = 0;

  virtual void SetUpHttpAuth(HttpAuthStaticParamsPtr http_auth_static_params) = 0;

  virtual void ConfigureHttpAuthPrefs(HttpAuthDynamicParamsPtr http_auth_dynamic_params) = 0;

  virtual void SetRawHeadersAccess(int32_t process_id, const std::vector<::url::Origin>& origins) = 0;

  virtual void SetMaxConnectionsPerProxyChain(int32_t max_connections) = 0;

  virtual void GetNetworkChangeManager(::mojo::PendingReceiver<::network::mojom::NetworkChangeManager> network_change_manager) = 0;

  virtual void GetNetworkQualityEstimatorManager(::mojo::PendingReceiver<::network::mojom::NetworkQualityEstimatorManager> receiver) = 0;

  virtual void GetDnsConfigChangeManager(::mojo::PendingReceiver<::network::mojom::DnsConfigChangeManager> receiver) = 0;

  using GetNetworkListCallback = base::OnceCallback<void(const std::optional<std::vector<::net::NetworkInterface>>&)>;
  using GetNetworkListMojoCallback = base::OnceCallback<void(const std::optional<std::vector<::net::NetworkInterface>>&)>;

  virtual void GetNetworkList(uint32_t policy, GetNetworkListCallback callback) = 0;

  virtual void OnTrustStoreChanged() = 0;

  virtual void OnClientCertStoreChanged() = 0;

  virtual void SetEncryptionKey(const std::string& encryption_key) = 0;

  virtual void OnMemoryPressure(::base::MemoryPressureLevel memory_pressure_level) = 0;

  virtual void OnPeerToPeerConnectionsCountChange(uint32_t count) = 0;

  using SetTrustTokenKeyCommitmentsCallback = base::OnceCallback<void()>;
  using SetTrustTokenKeyCommitmentsMojoCallback = base::OnceCallback<void()>;

  virtual void SetTrustTokenKeyCommitments(const std::string& raw_commitments, SetTrustTokenKeyCommitmentsCallback callback) = 0;

  virtual void ClearSCTAuditingCache() = 0;

  virtual void ConfigureSCTAuditing(SCTAuditingConfigurationPtr configuration) = 0;

  using UpdateCtLogListCallback = base::OnceCallback<void()>;
  using UpdateCtLogListMojoCallback = base::OnceCallback<void()>;

  virtual void UpdateCtLogList(std::vector<::network::mojom::CTLogInfoPtr> log_list, UpdateCtLogListCallback callback) = 0;

  using UpdateCtKnownPopularSCTsCallback = base::OnceCallback<void()>;
  using UpdateCtKnownPopularSCTsMojoCallback = base::OnceCallback<void()>;

  virtual void UpdateCtKnownPopularSCTs(const std::vector<std::vector<uint8_t>>& sct_hashes, UpdateCtKnownPopularSCTsCallback callback) = 0;

  using SetCtEnforcementEnabledCallback = base::OnceCallback<void()>;
  using SetCtEnforcementEnabledMojoCallback = base::OnceCallback<void()>;

  virtual void SetCtEnforcementEnabled(bool enabled, SetCtEnforcementEnabledCallback callback) = 0;

  virtual void UpdateKeyPinsList(::network::mojom::PinListPtr pin_list, ::base::Time update_time) = 0;

  virtual void BindTestInterfaceForTesting(::mojo::PendingReceiver<::network::mojom::NetworkServiceTest> receiver) = 0;

  virtual void SetFirstPartySets(::net::GlobalFirstPartySets sets) = 0;

  virtual void SetExplicitlyAllowedPorts(const std::vector<uint16_t>& ports) = 0;

  virtual void UpdateMaskedDomainList(::base::File default_file, uint64_t default_file_size, ::base::File regular_browsing_file, uint64_t regular_browsing_file_size) = 0;

  virtual void UpdateProbabilisticRevealTokenRegistry(::base::Value::Dict registry) = 0;

  using ParseHeadersCallback = base::OnceCallback<void(::network::mojom::ParsedHeadersPtr)>;
  using ParseHeadersMojoCallback = base::OnceCallback<void(::network::mojom::ParsedHeadersPtr)>;

  virtual void ParseHeaders(const ::GURL& url, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, ParseHeadersCallback callback) = 0;

  virtual void EnableDataUseUpdates(bool enable) = 0;

  virtual void SetIPv6ReachabilityOverride(bool reachability_override) = 0;

  virtual void SetNetworkAnnotationMonitor(::mojo::PendingRemote<::network::mojom::NetworkAnnotationMonitor> remote) = 0;

  virtual void SetTpcdMetadataGrants(const std::vector<::ContentSettingPatternSource>& settings) = 0;

  virtual void InterceptUrlLoaderForBodyDecoding(const std::vector<::net::SourceStreamType>& content_encoding_types, ::mojo::ScopedDataPipeConsumerHandle source_body, ::mojo::ScopedDataPipeProducerHandle dest_body, ::mojo::PendingRemote<::network::mojom::URLLoader> source_url_loader, ::mojo::PendingReceiver<::network::mojom::URLLoaderClient> source_url_loader_client, ::mojo::PendingReceiver<::network::mojom::URLLoader> dest_url_loader, ::mojo::PendingRemote<::network::mojom::URLLoaderClient> dest_url_loader_client) = 0;

  using DecodeContentEncodingCallback = base::OnceCallback<void(int32_t)>;
  using DecodeContentEncodingMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void DecodeContentEncoding(const std::vector<::net::SourceStreamType>& content_encoding_types, ::mojo::ScopedDataPipeConsumerHandle source_body, ::mojo::ScopedDataPipeProducerHandle dest_body, DecodeContentEncodingCallback callback) = 0;

  virtual void SetTLS13EarlyDataEnabled(bool enabled) = 0;
};



class  NetworkServiceProxy
    : public NetworkService {
 public:
  using InterfaceType = NetworkService;

  explicit NetworkServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetParams(NetworkServiceParamsPtr params) final;
  
  void StartNetLog(::base::File file, uint64_t max_total_size, ::net::NetLogCaptureMode capture_mode, ::base::Value::Dict constants, std::optional<::base::TimeDelta> duration) final;
  
  void AttachNetLogProxy(::mojo::PendingRemote<::network::mojom::NetLogProxySource> proxy_source, ::mojo::PendingReceiver<::network::mojom::NetLogProxySink> proxy_sink) final;
  
  void SetSSLKeyLogFile(::base::File file) final;
  
  void CreateNetworkContext(::mojo::PendingReceiver<::network::mojom::NetworkContext> context, ::network::mojom::NetworkContextParamsPtr params) final;
  
  void ConfigureStubHostResolver(bool insecure_dns_client_enabled, bool happy_eyeballs_v3_enabled, ::net::SecureDnsMode secure_dns_mode, const ::net::DnsOverHttpsConfig& dns_over_https_config, bool additional_dns_types_enabled) final;
  
  void DisableQuic() final;
  
  void SetUpHttpAuth(HttpAuthStaticParamsPtr http_auth_static_params) final;
  
  void ConfigureHttpAuthPrefs(HttpAuthDynamicParamsPtr http_auth_dynamic_params) final;
  
  void SetRawHeadersAccess(int32_t process_id, const std::vector<::url::Origin>& origins) final;
  
  void SetMaxConnectionsPerProxyChain(int32_t max_connections) final;
  
  void GetNetworkChangeManager(::mojo::PendingReceiver<::network::mojom::NetworkChangeManager> network_change_manager) final;
  
  void GetNetworkQualityEstimatorManager(::mojo::PendingReceiver<::network::mojom::NetworkQualityEstimatorManager> receiver) final;
  
  void GetDnsConfigChangeManager(::mojo::PendingReceiver<::network::mojom::DnsConfigChangeManager> receiver) final;
  
  void GetNetworkList(uint32_t policy, GetNetworkListCallback callback) final;
  
  void OnTrustStoreChanged() final;
  
  void OnClientCertStoreChanged() final;
  
  void SetEncryptionKey(const std::string& encryption_key) final;
  
  void OnMemoryPressure(::base::MemoryPressureLevel memory_pressure_level) final;
  
  void OnPeerToPeerConnectionsCountChange(uint32_t count) final;
  
  void SetTrustTokenKeyCommitments(const std::string& raw_commitments, SetTrustTokenKeyCommitmentsCallback callback) final;
  
  void ClearSCTAuditingCache() final;
  
  void ConfigureSCTAuditing(SCTAuditingConfigurationPtr configuration) final;
  
  void UpdateCtLogList(std::vector<::network::mojom::CTLogInfoPtr> log_list, UpdateCtLogListCallback callback) final;
  
  void UpdateCtKnownPopularSCTs(const std::vector<std::vector<uint8_t>>& sct_hashes, UpdateCtKnownPopularSCTsCallback callback) final;
  
  void SetCtEnforcementEnabled(bool enabled, SetCtEnforcementEnabledCallback callback) final;
  
  void UpdateKeyPinsList(::network::mojom::PinListPtr pin_list, ::base::Time update_time) final;
  
  void BindTestInterfaceForTesting(::mojo::PendingReceiver<::network::mojom::NetworkServiceTest> receiver) final;
  
  void SetFirstPartySets(::net::GlobalFirstPartySets sets) final;
  
  void SetExplicitlyAllowedPorts(const std::vector<uint16_t>& ports) final;
  
  void UpdateMaskedDomainList(::base::File default_file, uint64_t default_file_size, ::base::File regular_browsing_file, uint64_t regular_browsing_file_size) final;
  
  void UpdateProbabilisticRevealTokenRegistry(::base::Value::Dict registry) final;
  
  void ParseHeaders(const ::GURL& url, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, ParseHeadersCallback callback) final;
  
  void EnableDataUseUpdates(bool enable) final;
  
  void SetIPv6ReachabilityOverride(bool reachability_override) final;
  
  void SetNetworkAnnotationMonitor(::mojo::PendingRemote<::network::mojom::NetworkAnnotationMonitor> remote) final;
  
  void SetTpcdMetadataGrants(const std::vector<::ContentSettingPatternSource>& settings) final;
  
  void InterceptUrlLoaderForBodyDecoding(const std::vector<::net::SourceStreamType>& content_encoding_types, ::mojo::ScopedDataPipeConsumerHandle source_body, ::mojo::ScopedDataPipeProducerHandle dest_body, ::mojo::PendingRemote<::network::mojom::URLLoader> source_url_loader, ::mojo::PendingReceiver<::network::mojom::URLLoaderClient> source_url_loader_client, ::mojo::PendingReceiver<::network::mojom::URLLoader> dest_url_loader, ::mojo::PendingRemote<::network::mojom::URLLoaderClient> dest_url_loader_client) final;
  
  void DecodeContentEncoding(const std::vector<::net::SourceStreamType>& content_encoding_types, ::mojo::ScopedDataPipeConsumerHandle source_body, ::mojo::ScopedDataPipeProducerHandle dest_body, DecodeContentEncodingCallback callback) final;
  
  void SetTLS13EarlyDataEnabled(bool enabled) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NetworkServiceStubDispatch {
 public:
  static bool Accept(NetworkService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkService>>
class NetworkServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkServiceStub() = default;
  ~NetworkServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  HttpAuthStaticParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpAuthStaticParams, T>::value>;
  using DataView = HttpAuthStaticParamsDataView;
  using Data_ = internal::HttpAuthStaticParams_Data;

  template <typename... Args>
  static HttpAuthStaticParamsPtr New(Args&&... args) {
    return HttpAuthStaticParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpAuthStaticParamsPtr From(const U& u) {
    return mojo::TypeConverter<HttpAuthStaticParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpAuthStaticParams>::Convert(*this);
  }


  HttpAuthStaticParams();

  explicit HttpAuthStaticParams(
      const std::string& gssapi_library_name);


  ~HttpAuthStaticParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpAuthStaticParamsPtr>
  HttpAuthStaticParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpAuthStaticParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HttpAuthStaticParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HttpAuthStaticParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpAuthStaticParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpAuthStaticParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpAuthStaticParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpAuthStaticParams_UnserializedMessageContext<
            UserType, HttpAuthStaticParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HttpAuthStaticParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HttpAuthStaticParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpAuthStaticParams_UnserializedMessageContext<
            UserType, HttpAuthStaticParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpAuthStaticParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string gssapi_library_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpAuthStaticParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpAuthStaticParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpAuthStaticParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpAuthStaticParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  EnvironmentVariable {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EnvironmentVariable, T>::value>;
  using DataView = EnvironmentVariableDataView;
  using Data_ = internal::EnvironmentVariable_Data;

  template <typename... Args>
  static EnvironmentVariablePtr New(Args&&... args) {
    return EnvironmentVariablePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EnvironmentVariablePtr From(const U& u) {
    return mojo::TypeConverter<EnvironmentVariablePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EnvironmentVariable>::Convert(*this);
  }


  EnvironmentVariable();

  EnvironmentVariable(
      const std::string& name,
      const std::string& value);


  ~EnvironmentVariable();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EnvironmentVariablePtr>
  EnvironmentVariablePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EnvironmentVariable::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EnvironmentVariable::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EnvironmentVariable::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EnvironmentVariable::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EnvironmentVariable::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EnvironmentVariable::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EnvironmentVariable_UnserializedMessageContext<
            UserType, EnvironmentVariable::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EnvironmentVariable::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EnvironmentVariable::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EnvironmentVariable_UnserializedMessageContext<
            UserType, EnvironmentVariable::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EnvironmentVariable::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EnvironmentVariable::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EnvironmentVariable::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EnvironmentVariable::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EnvironmentVariable::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  HttpAuthDynamicParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpAuthDynamicParams, T>::value>;
  using DataView = HttpAuthDynamicParamsDataView;
  using Data_ = internal::HttpAuthDynamicParams_Data;

  template <typename... Args>
  static HttpAuthDynamicParamsPtr New(Args&&... args) {
    return HttpAuthDynamicParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpAuthDynamicParamsPtr From(const U& u) {
    return mojo::TypeConverter<HttpAuthDynamicParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpAuthDynamicParams>::Convert(*this);
  }


  HttpAuthDynamicParams();

  HttpAuthDynamicParams(
      std::optional<std::vector<std::string>> allowed_schemes,
      std::vector<std::string> patterns_allowed_to_use_all_schemes,
      const std::string& server_allowlist,
      const std::string& delegate_allowlist,
      bool delegate_by_kdc_policy,
      bool negotiate_disable_cname_lookup,
      bool enable_negotiate_port,
      bool ntlm_v2_enabled,
      const std::string& android_negotiate_account_type,
      bool allow_gssapi_library_load,
      bool basic_over_http_enabled);


  ~HttpAuthDynamicParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpAuthDynamicParamsPtr>
  HttpAuthDynamicParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpAuthDynamicParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HttpAuthDynamicParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HttpAuthDynamicParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpAuthDynamicParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpAuthDynamicParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpAuthDynamicParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpAuthDynamicParams_UnserializedMessageContext<
            UserType, HttpAuthDynamicParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HttpAuthDynamicParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HttpAuthDynamicParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpAuthDynamicParams_UnserializedMessageContext<
            UserType, HttpAuthDynamicParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpAuthDynamicParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::vector<std::string>> allowed_schemes;
  
  std::vector<std::string> patterns_allowed_to_use_all_schemes;
  
  std::string server_allowlist;
  
  std::string delegate_allowlist;
  
  bool delegate_by_kdc_policy;
  
  bool negotiate_disable_cname_lookup;
  
  bool enable_negotiate_port;
  
  bool ntlm_v2_enabled;
  
  std::string android_negotiate_account_type;
  
  bool allow_gssapi_library_load;
  
  bool basic_over_http_enabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpAuthDynamicParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpAuthDynamicParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpAuthDynamicParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpAuthDynamicParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  NetworkServiceParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkServiceParams, T>::value>;
  using DataView = NetworkServiceParamsDataView;
  using Data_ = internal::NetworkServiceParams_Data;

  template <typename... Args>
  static NetworkServiceParamsPtr New(Args&&... args) {
    return NetworkServiceParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkServiceParamsPtr From(const U& u) {
    return mojo::TypeConverter<NetworkServiceParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkServiceParams>::Convert(*this);
  }


  NetworkServiceParams();

  NetworkServiceParams(
      ::network::mojom::ConnectionType initial_connection_type,
      ::network::mojom::ConnectionSubtype initial_connection_subtype,
      std::vector<EnvironmentVariablePtr> environment,
      ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> default_observer,
      bool first_party_sets_enabled,
      ::mojo::PendingRemote<::network::mojom::SystemDnsResolver> system_dns_resolver,
      ::network::mojom::IpProtectionProxyBypassPolicy ip_protection_proxy_bypass_policy);

NetworkServiceParams(const NetworkServiceParams&) = delete;
NetworkServiceParams& operator=(const NetworkServiceParams&) = delete;

  ~NetworkServiceParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkServiceParamsPtr>
  NetworkServiceParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkServiceParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NetworkServiceParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NetworkServiceParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkServiceParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkServiceParams_UnserializedMessageContext<
            UserType, NetworkServiceParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NetworkServiceParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NetworkServiceParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkServiceParams_UnserializedMessageContext<
            UserType, NetworkServiceParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkServiceParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::mojom::ConnectionType initial_connection_type;
  
  ::network::mojom::ConnectionSubtype initial_connection_subtype;
  
  std::vector<EnvironmentVariablePtr> environment;
  
  ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> default_observer;
  
  bool first_party_sets_enabled;
  
  ::mojo::PendingRemote<::network::mojom::SystemDnsResolver> system_dns_resolver;
  
  ::network::mojom::IpProtectionProxyBypassPolicy ip_protection_proxy_bypass_policy;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkServiceParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkServiceParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkServiceParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkServiceParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SCTAuditingConfiguration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SCTAuditingConfiguration, T>::value>;
  using DataView = SCTAuditingConfigurationDataView;
  using Data_ = internal::SCTAuditingConfiguration_Data;

  template <typename... Args>
  static SCTAuditingConfigurationPtr New(Args&&... args) {
    return SCTAuditingConfigurationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SCTAuditingConfigurationPtr From(const U& u) {
    return mojo::TypeConverter<SCTAuditingConfigurationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SCTAuditingConfiguration>::Convert(*this);
  }


  SCTAuditingConfiguration();

  SCTAuditingConfiguration(
      double sampling_rate,
      ::base::TimeDelta log_expected_ingestion_delay,
      ::base::TimeDelta log_max_ingestion_random_delay,
      const ::GURL& report_uri,
      const ::GURL& hashdance_lookup_uri,
      const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation,
      const ::net::MutableNetworkTrafficAnnotationTag& hashdance_traffic_annotation);


  ~SCTAuditingConfiguration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SCTAuditingConfigurationPtr>
  SCTAuditingConfigurationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SCTAuditingConfiguration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SCTAuditingConfiguration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SCTAuditingConfiguration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SCTAuditingConfiguration::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SCTAuditingConfiguration::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SCTAuditingConfiguration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SCTAuditingConfiguration_UnserializedMessageContext<
            UserType, SCTAuditingConfiguration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SCTAuditingConfiguration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SCTAuditingConfiguration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SCTAuditingConfiguration_UnserializedMessageContext<
            UserType, SCTAuditingConfiguration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SCTAuditingConfiguration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double sampling_rate;
  
  ::base::TimeDelta log_expected_ingestion_delay;
  
  ::base::TimeDelta log_max_ingestion_random_delay;
  
  ::GURL report_uri;
  
  ::GURL hashdance_lookup_uri;
  
  ::net::MutableNetworkTrafficAnnotationTag traffic_annotation;
  
  ::net::MutableNetworkTrafficAnnotationTag hashdance_traffic_annotation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SCTAuditingConfiguration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SCTAuditingConfiguration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SCTAuditingConfiguration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SCTAuditingConfiguration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HttpAuthStaticParamsPtr HttpAuthStaticParams::Clone() const {
  return New(
      mojo::Clone(gssapi_library_name)
  );
}

template <typename T, HttpAuthStaticParams::EnableIfSame<T>*>
bool HttpAuthStaticParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->gssapi_library_name, other_struct.gssapi_library_name))
    return false;
  return true;
}

template <typename T, HttpAuthStaticParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.gssapi_library_name < rhs.gssapi_library_name)
    return true;
  if (rhs.gssapi_library_name < lhs.gssapi_library_name)
    return false;
  return false;
}
template <typename StructPtrType>
HttpAuthDynamicParamsPtr HttpAuthDynamicParams::Clone() const {
  return New(
      mojo::Clone(allowed_schemes),
      mojo::Clone(patterns_allowed_to_use_all_schemes),
      mojo::Clone(server_allowlist),
      mojo::Clone(delegate_allowlist),
      mojo::Clone(delegate_by_kdc_policy),
      mojo::Clone(negotiate_disable_cname_lookup),
      mojo::Clone(enable_negotiate_port),
      mojo::Clone(ntlm_v2_enabled),
      mojo::Clone(android_negotiate_account_type),
      mojo::Clone(allow_gssapi_library_load),
      mojo::Clone(basic_over_http_enabled)
  );
}

template <typename T, HttpAuthDynamicParams::EnableIfSame<T>*>
bool HttpAuthDynamicParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allowed_schemes, other_struct.allowed_schemes))
    return false;
  if (!mojo::Equals(this->patterns_allowed_to_use_all_schemes, other_struct.patterns_allowed_to_use_all_schemes))
    return false;
  if (!mojo::Equals(this->server_allowlist, other_struct.server_allowlist))
    return false;
  if (!mojo::Equals(this->delegate_allowlist, other_struct.delegate_allowlist))
    return false;
  if (!mojo::Equals(this->delegate_by_kdc_policy, other_struct.delegate_by_kdc_policy))
    return false;
  if (!mojo::Equals(this->negotiate_disable_cname_lookup, other_struct.negotiate_disable_cname_lookup))
    return false;
  if (!mojo::Equals(this->enable_negotiate_port, other_struct.enable_negotiate_port))
    return false;
  if (!mojo::Equals(this->ntlm_v2_enabled, other_struct.ntlm_v2_enabled))
    return false;
  if (!mojo::Equals(this->android_negotiate_account_type, other_struct.android_negotiate_account_type))
    return false;
  if (!mojo::Equals(this->allow_gssapi_library_load, other_struct.allow_gssapi_library_load))
    return false;
  if (!mojo::Equals(this->basic_over_http_enabled, other_struct.basic_over_http_enabled))
    return false;
  return true;
}

template <typename T, HttpAuthDynamicParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allowed_schemes < rhs.allowed_schemes)
    return true;
  if (rhs.allowed_schemes < lhs.allowed_schemes)
    return false;
  if (lhs.patterns_allowed_to_use_all_schemes < rhs.patterns_allowed_to_use_all_schemes)
    return true;
  if (rhs.patterns_allowed_to_use_all_schemes < lhs.patterns_allowed_to_use_all_schemes)
    return false;
  if (lhs.server_allowlist < rhs.server_allowlist)
    return true;
  if (rhs.server_allowlist < lhs.server_allowlist)
    return false;
  if (lhs.delegate_allowlist < rhs.delegate_allowlist)
    return true;
  if (rhs.delegate_allowlist < lhs.delegate_allowlist)
    return false;
  if (lhs.delegate_by_kdc_policy < rhs.delegate_by_kdc_policy)
    return true;
  if (rhs.delegate_by_kdc_policy < lhs.delegate_by_kdc_policy)
    return false;
  if (lhs.negotiate_disable_cname_lookup < rhs.negotiate_disable_cname_lookup)
    return true;
  if (rhs.negotiate_disable_cname_lookup < lhs.negotiate_disable_cname_lookup)
    return false;
  if (lhs.enable_negotiate_port < rhs.enable_negotiate_port)
    return true;
  if (rhs.enable_negotiate_port < lhs.enable_negotiate_port)
    return false;
  if (lhs.ntlm_v2_enabled < rhs.ntlm_v2_enabled)
    return true;
  if (rhs.ntlm_v2_enabled < lhs.ntlm_v2_enabled)
    return false;
  if (lhs.android_negotiate_account_type < rhs.android_negotiate_account_type)
    return true;
  if (rhs.android_negotiate_account_type < lhs.android_negotiate_account_type)
    return false;
  if (lhs.allow_gssapi_library_load < rhs.allow_gssapi_library_load)
    return true;
  if (rhs.allow_gssapi_library_load < lhs.allow_gssapi_library_load)
    return false;
  if (lhs.basic_over_http_enabled < rhs.basic_over_http_enabled)
    return true;
  if (rhs.basic_over_http_enabled < lhs.basic_over_http_enabled)
    return false;
  return false;
}
template <typename StructPtrType>
EnvironmentVariablePtr EnvironmentVariable::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value)
  );
}

template <typename T, EnvironmentVariable::EnableIfSame<T>*>
bool EnvironmentVariable::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, EnvironmentVariable::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
NetworkServiceParamsPtr NetworkServiceParams::Clone() const {
  return New(
      mojo::Clone(initial_connection_type),
      mojo::Clone(initial_connection_subtype),
      mojo::Clone(environment),
      mojo::Clone(default_observer),
      mojo::Clone(first_party_sets_enabled),
      mojo::Clone(system_dns_resolver),
      mojo::Clone(ip_protection_proxy_bypass_policy)
  );
}

template <typename T, NetworkServiceParams::EnableIfSame<T>*>
bool NetworkServiceParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->initial_connection_type, other_struct.initial_connection_type))
    return false;
  if (!mojo::Equals(this->initial_connection_subtype, other_struct.initial_connection_subtype))
    return false;
  if (!mojo::Equals(this->environment, other_struct.environment))
    return false;
  if (!mojo::Equals(this->default_observer, other_struct.default_observer))
    return false;
  if (!mojo::Equals(this->first_party_sets_enabled, other_struct.first_party_sets_enabled))
    return false;
  if (!mojo::Equals(this->system_dns_resolver, other_struct.system_dns_resolver))
    return false;
  if (!mojo::Equals(this->ip_protection_proxy_bypass_policy, other_struct.ip_protection_proxy_bypass_policy))
    return false;
  return true;
}

template <typename T, NetworkServiceParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.initial_connection_type < rhs.initial_connection_type)
    return true;
  if (rhs.initial_connection_type < lhs.initial_connection_type)
    return false;
  if (lhs.initial_connection_subtype < rhs.initial_connection_subtype)
    return true;
  if (rhs.initial_connection_subtype < lhs.initial_connection_subtype)
    return false;
  if (lhs.environment < rhs.environment)
    return true;
  if (rhs.environment < lhs.environment)
    return false;
  if (lhs.default_observer < rhs.default_observer)
    return true;
  if (rhs.default_observer < lhs.default_observer)
    return false;
  if (lhs.first_party_sets_enabled < rhs.first_party_sets_enabled)
    return true;
  if (rhs.first_party_sets_enabled < lhs.first_party_sets_enabled)
    return false;
  if (lhs.system_dns_resolver < rhs.system_dns_resolver)
    return true;
  if (rhs.system_dns_resolver < lhs.system_dns_resolver)
    return false;
  if (lhs.ip_protection_proxy_bypass_policy < rhs.ip_protection_proxy_bypass_policy)
    return true;
  if (rhs.ip_protection_proxy_bypass_policy < lhs.ip_protection_proxy_bypass_policy)
    return false;
  return false;
}
template <typename StructPtrType>
SCTAuditingConfigurationPtr SCTAuditingConfiguration::Clone() const {
  return New(
      mojo::Clone(sampling_rate),
      mojo::Clone(log_expected_ingestion_delay),
      mojo::Clone(log_max_ingestion_random_delay),
      mojo::Clone(report_uri),
      mojo::Clone(hashdance_lookup_uri),
      mojo::Clone(traffic_annotation),
      mojo::Clone(hashdance_traffic_annotation)
  );
}

template <typename T, SCTAuditingConfiguration::EnableIfSame<T>*>
bool SCTAuditingConfiguration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sampling_rate, other_struct.sampling_rate))
    return false;
  if (!mojo::Equals(this->log_expected_ingestion_delay, other_struct.log_expected_ingestion_delay))
    return false;
  if (!mojo::Equals(this->log_max_ingestion_random_delay, other_struct.log_max_ingestion_random_delay))
    return false;
  if (!mojo::Equals(this->report_uri, other_struct.report_uri))
    return false;
  if (!mojo::Equals(this->hashdance_lookup_uri, other_struct.hashdance_lookup_uri))
    return false;
  if (!mojo::Equals(this->traffic_annotation, other_struct.traffic_annotation))
    return false;
  if (!mojo::Equals(this->hashdance_traffic_annotation, other_struct.hashdance_traffic_annotation))
    return false;
  return true;
}

template <typename T, SCTAuditingConfiguration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sampling_rate < rhs.sampling_rate)
    return true;
  if (rhs.sampling_rate < lhs.sampling_rate)
    return false;
  if (lhs.log_expected_ingestion_delay < rhs.log_expected_ingestion_delay)
    return true;
  if (rhs.log_expected_ingestion_delay < lhs.log_expected_ingestion_delay)
    return false;
  if (lhs.log_max_ingestion_random_delay < rhs.log_max_ingestion_random_delay)
    return true;
  if (rhs.log_max_ingestion_random_delay < lhs.log_max_ingestion_random_delay)
    return false;
  if (lhs.report_uri < rhs.report_uri)
    return true;
  if (rhs.report_uri < lhs.report_uri)
    return false;
  if (lhs.hashdance_lookup_uri < rhs.hashdance_lookup_uri)
    return true;
  if (rhs.hashdance_lookup_uri < lhs.hashdance_lookup_uri)
    return false;
  if (lhs.traffic_annotation < rhs.traffic_annotation)
    return true;
  if (rhs.traffic_annotation < lhs.traffic_annotation)
    return false;
  if (lhs.hashdance_traffic_annotation < rhs.hashdance_traffic_annotation)
    return true;
  if (rhs.hashdance_traffic_annotation < lhs.hashdance_traffic_annotation)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::HttpAuthStaticParams::DataView,
                                         ::network::mojom::HttpAuthStaticParamsPtr> {
  static bool IsNull(const ::network::mojom::HttpAuthStaticParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::HttpAuthStaticParamsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::HttpAuthStaticParams::gssapi_library_name)& gssapi_library_name(
      const ::network::mojom::HttpAuthStaticParamsPtr& input) {
    return input->gssapi_library_name;
  }

  static bool Read(::network::mojom::HttpAuthStaticParams::DataView input, ::network::mojom::HttpAuthStaticParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::HttpAuthDynamicParams::DataView,
                                         ::network::mojom::HttpAuthDynamicParamsPtr> {
  static bool IsNull(const ::network::mojom::HttpAuthDynamicParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::HttpAuthDynamicParamsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::HttpAuthDynamicParams::allowed_schemes)& allowed_schemes(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->allowed_schemes;
  }

  static const decltype(::network::mojom::HttpAuthDynamicParams::patterns_allowed_to_use_all_schemes)& patterns_allowed_to_use_all_schemes(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->patterns_allowed_to_use_all_schemes;
  }

  static const decltype(::network::mojom::HttpAuthDynamicParams::server_allowlist)& server_allowlist(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->server_allowlist;
  }

  static const decltype(::network::mojom::HttpAuthDynamicParams::delegate_allowlist)& delegate_allowlist(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->delegate_allowlist;
  }

  static decltype(::network::mojom::HttpAuthDynamicParams::delegate_by_kdc_policy) delegate_by_kdc_policy(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->delegate_by_kdc_policy;
  }

  static decltype(::network::mojom::HttpAuthDynamicParams::negotiate_disable_cname_lookup) negotiate_disable_cname_lookup(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->negotiate_disable_cname_lookup;
  }

  static decltype(::network::mojom::HttpAuthDynamicParams::enable_negotiate_port) enable_negotiate_port(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->enable_negotiate_port;
  }

  static decltype(::network::mojom::HttpAuthDynamicParams::ntlm_v2_enabled) ntlm_v2_enabled(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->ntlm_v2_enabled;
  }

  static const decltype(::network::mojom::HttpAuthDynamicParams::android_negotiate_account_type)& android_negotiate_account_type(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->android_negotiate_account_type;
  }

  static decltype(::network::mojom::HttpAuthDynamicParams::allow_gssapi_library_load) allow_gssapi_library_load(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->allow_gssapi_library_load;
  }

  static decltype(::network::mojom::HttpAuthDynamicParams::basic_over_http_enabled) basic_over_http_enabled(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->basic_over_http_enabled;
  }

  static bool Read(::network::mojom::HttpAuthDynamicParams::DataView input, ::network::mojom::HttpAuthDynamicParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::EnvironmentVariable::DataView,
                                         ::network::mojom::EnvironmentVariablePtr> {
  static bool IsNull(const ::network::mojom::EnvironmentVariablePtr& input) { return !input; }
  static void SetToNull(::network::mojom::EnvironmentVariablePtr* output) { output->reset(); }

  static const decltype(::network::mojom::EnvironmentVariable::name)& name(
      const ::network::mojom::EnvironmentVariablePtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::EnvironmentVariable::value)& value(
      const ::network::mojom::EnvironmentVariablePtr& input) {
    return input->value;
  }

  static bool Read(::network::mojom::EnvironmentVariable::DataView input, ::network::mojom::EnvironmentVariablePtr* output);
};


template <>
struct  StructTraits<::network::mojom::NetworkServiceParams::DataView,
                                         ::network::mojom::NetworkServiceParamsPtr> {
  static bool IsNull(const ::network::mojom::NetworkServiceParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::NetworkServiceParamsPtr* output) { output->reset(); }

  static decltype(::network::mojom::NetworkServiceParams::initial_connection_type) initial_connection_type(
      const ::network::mojom::NetworkServiceParamsPtr& input) {
    return input->initial_connection_type;
  }

  static decltype(::network::mojom::NetworkServiceParams::initial_connection_subtype) initial_connection_subtype(
      const ::network::mojom::NetworkServiceParamsPtr& input) {
    return input->initial_connection_subtype;
  }

  static const decltype(::network::mojom::NetworkServiceParams::environment)& environment(
      const ::network::mojom::NetworkServiceParamsPtr& input) {
    return input->environment;
  }

  static  decltype(::network::mojom::NetworkServiceParams::default_observer)& default_observer(
       ::network::mojom::NetworkServiceParamsPtr& input) {
    return input->default_observer;
  }

  static decltype(::network::mojom::NetworkServiceParams::first_party_sets_enabled) first_party_sets_enabled(
      const ::network::mojom::NetworkServiceParamsPtr& input) {
    return input->first_party_sets_enabled;
  }

  static  decltype(::network::mojom::NetworkServiceParams::system_dns_resolver)& system_dns_resolver(
       ::network::mojom::NetworkServiceParamsPtr& input) {
    return input->system_dns_resolver;
  }

  static decltype(::network::mojom::NetworkServiceParams::ip_protection_proxy_bypass_policy) ip_protection_proxy_bypass_policy(
      const ::network::mojom::NetworkServiceParamsPtr& input) {
    return input->ip_protection_proxy_bypass_policy;
  }

  static bool Read(::network::mojom::NetworkServiceParams::DataView input, ::network::mojom::NetworkServiceParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::SCTAuditingConfiguration::DataView,
                                         ::network::mojom::SCTAuditingConfigurationPtr> {
  static bool IsNull(const ::network::mojom::SCTAuditingConfigurationPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SCTAuditingConfigurationPtr* output) { output->reset(); }

  static decltype(::network::mojom::SCTAuditingConfiguration::sampling_rate) sampling_rate(
      const ::network::mojom::SCTAuditingConfigurationPtr& input) {
    return input->sampling_rate;
  }

  static const decltype(::network::mojom::SCTAuditingConfiguration::log_expected_ingestion_delay)& log_expected_ingestion_delay(
      const ::network::mojom::SCTAuditingConfigurationPtr& input) {
    return input->log_expected_ingestion_delay;
  }

  static const decltype(::network::mojom::SCTAuditingConfiguration::log_max_ingestion_random_delay)& log_max_ingestion_random_delay(
      const ::network::mojom::SCTAuditingConfigurationPtr& input) {
    return input->log_max_ingestion_random_delay;
  }

  static const decltype(::network::mojom::SCTAuditingConfiguration::report_uri)& report_uri(
      const ::network::mojom::SCTAuditingConfigurationPtr& input) {
    return input->report_uri;
  }

  static const decltype(::network::mojom::SCTAuditingConfiguration::hashdance_lookup_uri)& hashdance_lookup_uri(
      const ::network::mojom::SCTAuditingConfigurationPtr& input) {
    return input->hashdance_lookup_uri;
  }

  static const decltype(::network::mojom::SCTAuditingConfiguration::traffic_annotation)& traffic_annotation(
      const ::network::mojom::SCTAuditingConfigurationPtr& input) {
    return input->traffic_annotation;
  }

  static const decltype(::network::mojom::SCTAuditingConfiguration::hashdance_traffic_annotation)& hashdance_traffic_annotation(
      const ::network::mojom::SCTAuditingConfigurationPtr& input) {
    return input->hashdance_traffic_annotation;
  }

  static bool Read(::network::mojom::SCTAuditingConfiguration::DataView input, ::network::mojom::SCTAuditingConfigurationPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_H_