// services/network/public/mojom/network_quality_estimator_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_quality_estimator_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_quality_estimator_manager.mojom-params-data.h"
#include "services/network/public/mojom/network_quality_estimator_manager.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_quality_estimator_manager.mojom-blink-import-headers.h"
#include "services/network/public/mojom/network_quality_estimator_manager.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
// The declaration includes the definition on other builds.

NetworkQualityEstimatorManagerClient::IPCStableHashFunction NetworkQualityEstimatorManagerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkQualityEstimatorManagerClient>(message.name())) {
    case messages::NetworkQualityEstimatorManagerClient::kOnNetworkQualityChanged: {
      return &NetworkQualityEstimatorManagerClient::OnNetworkQualityChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkQualityEstimatorManagerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkQualityEstimatorManagerClient>(message.name())) {
      case messages::NetworkQualityEstimatorManagerClient::kOnNetworkQualityChanged:
            return "Receive network::mojom::NetworkQualityEstimatorManagerClient::OnNetworkQualityChanged";
    }
  } else {
    switch (static_cast<messages::NetworkQualityEstimatorManagerClient>(message.name())) {
      case messages::NetworkQualityEstimatorManagerClient::kOnNetworkQualityChanged:
            return "Receive reply network::mojom::NetworkQualityEstimatorManagerClient::OnNetworkQualityChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkQualityEstimatorManagerClient::OnNetworkQualityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x33fffb79;  // IPCStableHash for network::mojom::NetworkQualityEstimatorManagerClient::OnNetworkQualityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NetworkQualityEstimatorManagerClientProxy::NetworkQualityEstimatorManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkQualityEstimatorManagerClientProxy::OnNetworkQualityChanged(
    ::network::mojom::blink::EffectiveConnectionType in_type, ::base::TimeDelta in_http_rtt, ::base::TimeDelta in_transport_rtt, int32_t in_downlink_bandwidth_kbps) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkQualityEstimatorManagerClient::OnNetworkQualityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::network::mojom::blink::EffectiveConnectionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_rtt"), in_http_rtt,
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transport_rtt"), in_transport_rtt,
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("downlink_bandwidth_kbps"), in_downlink_bandwidth_kbps,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkQualityEstimatorManagerClient::kOnNetworkQualityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::EffectiveConnectionType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->http_rtt)::BaseType> http_rtt_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_http_rtt,
    http_rtt_fragment);

  params->http_rtt.Set(
      http_rtt_fragment.is_null() ? nullptr : http_rtt_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->http_rtt.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null http_rtt in NetworkQualityEstimatorManagerClient.OnNetworkQualityChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->transport_rtt)::BaseType> transport_rtt_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_transport_rtt,
    transport_rtt_fragment);

  params->transport_rtt.Set(
      transport_rtt_fragment.is_null() ? nullptr : transport_rtt_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->transport_rtt.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null transport_rtt in NetworkQualityEstimatorManagerClient.OnNetworkQualityChanged request");

  params->downlink_bandwidth_kbps = in_downlink_bandwidth_kbps;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkQualityEstimatorManagerClient::Name_);
  message.set_method_name("OnNetworkQualityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NetworkQualityEstimatorManagerClientStubDispatch::Accept(
    NetworkQualityEstimatorManagerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkQualityEstimatorManagerClient>(message->header()->name)) {
    case messages::NetworkQualityEstimatorManagerClient::kOnNetworkQualityChanged: {
      DCHECK(message->is_serialized());
      internal::NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data* params =
          reinterpret_cast<internal::NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkQualityEstimatorManagerClient.0
      bool success = true;
      ::network::mojom::blink::EffectiveConnectionType p_type{};
      ::base::TimeDelta p_http_rtt{};
      ::base::TimeDelta p_transport_rtt{};
      int32_t p_downlink_bandwidth_kbps{};
      NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadHttpRtt(&p_http_rtt))
        success = false;
      if (success && !input_data_view.ReadTransportRtt(&p_transport_rtt))
        success = false;
      if (success)
        p_downlink_bandwidth_kbps = input_data_view.downlink_bandwidth_kbps();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkQualityEstimatorManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkQualityChanged(        
        std::move(p_type), 
        std::move(p_http_rtt), 
        std::move(p_transport_rtt), 
        std::move(p_downlink_bandwidth_kbps));
      return true;
    }
  }
  return false;
}

// static
bool NetworkQualityEstimatorManagerClientStubDispatch::AcceptWithResponder(
    NetworkQualityEstimatorManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkQualityEstimatorManagerClient>(message->header()->name)) {
    case messages::NetworkQualityEstimatorManagerClient::kOnNetworkQualityChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNetworkQualityEstimatorManagerClientValidationInfo[] = {
    { &internal::NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool NetworkQualityEstimatorManagerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::NetworkQualityEstimatorManagerClient::Name_,
    kNetworkQualityEstimatorManagerClientValidationInfo);
}

// The declaration includes the definition on other builds.

NetworkQualityEstimatorManager::IPCStableHashFunction NetworkQualityEstimatorManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkQualityEstimatorManager>(message.name())) {
    case messages::NetworkQualityEstimatorManager::kRequestNotifications: {
      return &NetworkQualityEstimatorManager::RequestNotifications_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkQualityEstimatorManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkQualityEstimatorManager>(message.name())) {
      case messages::NetworkQualityEstimatorManager::kRequestNotifications:
            return "Receive network::mojom::NetworkQualityEstimatorManager::RequestNotifications";
    }
  } else {
    switch (static_cast<messages::NetworkQualityEstimatorManager>(message.name())) {
      case messages::NetworkQualityEstimatorManager::kRequestNotifications:
            return "Receive reply network::mojom::NetworkQualityEstimatorManager::RequestNotifications";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkQualityEstimatorManager::RequestNotifications_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde8631f9;  // IPCStableHash for network::mojom::NetworkQualityEstimatorManager::RequestNotifications
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NetworkQualityEstimatorManagerProxy::NetworkQualityEstimatorManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkQualityEstimatorManagerProxy::RequestNotifications(
    ::mojo::PendingRemote<NetworkQualityEstimatorManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkQualityEstimatorManager::RequestNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<NetworkQualityEstimatorManagerClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkQualityEstimatorManager::kRequestNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkQualityEstimatorManager_RequestNotifications_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::NetworkQualityEstimatorManagerClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in NetworkQualityEstimatorManager.RequestNotifications request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkQualityEstimatorManager::Name_);
  message.set_method_name("RequestNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NetworkQualityEstimatorManagerStubDispatch::Accept(
    NetworkQualityEstimatorManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkQualityEstimatorManager>(message->header()->name)) {
    case messages::NetworkQualityEstimatorManager::kRequestNotifications: {
      DCHECK(message->is_serialized());
      internal::NetworkQualityEstimatorManager_RequestNotifications_Params_Data* params =
          reinterpret_cast<internal::NetworkQualityEstimatorManager_RequestNotifications_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkQualityEstimatorManager.0
      bool success = true;
      ::mojo::PendingRemote<NetworkQualityEstimatorManagerClient> p_client{};
      NetworkQualityEstimatorManager_RequestNotifications_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkQualityEstimatorManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNotifications(        
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool NetworkQualityEstimatorManagerStubDispatch::AcceptWithResponder(
    NetworkQualityEstimatorManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkQualityEstimatorManager>(message->header()->name)) {
    case messages::NetworkQualityEstimatorManager::kRequestNotifications: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNetworkQualityEstimatorManagerValidationInfo[] = {
    { &internal::NetworkQualityEstimatorManager_RequestNotifications_Params_Data::Validate,
     nullptr /* no response */},
};

bool NetworkQualityEstimatorManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::NetworkQualityEstimatorManager::Name_,
    kNetworkQualityEstimatorManagerValidationInfo);
}



}  // network::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void NetworkQualityEstimatorManagerClientInterceptorForTesting::OnNetworkQualityChanged(::network::mojom::blink::EffectiveConnectionType type, ::base::TimeDelta http_rtt, ::base::TimeDelta transport_rtt, int32_t downlink_bandwidth_kbps) {
  GetForwardingInterface()->OnNetworkQualityChanged(
    std::move(type)
    , 
    std::move(http_rtt)
    , 
    std::move(transport_rtt)
    , 
    std::move(downlink_bandwidth_kbps)
    );
}
NetworkQualityEstimatorManagerClientAsyncWaiter::NetworkQualityEstimatorManagerClientAsyncWaiter(
    NetworkQualityEstimatorManagerClient* proxy) : proxy_(proxy) {}

NetworkQualityEstimatorManagerClientAsyncWaiter::~NetworkQualityEstimatorManagerClientAsyncWaiter() = default;





void NetworkQualityEstimatorManagerInterceptorForTesting::RequestNotifications(::mojo::PendingRemote<NetworkQualityEstimatorManagerClient> client) {
  GetForwardingInterface()->RequestNotifications(
    std::move(client)
    );
}
NetworkQualityEstimatorManagerAsyncWaiter::NetworkQualityEstimatorManagerAsyncWaiter(
    NetworkQualityEstimatorManager* proxy) : proxy_(proxy) {}

NetworkQualityEstimatorManagerAsyncWaiter::~NetworkQualityEstimatorManagerAsyncWaiter() = default;







}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif