// services/network/public/mojom/network_context_client.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ReadOnlyFile as mojoBase_mojom_ReadOnlyFile,
  ReadOnlyFileSpec as mojoBase_mojom_ReadOnlyFileSpec
} from '../../../../mojo/public/mojom/base/file.mojom.m.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NetworkContextClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.NetworkContextClient', scope);
  }
}

/** @interface */
export class NetworkContextClientInterface {
  
  /**
   * @param { !number } processId
   * @param { !boolean } async
   * @param { !Array<!mojoBase_mojom_FilePath> } filePaths
   * @param { !url_mojom_Url } destinationUrl
   * @return {!Promise<{
        netError: !number,
        files: !Array<!mojoBase_mojom_ReadOnlyFile>,
   *  }>}
   */

  onFileUploadRequested(processId, async, filePaths, destinationUrl) {}
  
  /**
   * @param { !Array<!url_mojom_Origin> } origins
   * @return {!Promise<{
        origins: !Array<!url_mojom_Origin>,
   *  }>}
   */

  onCanSendReportingReports(origins) {}
  
  /**
   * @param { !url_mojom_Origin } origin
   * @return {!Promise<{
        allowed: !boolean,
   *  }>}
   */

  onCanSendDomainReliabilityUpload(origin) {}
  
  /**
   * @return {!Promise<{
        allowed: !boolean,
   *  }>}
   */

  onCanSendSCTAuditingReport() {}
  
  /**
   */

  onNewSCTAuditingReportSent() {}
}

/**
 * @implements { NetworkContextClientInterface }
 */
export class NetworkContextClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NetworkContextClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NetworkContextClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NetworkContextClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } processId
   * @param { !boolean } async
   * @param { !Array<!mojoBase_mojom_FilePath> } filePaths
   * @param { !url_mojom_Url } destinationUrl
   * @return {!Promise<{
        netError: !number,
        files: !Array<!mojoBase_mojom_ReadOnlyFile>,
   *  }>}
   */

  onFileUploadRequested(
      processId,
      async,
      filePaths,
      destinationUrl) {
    return this.proxy.sendMessage(
        0,
        NetworkContextClient_OnFileUploadRequested_ParamsSpec.$,
        NetworkContextClient_OnFileUploadRequested_ResponseParamsSpec.$,
        [
          processId,
          async,
          filePaths,
          destinationUrl
        ],
        false);
  }

  
  /**
   * @param { !Array<!url_mojom_Origin> } origins
   * @return {!Promise<{
        origins: !Array<!url_mojom_Origin>,
   *  }>}
   */

  onCanSendReportingReports(
      origins) {
    return this.proxy.sendMessage(
        1,
        NetworkContextClient_OnCanSendReportingReports_ParamsSpec.$,
        NetworkContextClient_OnCanSendReportingReports_ResponseParamsSpec.$,
        [
          origins
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Origin } origin
   * @return {!Promise<{
        allowed: !boolean,
   *  }>}
   */

  onCanSendDomainReliabilityUpload(
      origin) {
    return this.proxy.sendMessage(
        2,
        NetworkContextClient_OnCanSendDomainReliabilityUpload_ParamsSpec.$,
        NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParamsSpec.$,
        [
          origin
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        allowed: !boolean,
   *  }>}
   */

  onCanSendSCTAuditingReport() {
    return this.proxy.sendMessage(
        3,
        NetworkContextClient_OnCanSendSCTAuditingReport_ParamsSpec.$,
        NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   */

  onNewSCTAuditingReportSent() {
    this.proxy.sendMessage(
        4,
        NetworkContextClient_OnNewSCTAuditingReportSent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NetworkContextClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetworkContextClientReceiver {
  /**
   * @param {!NetworkContextClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NetworkContextClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NetworkContextClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkContextClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NetworkContextClient_OnFileUploadRequested_ParamsSpec.$,
        NetworkContextClient_OnFileUploadRequested_ResponseParamsSpec.$,
        impl.onFileUploadRequested.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NetworkContextClient_OnCanSendReportingReports_ParamsSpec.$,
        NetworkContextClient_OnCanSendReportingReports_ResponseParamsSpec.$,
        impl.onCanSendReportingReports.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        NetworkContextClient_OnCanSendDomainReliabilityUpload_ParamsSpec.$,
        NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParamsSpec.$,
        impl.onCanSendDomainReliabilityUpload.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        NetworkContextClient_OnCanSendSCTAuditingReport_ParamsSpec.$,
        NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParamsSpec.$,
        impl.onCanSendSCTAuditingReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        NetworkContextClient_OnNewSCTAuditingReportSent_ParamsSpec.$,
        null,
        impl.onNewSCTAuditingReportSent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NetworkContextClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkContextClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NetworkContextClientRemote}
   */
  static getRemote() {
    let remote = new NetworkContextClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NetworkContextClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetworkContextClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NetworkContextClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkContextClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFileUploadRequested =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NetworkContextClient_OnFileUploadRequested_ParamsSpec.$,
        NetworkContextClient_OnFileUploadRequested_ResponseParamsSpec.$,
        this.onFileUploadRequested.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCanSendReportingReports =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NetworkContextClient_OnCanSendReportingReports_ParamsSpec.$,
        NetworkContextClient_OnCanSendReportingReports_ResponseParamsSpec.$,
        this.onCanSendReportingReports.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCanSendDomainReliabilityUpload =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        NetworkContextClient_OnCanSendDomainReliabilityUpload_ParamsSpec.$,
        NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParamsSpec.$,
        this.onCanSendDomainReliabilityUpload.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCanSendSCTAuditingReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        NetworkContextClient_OnCanSendSCTAuditingReport_ParamsSpec.$,
        NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParamsSpec.$,
        this.onCanSendSCTAuditingReport.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNewSCTAuditingReportSent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        NetworkContextClient_OnNewSCTAuditingReportSent_ParamsSpec.$,
        null,
        this.onNewSCTAuditingReportSent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContextClient_OnFileUploadRequested_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContextClient_OnFileUploadRequested_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContextClient_OnCanSendReportingReports_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContextClient_OnCanSendReportingReports_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContextClient_OnCanSendDomainReliabilityUpload_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContextClient_OnCanSendSCTAuditingReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkContextClient_OnNewSCTAuditingReportSent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    NetworkContextClient_OnFileUploadRequested_ParamsSpec.$,
    'NetworkContextClient_OnFileUploadRequested_Params',
    [
      mojo.internal.StructField(
        'processId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'async', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filePaths', 8,
        0,
        mojo.internal.Array(mojoBase_mojom_FilePathSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'destinationUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NetworkContextClient_OnFileUploadRequested_Params {
  constructor() {
    /** @type { !number } */
    this.processId;
    /** @type { !boolean } */
    this.async;
    /** @type { !Array<!mojoBase_mojom_FilePath> } */
    this.filePaths;
    /** @type { !url_mojom_Url } */
    this.destinationUrl;
  }
}



mojo.internal.Struct(
    NetworkContextClient_OnFileUploadRequested_ResponseParamsSpec.$,
    'NetworkContextClient_OnFileUploadRequested_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'files', 8,
        0,
        mojo.internal.Array(mojoBase_mojom_ReadOnlyFileSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkContextClient_OnFileUploadRequested_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.netError;
    /** @type { !Array<!mojoBase_mojom_ReadOnlyFile> } */
    this.files;
  }
}



mojo.internal.Struct(
    NetworkContextClient_OnCanSendReportingReports_ParamsSpec.$,
    'NetworkContextClient_OnCanSendReportingReports_Params',
    [
      mojo.internal.StructField(
        'origins', 0,
        0,
        mojo.internal.Array(url_mojom_OriginSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContextClient_OnCanSendReportingReports_Params {
  constructor() {
    /** @type { !Array<!url_mojom_Origin> } */
    this.origins;
  }
}



mojo.internal.Struct(
    NetworkContextClient_OnCanSendReportingReports_ResponseParamsSpec.$,
    'NetworkContextClient_OnCanSendReportingReports_ResponseParams',
    [
      mojo.internal.StructField(
        'origins', 0,
        0,
        mojo.internal.Array(url_mojom_OriginSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContextClient_OnCanSendReportingReports_ResponseParams {
  constructor() {
    /** @type { !Array<!url_mojom_Origin> } */
    this.origins;
  }
}



mojo.internal.Struct(
    NetworkContextClient_OnCanSendDomainReliabilityUpload_ParamsSpec.$,
    'NetworkContextClient_OnCanSendDomainReliabilityUpload_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContextClient_OnCanSendDomainReliabilityUpload_Params {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
  }
}



mojo.internal.Struct(
    NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParamsSpec.$,
    'NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams',
    [
      mojo.internal.StructField(
        'allowed', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.allowed;
  }
}



mojo.internal.Struct(
    NetworkContextClient_OnCanSendSCTAuditingReport_ParamsSpec.$,
    'NetworkContextClient_OnCanSendSCTAuditingReport_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContextClient_OnCanSendSCTAuditingReport_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParamsSpec.$,
    'NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams',
    [
      mojo.internal.StructField(
        'allowed', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkContextClient_OnCanSendSCTAuditingReport_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.allowed;
  }
}



mojo.internal.Struct(
    NetworkContextClient_OnNewSCTAuditingReportSent_ParamsSpec.$,
    'NetworkContextClient_OnNewSCTAuditingReportSent_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkContextClient_OnNewSCTAuditingReportSent_Params {
  constructor() {
  }
}

