// services/network/public/mojom/network_anonymization_key.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ANONYMIZATION_KEY_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ANONYMIZATION_KEY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_anonymization_key.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_anonymization_key.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/network_isolation_partition.mojom.h"
#include "services/network/public/mojom/schemeful_site.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/network_anonymization_key_mojom_traits.h"




namespace network::mojom {





class  EmptyNetworkAnonymizationKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EmptyNetworkAnonymizationKey, T>::value>;
  using DataView = EmptyNetworkAnonymizationKeyDataView;
  using Data_ = internal::EmptyNetworkAnonymizationKey_Data;

  template <typename... Args>
  static EmptyNetworkAnonymizationKeyPtr New(Args&&... args) {
    return EmptyNetworkAnonymizationKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EmptyNetworkAnonymizationKeyPtr From(const U& u) {
    return mojo::TypeConverter<EmptyNetworkAnonymizationKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EmptyNetworkAnonymizationKey>::Convert(*this);
  }


  EmptyNetworkAnonymizationKey();


  ~EmptyNetworkAnonymizationKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EmptyNetworkAnonymizationKeyPtr>
  EmptyNetworkAnonymizationKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EmptyNetworkAnonymizationKey::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EmptyNetworkAnonymizationKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EmptyNetworkAnonymizationKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EmptyNetworkAnonymizationKey_UnserializedMessageContext<
            UserType, EmptyNetworkAnonymizationKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EmptyNetworkAnonymizationKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EmptyNetworkAnonymizationKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EmptyNetworkAnonymizationKey_UnserializedMessageContext<
            UserType, EmptyNetworkAnonymizationKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EmptyNetworkAnonymizationKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  NetworkAnonymizationKey {
 public:
  using DataView = NetworkAnonymizationKeyDataView;
  using Data_ = internal::NetworkAnonymizationKey_Data;
  using Tag = Data_::NetworkAnonymizationKey_Tag;

  template <typename... Args>
  static NetworkAnonymizationKeyPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |empty|.
  static NetworkAnonymizationKeyPtr NewEmpty(
      EmptyNetworkAnonymizationKeyPtr value);
  // Construct an instance holding |non_empty|.
  static NetworkAnonymizationKeyPtr NewNonEmpty(
      NonEmptyNetworkAnonymizationKeyPtr value);

  template <typename U>
  static NetworkAnonymizationKeyPtr From(const U& u) {
    return mojo::TypeConverter<NetworkAnonymizationKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkAnonymizationKey>::Convert(*this);
  }
  ~NetworkAnonymizationKey();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  NetworkAnonymizationKey(const NetworkAnonymizationKey& other) = delete;
  NetworkAnonymizationKey& operator=(const NetworkAnonymizationKey& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = NetworkAnonymizationKeyPtr>
  NetworkAnonymizationKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, NetworkAnonymizationKey>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, NetworkAnonymizationKey>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_empty() const { return tag_ == Tag::kEmpty; }
  const EmptyNetworkAnonymizationKeyPtr& get_empty() const {
    CHECK(tag_ == Tag::kEmpty);
    return data_.empty;
  }
  EmptyNetworkAnonymizationKeyPtr& get_empty() {
    CHECK(tag_ == Tag::kEmpty);
    return data_.empty;
  }
  void set_empty(EmptyNetworkAnonymizationKeyPtr empty);

  bool is_non_empty() const { return tag_ == Tag::kNonEmpty; }
  const NonEmptyNetworkAnonymizationKeyPtr& get_non_empty() const {
    CHECK(tag_ == Tag::kNonEmpty);
    return data_.non_empty;
  }
  NonEmptyNetworkAnonymizationKeyPtr& get_non_empty() {
    CHECK(tag_ == Tag::kNonEmpty);
    return data_.non_empty;
  }
  void set_non_empty(NonEmptyNetworkAnonymizationKeyPtr non_empty);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkAnonymizationKey::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<NetworkAnonymizationKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
        EmptyNetworkAnonymizationKeyPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNonEmpty)>,
        NonEmptyNetworkAnonymizationKeyPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    EmptyNetworkAnonymizationKeyPtr empty;
    NonEmptyNetworkAnonymizationKeyPtr non_empty;
  };

  NetworkAnonymizationKey(
      std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
      EmptyNetworkAnonymizationKeyPtr value);
  NetworkAnonymizationKey(
      std::in_place_index_t<static_cast<size_t>(Tag::kNonEmpty)>,
      NonEmptyNetworkAnonymizationKeyPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  NonEmptyNetworkAnonymizationKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NonEmptyNetworkAnonymizationKey, T>::value>;
  using DataView = NonEmptyNetworkAnonymizationKeyDataView;
  using Data_ = internal::NonEmptyNetworkAnonymizationKey_Data;

  template <typename... Args>
  static NonEmptyNetworkAnonymizationKeyPtr New(Args&&... args) {
    return NonEmptyNetworkAnonymizationKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NonEmptyNetworkAnonymizationKeyPtr From(const U& u) {
    return mojo::TypeConverter<NonEmptyNetworkAnonymizationKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NonEmptyNetworkAnonymizationKey>::Convert(*this);
  }


  NonEmptyNetworkAnonymizationKey();

  NonEmptyNetworkAnonymizationKey(
      const ::net::SchemefulSite& top_frame_site,
      bool is_cross_site,
      const std::optional<::base::UnguessableToken>& nonce,
      ::net::NetworkIsolationPartition network_isolation_partition);


  ~NonEmptyNetworkAnonymizationKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NonEmptyNetworkAnonymizationKeyPtr>
  NonEmptyNetworkAnonymizationKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NonEmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NonEmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NonEmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NonEmptyNetworkAnonymizationKey::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NonEmptyNetworkAnonymizationKey::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NonEmptyNetworkAnonymizationKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NonEmptyNetworkAnonymizationKey_UnserializedMessageContext<
            UserType, NonEmptyNetworkAnonymizationKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NonEmptyNetworkAnonymizationKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NonEmptyNetworkAnonymizationKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NonEmptyNetworkAnonymizationKey_UnserializedMessageContext<
            UserType, NonEmptyNetworkAnonymizationKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NonEmptyNetworkAnonymizationKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::SchemefulSite top_frame_site;
  
  bool is_cross_site;
  
  std::optional<::base::UnguessableToken> nonce;
  
  ::net::NetworkIsolationPartition network_isolation_partition;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NonEmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NonEmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NonEmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NonEmptyNetworkAnonymizationKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
NetworkAnonymizationKeyPtr NetworkAnonymizationKey::Clone() const {
  switch (tag_) {
    case Tag::kEmpty:
      return NewEmpty(
          mojo::Clone(data_.empty));
    case Tag::kNonEmpty:
      return NewNonEmpty(
          mojo::Clone(data_.non_empty));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, NetworkAnonymizationKey>::value>::type*>
bool NetworkAnonymizationKey::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kEmpty:
      return mojo::Equals(data_.empty, other.data_.empty);
    case Tag::kNonEmpty:
      return mojo::Equals(data_.non_empty, other.data_.non_empty);
  }

  return false;
}
template <typename StructPtrType>
EmptyNetworkAnonymizationKeyPtr EmptyNetworkAnonymizationKey::Clone() const {
  return New(
  );
}

template <typename T, EmptyNetworkAnonymizationKey::EnableIfSame<T>*>
bool EmptyNetworkAnonymizationKey::Equals(const T& other_struct) const {
  return true;
}

template <typename T, EmptyNetworkAnonymizationKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
NonEmptyNetworkAnonymizationKeyPtr NonEmptyNetworkAnonymizationKey::Clone() const {
  return New(
      mojo::Clone(top_frame_site),
      mojo::Clone(is_cross_site),
      mojo::Clone(nonce),
      mojo::Clone(network_isolation_partition)
  );
}

template <typename T, NonEmptyNetworkAnonymizationKey::EnableIfSame<T>*>
bool NonEmptyNetworkAnonymizationKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top_frame_site, other_struct.top_frame_site))
    return false;
  if (!mojo::Equals(this->is_cross_site, other_struct.is_cross_site))
    return false;
  if (!mojo::Equals(this->nonce, other_struct.nonce))
    return false;
  if (!mojo::Equals(this->network_isolation_partition, other_struct.network_isolation_partition))
    return false;
  return true;
}

template <typename T, NonEmptyNetworkAnonymizationKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.top_frame_site < rhs.top_frame_site)
    return true;
  if (rhs.top_frame_site < lhs.top_frame_site)
    return false;
  if (lhs.is_cross_site < rhs.is_cross_site)
    return true;
  if (rhs.is_cross_site < lhs.is_cross_site)
    return false;
  if (lhs.nonce < rhs.nonce)
    return true;
  if (rhs.nonce < lhs.nonce)
    return false;
  if (lhs.network_isolation_partition < rhs.network_isolation_partition)
    return true;
  if (rhs.network_isolation_partition < lhs.network_isolation_partition)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::EmptyNetworkAnonymizationKey::DataView,
                                         ::network::mojom::EmptyNetworkAnonymizationKeyPtr> {
  static bool IsNull(const ::network::mojom::EmptyNetworkAnonymizationKeyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::EmptyNetworkAnonymizationKeyPtr* output) { output->reset(); }

  static bool Read(::network::mojom::EmptyNetworkAnonymizationKey::DataView input, ::network::mojom::EmptyNetworkAnonymizationKeyPtr* output);
};


template <>
struct  StructTraits<::network::mojom::NonEmptyNetworkAnonymizationKey::DataView,
                                         ::network::mojom::NonEmptyNetworkAnonymizationKeyPtr> {
  static bool IsNull(const ::network::mojom::NonEmptyNetworkAnonymizationKeyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::NonEmptyNetworkAnonymizationKeyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::NonEmptyNetworkAnonymizationKey::top_frame_site)& top_frame_site(
      const ::network::mojom::NonEmptyNetworkAnonymizationKeyPtr& input) {
    return input->top_frame_site;
  }

  static decltype(::network::mojom::NonEmptyNetworkAnonymizationKey::is_cross_site) is_cross_site(
      const ::network::mojom::NonEmptyNetworkAnonymizationKeyPtr& input) {
    return input->is_cross_site;
  }

  static const decltype(::network::mojom::NonEmptyNetworkAnonymizationKey::nonce)& nonce(
      const ::network::mojom::NonEmptyNetworkAnonymizationKeyPtr& input) {
    return input->nonce;
  }

  static decltype(::network::mojom::NonEmptyNetworkAnonymizationKey::network_isolation_partition) network_isolation_partition(
      const ::network::mojom::NonEmptyNetworkAnonymizationKeyPtr& input) {
    return input->network_isolation_partition;
  }

  static bool Read(::network::mojom::NonEmptyNetworkAnonymizationKey::DataView input, ::network::mojom::NonEmptyNetworkAnonymizationKeyPtr* output);
};


template <>
struct  UnionTraits<::network::mojom::NetworkAnonymizationKey::DataView,
                                        ::network::mojom::NetworkAnonymizationKeyPtr> {
  static bool IsNull(const ::network::mojom::NetworkAnonymizationKeyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::NetworkAnonymizationKeyPtr* output) { output->reset(); }

  static ::network::mojom::NetworkAnonymizationKey::Tag GetTag(const ::network::mojom::NetworkAnonymizationKeyPtr& input) {
    return input->which();
  }

  static const ::network::mojom::EmptyNetworkAnonymizationKeyPtr& empty(const ::network::mojom::NetworkAnonymizationKeyPtr& input) {
    return input->get_empty();
  }

  static const ::network::mojom::NonEmptyNetworkAnonymizationKeyPtr& non_empty(const ::network::mojom::NetworkAnonymizationKeyPtr& input) {
    return input->get_non_empty();
  }

  static bool Read(::network::mojom::NetworkAnonymizationKey::DataView input, ::network::mojom::NetworkAnonymizationKeyPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ANONYMIZATION_KEY_MOJOM_H_