// services/network/public/mojom/mdns_responder.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.MdnsResponderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.MdnsResponder.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.MdnsResponderInterface }
 */
network.mojom.MdnsResponderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.MdnsResponderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.MdnsResponderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.MdnsResponderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.IPAddress } address
   * @return {!Promise<{
        name: !string,
        announcementScheduled: !boolean,
   *  }>}
   */

  createNameForAddress(
      address) {
    return this.proxy.sendMessage(
        0,
        network.mojom.MdnsResponder_CreateNameForAddress_ParamsSpec.$,
        network.mojom.MdnsResponder_CreateNameForAddress_ResponseParamsSpec.$,
        [
          address
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.IPAddress } address
   * @return {!Promise<{
        removed: !boolean,
        goodbyeScheduled: !boolean,
   *  }>}
   */

  removeNameForAddress(
      address) {
    return this.proxy.sendMessage(
        1,
        network.mojom.MdnsResponder_RemoveNameForAddress_ParamsSpec.$,
        network.mojom.MdnsResponder_RemoveNameForAddress_ResponseParamsSpec.$,
        [
          address
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MdnsResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.MdnsResponderReceiver = class {
  /**
   * @param {!network.mojom.MdnsResponderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.MdnsResponderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.MdnsResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.MdnsResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.MdnsResponder_CreateNameForAddress_ParamsSpec.$,
        network.mojom.MdnsResponder_CreateNameForAddress_ResponseParamsSpec.$,
        impl.createNameForAddress.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.MdnsResponder_RemoveNameForAddress_ParamsSpec.$,
        network.mojom.MdnsResponder_RemoveNameForAddress_ResponseParamsSpec.$,
        impl.removeNameForAddress.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.MdnsResponder = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.MdnsResponder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.MdnsResponderRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.MdnsResponderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MdnsResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.MdnsResponderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.MdnsResponderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.MdnsResponderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createNameForAddress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.MdnsResponder_CreateNameForAddress_ParamsSpec.$,
        network.mojom.MdnsResponder_CreateNameForAddress_ResponseParamsSpec.$,
        this.createNameForAddress.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeNameForAddress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.MdnsResponder_RemoveNameForAddress_ParamsSpec.$,
        network.mojom.MdnsResponder_RemoveNameForAddress_ResponseParamsSpec.$,
        this.removeNameForAddress.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.MdnsResponder_CreateNameForAddress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.MdnsResponder_CreateNameForAddress_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.MdnsResponder_RemoveNameForAddress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.MdnsResponder_RemoveNameForAddress_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.MdnsResponder_CreateNameForAddress_ParamsSpec.$,
    'MdnsResponder_CreateNameForAddress_Params',
    [
      mojo.internal.StructField(
        'address', 0,
        0,
        network.mojom.IPAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.MdnsResponder_CreateNameForAddress_Params = class {
  constructor() {
    /** @export { !network.mojom.IPAddress } */
    this.address;
  }
};



mojo.internal.Struct(
    network.mojom.MdnsResponder_CreateNameForAddress_ResponseParamsSpec.$,
    'MdnsResponder_CreateNameForAddress_ResponseParams',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'announcementScheduled', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.MdnsResponder_CreateNameForAddress_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !boolean } */
    this.announcementScheduled;
  }
};



mojo.internal.Struct(
    network.mojom.MdnsResponder_RemoveNameForAddress_ParamsSpec.$,
    'MdnsResponder_RemoveNameForAddress_Params',
    [
      mojo.internal.StructField(
        'address', 0,
        0,
        network.mojom.IPAddressSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.MdnsResponder_RemoveNameForAddress_Params = class {
  constructor() {
    /** @export { !network.mojom.IPAddress } */
    this.address;
  }
};



mojo.internal.Struct(
    network.mojom.MdnsResponder_RemoveNameForAddress_ResponseParamsSpec.$,
    'MdnsResponder_RemoveNameForAddress_ResponseParams',
    [
      mojo.internal.StructField(
        'removed', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'goodbyeScheduled', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.MdnsResponder_RemoveNameForAddress_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.removed;
    /** @export { !boolean } */
    this.goodbyeScheduled;
  }
};

