// services/network/public/mojom/link_header.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_LINK_HEADER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_LINK_HEADER_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/link_header.mojom-shared-internal.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "services/network/public/mojom/link_header.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::LinkRelAttribute, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::LinkAsAttribute, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CrossOriginAttribute, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::LinkHeaderDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::LinkHeaderDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::LinkHeader_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::href(input)) in_href = Traits::href(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->href)::BaseType> href_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_href,
        href_fragment);

      fragment->href.Set(
          href_fragment.is_null() ? nullptr : href_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->href.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null href in LinkHeader struct");

      
      mojo::internal::Serialize<::network::mojom::LinkRelAttribute>(
        Traits::rel(input),
        &fragment->rel);

      
      mojo::internal::Serialize<::network::mojom::LinkAsAttribute>(
        Traits::as(input),
        &fragment->as);

      
      mojo::internal::Serialize<::network::mojom::CrossOriginAttribute>(
        Traits::cross_origin(input),
        &fragment->cross_origin);

      
      mojo::internal::Serialize<::network::mojom::FetchPriorityAttribute>(
        Traits::fetch_priority(input),
        &fragment->fetch_priority);

      decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mime_type,
        mime_type_fragment);

      fragment->mime_type.Set(
          mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_LINK_HEADER_MOJOM_SEND_VALIDATION_H_