// services/network/public/mojom/integrity_metadata.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_INTEGRITY_METADATA_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_INTEGRITY_METADATA_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/integrity_metadata.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/integrity_metadata.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/integrity_metadata.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/integrity_algorithm.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "services/network/public/cpp/integrity_metadata_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {








class BLINK_PLATFORM_EXPORT IntegrityMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IntegrityMetadata, T>::value>;
  using DataView = IntegrityMetadataDataView;
  using Data_ = internal::IntegrityMetadata_Data;

  template <typename... Args>
  static IntegrityMetadataPtr New(Args&&... args) {
    return IntegrityMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IntegrityMetadataPtr From(const U& u) {
    return mojo::TypeConverter<IntegrityMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IntegrityMetadata>::Convert(*this);
  }


  IntegrityMetadata();

  IntegrityMetadata(
      ::network::mojom::blink::IntegrityAlgorithm algorithm,
      ::blink::Vector<uint8_t> value);


  ~IntegrityMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IntegrityMetadataPtr>
  IntegrityMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IntegrityMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IntegrityMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IntegrityMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IntegrityMetadata::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IntegrityMetadata::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IntegrityMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IntegrityMetadata_UnserializedMessageContext<
            UserType, IntegrityMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IntegrityMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IntegrityMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IntegrityMetadata_UnserializedMessageContext<
            UserType, IntegrityMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IntegrityMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::mojom::blink::IntegrityAlgorithm algorithm;
  
  ::blink::Vector<uint8_t> value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IntegrityMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IntegrityMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IntegrityMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IntegrityMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
IntegrityMetadataPtr IntegrityMetadata::Clone() const {
  return New(
      mojo::Clone(algorithm),
      mojo::Clone(value)
  );
}

template <typename T, IntegrityMetadata::EnableIfSame<T>*>
bool IntegrityMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->algorithm, other_struct.algorithm))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, IntegrityMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.algorithm < rhs.algorithm)
    return true;
  if (rhs.algorithm < lhs.algorithm)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::IntegrityMetadata::DataView,
                                         ::network::mojom::blink::IntegrityMetadataPtr> {
  static bool IsNull(const ::network::mojom::blink::IntegrityMetadataPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::IntegrityMetadataPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::IntegrityMetadata::algorithm) algorithm(
      const ::network::mojom::blink::IntegrityMetadataPtr& input) {
    return input->algorithm;
  }

  static const decltype(::network::mojom::blink::IntegrityMetadata::value)& value(
      const ::network::mojom::blink::IntegrityMetadataPtr& input) {
    return input->value;
  }

  static bool Read(::network::mojom::blink::IntegrityMetadata::DataView input, ::network::mojom::blink::IntegrityMetadataPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_INTEGRITY_METADATA_MOJOM_BLINK_H_