// services/network/public/mojom/http_cache_backend_file_operations.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_error.mojom-shared.h"
#include "mojo/public/mojom/base/file_info.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::HttpCacheBackendOpenFileFlags>
    : public mojo::internal::EnumHashImpl<::network::mojom::HttpCacheBackendOpenFileFlags> {};

template <>
struct hash<::network::mojom::HttpCacheBackendDeleteFileMode>
    : public mojo::internal::EnumHashImpl<::network::mojom::HttpCacheBackendDeleteFileMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HttpCacheBackendOpenFileFlags, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::HttpCacheBackendOpenFileFlags, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::HttpCacheBackendOpenFileFlags>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HttpCacheBackendDeleteFileMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::HttpCacheBackendDeleteFileMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::HttpCacheBackendDeleteFileMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::FileEnumerationEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FileEnumerationEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FileEnumerationEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path,
      path_fragment);

    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in FileEnumerationEntry struct");

    fragment->size = Traits::size(input);

    decltype(Traits::last_accessed(input)) in_last_accessed = Traits::last_accessed(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_accessed)::BaseType> last_accessed_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_accessed,
      last_accessed_fragment);

    fragment->last_accessed.Set(
        last_accessed_fragment.is_null() ? nullptr : last_accessed_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_accessed.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_accessed in FileEnumerationEntry struct");

    decltype(Traits::last_modified(input)) in_last_modified = Traits::last_modified(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_modified)::BaseType> last_modified_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_modified,
      last_modified_fragment);

    fragment->last_modified.Set(
        last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_modified.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_modified in FileEnumerationEntry struct");
  }

  static bool Deserialize(::network::mojom::internal::FileEnumerationEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::FileEnumerationEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void FileEnumerationEntryDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void FileEnumerationEntryDataView::GetLastAccessedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_accessed.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void FileEnumerationEntryDataView::GetLastModifiedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_modified.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::HttpCacheBackendOpenFileFlags> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::HttpCacheBackendOpenFileFlags value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::HttpCacheBackendDeleteFileMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::HttpCacheBackendDeleteFileMode value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_SHARED_H_