// services/network/public/mojom/http_cache_backend_file_operations.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_error.mojom-shared.h"
#include "mojo/public/mojom/base/file_info.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace network::mojom {
class FileEnumerationEntryDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::FileEnumerationEntryDataView> {
  using Data = ::network::mojom::internal::FileEnumerationEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class HttpCacheBackendOpenFileFlags : int32_t {
  
  kOpenAndRead = 33,
  
  kCreateAndWrite = 66,
  
  kOpenReadWriteWinShareDelete = 32865,
  
  kCreateReadWriteWinShareDelete = 32866,
  
  kCreateAlwaysWriteWinShareDelete = 32840,
  
  kOpenReadWinShareDeleteWinSequentialScan = 557089,
  kMinValue = 33,
  kMaxValue = 557089,
};

 std::ostream& operator<<(std::ostream& os, HttpCacheBackendOpenFileFlags value);
inline bool IsKnownEnumValue(HttpCacheBackendOpenFileFlags value) {
  return internal::HttpCacheBackendOpenFileFlags_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HttpCacheBackendDeleteFileMode : int32_t {
  
  kDefault = 0,
  
  kEnsureImmediateAvailability = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, HttpCacheBackendDeleteFileMode value);
inline bool IsKnownEnumValue(HttpCacheBackendDeleteFileMode value) {
  return internal::HttpCacheBackendDeleteFileMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FileEnumeratorInterfaceBase {};

using FileEnumeratorPtrDataView =
    mojo::InterfacePtrDataView<FileEnumeratorInterfaceBase>;
using FileEnumeratorRequestDataView =
    mojo::InterfaceRequestDataView<FileEnumeratorInterfaceBase>;
using FileEnumeratorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileEnumeratorInterfaceBase>;
using FileEnumeratorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileEnumeratorInterfaceBase>;
class HttpCacheBackendFileOperationsInterfaceBase {};

using HttpCacheBackendFileOperationsPtrDataView =
    mojo::InterfacePtrDataView<HttpCacheBackendFileOperationsInterfaceBase>;
using HttpCacheBackendFileOperationsRequestDataView =
    mojo::InterfaceRequestDataView<HttpCacheBackendFileOperationsInterfaceBase>;
using HttpCacheBackendFileOperationsAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HttpCacheBackendFileOperationsInterfaceBase>;
using HttpCacheBackendFileOperationsAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HttpCacheBackendFileOperationsInterfaceBase>;
class HttpCacheBackendFileOperationsFactoryInterfaceBase {};

using HttpCacheBackendFileOperationsFactoryPtrDataView =
    mojo::InterfacePtrDataView<HttpCacheBackendFileOperationsFactoryInterfaceBase>;
using HttpCacheBackendFileOperationsFactoryRequestDataView =
    mojo::InterfaceRequestDataView<HttpCacheBackendFileOperationsFactoryInterfaceBase>;
using HttpCacheBackendFileOperationsFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HttpCacheBackendFileOperationsFactoryInterfaceBase>;
using HttpCacheBackendFileOperationsFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HttpCacheBackendFileOperationsFactoryInterfaceBase>;


class FileEnumerationEntryDataView {
 public:
  FileEnumerationEntryDataView() = default;

  FileEnumerationEntryDataView(
      internal::FileEnumerationEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  int64_t size() const {
    return data_->size;
  }
  inline void GetLastAccessedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastAccessed(UserType* output) {
    
    auto* pointer = data_->last_accessed.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastModifiedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastModified(UserType* output) {
    
    auto* pointer = data_->last_modified.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileEnumerationEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_DATA_VIEW_H_