// services/network/public/mojom/host_resolver.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/host_resolver.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/host_resolver.mojom-params-data.h"
#include "services/network/public/mojom/host_resolver.mojom-shared-message-ids.h"

#include "services/network/public/mojom/host_resolver.mojom-blink-import-headers.h"
#include "services/network/public/mojom/host_resolver.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
DnsOverHttpsServerConfig::DnsOverHttpsServerConfig()
    : server_template(),
      endpoints() {}

DnsOverHttpsServerConfig::DnsOverHttpsServerConfig(
    const ::blink::String& server_template_in,
    ::blink::Vector<::blink::Vector<::net::IPAddress>> endpoints_in)
    : server_template(std::move(server_template_in)),
      endpoints(std::move(endpoints_in)) {}

DnsOverHttpsServerConfig::~DnsOverHttpsServerConfig() = default;

void DnsOverHttpsServerConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_template"), this->server_template,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "endpoints"), this->endpoints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::Vector<::net::IPAddress>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DnsOverHttpsServerConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DnsOverHttpsConfig::DnsOverHttpsConfig()
    : servers() {}

DnsOverHttpsConfig::DnsOverHttpsConfig(
    ::blink::Vector<DnsOverHttpsServerConfigPtr> servers_in)
    : servers(std::move(servers_in)) {}

DnsOverHttpsConfig::~DnsOverHttpsConfig() = default;

void DnsOverHttpsConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "servers"), this->servers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<DnsOverHttpsServerConfigPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DnsOverHttpsConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DnsConfigOverrides::DnsConfigOverrides()
    : nameservers(),
      search(),
      append_to_multi_label_name(DnsConfigOverrides_Tristate::NO_OVERRIDE),
      ndots(-1),
      fallback_period(),
      attempts(-1),
      rotate(DnsConfigOverrides_Tristate::NO_OVERRIDE),
      use_local_ipv6(DnsConfigOverrides_Tristate::NO_OVERRIDE),
      dns_over_https_config(),
      secure_dns_mode(OptionalSecureDnsMode::NO_OVERRIDE),
      allow_dns_over_https_upgrade(DnsConfigOverrides_Tristate::NO_OVERRIDE),
      clear_hosts(false) {}

DnsConfigOverrides::DnsConfigOverrides(
    std::optional<::blink::Vector<::net::IPEndPoint>> nameservers_in,
    std::optional<::blink::Vector<::blink::String>> search_in,
    DnsConfigOverrides::Tristate append_to_multi_label_name_in,
    int8_t ndots_in,
    std::optional<::base::TimeDelta> fallback_period_in,
    int32_t attempts_in,
    DnsConfigOverrides::Tristate rotate_in,
    DnsConfigOverrides::Tristate use_local_ipv6_in,
    DnsOverHttpsConfigPtr dns_over_https_config_in,
    OptionalSecureDnsMode secure_dns_mode_in,
    DnsConfigOverrides::Tristate allow_dns_over_https_upgrade_in,
    bool clear_hosts_in)
    : nameservers(std::move(nameservers_in)),
      search(std::move(search_in)),
      append_to_multi_label_name(std::move(append_to_multi_label_name_in)),
      ndots(std::move(ndots_in)),
      fallback_period(std::move(fallback_period_in)),
      attempts(std::move(attempts_in)),
      rotate(std::move(rotate_in)),
      use_local_ipv6(std::move(use_local_ipv6_in)),
      dns_over_https_config(std::move(dns_over_https_config_in)),
      secure_dns_mode(std::move(secure_dns_mode_in)),
      allow_dns_over_https_upgrade(std::move(allow_dns_over_https_upgrade_in)),
      clear_hosts(std::move(clear_hosts_in)) {}

DnsConfigOverrides::~DnsConfigOverrides() = default;

void DnsConfigOverrides::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nameservers"), this->nameservers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::net::IPEndPoint>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "search"), this->search,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<::blink::String>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "append_to_multi_label_name"), this->append_to_multi_label_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DnsConfigOverrides::Tristate>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ndots"), this->ndots,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fallback_period"), this->fallback_period,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attempts"), this->attempts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rotate"), this->rotate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DnsConfigOverrides::Tristate>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_local_ipv6"), this->use_local_ipv6,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DnsConfigOverrides::Tristate>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dns_over_https_config"), this->dns_over_https_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DnsOverHttpsConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure_dns_mode"), this->secure_dns_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalSecureDnsMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_dns_over_https_upgrade"), this->allow_dns_over_https_upgrade,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DnsConfigOverrides::Tristate>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clear_hosts"), this->clear_hosts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DnsConfigOverrides::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResolveHostParameters::ResolveHostParameters()
    : dns_query_type(mojo::internal::ConvertEnumValue<DnsQueryType, ::net::DnsQueryType>(DnsQueryType::UNSPECIFIED)),
      initial_priority(mojo::internal::ConvertEnumValue<::network::mojom::blink::RequestPriority, ::net::RequestPriority>(::network::mojom::blink::RequestPriority::kLowest)),
      source(ResolveHostParameters_Source::ANY),
      cache_usage(ResolveHostParameters_CacheUsage::ALLOWED),
      control_handle(),
      include_canonical_name(false),
      loopback_only(false),
      is_speculative(false),
      secure_dns_policy(SecureDnsPolicy::ALLOW),
      purpose(ResolveHostParameters_Purpose::kUnspecified) {}

ResolveHostParameters::ResolveHostParameters(
    ::net::DnsQueryType dns_query_type_in,
    ::net::RequestPriority initial_priority_in,
    ResolveHostParameters::Source source_in,
    ResolveHostParameters::CacheUsage cache_usage_in,
    ::mojo::PendingReceiver<ResolveHostHandle> control_handle_in,
    bool include_canonical_name_in,
    bool loopback_only_in,
    bool is_speculative_in,
    SecureDnsPolicy secure_dns_policy_in,
    ResolveHostParameters::Purpose purpose_in)
    : dns_query_type(std::move(dns_query_type_in)),
      initial_priority(std::move(initial_priority_in)),
      source(std::move(source_in)),
      cache_usage(std::move(cache_usage_in)),
      control_handle(std::move(control_handle_in)),
      include_canonical_name(std::move(include_canonical_name_in)),
      loopback_only(std::move(loopback_only_in)),
      is_speculative(std::move(is_speculative_in)),
      secure_dns_policy(std::move(secure_dns_policy_in)),
      purpose(std::move(purpose_in)) {}

ResolveHostParameters::~ResolveHostParameters() = default;

void ResolveHostParameters::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dns_query_type"), this->dns_query_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::DnsQueryType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_priority"), this->initial_priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::RequestPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResolveHostParameters::Source>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_usage"), this->cache_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResolveHostParameters::CacheUsage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "control_handle"), this->control_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<ResolveHostHandle>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_canonical_name"), this->include_canonical_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "loopback_only"), this->loopback_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_speculative"), this->is_speculative,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure_dns_policy"), this->secure_dns_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SecureDnsPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "purpose"), this->purpose,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResolveHostParameters::Purpose>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResolveHostParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HostResolverHostPtr
HostResolverHost::NewSchemeHostPort(
    const ::url::SchemeHostPort& value) {
  return HostResolverHostPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSchemeHostPort)>,
      std::move(value));
}

HostResolverHostPtr
HostResolverHost::NewHostPortPair(
    const ::net::HostPortPair& value) {
  return HostResolverHostPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kHostPortPair)>,
      std::move(value));
}

HostResolverHost::HostResolverHost(
    std::in_place_index_t<static_cast<size_t>(Tag::kSchemeHostPort)>,
    const ::url::SchemeHostPort& value)
    : tag_(Tag::kSchemeHostPort),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSchemeHostPort)>,
            std::move(value)) {}

HostResolverHost::HostResolverHost(
    std::in_place_index_t<static_cast<size_t>(Tag::kHostPortPair)>,
    const ::net::HostPortPair& value)
    : tag_(Tag::kHostPortPair),
      data_(std::in_place_index<static_cast<size_t>(Tag::kHostPortPair)>,
            std::move(value)) {}
HostResolverHost::~HostResolverHost() {
  DestroyActive();
}

void HostResolverHost::set_scheme_host_port(const ::url::SchemeHostPort& scheme_host_port) {
  if (tag_ == Tag::kSchemeHostPort) {
    data_.scheme_host_port = std::move(scheme_host_port);
  } else {
    DestroyActive();
    tag_ = Tag::kSchemeHostPort;
    new (&data_.scheme_host_port) ::url::SchemeHostPort(
        std::move(scheme_host_port));
  }
}

void HostResolverHost::set_host_port_pair(const ::net::HostPortPair& host_port_pair) {
  if (tag_ == Tag::kHostPortPair) {
    data_.host_port_pair = std::move(host_port_pair);
  } else {
    DestroyActive();
    tag_ = Tag::kHostPortPair;
    new (&data_.host_port_pair) ::net::HostPortPair(
        std::move(host_port_pair));
  }
}


HostResolverHost::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSchemeHostPort)>,
    const ::url::SchemeHostPort& value)
    : scheme_host_port(std::move(value)) {}

HostResolverHost::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kHostPortPair)>,
    const ::net::HostPortPair& value)
    : host_port_pair(std::move(value)) {}

void HostResolverHost::DestroyActive() {
  switch (tag_) {

    case Tag::kSchemeHostPort:
      std::destroy_at(&data_.scheme_host_port);
      break;
    case Tag::kHostPortPair:
      std::destroy_at(&data_.host_port_pair);
      break;
  }
}

bool HostResolverHost::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

ResolveHostHandle::IPCStableHashFunction ResolveHostHandle::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ResolveHostHandle>(message.name())) {
    case messages::ResolveHostHandle::kCancel: {
      return &ResolveHostHandle::Cancel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ResolveHostHandle::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ResolveHostHandle>(message.name())) {
      case messages::ResolveHostHandle::kCancel:
            return "Receive network::mojom::ResolveHostHandle::Cancel";
    }
  } else {
    switch (static_cast<messages::ResolveHostHandle>(message.name())) {
      case messages::ResolveHostHandle::kCancel:
            return "Receive reply network::mojom::ResolveHostHandle::Cancel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ResolveHostHandle::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8a7e58d3;  // IPCStableHash for network::mojom::ResolveHostHandle::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ResolveHostHandleProxy::ResolveHostHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResolveHostHandleProxy::Cancel(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ResolveHostHandle::Cancel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResolveHostHandle::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ResolveHostHandle_Cancel_Params_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResolveHostHandle::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ResolveHostHandleStubDispatch::Accept(
    ResolveHostHandle* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ResolveHostHandle>(message->header()->name)) {
    case messages::ResolveHostHandle::kCancel: {
      DCHECK(message->is_serialized());
      internal::ResolveHostHandle_Cancel_Params_Data* params =
          reinterpret_cast<internal::ResolveHostHandle_Cancel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ResolveHostHandle.0
      bool success = true;
      int32_t p_result{};
      ResolveHostHandle_Cancel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_result = input_data_view.result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResolveHostHandle::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        
        std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool ResolveHostHandleStubDispatch::AcceptWithResponder(
    ResolveHostHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ResolveHostHandle>(message->header()->name)) {
    case messages::ResolveHostHandle::kCancel: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kResolveHostHandleValidationInfo[] = {
    { &internal::ResolveHostHandle_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool ResolveHostHandleRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::ResolveHostHandle::Name_,
    kResolveHostHandleValidationInfo);
}

// The declaration includes the definition on other builds.

ResolveHostClient::IPCStableHashFunction ResolveHostClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ResolveHostClient>(message.name())) {
    case messages::ResolveHostClient::kOnComplete: {
      return &ResolveHostClient::OnComplete_Sym::IPCStableHash;
    }
    case messages::ResolveHostClient::kOnTextResults: {
      return &ResolveHostClient::OnTextResults_Sym::IPCStableHash;
    }
    case messages::ResolveHostClient::kOnHostnameResults: {
      return &ResolveHostClient::OnHostnameResults_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ResolveHostClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ResolveHostClient>(message.name())) {
      case messages::ResolveHostClient::kOnComplete:
            return "Receive network::mojom::ResolveHostClient::OnComplete";
      case messages::ResolveHostClient::kOnTextResults:
            return "Receive network::mojom::ResolveHostClient::OnTextResults";
      case messages::ResolveHostClient::kOnHostnameResults:
            return "Receive network::mojom::ResolveHostClient::OnHostnameResults";
    }
  } else {
    switch (static_cast<messages::ResolveHostClient>(message.name())) {
      case messages::ResolveHostClient::kOnComplete:
            return "Receive reply network::mojom::ResolveHostClient::OnComplete";
      case messages::ResolveHostClient::kOnTextResults:
            return "Receive reply network::mojom::ResolveHostClient::OnTextResults";
      case messages::ResolveHostClient::kOnHostnameResults:
            return "Receive reply network::mojom::ResolveHostClient::OnHostnameResults";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ResolveHostClient::OnComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x52f42713;  // IPCStableHash for network::mojom::ResolveHostClient::OnComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ResolveHostClient::OnTextResults_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6db78bbf;  // IPCStableHash for network::mojom::ResolveHostClient::OnTextResults
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ResolveHostClient::OnHostnameResults_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe4a590f6;  // IPCStableHash for network::mojom::ResolveHostClient::OnHostnameResults
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ResolveHostClientProxy::ResolveHostClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResolveHostClientProxy::OnComplete(
    int32_t in_result, ::network::mojom::blink::ResolveErrorInfoPtr in_resolve_error_info, ::network::mojom::blink::AddressListPtr in_resolved_addresses, ::blink::Vector<::network::mojom::blink::HostResolverEndpointResultPtr> in_alternative_endpoints) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ResolveHostClient::OnComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resolve_error_info"), in_resolve_error_info,
                        "<value of type ::network::mojom::blink::ResolveErrorInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resolved_addresses"), in_resolved_addresses,
                        "<value of type ::network::mojom::blink::AddressListPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("alternative_endpoints"), in_alternative_endpoints,
                        "<value of type ::blink::Vector<::network::mojom::blink::HostResolverEndpointResultPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResolveHostClient::kOnComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ResolveHostClient_OnComplete_Params_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->resolve_error_info)::BaseType> resolve_error_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ResolveErrorInfoDataView>(
    in_resolve_error_info,
    resolve_error_info_fragment);

  params->resolve_error_info.Set(
      resolve_error_info_fragment.is_null() ? nullptr : resolve_error_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resolve_error_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resolve_error_info in ResolveHostClient.OnComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->resolved_addresses)::BaseType> resolved_addresses_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::AddressListDataView>(
    in_resolved_addresses,
    resolved_addresses_fragment);

  params->resolved_addresses.Set(
      resolved_addresses_fragment.is_null() ? nullptr : resolved_addresses_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resolved_addresses.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resolved_addresses in ResolveHostClient.OnComplete request");
  mojo::internal::MessageFragment<
      typename decltype(params->alternative_endpoints)::BaseType>
      alternative_endpoints_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& alternative_endpoints_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HostResolverEndpointResultDataView>>(
    in_alternative_endpoints,
    alternative_endpoints_fragment,
    &alternative_endpoints_validate_params);

  params->alternative_endpoints.Set(
      alternative_endpoints_fragment.is_null() ? nullptr : alternative_endpoints_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->alternative_endpoints.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null alternative_endpoints in ResolveHostClient.OnComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResolveHostClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ResolveHostClientProxy::OnTextResults(
    const ::blink::Vector<::blink::String>& in_text_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ResolveHostClient::OnTextResults", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_results"), in_text_results,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResolveHostClient::kOnTextResults), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ResolveHostClient_OnTextResults_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text_results)::BaseType>
      text_results_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& text_results_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_text_results,
    text_results_fragment,
    &text_results_validate_params);

  params->text_results.Set(
      text_results_fragment.is_null() ? nullptr : text_results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text_results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text_results in ResolveHostClient.OnTextResults request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResolveHostClient::Name_);
  message.set_method_name("OnTextResults");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ResolveHostClientProxy::OnHostnameResults(
    const ::blink::Vector<::net::HostPortPair>& in_hosts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ResolveHostClient::OnHostnameResults", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hosts"), in_hosts,
                        "<value of type const ::blink::Vector<::net::HostPortPair>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ResolveHostClient::kOnHostnameResults), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ResolveHostClient_OnHostnameResults_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hosts)::BaseType>
      hosts_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& hosts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HostPortPairDataView>>(
    in_hosts,
    hosts_fragment,
    &hosts_validate_params);

  params->hosts.Set(
      hosts_fragment.is_null() ? nullptr : hosts_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hosts.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hosts in ResolveHostClient.OnHostnameResults request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResolveHostClient::Name_);
  message.set_method_name("OnHostnameResults");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ResolveHostClientStubDispatch::Accept(
    ResolveHostClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ResolveHostClient>(message->header()->name)) {
    case messages::ResolveHostClient::kOnComplete: {
      DCHECK(message->is_serialized());
      internal::ResolveHostClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::ResolveHostClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ResolveHostClient.0
      bool success = true;
      int32_t p_result{};
      ::network::mojom::blink::ResolveErrorInfoPtr p_resolve_error_info{};
      ::network::mojom::blink::AddressListPtr p_resolved_addresses{};
      ::blink::Vector<::network::mojom::blink::HostResolverEndpointResultPtr> p_alternative_endpoints{};
      ResolveHostClient_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_result = input_data_view.result();
      if (success && !input_data_view.ReadResolveErrorInfo(&p_resolve_error_info))
        success = false;
      if (success && !input_data_view.ReadResolvedAddresses(&p_resolved_addresses))
        success = false;
      if (success && !input_data_view.ReadAlternativeEndpoints(&p_alternative_endpoints))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResolveHostClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(        
        std::move(p_result), 
        std::move(p_resolve_error_info), 
        std::move(p_resolved_addresses), 
        std::move(p_alternative_endpoints));
      return true;
    }
    case messages::ResolveHostClient::kOnTextResults: {
      DCHECK(message->is_serialized());
      internal::ResolveHostClient_OnTextResults_Params_Data* params =
          reinterpret_cast<internal::ResolveHostClient_OnTextResults_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ResolveHostClient.1
      bool success = true;
      ::blink::Vector<::blink::String> p_text_results{};
      ResolveHostClient_OnTextResults_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTextResults(&p_text_results))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResolveHostClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTextResults(        
        std::move(p_text_results));
      return true;
    }
    case messages::ResolveHostClient::kOnHostnameResults: {
      DCHECK(message->is_serialized());
      internal::ResolveHostClient_OnHostnameResults_Params_Data* params =
          reinterpret_cast<internal::ResolveHostClient_OnHostnameResults_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ResolveHostClient.2
      bool success = true;
      ::blink::Vector<::net::HostPortPair> p_hosts{};
      ResolveHostClient_OnHostnameResults_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHosts(&p_hosts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResolveHostClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHostnameResults(        
        std::move(p_hosts));
      return true;
    }
  }
  return false;
}

// static
bool ResolveHostClientStubDispatch::AcceptWithResponder(
    ResolveHostClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ResolveHostClient>(message->header()->name)) {
    case messages::ResolveHostClient::kOnComplete: {
      break;
    }
    case messages::ResolveHostClient::kOnTextResults: {
      break;
    }
    case messages::ResolveHostClient::kOnHostnameResults: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kResolveHostClientValidationInfo[] = {
    { &internal::ResolveHostClient_OnComplete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ResolveHostClient_OnTextResults_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ResolveHostClient_OnHostnameResults_Params_Data::Validate,
     nullptr /* no response */},
};

bool ResolveHostClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::ResolveHostClient::Name_,
    kResolveHostClientValidationInfo);
}

// The declaration includes the definition on other builds.

MdnsListenClient::IPCStableHashFunction MdnsListenClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MdnsListenClient>(message.name())) {
    case messages::MdnsListenClient::kOnAddressResult: {
      return &MdnsListenClient::OnAddressResult_Sym::IPCStableHash;
    }
    case messages::MdnsListenClient::kOnTextResult: {
      return &MdnsListenClient::OnTextResult_Sym::IPCStableHash;
    }
    case messages::MdnsListenClient::kOnHostnameResult: {
      return &MdnsListenClient::OnHostnameResult_Sym::IPCStableHash;
    }
    case messages::MdnsListenClient::kOnUnhandledResult: {
      return &MdnsListenClient::OnUnhandledResult_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MdnsListenClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MdnsListenClient>(message.name())) {
      case messages::MdnsListenClient::kOnAddressResult:
            return "Receive network::mojom::MdnsListenClient::OnAddressResult";
      case messages::MdnsListenClient::kOnTextResult:
            return "Receive network::mojom::MdnsListenClient::OnTextResult";
      case messages::MdnsListenClient::kOnHostnameResult:
            return "Receive network::mojom::MdnsListenClient::OnHostnameResult";
      case messages::MdnsListenClient::kOnUnhandledResult:
            return "Receive network::mojom::MdnsListenClient::OnUnhandledResult";
    }
  } else {
    switch (static_cast<messages::MdnsListenClient>(message.name())) {
      case messages::MdnsListenClient::kOnAddressResult:
            return "Receive reply network::mojom::MdnsListenClient::OnAddressResult";
      case messages::MdnsListenClient::kOnTextResult:
            return "Receive reply network::mojom::MdnsListenClient::OnTextResult";
      case messages::MdnsListenClient::kOnHostnameResult:
            return "Receive reply network::mojom::MdnsListenClient::OnHostnameResult";
      case messages::MdnsListenClient::kOnUnhandledResult:
            return "Receive reply network::mojom::MdnsListenClient::OnUnhandledResult";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MdnsListenClient::OnAddressResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfedd2be6;  // IPCStableHash for network::mojom::MdnsListenClient::OnAddressResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MdnsListenClient::OnTextResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc54ca1d;  // IPCStableHash for network::mojom::MdnsListenClient::OnTextResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MdnsListenClient::OnHostnameResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x53107135;  // IPCStableHash for network::mojom::MdnsListenClient::OnHostnameResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MdnsListenClient::OnUnhandledResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc7a26c97;  // IPCStableHash for network::mojom::MdnsListenClient::OnUnhandledResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MdnsListenClientProxy::MdnsListenClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MdnsListenClientProxy::OnAddressResult(
    MdnsListenClient::UpdateType in_update_type, ::net::DnsQueryType in_query_type, const ::net::IPEndPoint& in_endpoint) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::MdnsListenClient::OnAddressResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_type"), in_update_type,
                        "<value of type MdnsListenClient::UpdateType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_type"), in_query_type,
                        "<value of type ::net::DnsQueryType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("endpoint"), in_endpoint,
                        "<value of type const ::net::IPEndPoint&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MdnsListenClient::kOnAddressResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::MdnsListenClient_OnAddressResult_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::MdnsListenClient_UpdateType>(
    in_update_type,
    &params->update_type);

  
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
    in_query_type,
    &params->query_type);
  mojo::internal::MessageFragment<
      typename decltype(params->endpoint)::BaseType> endpoint_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
    in_endpoint,
    endpoint_fragment);

  params->endpoint.Set(
      endpoint_fragment.is_null() ? nullptr : endpoint_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->endpoint.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null endpoint in MdnsListenClient.OnAddressResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsListenClient::Name_);
  message.set_method_name("OnAddressResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MdnsListenClientProxy::OnTextResult(
    MdnsListenClient::UpdateType in_update_type, ::net::DnsQueryType in_query_type, const ::blink::Vector<::blink::String>& in_text_records) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::MdnsListenClient::OnTextResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_type"), in_update_type,
                        "<value of type MdnsListenClient::UpdateType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_type"), in_query_type,
                        "<value of type ::net::DnsQueryType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_records"), in_text_records,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MdnsListenClient::kOnTextResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::MdnsListenClient_OnTextResult_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::MdnsListenClient_UpdateType>(
    in_update_type,
    &params->update_type);

  
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
    in_query_type,
    &params->query_type);
  mojo::internal::MessageFragment<
      typename decltype(params->text_records)::BaseType>
      text_records_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& text_records_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_text_records,
    text_records_fragment,
    &text_records_validate_params);

  params->text_records.Set(
      text_records_fragment.is_null() ? nullptr : text_records_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text_records.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text_records in MdnsListenClient.OnTextResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsListenClient::Name_);
  message.set_method_name("OnTextResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MdnsListenClientProxy::OnHostnameResult(
    MdnsListenClient::UpdateType in_update_type, ::net::DnsQueryType in_query_type, const ::net::HostPortPair& in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::MdnsListenClient::OnHostnameResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_type"), in_update_type,
                        "<value of type MdnsListenClient::UpdateType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_type"), in_query_type,
                        "<value of type ::net::DnsQueryType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const ::net::HostPortPair&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MdnsListenClient::kOnHostnameResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::MdnsListenClient_OnHostnameResult_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::MdnsListenClient_UpdateType>(
    in_update_type,
    &params->update_type);

  
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
    in_query_type,
    &params->query_type);
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
    in_host,
    host_fragment);

  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host in MdnsListenClient.OnHostnameResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsListenClient::Name_);
  message.set_method_name("OnHostnameResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MdnsListenClientProxy::OnUnhandledResult(
    MdnsListenClient::UpdateType in_update_type, ::net::DnsQueryType in_query_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::MdnsListenClient::OnUnhandledResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_type"), in_update_type,
                        "<value of type MdnsListenClient::UpdateType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_type"), in_query_type,
                        "<value of type ::net::DnsQueryType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MdnsListenClient::kOnUnhandledResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::MdnsListenClient_OnUnhandledResult_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::MdnsListenClient_UpdateType>(
    in_update_type,
    &params->update_type);

  
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
    in_query_type,
    &params->query_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsListenClient::Name_);
  message.set_method_name("OnUnhandledResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MdnsListenClientStubDispatch::Accept(
    MdnsListenClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MdnsListenClient>(message->header()->name)) {
    case messages::MdnsListenClient::kOnAddressResult: {
      DCHECK(message->is_serialized());
      internal::MdnsListenClient_OnAddressResult_Params_Data* params =
          reinterpret_cast<internal::MdnsListenClient_OnAddressResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MdnsListenClient.0
      bool success = true;
      MdnsListenClient::UpdateType p_update_type{};
      ::net::DnsQueryType p_query_type{};
      ::net::IPEndPoint p_endpoint{};
      MdnsListenClient_OnAddressResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (success && !input_data_view.ReadEndpoint(&p_endpoint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsListenClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAddressResult(        
        std::move(p_update_type), 
        std::move(p_query_type), 
        std::move(p_endpoint));
      return true;
    }
    case messages::MdnsListenClient::kOnTextResult: {
      DCHECK(message->is_serialized());
      internal::MdnsListenClient_OnTextResult_Params_Data* params =
          reinterpret_cast<internal::MdnsListenClient_OnTextResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MdnsListenClient.1
      bool success = true;
      MdnsListenClient::UpdateType p_update_type{};
      ::net::DnsQueryType p_query_type{};
      ::blink::Vector<::blink::String> p_text_records{};
      MdnsListenClient_OnTextResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (success && !input_data_view.ReadTextRecords(&p_text_records))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsListenClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTextResult(        
        std::move(p_update_type), 
        std::move(p_query_type), 
        std::move(p_text_records));
      return true;
    }
    case messages::MdnsListenClient::kOnHostnameResult: {
      DCHECK(message->is_serialized());
      internal::MdnsListenClient_OnHostnameResult_Params_Data* params =
          reinterpret_cast<internal::MdnsListenClient_OnHostnameResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MdnsListenClient.2
      bool success = true;
      MdnsListenClient::UpdateType p_update_type{};
      ::net::DnsQueryType p_query_type{};
      ::net::HostPortPair p_host{};
      MdnsListenClient_OnHostnameResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsListenClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHostnameResult(        
        std::move(p_update_type), 
        std::move(p_query_type), 
        std::move(p_host));
      return true;
    }
    case messages::MdnsListenClient::kOnUnhandledResult: {
      DCHECK(message->is_serialized());
      internal::MdnsListenClient_OnUnhandledResult_Params_Data* params =
          reinterpret_cast<internal::MdnsListenClient_OnUnhandledResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MdnsListenClient.3
      bool success = true;
      MdnsListenClient::UpdateType p_update_type{};
      ::net::DnsQueryType p_query_type{};
      MdnsListenClient_OnUnhandledResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsListenClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUnhandledResult(        
        std::move(p_update_type), 
        std::move(p_query_type));
      return true;
    }
  }
  return false;
}

// static
bool MdnsListenClientStubDispatch::AcceptWithResponder(
    MdnsListenClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MdnsListenClient>(message->header()->name)) {
    case messages::MdnsListenClient::kOnAddressResult: {
      break;
    }
    case messages::MdnsListenClient::kOnTextResult: {
      break;
    }
    case messages::MdnsListenClient::kOnHostnameResult: {
      break;
    }
    case messages::MdnsListenClient::kOnUnhandledResult: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMdnsListenClientValidationInfo[] = {
    { &internal::MdnsListenClient_OnAddressResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MdnsListenClient_OnTextResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MdnsListenClient_OnHostnameResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MdnsListenClient_OnUnhandledResult_Params_Data::Validate,
     nullptr /* no response */},
};

bool MdnsListenClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::MdnsListenClient::Name_,
    kMdnsListenClientValidationInfo);
}

// The declaration includes the definition on other builds.

HostResolver::IPCStableHashFunction HostResolver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HostResolver>(message.name())) {
    case messages::HostResolver::kResolveHost: {
      return &HostResolver::ResolveHost_Sym::IPCStableHash;
    }
    case messages::HostResolver::kMdnsListen: {
      return &HostResolver::MdnsListen_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HostResolver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HostResolver>(message.name())) {
      case messages::HostResolver::kResolveHost:
            return "Receive network::mojom::HostResolver::ResolveHost";
      case messages::HostResolver::kMdnsListen:
            return "Receive network::mojom::HostResolver::MdnsListen";
    }
  } else {
    switch (static_cast<messages::HostResolver>(message.name())) {
      case messages::HostResolver::kResolveHost:
            return "Receive reply network::mojom::HostResolver::ResolveHost";
      case messages::HostResolver::kMdnsListen:
            return "Receive reply network::mojom::HostResolver::MdnsListen";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HostResolver::ResolveHost_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa4564e1f;  // IPCStableHash for network::mojom::HostResolver::ResolveHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HostResolver::MdnsListen_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbfa720c6;  // IPCStableHash for network::mojom::HostResolver::MdnsListen
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class HostResolver_MdnsListen_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HostResolver_MdnsListen_ForwardToCallback(
      HostResolver::MdnsListenCallback callback
      ) : callback_(std::move(callback)) {
  }

  HostResolver_MdnsListen_ForwardToCallback(const HostResolver_MdnsListen_ForwardToCallback&) = delete;
  HostResolver_MdnsListen_ForwardToCallback& operator=(const HostResolver_MdnsListen_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HostResolver::MdnsListenCallback callback_;
};

HostResolverProxy::HostResolverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HostResolverProxy::ResolveHost(
    HostResolverHostPtr in_host, ::network::mojom::blink::NetworkAnonymizationKeyPtr in_network_anonymization_key, ResolveHostParametersPtr in_optional_parameters, ::mojo::PendingRemote<ResolveHostClient> in_response_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::HostResolver::ResolveHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type HostResolverHostPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_anonymization_key"), in_network_anonymization_key,
                        "<value of type ::network::mojom::blink::NetworkAnonymizationKeyPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("optional_parameters"), in_optional_parameters,
                        "<value of type ResolveHostParametersPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_client"), in_response_client,
                        "<value of type ::mojo::PendingRemote<ResolveHostClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HostResolver::kResolveHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::HostResolver_ResolveHost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->host)>
      host_fragment(params.message());
  host_fragment.Claim(&params->host);
  
  mojo::internal::Serialize<::network::mojom::HostResolverHostDataView>(
    in_host,
    host_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host in HostResolver.ResolveHost request");
  mojo::internal::MessageFragment<decltype(params->network_anonymization_key)>
      network_anonymization_key_fragment(params.message());
  network_anonymization_key_fragment.Claim(&params->network_anonymization_key);
  
  mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView>(
    in_network_anonymization_key,
    network_anonymization_key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->network_anonymization_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null network_anonymization_key in HostResolver.ResolveHost request");
  mojo::internal::MessageFragment<
      typename decltype(params->optional_parameters)::BaseType> optional_parameters_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ResolveHostParametersDataView>(
    in_optional_parameters,
    optional_parameters_fragment);

  params->optional_parameters.Set(
      optional_parameters_fragment.is_null() ? nullptr : optional_parameters_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ResolveHostClientInterfaceBase>>(
    in_response_client,
    &params->response_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->response_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid response_client in HostResolver.ResolveHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HostResolver::Name_);
  message.set_method_name("ResolveHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void HostResolverProxy::MdnsListen(
    const ::net::HostPortPair& in_host, ::net::DnsQueryType in_query_type, ::mojo::PendingRemote<MdnsListenClient> in_response_client, MdnsListenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::HostResolver::MdnsListen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const ::net::HostPortPair&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query_type"), in_query_type,
                        "<value of type ::net::DnsQueryType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_client"), in_response_client,
                        "<value of type ::mojo::PendingRemote<MdnsListenClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HostResolver::kMdnsListen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::HostResolver_MdnsListen_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
    in_host,
    host_fragment);

  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host in HostResolver.MdnsListen request");

  
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
    in_query_type,
    &params->query_type);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::MdnsListenClientInterfaceBase>>(
    in_response_client,
    &params->response_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->response_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid response_client in HostResolver.MdnsListen request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HostResolver::Name_);
  message.set_method_name("MdnsListen");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HostResolver_MdnsListen_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class HostResolver_MdnsListen_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HostResolver::MdnsListenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HostResolver_MdnsListen_ProxyToResponder> proxy(
        new HostResolver_MdnsListen_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HostResolver_MdnsListen_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HostResolver_MdnsListen_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HostResolver_MdnsListen_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HostResolver::MdnsListenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool HostResolver_MdnsListen_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HostResolver_MdnsListen_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HostResolver_MdnsListen_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HostResolver.1
  bool success = true;
  int32_t p_result{};
  HostResolver_MdnsListen_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HostResolver::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void HostResolver_MdnsListen_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::HostResolver::MdnsListen", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HostResolver::kMdnsListen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::HostResolver_MdnsListen_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HostResolver::Name_);
  message.set_method_name("MdnsListen");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HostResolverStubDispatch::Accept(
    HostResolver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HostResolver>(message->header()->name)) {
    case messages::HostResolver::kResolveHost: {
      DCHECK(message->is_serialized());
      internal::HostResolver_ResolveHost_Params_Data* params =
          reinterpret_cast<internal::HostResolver_ResolveHost_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HostResolver.0
      bool success = true;
      HostResolverHostPtr p_host{};
      ::network::mojom::blink::NetworkAnonymizationKeyPtr p_network_anonymization_key{};
      ResolveHostParametersPtr p_optional_parameters{};
      ::mojo::PendingRemote<ResolveHostClient> p_response_client{};
      HostResolver_ResolveHost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadNetworkAnonymizationKey(&p_network_anonymization_key))
        success = false;
      if (success && !input_data_view.ReadOptionalParameters(&p_optional_parameters))
        success = false;
      if (success) {
        p_response_client =
            input_data_view.TakeResponseClient<decltype(p_response_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HostResolver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveHost(        
        std::move(p_host), 
        std::move(p_network_anonymization_key), 
        std::move(p_optional_parameters), 
        std::move(p_response_client));
      return true;
    }
    case messages::HostResolver::kMdnsListen: {
      break;
    }
  }
  return false;
}

// static
bool HostResolverStubDispatch::AcceptWithResponder(
    HostResolver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HostResolver>(message->header()->name)) {
    case messages::HostResolver::kResolveHost: {
      break;
    }
    case messages::HostResolver::kMdnsListen: {
      internal::HostResolver_MdnsListen_Params_Data* params =
          reinterpret_cast<
              internal::HostResolver_MdnsListen_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HostResolver.1
      bool success = true;
      ::net::HostPortPair p_host{};
      ::net::DnsQueryType p_query_type{};
      ::mojo::PendingRemote<MdnsListenClient> p_response_client{};
      HostResolver_MdnsListen_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (success) {
        p_response_client =
            input_data_view.TakeResponseClient<decltype(p_response_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HostResolver::Name_, 1, false);
        return false;
      }
      auto callback =
          HostResolver_MdnsListen_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MdnsListen(        
        std::move(p_host), 
        std::move(p_query_type), 
        std::move(p_response_client), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHostResolverValidationInfo[] = {
    { &internal::HostResolver_ResolveHost_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::HostResolver_MdnsListen_Params_Data::Validate,
     &internal::HostResolver_MdnsListen_ResponseParams_Data::Validate},
};

bool HostResolverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::HostResolver::Name_,
    kHostResolverValidationInfo);
}

bool HostResolverResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::network::mojom::blink::HostResolver::Name_,
    kHostResolverValidationInfo);
}
// The declaration includes the definition on other builds.

DnsConfigChangeManagerClient::IPCStableHashFunction DnsConfigChangeManagerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DnsConfigChangeManagerClient>(message.name())) {
    case messages::DnsConfigChangeManagerClient::kOnDnsConfigChanged: {
      return &DnsConfigChangeManagerClient::OnDnsConfigChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DnsConfigChangeManagerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DnsConfigChangeManagerClient>(message.name())) {
      case messages::DnsConfigChangeManagerClient::kOnDnsConfigChanged:
            return "Receive network::mojom::DnsConfigChangeManagerClient::OnDnsConfigChanged";
    }
  } else {
    switch (static_cast<messages::DnsConfigChangeManagerClient>(message.name())) {
      case messages::DnsConfigChangeManagerClient::kOnDnsConfigChanged:
            return "Receive reply network::mojom::DnsConfigChangeManagerClient::OnDnsConfigChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DnsConfigChangeManagerClient::OnDnsConfigChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85cd1f0d;  // IPCStableHash for network::mojom::DnsConfigChangeManagerClient::OnDnsConfigChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DnsConfigChangeManagerClientProxy::DnsConfigChangeManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DnsConfigChangeManagerClientProxy::OnDnsConfigChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::DnsConfigChangeManagerClient::OnDnsConfigChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DnsConfigChangeManagerClient::kOnDnsConfigChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DnsConfigChangeManagerClient::Name_);
  message.set_method_name("OnDnsConfigChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DnsConfigChangeManagerClientStubDispatch::Accept(
    DnsConfigChangeManagerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DnsConfigChangeManagerClient>(message->header()->name)) {
    case messages::DnsConfigChangeManagerClient::kOnDnsConfigChanged: {
      DCHECK(message->is_serialized());
      internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data* params =
          reinterpret_cast<internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DnsConfigChangeManagerClient.0
      bool success = true;
      DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DnsConfigChangeManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDnsConfigChanged(        );
      return true;
    }
  }
  return false;
}

// static
bool DnsConfigChangeManagerClientStubDispatch::AcceptWithResponder(
    DnsConfigChangeManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DnsConfigChangeManagerClient>(message->header()->name)) {
    case messages::DnsConfigChangeManagerClient::kOnDnsConfigChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDnsConfigChangeManagerClientValidationInfo[] = {
    { &internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool DnsConfigChangeManagerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::DnsConfigChangeManagerClient::Name_,
    kDnsConfigChangeManagerClientValidationInfo);
}

// The declaration includes the definition on other builds.

DnsConfigChangeManager::IPCStableHashFunction DnsConfigChangeManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DnsConfigChangeManager>(message.name())) {
    case messages::DnsConfigChangeManager::kRequestNotifications: {
      return &DnsConfigChangeManager::RequestNotifications_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DnsConfigChangeManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DnsConfigChangeManager>(message.name())) {
      case messages::DnsConfigChangeManager::kRequestNotifications:
            return "Receive network::mojom::DnsConfigChangeManager::RequestNotifications";
    }
  } else {
    switch (static_cast<messages::DnsConfigChangeManager>(message.name())) {
      case messages::DnsConfigChangeManager::kRequestNotifications:
            return "Receive reply network::mojom::DnsConfigChangeManager::RequestNotifications";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DnsConfigChangeManager::RequestNotifications_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5a04aa25;  // IPCStableHash for network::mojom::DnsConfigChangeManager::RequestNotifications
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DnsConfigChangeManagerProxy::DnsConfigChangeManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DnsConfigChangeManagerProxy::RequestNotifications(
    ::mojo::PendingRemote<DnsConfigChangeManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DnsConfigChangeManager::RequestNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<DnsConfigChangeManagerClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DnsConfigChangeManager::kRequestNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DnsConfigChangeManager_RequestNotifications_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DnsConfigChangeManagerClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in DnsConfigChangeManager.RequestNotifications request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DnsConfigChangeManager::Name_);
  message.set_method_name("RequestNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DnsConfigChangeManagerStubDispatch::Accept(
    DnsConfigChangeManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DnsConfigChangeManager>(message->header()->name)) {
    case messages::DnsConfigChangeManager::kRequestNotifications: {
      DCHECK(message->is_serialized());
      internal::DnsConfigChangeManager_RequestNotifications_Params_Data* params =
          reinterpret_cast<internal::DnsConfigChangeManager_RequestNotifications_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DnsConfigChangeManager.0
      bool success = true;
      ::mojo::PendingRemote<DnsConfigChangeManagerClient> p_client{};
      DnsConfigChangeManager_RequestNotifications_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DnsConfigChangeManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNotifications(        
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool DnsConfigChangeManagerStubDispatch::AcceptWithResponder(
    DnsConfigChangeManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DnsConfigChangeManager>(message->header()->name)) {
    case messages::DnsConfigChangeManager::kRequestNotifications: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDnsConfigChangeManagerValidationInfo[] = {
    { &internal::DnsConfigChangeManager_RequestNotifications_Params_Data::Validate,
     nullptr /* no response */},
};

bool DnsConfigChangeManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::DnsConfigChangeManager::Name_,
    kDnsConfigChangeManagerValidationInfo);
}



}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::DnsOverHttpsServerConfig::DataView, ::network::mojom::blink::DnsOverHttpsServerConfigPtr>::Read(
    ::network::mojom::blink::DnsOverHttpsServerConfig::DataView input,
    ::network::mojom::blink::DnsOverHttpsServerConfigPtr* output) {
  bool success = true;
  ::network::mojom::blink::DnsOverHttpsServerConfigPtr result(::network::mojom::blink::DnsOverHttpsServerConfig::New());
  
      if (success && !input.ReadServerTemplate(&result->server_template))
        success = false;
      if (success && !input.ReadEndpoints(&result->endpoints))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::DnsOverHttpsConfig::DataView, ::network::mojom::blink::DnsOverHttpsConfigPtr>::Read(
    ::network::mojom::blink::DnsOverHttpsConfig::DataView input,
    ::network::mojom::blink::DnsOverHttpsConfigPtr* output) {
  bool success = true;
  ::network::mojom::blink::DnsOverHttpsConfigPtr result(::network::mojom::blink::DnsOverHttpsConfig::New());
  
      if (success && !input.ReadServers(&result->servers))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::DnsConfigOverrides::DataView, ::network::mojom::blink::DnsConfigOverridesPtr>::Read(
    ::network::mojom::blink::DnsConfigOverrides::DataView input,
    ::network::mojom::blink::DnsConfigOverridesPtr* output) {
  bool success = true;
  ::network::mojom::blink::DnsConfigOverridesPtr result(::network::mojom::blink::DnsConfigOverrides::New());
  
      if (success && !input.ReadNameservers(&result->nameservers))
        success = false;
      if (success && !input.ReadSearch(&result->search))
        success = false;
      if (success && !input.ReadAppendToMultiLabelName(&result->append_to_multi_label_name))
        success = false;
      if (success)
        result->ndots = input.ndots();
      if (success && !input.ReadFallbackPeriod(&result->fallback_period))
        success = false;
      if (success)
        result->attempts = input.attempts();
      if (success && !input.ReadRotate(&result->rotate))
        success = false;
      if (success && !input.ReadUseLocalIpv6(&result->use_local_ipv6))
        success = false;
      if (success && !input.ReadDnsOverHttpsConfig(&result->dns_over_https_config))
        success = false;
      if (success && !input.ReadSecureDnsMode(&result->secure_dns_mode))
        success = false;
      if (success && !input.ReadAllowDnsOverHttpsUpgrade(&result->allow_dns_over_https_upgrade))
        success = false;
      if (success)
        result->clear_hosts = input.clear_hosts();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ResolveHostParameters::DataView, ::network::mojom::blink::ResolveHostParametersPtr>::Read(
    ::network::mojom::blink::ResolveHostParameters::DataView input,
    ::network::mojom::blink::ResolveHostParametersPtr* output) {
  bool success = true;
  ::network::mojom::blink::ResolveHostParametersPtr result(::network::mojom::blink::ResolveHostParameters::New());
  
      if (success && !input.ReadDnsQueryType(&result->dns_query_type))
        success = false;
      if (success && !input.ReadInitialPriority(&result->initial_priority))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
      if (success && !input.ReadCacheUsage(&result->cache_usage))
        success = false;
      if (success) {
        result->control_handle =
            input.TakeControlHandle<decltype(result->control_handle)>();
      }
      if (success)
        result->include_canonical_name = input.include_canonical_name();
      if (success)
        result->loopback_only = input.loopback_only();
      if (success)
        result->is_speculative = input.is_speculative();
      if (success && !input.ReadSecureDnsPolicy(&result->secure_dns_policy))
        success = false;
      if (success && !input.ReadPurpose(&result->purpose))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::blink::HostResolverHost::DataView, ::network::mojom::blink::HostResolverHostPtr>::Read(
    ::network::mojom::blink::HostResolverHost::DataView input,
    ::network::mojom::blink::HostResolverHostPtr* output) {
  using UnionType = ::network::mojom::blink::HostResolverHost;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSchemeHostPort: {
      ::url::SchemeHostPort result_scheme_host_port{};
      if (!input.ReadSchemeHostPort(&result_scheme_host_port))
        return false;

      *output = UnionType::NewSchemeHostPort(
          std::move(result_scheme_host_port));
      break;
    }
    case Tag::kHostPortPair: {
      ::net::HostPortPair result_host_port_pair{};
      if (!input.ReadHostPortPair(&result_host_port_pair))
        return false;

      *output = UnionType::NewHostPortPair(
          std::move(result_host_port_pair));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void ResolveHostHandleInterceptorForTesting::Cancel(int32_t result) {
  GetForwardingInterface()->Cancel(
    std::move(result)
    );
}
ResolveHostHandleAsyncWaiter::ResolveHostHandleAsyncWaiter(
    ResolveHostHandle* proxy) : proxy_(proxy) {}

ResolveHostHandleAsyncWaiter::~ResolveHostHandleAsyncWaiter() = default;





void ResolveHostClientInterceptorForTesting::OnComplete(int32_t result, ::network::mojom::blink::ResolveErrorInfoPtr resolve_error_info, ::network::mojom::blink::AddressListPtr resolved_addresses, ::blink::Vector<::network::mojom::blink::HostResolverEndpointResultPtr> alternative_endpoints) {
  GetForwardingInterface()->OnComplete(
    std::move(result)
    , 
    std::move(resolve_error_info)
    , 
    std::move(resolved_addresses)
    , 
    std::move(alternative_endpoints)
    );
}
void ResolveHostClientInterceptorForTesting::OnTextResults(const ::blink::Vector<::blink::String>& text_results) {
  GetForwardingInterface()->OnTextResults(
    std::move(text_results)
    );
}
void ResolveHostClientInterceptorForTesting::OnHostnameResults(const ::blink::Vector<::net::HostPortPair>& hosts) {
  GetForwardingInterface()->OnHostnameResults(
    std::move(hosts)
    );
}
ResolveHostClientAsyncWaiter::ResolveHostClientAsyncWaiter(
    ResolveHostClient* proxy) : proxy_(proxy) {}

ResolveHostClientAsyncWaiter::~ResolveHostClientAsyncWaiter() = default;





void MdnsListenClientInterceptorForTesting::OnAddressResult(MdnsListenClient::UpdateType update_type, ::net::DnsQueryType query_type, const ::net::IPEndPoint& endpoint) {
  GetForwardingInterface()->OnAddressResult(
    std::move(update_type)
    , 
    std::move(query_type)
    , 
    std::move(endpoint)
    );
}
void MdnsListenClientInterceptorForTesting::OnTextResult(MdnsListenClient::UpdateType update_type, ::net::DnsQueryType query_type, const ::blink::Vector<::blink::String>& text_records) {
  GetForwardingInterface()->OnTextResult(
    std::move(update_type)
    , 
    std::move(query_type)
    , 
    std::move(text_records)
    );
}
void MdnsListenClientInterceptorForTesting::OnHostnameResult(MdnsListenClient::UpdateType update_type, ::net::DnsQueryType query_type, const ::net::HostPortPair& host) {
  GetForwardingInterface()->OnHostnameResult(
    std::move(update_type)
    , 
    std::move(query_type)
    , 
    std::move(host)
    );
}
void MdnsListenClientInterceptorForTesting::OnUnhandledResult(MdnsListenClient::UpdateType update_type, ::net::DnsQueryType query_type) {
  GetForwardingInterface()->OnUnhandledResult(
    std::move(update_type)
    , 
    std::move(query_type)
    );
}
MdnsListenClientAsyncWaiter::MdnsListenClientAsyncWaiter(
    MdnsListenClient* proxy) : proxy_(proxy) {}

MdnsListenClientAsyncWaiter::~MdnsListenClientAsyncWaiter() = default;





void HostResolverInterceptorForTesting::ResolveHost(HostResolverHostPtr host, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<ResolveHostClient> response_client) {
  GetForwardingInterface()->ResolveHost(
    std::move(host)
    , 
    std::move(network_anonymization_key)
    , 
    std::move(optional_parameters)
    , 
    std::move(response_client)
    );
}
void HostResolverInterceptorForTesting::MdnsListen(const ::net::HostPortPair& host, ::net::DnsQueryType query_type, ::mojo::PendingRemote<MdnsListenClient> response_client, MdnsListenCallback callback) {
  GetForwardingInterface()->MdnsListen(
    std::move(host)
    , 
    std::move(query_type)
    , 
    std::move(response_client)
    , std::move(callback));
}
HostResolverAsyncWaiter::HostResolverAsyncWaiter(
    HostResolver* proxy) : proxy_(proxy) {}

HostResolverAsyncWaiter::~HostResolverAsyncWaiter() = default;


void HostResolverAsyncWaiter::MdnsListen(
    const ::net::HostPortPair& host, ::net::DnsQueryType query_type, ::mojo::PendingRemote<MdnsListenClient> response_client, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->MdnsListen(
      std::move(host),
      std::move(query_type),
      std::move(response_client),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t HostResolverAsyncWaiter::MdnsListen(
    const ::net::HostPortPair& host, ::net::DnsQueryType query_type, ::mojo::PendingRemote<MdnsListenClient> response_client) {
  int32_t async_wait_result;
  MdnsListen(std::move(host),std::move(query_type),std::move(response_client),&async_wait_result);
  return async_wait_result;
}




void DnsConfigChangeManagerClientInterceptorForTesting::OnDnsConfigChanged() {
  GetForwardingInterface()->OnDnsConfigChanged();
}
DnsConfigChangeManagerClientAsyncWaiter::DnsConfigChangeManagerClientAsyncWaiter(
    DnsConfigChangeManagerClient* proxy) : proxy_(proxy) {}

DnsConfigChangeManagerClientAsyncWaiter::~DnsConfigChangeManagerClientAsyncWaiter() = default;





void DnsConfigChangeManagerInterceptorForTesting::RequestNotifications(::mojo::PendingRemote<DnsConfigChangeManagerClient> client) {
  GetForwardingInterface()->RequestNotifications(
    std::move(client)
    );
}
DnsConfigChangeManagerAsyncWaiter::DnsConfigChangeManagerAsyncWaiter(
    DnsConfigChangeManager* proxy) : proxy_(proxy) {}

DnsConfigChangeManagerAsyncWaiter::~DnsConfigChangeManagerAsyncWaiter() = default;







}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif