// services/network/public/mojom/fetch_retry_options.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_FETCH_RETRY_OPTIONS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_FETCH_RETRY_OPTIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/fetch_retry_options.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"




#include "services/network/public/mojom/fetch_retry_options.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::FetchRetryOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FetchRetryOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FetchRetryOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->max_attempts = Traits::max_attempts(input);

    decltype(Traits::initial_delay(input)) in_initial_delay = Traits::initial_delay(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_delay)::BaseType> initial_delay_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_initial_delay,
      initial_delay_fragment);

    fragment->initial_delay.Set(
        initial_delay_fragment.is_null() ? nullptr : initial_delay_fragment.data());
    fragment->backoff_factor_$flag = Traits::backoff_factor(input).has_value();
    if (Traits::backoff_factor(input).has_value()) {
      fragment->backoff_factor_$value = Traits::backoff_factor(input).value();
    }

    decltype(Traits::max_age(input)) in_max_age = Traits::max_age(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->max_age)::BaseType> max_age_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_max_age,
      max_age_fragment);

    fragment->max_age.Set(
        max_age_fragment.is_null() ? nullptr : max_age_fragment.data());

    fragment->retry_after_unload = Traits::retry_after_unload(input);

    fragment->retry_non_idempotent = Traits::retry_non_idempotent(input);

    fragment->retry_only_if_server_unreached = Traits::retry_only_if_server_unreached(input);
  }

  static bool Deserialize(::network::mojom::internal::FetchRetryOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::FetchRetryOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void FetchRetryOptionsDataView::GetInitialDelayDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->initial_delay.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void FetchRetryOptionsDataView::GetMaxAgeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->max_age.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_FETCH_RETRY_OPTIONS_MOJOM_SHARED_H_