// services/network/public/mojom/digitally_signed.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DIGITALLY_SIGNED_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DIGITALLY_SIGNED_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/digitally_signed.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/digitally_signed.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/digitally_signed.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {








class BLINK_PLATFORM_EXPORT DigitallySigned {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DigitallySigned, T>::value>;
  using DataView = DigitallySignedDataView;
  using Data_ = internal::DigitallySigned_Data;

  template <typename... Args>
  static DigitallySignedPtr New(Args&&... args) {
    return DigitallySignedPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DigitallySignedPtr From(const U& u) {
    return mojo::TypeConverter<DigitallySignedPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DigitallySigned>::Convert(*this);
  }


  DigitallySigned();

  DigitallySigned(
      HashAlgorithm hash_algorithm,
      SignatureAlgorithm signature_algorithm,
      ::blink::Vector<uint8_t> signature);


  ~DigitallySigned();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DigitallySignedPtr>
  DigitallySignedPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DigitallySigned::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DigitallySigned::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DigitallySigned::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DigitallySigned::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DigitallySigned::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DigitallySigned::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DigitallySigned_UnserializedMessageContext<
            UserType, DigitallySigned::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DigitallySigned::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DigitallySigned::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DigitallySigned_UnserializedMessageContext<
            UserType, DigitallySigned::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DigitallySigned::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  HashAlgorithm hash_algorithm;
  
  SignatureAlgorithm signature_algorithm;
  
  ::blink::Vector<uint8_t> signature;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DigitallySigned::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DigitallySigned::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DigitallySigned::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DigitallySigned::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DigitallySignedPtr DigitallySigned::Clone() const {
  return New(
      mojo::Clone(hash_algorithm),
      mojo::Clone(signature_algorithm),
      mojo::Clone(signature)
  );
}

template <typename T, DigitallySigned::EnableIfSame<T>*>
bool DigitallySigned::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->hash_algorithm, other_struct.hash_algorithm))
    return false;
  if (!mojo::Equals(this->signature_algorithm, other_struct.signature_algorithm))
    return false;
  if (!mojo::Equals(this->signature, other_struct.signature))
    return false;
  return true;
}

template <typename T, DigitallySigned::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.hash_algorithm < rhs.hash_algorithm)
    return true;
  if (rhs.hash_algorithm < lhs.hash_algorithm)
    return false;
  if (lhs.signature_algorithm < rhs.signature_algorithm)
    return true;
  if (rhs.signature_algorithm < lhs.signature_algorithm)
    return false;
  if (lhs.signature < rhs.signature)
    return true;
  if (rhs.signature < lhs.signature)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::DigitallySigned::DataView,
                                         ::network::mojom::blink::DigitallySignedPtr> {
  static bool IsNull(const ::network::mojom::blink::DigitallySignedPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::DigitallySignedPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::DigitallySigned::hash_algorithm) hash_algorithm(
      const ::network::mojom::blink::DigitallySignedPtr& input) {
    return input->hash_algorithm;
  }

  static decltype(::network::mojom::blink::DigitallySigned::signature_algorithm) signature_algorithm(
      const ::network::mojom::blink::DigitallySignedPtr& input) {
    return input->signature_algorithm;
  }

  static const decltype(::network::mojom::blink::DigitallySigned::signature)& signature(
      const ::network::mojom::blink::DigitallySignedPtr& input) {
    return input->signature;
  }

  static bool Read(::network::mojom::blink::DigitallySigned::DataView input, ::network::mojom::blink::DigitallySignedPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DIGITALLY_SIGNED_MOJOM_BLINK_H_