// services/network/public/mojom/devtools_observer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/devtools_observer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/alternate_protocol_usage.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cookie_partition_key.mojom-shared.h"
#include "services/network/public/mojom/cors.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/http_raw_headers.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "services/network/public/mojom/service_worker_router_info.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_error.mojom-shared.h"
#include "services/network/public/mojom/sri_message_signature.mojom-shared.h"
#include "services/network/public/mojom/unencoded_digest.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace network::mojom {
class URLRequestDevToolsInfoDataView;

class URLResponseHeadDevToolsInfoDataView;

class OtherPartitionInfoDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::URLRequestDevToolsInfoDataView> {
  using Data = ::network::mojom::internal::URLRequestDevToolsInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::URLResponseHeadDevToolsInfoDataView> {
  using Data = ::network::mojom::internal::URLResponseHeadDevToolsInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::OtherPartitionInfoDataView> {
  using Data = ::network::mojom::internal::OtherPartitionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class DevToolsObserverInterfaceBase {};

using DevToolsObserverPtrDataView =
    mojo::InterfacePtrDataView<DevToolsObserverInterfaceBase>;
using DevToolsObserverRequestDataView =
    mojo::InterfaceRequestDataView<DevToolsObserverInterfaceBase>;
using DevToolsObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DevToolsObserverInterfaceBase>;
using DevToolsObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DevToolsObserverInterfaceBase>;


class URLRequestDevToolsInfoDataView {
 public:
  URLRequestDevToolsInfoDataView() = default;

  URLRequestDevToolsInfoDataView(
      internal::URLRequestDevToolsInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPriority(UserType* output) const {
    auto data_value = data_->priority;
    return mojo::internal::Deserialize<::network::mojom::RequestPriority>(
        data_value, output);
  }
  ::network::mojom::RequestPriority priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestPriority>(data_->priority));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::URLRequestReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::URLRequestReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::URLRequestReferrerPolicy>(data_->referrer_policy));
  }
  inline void GetTrustTokenParamsDataView(
      ::network::mojom::TrustTokenParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TrustTokenParamsDataView, UserType>(),
    "Attempting to read the optional `trust_token_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustTokenParams` instead "
    "of `ReadTrustTokenParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trust_token_params.Get();
    return mojo::internal::Deserialize<::network::mojom::TrustTokenParamsDataView>(
        pointer, output, message_);
  }
  bool has_user_gesture() const {
    return data_->has_user_gesture;
  }
  uint32_t resource_type() const {
    return data_->resource_type;
  }
  bool is_ad_related() const {
    return data_->is_ad_related;
  }
 private:
  internal::URLRequestDevToolsInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLResponseHeadDevToolsInfoDataView {
 public:
  URLResponseHeadDevToolsInfoDataView() = default;

  URLResponseHeadDevToolsInfoDataView(
      internal::URLResponseHeadDevToolsInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResponseTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseTime(UserType* output) {
    
    auto* pointer = data_->response_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      ::network::mojom::HttpResponseHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpResponseHeadersDataView>(
        pointer, output, message_);
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCharsetDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCharset(UserType* output) {
    
    auto* pointer = data_->charset.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLoadTimingDataView(
      ::network::mojom::LoadTimingInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLoadTiming(UserType* output) {
    
    auto* pointer = data_->load_timing.Get();
    return mojo::internal::Deserialize<::network::mojom::LoadTimingInfoDataView>(
        pointer, output, message_);
  }
  uint32_t cert_status() const {
    return data_->cert_status;
  }
  int64_t encoded_data_length() const {
    return data_->encoded_data_length;
  }
  bool was_in_prefetch_cache() const {
    return data_->was_in_prefetch_cache;
  }
  bool was_fetched_via_service_worker() const {
    return data_->was_fetched_via_service_worker;
  }
  inline void GetCacheStorageCacheNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCacheStorageCacheName(UserType* output) {
    
    auto* pointer = data_->cache_storage_cache_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAlpnNegotiatedProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlpnNegotiatedProtocol(UserType* output) {
    
    auto* pointer = data_->alpn_negotiated_protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAlternateProtocolUsage(UserType* output) const {
    auto data_value = data_->alternate_protocol_usage;
    return mojo::internal::Deserialize<::network::mojom::AlternateProtocolUsage>(
        data_value, output);
  }
  ::network::mojom::AlternateProtocolUsage alternate_protocol_usage() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AlternateProtocolUsage>(data_->alternate_protocol_usage));
  }
  bool was_fetched_via_spdy() const {
    return data_->was_fetched_via_spdy;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerResponseSource(UserType* output) const {
    auto data_value = data_->service_worker_response_source;
    return mojo::internal::Deserialize<::network::mojom::FetchResponseSource>(
        data_value, output);
  }
  ::network::mojom::FetchResponseSource service_worker_response_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::FetchResponseSource>(data_->service_worker_response_source));
  }
  inline void GetServiceWorkerRouterInfoDataView(
      ::network::mojom::ServiceWorkerRouterInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerRouterInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ServiceWorkerRouterInfoDataView, UserType>(),
    "Attempting to read the optional `service_worker_router_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServiceWorkerRouterInfo` instead "
    "of `ReadServiceWorkerRouterInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->service_worker_router_info.Get();
    return mojo::internal::Deserialize<::network::mojom::ServiceWorkerRouterInfoDataView>(
        pointer, output, message_);
  }
  inline void GetSslInfoDataView(
      ::network::mojom::SSLInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSslInfo(UserType* output) {
    
    auto* pointer = data_->ssl_info.Get();
    return mojo::internal::Deserialize<::network::mojom::SSLInfoDataView>(
        pointer, output, message_);
  }
  inline void GetRemoteEndpointDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteEndpoint(UserType* output) {
    
    auto* pointer = data_->remote_endpoint.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
  bool emitted_extra_info() const {
    return data_->emitted_extra_info;
  }
  bool is_for_ip_protection() const {
    return data_->is_for_ip_protection;
  }
 private:
  internal::URLResponseHeadDevToolsInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OtherPartitionInfoDataView {
 public:
  OtherPartitionInfoDataView() = default;

  OtherPartitionInfoDataView(
      internal::OtherPartitionInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool site_has_cookie_in_other_partition() const {
    return data_->site_has_cookie_in_other_partition;
  }
 private:
  internal::OtherPartitionInfo_Data* data_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_DATA_VIEW_H_