// services/network/public/mojom/cross_origin_embedder_policy.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/cross_origin_embedder_policy.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', 'fetch_api.mojom.js');
  }


  var CrossOriginEmbedderPolicyValue = {};
  CrossOriginEmbedderPolicyValue.kNone = 0;
  CrossOriginEmbedderPolicyValue.kRequireCorp = 1;
  CrossOriginEmbedderPolicyValue.kCredentialless = 2;
  CrossOriginEmbedderPolicyValue.MIN_VALUE = 0;
  CrossOriginEmbedderPolicyValue.MAX_VALUE = 2;

  CrossOriginEmbedderPolicyValue.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CrossOriginEmbedderPolicyValue.toKnownEnumValue = function(value) {
    return value;
  };

  CrossOriginEmbedderPolicyValue.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CrossOriginEmbedderPolicy(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CrossOriginEmbedderPolicy.prototype.initDefaults_ = function() {
    this.value = CrossOriginEmbedderPolicyValue.kNone;
    this.reportOnlyValue = CrossOriginEmbedderPolicyValue.kNone;
    this.reportingEndpoint = null;
    this.reportOnlyReportingEndpoint = null;
  };
  CrossOriginEmbedderPolicy.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CrossOriginEmbedderPolicy.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginEmbedderPolicy.value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CrossOriginEmbedderPolicyValue);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginEmbedderPolicy.reportingEndpoint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginEmbedderPolicy.reportOnlyValue
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, CrossOriginEmbedderPolicyValue);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginEmbedderPolicy.reportOnlyReportingEndpoint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CrossOriginEmbedderPolicy.encodedSize = codec.kStructHeaderSize + 24;

  CrossOriginEmbedderPolicy.decode = function(decoder) {
    var packed;
    var val = new CrossOriginEmbedderPolicy();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(new codec.Enum(CrossOriginEmbedderPolicyValue));
    val.reportOnlyValue =
        decoder.decodeStruct(new codec.Enum(CrossOriginEmbedderPolicyValue));
    val.reportingEndpoint =
        decoder.decodeStruct(codec.String);
    val.reportOnlyReportingEndpoint =
        decoder.decodeStruct(codec.String);
    return val;
  };

  CrossOriginEmbedderPolicy.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CrossOriginEmbedderPolicy.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.value);
    encoder.encodeStruct(codec.Int32, val.reportOnlyValue);
    encoder.encodeStruct(codec.String, val.reportingEndpoint);
    encoder.encodeStruct(codec.String, val.reportOnlyReportingEndpoint);
  };
  function CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params.prototype.initDefaults_ = function() {
    this.blockedUrl = null;
    this.destination = 0;
    this.reportOnly = false;
  };
  CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params.blockedUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params.destination
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, fetch_api$.RequestDestination);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params.encodedSize = codec.kStructHeaderSize + 16;

  CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params.decode = function(decoder) {
    var packed;
    var val = new CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.blockedUrl =
        decoder.decodeStructPointer(url$.Url);
    val.destination =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RequestDestination));
    packed = decoder.readUint8();
    val.reportOnly = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.blockedUrl);
    encoder.encodeStruct(codec.Int32, val.destination);
    packed = 0;
    packed |= (val.reportOnly & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CrossOriginEmbedderPolicyReporter_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CrossOriginEmbedderPolicyReporter_Clone_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  CrossOriginEmbedderPolicyReporter_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CrossOriginEmbedderPolicyReporter_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginEmbedderPolicyReporter_Clone_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CrossOriginEmbedderPolicyReporter_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  CrossOriginEmbedderPolicyReporter_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new CrossOriginEmbedderPolicyReporter_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CrossOriginEmbedderPolicyReporter_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CrossOriginEmbedderPolicyReporter_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kCrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Name = 0;
  var kCrossOriginEmbedderPolicyReporter_Clone_Name = 1;

  function CrossOriginEmbedderPolicyReporterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CrossOriginEmbedderPolicyReporter,
                                                   handleOrPtrInfo);
  }

  function CrossOriginEmbedderPolicyReporterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CrossOriginEmbedderPolicyReporter, associatedInterfacePtrInfo);
  }

  CrossOriginEmbedderPolicyReporterAssociatedPtr.prototype =
      Object.create(CrossOriginEmbedderPolicyReporterPtr.prototype);
  CrossOriginEmbedderPolicyReporterAssociatedPtr.prototype.constructor =
      CrossOriginEmbedderPolicyReporterAssociatedPtr;

  function CrossOriginEmbedderPolicyReporterProxy(receiver) {
    this.receiver_ = receiver;
  }
  CrossOriginEmbedderPolicyReporterPtr.prototype.queueCorpViolationReport = function() {
    return CrossOriginEmbedderPolicyReporterProxy.prototype.queueCorpViolationReport
        .apply(this.ptr.getProxy(), arguments);
  };

  CrossOriginEmbedderPolicyReporterProxy.prototype.queueCorpViolationReport = function(blockedUrl, destination, reportOnly) {
    var params_ = new CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params();
    params_.blockedUrl = blockedUrl;
    params_.destination = destination;
    params_.reportOnly = reportOnly;
    var builder = new codec.MessageV0Builder(
        kCrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Name,
        codec.align(CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params.encodedSize));
    builder.encodeStruct(CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CrossOriginEmbedderPolicyReporterPtr.prototype.clone = function() {
    return CrossOriginEmbedderPolicyReporterProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  CrossOriginEmbedderPolicyReporterProxy.prototype.clone = function(receiver) {
    var params_ = new CrossOriginEmbedderPolicyReporter_Clone_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kCrossOriginEmbedderPolicyReporter_Clone_Name,
        codec.align(CrossOriginEmbedderPolicyReporter_Clone_Params.encodedSize));
    builder.encodeStruct(CrossOriginEmbedderPolicyReporter_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CrossOriginEmbedderPolicyReporterStub(delegate) {
    this.delegate_ = delegate;
  }
  CrossOriginEmbedderPolicyReporterStub.prototype.queueCorpViolationReport = function(blockedUrl, destination, reportOnly) {
    return this.delegate_ && this.delegate_.queueCorpViolationReport && this.delegate_.queueCorpViolationReport(blockedUrl, destination, reportOnly);
  }
  CrossOriginEmbedderPolicyReporterStub.prototype.clone = function(receiver) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(receiver);
  }

  CrossOriginEmbedderPolicyReporterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Name:
      var params = reader.decodeStruct(CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params);
      this.queueCorpViolationReport(params.blockedUrl, params.destination, params.reportOnly);
      return true;
    case kCrossOriginEmbedderPolicyReporter_Clone_Name:
      var params = reader.decodeStruct(CrossOriginEmbedderPolicyReporter_Clone_Params);
      this.clone(params.receiver);
      return true;
    default:
      return false;
    }
  };

  CrossOriginEmbedderPolicyReporterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateCrossOriginEmbedderPolicyReporterRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params;
      break;
      case kCrossOriginEmbedderPolicyReporter_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CrossOriginEmbedderPolicyReporter_Clone_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCrossOriginEmbedderPolicyReporterResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var CrossOriginEmbedderPolicyReporter = {
    name: 'network.mojom.CrossOriginEmbedderPolicyReporter',
    kVersion: 0,
    ptrClass: CrossOriginEmbedderPolicyReporterPtr,
    proxyClass: CrossOriginEmbedderPolicyReporterProxy,
    stubClass: CrossOriginEmbedderPolicyReporterStub,
    validateRequest: validateCrossOriginEmbedderPolicyReporterRequest,
    validateResponse: null,
  };
  CrossOriginEmbedderPolicyReporterStub.prototype.validator = validateCrossOriginEmbedderPolicyReporterRequest;
  CrossOriginEmbedderPolicyReporterProxy.prototype.validator = null;
  exports.CrossOriginEmbedderPolicyValue = CrossOriginEmbedderPolicyValue;
  exports.CrossOriginEmbedderPolicy = CrossOriginEmbedderPolicy;
  exports.CrossOriginEmbedderPolicyReporter = CrossOriginEmbedderPolicyReporter;
  exports.CrossOriginEmbedderPolicyReporterPtr = CrossOriginEmbedderPolicyReporterPtr;
  exports.CrossOriginEmbedderPolicyReporterAssociatedPtr = CrossOriginEmbedderPolicyReporterAssociatedPtr;
})();