// services/network/public/mojom/cors_origin_pattern.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CorsPortMatchModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CorsPortMatchMode = {
  
  kAllowAnyPort: 0,
  kAllowOnlySpecifiedPort: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CorsDomainMatchModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CorsDomainMatchMode = {
  
  kAllowSubdomains: 0,
  kAllowRegistrableDomains: 1,
  kDisallowSubdomains: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CorsOriginAccessMatchPrioritySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CorsOriginAccessMatchPriority = {
  
  kNoMatchingOrigin: 0,
  kDefaultPriority: 1,
  kLowPriority: 2,
  kMediumPriority: 3,
  kHighPriority: 4,
  kMaxPriority: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CorsOriginPatternSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CorsOriginAccessPatternsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CorsOriginPatternSpec.$,
    'CorsOriginPattern',
    [
      mojo.internal.StructField(
        'protocol', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domain', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'port', 16,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domainMatchMode', 20,
        0,
        CorsDomainMatchModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'portMatchMode', 24,
        0,
        CorsPortMatchModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priority', 28,
        0,
        CorsOriginAccessMatchPrioritySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CorsOriginPattern {
  constructor() {
    /** @type { !string } */
    this.protocol;
    /** @type { !string } */
    this.domain;
    /** @type { !number } */
    this.port;
    /** @type { !CorsDomainMatchMode } */
    this.domainMatchMode;
    /** @type { !CorsPortMatchMode } */
    this.portMatchMode;
    /** @type { !CorsOriginAccessMatchPriority } */
    this.priority;
  }
}



mojo.internal.Struct(
    CorsOriginAccessPatternsSpec.$,
    'CorsOriginAccessPatterns',
    [
      mojo.internal.StructField(
        'sourceOrigin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowPatterns', 8,
        0,
        mojo.internal.Array(CorsOriginPatternSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blockPatterns', 16,
        0,
        mojo.internal.Array(CorsOriginPatternSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CorsOriginAccessPatterns {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.sourceOrigin;
    /** @type { !Array<!CorsOriginPattern> } */
    this.allowPatterns;
    /** @type { !Array<!CorsOriginPattern> } */
    this.blockPatterns;
  }
}

