// services/network/public/mojom/cors.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CORS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CORS_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/cors.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"

#include "services/network/public/mojom/cors.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CorsPreflightPolicy, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CorsError, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::PrivateNetworkAccessPreflightResult, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CorsErrorStatusDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CorsErrorStatusDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CorsErrorStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::CorsError>(
        Traits::cors_error(input),
        &fragment->cors_error);

      decltype(Traits::failed_parameter(input)) in_failed_parameter = Traits::failed_parameter(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->failed_parameter)::BaseType> failed_parameter_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_failed_parameter,
        failed_parameter_fragment);

      fragment->failed_parameter.Set(
          failed_parameter_fragment.is_null() ? nullptr : failed_parameter_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->failed_parameter.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null failed_parameter in CorsErrorStatus struct");

      
      mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::target_address_space(input),
        &fragment->target_address_space);

      
      mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::resource_address_space(input),
        &fragment->resource_address_space);

      fragment->has_authorization_covered_by_wildcard_on_preflight = Traits::has_authorization_covered_by_wildcard_on_preflight(input);

      decltype(Traits::issue_id(input)) in_issue_id = Traits::issue_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->issue_id)::BaseType> issue_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_issue_id,
        issue_id_fragment);

      fragment->issue_id.Set(
          issue_id_fragment.is_null() ? nullptr : issue_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->issue_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null issue_id in CorsErrorStatus struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CORS_MOJOM_SEND_VALIDATION_H_