// services/network/public/mojom/client_security_state.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/client_security_state.mojom-shared-internal.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/document_isolation_policy.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"


namespace network::mojom {
class ClientSecurityStateDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ClientSecurityStateDataView> {
  using Data = ::network::mojom::internal::ClientSecurityState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class PrivateNetworkRequestPolicy : int32_t {
  
  kAllow = 0,
  
  kWarn = 1,
  
  kBlock = 2,
  
  kPreflightWarn = 3,
  
  kPreflightBlock = 4,
  
  kPermissionWarn = 5,
  
  kPermissionBlock = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, PrivateNetworkRequestPolicy value);
inline bool IsKnownEnumValue(PrivateNetworkRequestPolicy value) {
  return internal::PrivateNetworkRequestPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ClientSecurityStateDataView {
 public:
  ClientSecurityStateDataView() = default;

  ClientSecurityStateDataView(
      internal::ClientSecurityState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCrossOriginEmbedderPolicyDataView(
      ::network::mojom::CrossOriginEmbedderPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCrossOriginEmbedderPolicy(UserType* output) {
    
    auto* pointer = data_->cross_origin_embedder_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
        pointer, output, message_);
  }
  bool is_web_secure_context() const {
    return data_->is_web_secure_context;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadIpAddressSpace(UserType* output) const {
    auto data_value = data_->ip_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace ip_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->ip_address_space));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPrivateNetworkRequestPolicy(UserType* output) const {
    auto data_value = data_->private_network_request_policy;
    return mojo::internal::Deserialize<::network::mojom::PrivateNetworkRequestPolicy>(
        data_value, output);
  }
  PrivateNetworkRequestPolicy private_network_request_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::PrivateNetworkRequestPolicy>(data_->private_network_request_policy));
  }
  inline void GetDocumentIsolationPolicyDataView(
      ::network::mojom::DocumentIsolationPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentIsolationPolicy(UserType* output) {
    
    auto* pointer = data_->document_isolation_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::DocumentIsolationPolicyDataView>(
        pointer, output, message_);
  }
 private:
  internal::ClientSecurityState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_DATA_VIEW_H_