// services/network/public/mojom/clear_data_filter.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/clear_data_filter.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }



  function ClearDataFilter(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  ClearDataFilter.Type = {};
  ClearDataFilter.Type.DELETE_MATCHES = 0;
  ClearDataFilter.Type.KEEP_MATCHES = 1;
  ClearDataFilter.Type.MIN_VALUE = 0;
  ClearDataFilter.Type.MAX_VALUE = 1;

  ClearDataFilter.Type.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ClearDataFilter.Type.toKnownEnumValue = function(value) {
    return value;
  };

  ClearDataFilter.Type.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  ClearDataFilter.prototype.initDefaults_ = function() {
    this.type = 0;
    this.domains = null;
    this.origins = null;
  };
  ClearDataFilter.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClearDataFilter.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClearDataFilter.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ClearDataFilter.Type);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClearDataFilter.domains
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClearDataFilter.origins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(origin$.Origin), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClearDataFilter.encodedSize = codec.kStructHeaderSize + 24;

  ClearDataFilter.decode = function(decoder) {
    var packed;
    var val = new ClearDataFilter();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(ClearDataFilter.Type));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.domains =
        decoder.decodeArrayPointer(codec.String);
    val.origins =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    return val;
  };

  ClearDataFilter.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClearDataFilter.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.String, val.domains);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.origins);
  };
  exports.ClearDataFilter = ClearDataFilter;
})();