// services/media_session/public/mojom/audio_focus.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_BLINK_TEST_UTILS_H_

#include "services/media_session/public/mojom/audio_focus.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace media_session::mojom::blink {


class BLINK_PLATFORM_EXPORT AudioFocusObserverInterceptorForTesting : public AudioFocusObserver {
  virtual AudioFocusObserver* GetForwardingInterface() = 0;
  void OnFocusGained(AudioFocusRequestStatePtr state) override;
  void OnFocusLost(AudioFocusRequestStatePtr state) override;
  void OnRequestIdReleased(const ::base::UnguessableToken& request_id) override;
};
class BLINK_PLATFORM_EXPORT AudioFocusObserverAsyncWaiter {
 public:
  explicit AudioFocusObserverAsyncWaiter(AudioFocusObserver* proxy);

  AudioFocusObserverAsyncWaiter(const AudioFocusObserverAsyncWaiter&) = delete;
  AudioFocusObserverAsyncWaiter& operator=(const AudioFocusObserverAsyncWaiter&) = delete;

  ~AudioFocusObserverAsyncWaiter();

 private:
  AudioFocusObserver* const proxy_;
};


class BLINK_PLATFORM_EXPORT AudioFocusRequestClientInterceptorForTesting : public AudioFocusRequestClient {
  virtual AudioFocusRequestClient* GetForwardingInterface() = 0;
  void RequestAudioFocus(::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, RequestAudioFocusCallback callback) override;
  void AbandonAudioFocus() override;
  void MediaSessionInfoChanged(::media_session::mojom::blink::MediaSessionInfoPtr session_info) override;
};
class BLINK_PLATFORM_EXPORT AudioFocusRequestClientAsyncWaiter {
 public:
  explicit AudioFocusRequestClientAsyncWaiter(AudioFocusRequestClient* proxy);

  AudioFocusRequestClientAsyncWaiter(const AudioFocusRequestClientAsyncWaiter&) = delete;
  AudioFocusRequestClientAsyncWaiter& operator=(const AudioFocusRequestClientAsyncWaiter&) = delete;

  ~AudioFocusRequestClientAsyncWaiter();
  void RequestAudioFocus(
      ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type);
  

 private:
  AudioFocusRequestClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT AudioFocusManagerInterceptorForTesting : public AudioFocusManager {
  virtual AudioFocusManager* GetForwardingInterface() = 0;
  void RequestAudioFocus(::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, RequestAudioFocusCallback callback) override;
  void RequestGroupedAudioFocus(const ::base::UnguessableToken& request_id, ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, const ::base::UnguessableToken& group_id, RequestGroupedAudioFocusCallback callback) override;
  void GetFocusRequests(GetFocusRequestsCallback callback) override;
  void AddObserver(::mojo::PendingRemote<AudioFocusObserver> observer) override;
  void SetSource(const ::base::UnguessableToken& identity, const ::blink::String& name) override;
  void SetEnforcementMode(EnforcementMode mode) override;
  void AddSourceObserver(const ::base::UnguessableToken& source_id, ::mojo::PendingRemote<AudioFocusObserver> observer) override;
  void GetSourceFocusRequests(const ::base::UnguessableToken& source_id, GetSourceFocusRequestsCallback callback) override;
  void RequestIdReleased(const ::base::UnguessableToken& request_id) override;
  void StartDuckingAllAudio(const std::optional<::base::UnguessableToken>& exempted_request_id) override;
  void StopDuckingAllAudio() override;
  void FlushForTesting(FlushForTestingCallback callback) override;
};
class BLINK_PLATFORM_EXPORT AudioFocusManagerAsyncWaiter {
 public:
  explicit AudioFocusManagerAsyncWaiter(AudioFocusManager* proxy);

  AudioFocusManagerAsyncWaiter(const AudioFocusManagerAsyncWaiter&) = delete;
  AudioFocusManagerAsyncWaiter& operator=(const AudioFocusManagerAsyncWaiter&) = delete;

  ~AudioFocusManagerAsyncWaiter();
  void RequestAudioFocus(
      ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, ::base::UnguessableToken* out_request_id);
  ::base::UnguessableToken RequestAudioFocus(::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type);
  void RequestGroupedAudioFocus(
      const ::base::UnguessableToken& request_id, ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, const ::base::UnguessableToken& group_id, bool* out_success);
  bool RequestGroupedAudioFocus(const ::base::UnguessableToken& request_id, ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, const ::base::UnguessableToken& group_id);
  void GetFocusRequests(
      ::blink::Vector<AudioFocusRequestStatePtr>* out_requests);
  ::blink::Vector<AudioFocusRequestStatePtr> GetFocusRequests();
  void GetSourceFocusRequests(
      const ::base::UnguessableToken& source_id, ::blink::Vector<AudioFocusRequestStatePtr>* out_requests);
  ::blink::Vector<AudioFocusRequestStatePtr> GetSourceFocusRequests(const ::base::UnguessableToken& source_id);
  void FlushForTesting(
      );
  

 private:
  AudioFocusManager* const proxy_;
};


class BLINK_PLATFORM_EXPORT AudioFocusManagerDebugInterceptorForTesting : public AudioFocusManagerDebug {
  virtual AudioFocusManagerDebug* GetForwardingInterface() = 0;
  void GetDebugInfoForRequest(const ::base::UnguessableToken& request_id, GetDebugInfoForRequestCallback callback) override;
};
class BLINK_PLATFORM_EXPORT AudioFocusManagerDebugAsyncWaiter {
 public:
  explicit AudioFocusManagerDebugAsyncWaiter(AudioFocusManagerDebug* proxy);

  AudioFocusManagerDebugAsyncWaiter(const AudioFocusManagerDebugAsyncWaiter&) = delete;
  AudioFocusManagerDebugAsyncWaiter& operator=(const AudioFocusManagerDebugAsyncWaiter&) = delete;

  ~AudioFocusManagerDebugAsyncWaiter();
  void GetDebugInfoForRequest(
      const ::base::UnguessableToken& request_id, ::media_session::mojom::blink::MediaSessionDebugInfoPtr* out_debug_info);
  ::media_session::mojom::blink::MediaSessionDebugInfoPtr GetDebugInfoForRequest(const ::base::UnguessableToken& request_id);

 private:
  AudioFocusManagerDebug* const proxy_;
};




}  // media_session::mojom::blink

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_BLINK_TEST_UTILS_H_