// services/device/public/mojom/wake_lock_provider.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  WakeLockReason as device_mojom_WakeLockReason,
  WakeLockReasonSpec as device_mojom_WakeLockReasonSpec,
  WakeLockType as device_mojom_WakeLockType,
  WakeLockTypeSpec as device_mojom_WakeLockTypeSpec,
  WakeLockRemote as device_mojom_WakeLockRemote,
  WakeLockPendingReceiver as device_mojom_WakeLockPendingReceiver
} from './wake_lock.mojom.m.js';

import {
  WakeLockContextRemote as device_mojom_WakeLockContextRemote,
  WakeLockContextPendingReceiver as device_mojom_WakeLockContextPendingReceiver
} from './wake_lock_context.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WakeLockProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.WakeLockProvider', scope);
  }
}

/** @interface */
export class WakeLockProviderInterface {
  
  /**
   * @param { !number } contextId
   * @param { !device_mojom_WakeLockContextPendingReceiver } context
   */

  getWakeLockContextForID(contextId, context) {}
  
  /**
   * @param { !device_mojom_WakeLockType } type
   * @param { !device_mojom_WakeLockReason } reason
   * @param { !string } description
   * @param { !device_mojom_WakeLockPendingReceiver } wakeLock
   */

  getWakeLockWithoutContext(type, reason, description, wakeLock) {}
  
  /**
   * @param { !device_mojom_WakeLockType } type
   * @param { !WakeLockObserverRemote } observer
   */

  notifyOnWakeLockDeactivation(type, observer) {}
  
  /**
   * @param { !device_mojom_WakeLockType } type
   * @return {!Promise<{
        count: !number,
   *  }>}
   */

  getActiveWakeLocksForTests(type) {}
}

/**
 * @implements { WakeLockProviderInterface }
 */
export class WakeLockProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WakeLockProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WakeLockProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WakeLockProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } contextId
   * @param { !device_mojom_WakeLockContextPendingReceiver } context
   */

  getWakeLockContextForID(
      contextId,
      context) {
    this.proxy.sendMessage(
        0,
        WakeLockProvider_GetWakeLockContextForID_ParamsSpec.$,
        null,
        [
          contextId,
          context
        ],
        false);
  }

  
  /**
   * @param { !device_mojom_WakeLockType } type
   * @param { !device_mojom_WakeLockReason } reason
   * @param { !string } description
   * @param { !device_mojom_WakeLockPendingReceiver } wakeLock
   */

  getWakeLockWithoutContext(
      type,
      reason,
      description,
      wakeLock) {
    this.proxy.sendMessage(
        1,
        WakeLockProvider_GetWakeLockWithoutContext_ParamsSpec.$,
        null,
        [
          type,
          reason,
          description,
          wakeLock
        ],
        false);
  }

  
  /**
   * @param { !device_mojom_WakeLockType } type
   * @param { !WakeLockObserverRemote } observer
   */

  notifyOnWakeLockDeactivation(
      type,
      observer) {
    this.proxy.sendMessage(
        2,
        WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsSpec.$,
        null,
        [
          type,
          observer
        ],
        false);
  }

  
  /**
   * @param { !device_mojom_WakeLockType } type
   * @return {!Promise<{
        count: !number,
   *  }>}
   */

  getActiveWakeLocksForTests(
      type) {
    return this.proxy.sendMessage(
        3,
        WakeLockProvider_GetActiveWakeLocksForTests_ParamsSpec.$,
        WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WakeLockProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WakeLockProviderReceiver {
  /**
   * @param {!WakeLockProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WakeLockProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WakeLockProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WakeLockProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WakeLockProvider_GetWakeLockContextForID_ParamsSpec.$,
        null,
        impl.getWakeLockContextForID.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WakeLockProvider_GetWakeLockWithoutContext_ParamsSpec.$,
        null,
        impl.getWakeLockWithoutContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsSpec.$,
        null,
        impl.notifyOnWakeLockDeactivation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WakeLockProvider_GetActiveWakeLocksForTests_ParamsSpec.$,
        WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsSpec.$,
        impl.getActiveWakeLocksForTests.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WakeLockProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.WakeLockProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WakeLockProviderRemote}
   */
  static getRemote() {
    let remote = new WakeLockProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WakeLockProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WakeLockProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WakeLockProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WakeLockProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getWakeLockContextForID =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WakeLockProvider_GetWakeLockContextForID_ParamsSpec.$,
        null,
        this.getWakeLockContextForID.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getWakeLockWithoutContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WakeLockProvider_GetWakeLockWithoutContext_ParamsSpec.$,
        null,
        this.getWakeLockWithoutContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyOnWakeLockDeactivation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsSpec.$,
        null,
        this.notifyOnWakeLockDeactivation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getActiveWakeLocksForTests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WakeLockProvider_GetActiveWakeLocksForTests_ParamsSpec.$,
        WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsSpec.$,
        this.getActiveWakeLocksForTests.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WakeLockObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.WakeLockObserver', scope);
  }
}

/** @interface */
export class WakeLockObserverInterface {
  
  /**
   * @param { !device_mojom_WakeLockType } type
   */

  onWakeLockDeactivated(type) {}
}

/**
 * @implements { WakeLockObserverInterface }
 */
export class WakeLockObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WakeLockObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WakeLockObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WakeLockObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device_mojom_WakeLockType } type
   */

  onWakeLockDeactivated(
      type) {
    this.proxy.sendMessage(
        0,
        WakeLockObserver_OnWakeLockDeactivated_ParamsSpec.$,
        null,
        [
          type
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WakeLockObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WakeLockObserverReceiver {
  /**
   * @param {!WakeLockObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WakeLockObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WakeLockObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WakeLockObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WakeLockObserver_OnWakeLockDeactivated_ParamsSpec.$,
        null,
        impl.onWakeLockDeactivated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WakeLockObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.WakeLockObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WakeLockObserverRemote}
   */
  static getRemote() {
    let remote = new WakeLockObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WakeLockObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WakeLockObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WakeLockObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WakeLockObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWakeLockDeactivated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WakeLockObserver_OnWakeLockDeactivated_ParamsSpec.$,
        null,
        this.onWakeLockDeactivated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLockProvider_GetWakeLockContextForID_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLockProvider_GetWakeLockWithoutContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLockProvider_GetActiveWakeLocksForTests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLockObserver_OnWakeLockDeactivated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WakeLockProvider_GetWakeLockContextForID_ParamsSpec.$,
    'WakeLockProvider_GetWakeLockContextForID_Params',
    [
      mojo.internal.StructField(
        'contextId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'context', 4,
        0,
        mojo.internal.InterfaceRequest(device_mojom_WakeLockContextPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WakeLockProvider_GetWakeLockContextForID_Params {
  constructor() {
    /** @type { !number } */
    this.contextId;
    /** @type { !device_mojom_WakeLockContextPendingReceiver } */
    this.context;
  }
}



mojo.internal.Struct(
    WakeLockProvider_GetWakeLockWithoutContext_ParamsSpec.$,
    'WakeLockProvider_GetWakeLockWithoutContext_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device_mojom_WakeLockTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reason', 4,
        0,
        device_mojom_WakeLockReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wakeLock', 16,
        0,
        mojo.internal.InterfaceRequest(device_mojom_WakeLockPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class WakeLockProvider_GetWakeLockWithoutContext_Params {
  constructor() {
    /** @type { !device_mojom_WakeLockType } */
    this.type;
    /** @type { !device_mojom_WakeLockReason } */
    this.reason;
    /** @type { !string } */
    this.description;
    /** @type { !device_mojom_WakeLockPendingReceiver } */
    this.wakeLock;
  }
}



mojo.internal.Struct(
    WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsSpec.$,
    'WakeLockProvider_NotifyOnWakeLockDeactivation_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device_mojom_WakeLockTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 4,
        0,
        mojo.internal.InterfaceProxy(WakeLockObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WakeLockProvider_NotifyOnWakeLockDeactivation_Params {
  constructor() {
    /** @type { !device_mojom_WakeLockType } */
    this.type;
    /** @type { !WakeLockObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    WakeLockProvider_GetActiveWakeLocksForTests_ParamsSpec.$,
    'WakeLockProvider_GetActiveWakeLocksForTests_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device_mojom_WakeLockTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WakeLockProvider_GetActiveWakeLocksForTests_Params {
  constructor() {
    /** @type { !device_mojom_WakeLockType } */
    this.type;
  }
}



mojo.internal.Struct(
    WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsSpec.$,
    'WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.count;
  }
}



mojo.internal.Struct(
    WakeLockObserver_OnWakeLockDeactivated_ParamsSpec.$,
    'WakeLockObserver_OnWakeLockDeactivated_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device_mojom_WakeLockTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WakeLockObserver_OnWakeLockDeactivated_Params {
  constructor() {
    /** @type { !device_mojom_WakeLockType } */
    this.type;
  }
}

