// services/device/public/mojom/smart_card.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/smart_card.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/smart_card.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* SmartCardSuccessToStringHelper(SmartCardSuccess value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SmartCardSuccess::kOk:
      return "kOk";
    default:
      return nullptr;
  }
}

std::string SmartCardSuccessToString(SmartCardSuccess value) {
  const char *str = SmartCardSuccessToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SmartCardSuccess value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SmartCardSuccess value) {
  return os << SmartCardSuccessToString(value);
}

NOINLINE static const char* SmartCardErrorToStringHelper(SmartCardError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SmartCardError::kRemovedCard:
      return "kRemovedCard";
    case SmartCardError::kResetCard:
      return "kResetCard";
    case SmartCardError::kUnpoweredCard:
      return "kUnpoweredCard";
    case SmartCardError::kUnresponsiveCard:
      return "kUnresponsiveCard";
    case SmartCardError::kUnsupportedCard:
      return "kUnsupportedCard";
    case SmartCardError::kReaderUnavailable:
      return "kReaderUnavailable";
    case SmartCardError::kSharingViolation:
      return "kSharingViolation";
    case SmartCardError::kNotTransacted:
      return "kNotTransacted";
    case SmartCardError::kNoSmartcard:
      return "kNoSmartcard";
    case SmartCardError::kProtoMismatch:
      return "kProtoMismatch";
    case SmartCardError::kSystemCancelled:
      return "kSystemCancelled";
    case SmartCardError::kNotReady:
      return "kNotReady";
    case SmartCardError::kCancelled:
      return "kCancelled";
    case SmartCardError::kInsufficientBuffer:
      return "kInsufficientBuffer";
    case SmartCardError::kInvalidHandle:
      return "kInvalidHandle";
    case SmartCardError::kInvalidParameter:
      return "kInvalidParameter";
    case SmartCardError::kInvalidValue:
      return "kInvalidValue";
    case SmartCardError::kNoMemory:
      return "kNoMemory";
    case SmartCardError::kTimeout:
      return "kTimeout";
    case SmartCardError::kUnknownReader:
      return "kUnknownReader";
    case SmartCardError::kUnsupportedFeature:
      return "kUnsupportedFeature";
    case SmartCardError::kNoReadersAvailable:
      return "kNoReadersAvailable";
    case SmartCardError::kServiceStopped:
      return "kServiceStopped";
    case SmartCardError::kNoService:
      return "kNoService";
    case SmartCardError::kCommError:
      return "kCommError";
    case SmartCardError::kInternalError:
      return "kInternalError";
    case SmartCardError::kUnknownError:
      return "kUnknownError";
    case SmartCardError::kServerTooBusy:
      return "kServerTooBusy";
    case SmartCardError::kUnexpected:
      return "kUnexpected";
    case SmartCardError::kShutdown:
      return "kShutdown";
    case SmartCardError::kUnknown:
      return "kUnknown";
    case SmartCardError::kPermissionDenied:
      return "kPermissionDenied";
    default:
      return nullptr;
  }
}

std::string SmartCardErrorToString(SmartCardError value) {
  const char *str = SmartCardErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SmartCardError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SmartCardError value) {
  return os << SmartCardErrorToString(value);
}

NOINLINE static const char* SmartCardShareModeToStringHelper(SmartCardShareMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SmartCardShareMode::kShared:
      return "kShared";
    case SmartCardShareMode::kExclusive:
      return "kExclusive";
    case SmartCardShareMode::kDirect:
      return "kDirect";
    default:
      return nullptr;
  }
}

std::string SmartCardShareModeToString(SmartCardShareMode value) {
  const char *str = SmartCardShareModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SmartCardShareMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SmartCardShareMode value) {
  return os << SmartCardShareModeToString(value);
}

NOINLINE static const char* SmartCardProtocolToStringHelper(SmartCardProtocol value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SmartCardProtocol::kUndefined:
      return "kUndefined";
    case SmartCardProtocol::kT0:
      return "kT0";
    case SmartCardProtocol::kT1:
      return "kT1";
    case SmartCardProtocol::kRaw:
      return "kRaw";
    default:
      return nullptr;
  }
}

std::string SmartCardProtocolToString(SmartCardProtocol value) {
  const char *str = SmartCardProtocolToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SmartCardProtocol value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SmartCardProtocol value) {
  return os << SmartCardProtocolToString(value);
}

NOINLINE static const char* SmartCardDispositionToStringHelper(SmartCardDisposition value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SmartCardDisposition::kLeave:
      return "kLeave";
    case SmartCardDisposition::kReset:
      return "kReset";
    case SmartCardDisposition::kUnpower:
      return "kUnpower";
    case SmartCardDisposition::kEject:
      return "kEject";
    default:
      return nullptr;
  }
}

std::string SmartCardDispositionToString(SmartCardDisposition value) {
  const char *str = SmartCardDispositionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SmartCardDisposition value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SmartCardDisposition value) {
  return os << SmartCardDispositionToString(value);
}

NOINLINE static const char* SmartCardConnectionStateToStringHelper(SmartCardConnectionState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SmartCardConnectionState::kAbsent:
      return "kAbsent";
    case SmartCardConnectionState::kPresent:
      return "kPresent";
    case SmartCardConnectionState::kSwallowed:
      return "kSwallowed";
    case SmartCardConnectionState::kPowered:
      return "kPowered";
    case SmartCardConnectionState::kNegotiable:
      return "kNegotiable";
    case SmartCardConnectionState::kSpecific:
      return "kSpecific";
    default:
      return nullptr;
  }
}

std::string SmartCardConnectionStateToString(SmartCardConnectionState value) {
  const char *str = SmartCardConnectionStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SmartCardConnectionState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SmartCardConnectionState value) {
  return os << SmartCardConnectionStateToString(value);
}

namespace internal {
// static
bool SmartCardResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SmartCardResult_Data* object = static_cast<const SmartCardResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SmartCardResult_Tag::kSuccess: {


      if (!::device::mojom::internal::SmartCardSuccess_Data
            ::Validate(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case SmartCardResult_Tag::kError: {


      if (!::device::mojom::internal::SmartCardError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SmartCardResult");
      return false;
    }
  }
}
// static
bool SmartCardStatusChangeResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SmartCardStatusChangeResult_Data* object = static_cast<const SmartCardStatusChangeResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SmartCardStatusChangeResult_Tag::kReaderStates: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_reader_states, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& reader_states_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_reader_states, validation_context,
                                             &reader_states_validate_params)) {
        return false;
      }
      return true;
    }
    case SmartCardStatusChangeResult_Tag::kError: {


      if (!::device::mojom::internal::SmartCardError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SmartCardStatusChangeResult");
      return false;
    }
  }
}
// static
bool SmartCardListReadersResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SmartCardListReadersResult_Data* object = static_cast<const SmartCardListReadersResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SmartCardListReadersResult_Tag::kReaders: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_readers, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& readers_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      if (!mojo::internal::ValidateContainer(object->data.f_readers, validation_context,
                                             &readers_validate_params)) {
        return false;
      }
      return true;
    }
    case SmartCardListReadersResult_Tag::kError: {


      if (!::device::mojom::internal::SmartCardError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SmartCardListReadersResult");
      return false;
    }
  }
}
// static
bool SmartCardCreateContextResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SmartCardCreateContextResult_Data* object = static_cast<const SmartCardCreateContextResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SmartCardCreateContextResult_Tag::kContext: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_context, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_context,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    case SmartCardCreateContextResult_Tag::kError: {


      if (!::device::mojom::internal::SmartCardError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SmartCardCreateContextResult");
      return false;
    }
  }
}
// static
bool SmartCardConnectResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SmartCardConnectResult_Data* object = static_cast<const SmartCardConnectResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SmartCardConnectResult_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case SmartCardConnectResult_Tag::kError: {


      if (!::device::mojom::internal::SmartCardError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SmartCardConnectResult");
      return false;
    }
  }
}
// static
bool SmartCardDataResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SmartCardDataResult_Data* object = static_cast<const SmartCardDataResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SmartCardDataResult_Tag::kData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_data, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_data, validation_context,
                                             &data_validate_params)) {
        return false;
      }
      return true;
    }
    case SmartCardDataResult_Tag::kError: {


      if (!::device::mojom::internal::SmartCardError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SmartCardDataResult");
      return false;
    }
  }
}
// static
bool SmartCardStatusResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SmartCardStatusResult_Data* object = static_cast<const SmartCardStatusResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SmartCardStatusResult_Tag::kStatus: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_status, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_status, validation_context))
        return false;
      return true;
    }
    case SmartCardStatusResult_Tag::kError: {


      if (!::device::mojom::internal::SmartCardError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SmartCardStatusResult");
      return false;
    }
  }
}
// static
bool SmartCardTransactionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SmartCardTransactionResult_Data* object = static_cast<const SmartCardTransactionResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SmartCardTransactionResult_Tag::kTransaction: {

      if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
              object->data.f_transaction, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateHandleOrInterface(object->data.f_transaction,
                                                     validation_context)) {
        return false;
      }
      return true;
    }
    case SmartCardTransactionResult_Tag::kError: {


      if (!::device::mojom::internal::SmartCardError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SmartCardTransactionResult");
      return false;
    }
  }
}


// static
bool SmartCardReaderStateFlags_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardReaderStateFlags_Data* object =
      static_cast<const SmartCardReaderStateFlags_Data*>(data);

  return true;
}

SmartCardReaderStateFlags_Data::SmartCardReaderStateFlags_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardReaderStateIn_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardReaderStateIn_Data* object =
      static_cast<const SmartCardReaderStateIn_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reader, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reader_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reader, validation_context,
                                         &reader_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->current_state, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->current_state, validation_context))
    return false;

  return true;
}

SmartCardReaderStateIn_Data::SmartCardReaderStateIn_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardReaderStateOut_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardReaderStateOut_Data* object =
      static_cast<const SmartCardReaderStateOut_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reader, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reader_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reader, validation_context,
                                         &reader_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_state, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->answer_to_reset, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& answer_to_reset_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->answer_to_reset, validation_context,
                                         &answer_to_reset_validate_params)) {
    return false;
  }

  return true;
}

SmartCardReaderStateOut_Data::SmartCardReaderStateOut_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardProtocols_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardProtocols_Data* object =
      static_cast<const SmartCardProtocols_Data*>(data);

  return true;
}

SmartCardProtocols_Data::SmartCardProtocols_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardStatus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardStatus_Data* object =
      static_cast<const SmartCardStatus_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reader_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reader_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reader_name, validation_context,
                                         &reader_name_validate_params)) {
    return false;
  }


  if (!::device::mojom::internal::SmartCardConnectionState_Data
        ::Validate(object->state, validation_context))
    return false;


  if (!::device::mojom::internal::SmartCardProtocol_Data
        ::Validate(object->protocol, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->answer_to_reset, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& answer_to_reset_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->answer_to_reset, validation_context,
                                         &answer_to_reset_validate_params)) {
    return false;
  }

  return true;
}

SmartCardStatus_Data::SmartCardStatus_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnectSuccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnectSuccess_Data* object =
      static_cast<const SmartCardConnectSuccess_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->connection, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->connection,
                                                 validation_context)) {
    return false;
  }


  if (!::device::mojom::internal::SmartCardProtocol_Data
        ::Validate(object->active_protocol, validation_context))
    return false;

  return true;
}

SmartCardConnectSuccess_Data::SmartCardConnectSuccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardTransaction_EndTransaction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardTransaction_EndTransaction_Params_Data* object =
      static_cast<const SmartCardTransaction_EndTransaction_Params_Data*>(data);


  if (!::device::mojom::internal::SmartCardDisposition_Data
        ::Validate(object->disposition, validation_context))
    return false;

  return true;
}

SmartCardTransaction_EndTransaction_Params_Data::SmartCardTransaction_EndTransaction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardTransaction_EndTransaction_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardTransaction_EndTransaction_ResponseParams_Data* object =
      static_cast<const SmartCardTransaction_EndTransaction_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardTransaction_EndTransaction_ResponseParams_Data::SmartCardTransaction_EndTransaction_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_Disconnect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_Disconnect_Params_Data* object =
      static_cast<const SmartCardConnection_Disconnect_Params_Data*>(data);


  if (!::device::mojom::internal::SmartCardDisposition_Data
        ::Validate(object->disposition, validation_context))
    return false;

  return true;
}

SmartCardConnection_Disconnect_Params_Data::SmartCardConnection_Disconnect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_Disconnect_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_Disconnect_ResponseParams_Data* object =
      static_cast<const SmartCardConnection_Disconnect_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardConnection_Disconnect_ResponseParams_Data::SmartCardConnection_Disconnect_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_Transmit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_Transmit_Params_Data* object =
      static_cast<const SmartCardConnection_Transmit_Params_Data*>(data);


  if (!::device::mojom::internal::SmartCardProtocol_Data
        ::Validate(object->protocol, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

SmartCardConnection_Transmit_Params_Data::SmartCardConnection_Transmit_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_Transmit_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_Transmit_ResponseParams_Data* object =
      static_cast<const SmartCardConnection_Transmit_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardConnection_Transmit_ResponseParams_Data::SmartCardConnection_Transmit_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_Control_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_Control_Params_Data* object =
      static_cast<const SmartCardConnection_Control_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

SmartCardConnection_Control_Params_Data::SmartCardConnection_Control_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_Control_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_Control_ResponseParams_Data* object =
      static_cast<const SmartCardConnection_Control_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardConnection_Control_ResponseParams_Data::SmartCardConnection_Control_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_GetAttrib_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_GetAttrib_Params_Data* object =
      static_cast<const SmartCardConnection_GetAttrib_Params_Data*>(data);

  return true;
}

SmartCardConnection_GetAttrib_Params_Data::SmartCardConnection_GetAttrib_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_GetAttrib_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_GetAttrib_ResponseParams_Data* object =
      static_cast<const SmartCardConnection_GetAttrib_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardConnection_GetAttrib_ResponseParams_Data::SmartCardConnection_GetAttrib_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_SetAttrib_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_SetAttrib_Params_Data* object =
      static_cast<const SmartCardConnection_SetAttrib_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

SmartCardConnection_SetAttrib_Params_Data::SmartCardConnection_SetAttrib_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_SetAttrib_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_SetAttrib_ResponseParams_Data* object =
      static_cast<const SmartCardConnection_SetAttrib_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardConnection_SetAttrib_ResponseParams_Data::SmartCardConnection_SetAttrib_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_Status_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_Status_Params_Data* object =
      static_cast<const SmartCardConnection_Status_Params_Data*>(data);

  return true;
}

SmartCardConnection_Status_Params_Data::SmartCardConnection_Status_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_Status_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_Status_ResponseParams_Data* object =
      static_cast<const SmartCardConnection_Status_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardConnection_Status_ResponseParams_Data::SmartCardConnection_Status_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_BeginTransaction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_BeginTransaction_Params_Data* object =
      static_cast<const SmartCardConnection_BeginTransaction_Params_Data*>(data);

  return true;
}

SmartCardConnection_BeginTransaction_Params_Data::SmartCardConnection_BeginTransaction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnection_BeginTransaction_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnection_BeginTransaction_ResponseParams_Data* object =
      static_cast<const SmartCardConnection_BeginTransaction_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardConnection_BeginTransaction_ResponseParams_Data::SmartCardConnection_BeginTransaction_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardConnectionWatcher_NotifyConnectionUsed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardConnectionWatcher_NotifyConnectionUsed_Params_Data* object =
      static_cast<const SmartCardConnectionWatcher_NotifyConnectionUsed_Params_Data*>(data);

  return true;
}

SmartCardConnectionWatcher_NotifyConnectionUsed_Params_Data::SmartCardConnectionWatcher_NotifyConnectionUsed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardContext_ListReaders_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardContext_ListReaders_Params_Data* object =
      static_cast<const SmartCardContext_ListReaders_Params_Data*>(data);

  return true;
}

SmartCardContext_ListReaders_Params_Data::SmartCardContext_ListReaders_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardContext_ListReaders_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardContext_ListReaders_ResponseParams_Data* object =
      static_cast<const SmartCardContext_ListReaders_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardContext_ListReaders_ResponseParams_Data::SmartCardContext_ListReaders_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardContext_GetStatusChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardContext_GetStatusChange_Params_Data* object =
      static_cast<const SmartCardContext_GetStatusChange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timeout, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timeout, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reader_states, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reader_states_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reader_states, validation_context,
                                         &reader_states_validate_params)) {
    return false;
  }

  return true;
}

SmartCardContext_GetStatusChange_Params_Data::SmartCardContext_GetStatusChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardContext_GetStatusChange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardContext_GetStatusChange_ResponseParams_Data* object =
      static_cast<const SmartCardContext_GetStatusChange_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardContext_GetStatusChange_ResponseParams_Data::SmartCardContext_GetStatusChange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardContext_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardContext_Cancel_Params_Data* object =
      static_cast<const SmartCardContext_Cancel_Params_Data*>(data);

  return true;
}

SmartCardContext_Cancel_Params_Data::SmartCardContext_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardContext_Cancel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardContext_Cancel_ResponseParams_Data* object =
      static_cast<const SmartCardContext_Cancel_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardContext_Cancel_ResponseParams_Data::SmartCardContext_Cancel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardContext_Connect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardContext_Connect_Params_Data* object =
      static_cast<const SmartCardContext_Connect_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reader, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reader_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reader, validation_context,
                                         &reader_validate_params)) {
    return false;
  }


  if (!::device::mojom::internal::SmartCardShareMode_Data
        ::Validate(object->share_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->preferred_protocols, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->preferred_protocols, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->connection_watcher,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SmartCardContext_Connect_Params_Data::SmartCardContext_Connect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardContext_Connect_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardContext_Connect_ResponseParams_Data* object =
      static_cast<const SmartCardContext_Connect_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardContext_Connect_ResponseParams_Data::SmartCardContext_Connect_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardContextFactory_CreateContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardContextFactory_CreateContext_Params_Data* object =
      static_cast<const SmartCardContextFactory_CreateContext_Params_Data*>(data);

  return true;
}

SmartCardContextFactory_CreateContext_Params_Data::SmartCardContextFactory_CreateContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SmartCardContextFactory_CreateContext_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SmartCardContextFactory_CreateContext_ResponseParams_Data* object =
      static_cast<const SmartCardContextFactory_CreateContext_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SmartCardContextFactory_CreateContext_ResponseParams_Data::SmartCardContextFactory_CreateContext_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SmartCardSuccess>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SmartCardSuccess value) {
  return std::move(context).WriteString(::device::mojom::SmartCardSuccessToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SmartCardError>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SmartCardError value) {
  return std::move(context).WriteString(::device::mojom::SmartCardErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SmartCardShareMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SmartCardShareMode value) {
  return std::move(context).WriteString(::device::mojom::SmartCardShareModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SmartCardProtocol>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SmartCardProtocol value) {
  return std::move(context).WriteString(::device::mojom::SmartCardProtocolToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SmartCardDisposition>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SmartCardDisposition value) {
  return std::move(context).WriteString(::device::mojom::SmartCardDispositionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SmartCardConnectionState>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SmartCardConnectionState value) {
  return std::move(context).WriteString(::device::mojom::SmartCardConnectionStateToString(value));
}

} // namespace perfetto