// services/device/public/mojom/serial.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/device/public/mojom/serial.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('device.mojom');
  var uuid$ =
      mojo.internal.exposeNamespace('bluetooth.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'device/bluetooth/public/mojom/uuid.mojom', '../../../../device/bluetooth/public/mojom/uuid.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }


  var SerialSendError = {};
  SerialSendError.NONE = 0;
  SerialSendError.DISCONNECTED = 1;
  SerialSendError.SYSTEM_ERROR = 2;
  SerialSendError.MIN_VALUE = 0;
  SerialSendError.MAX_VALUE = 2;

  SerialSendError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SerialSendError.toKnownEnumValue = function(value) {
    return value;
  };

  SerialSendError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SerialReceiveError = {};
  SerialReceiveError.NONE = 0;
  SerialReceiveError.DISCONNECTED = 1;
  SerialReceiveError.DEVICE_LOST = 2;
  SerialReceiveError.BREAK = 3;
  SerialReceiveError.FRAME_ERROR = 4;
  SerialReceiveError.OVERRUN = 5;
  SerialReceiveError.BUFFER_OVERFLOW = 6;
  SerialReceiveError.PARITY_ERROR = 7;
  SerialReceiveError.SYSTEM_ERROR = 8;
  SerialReceiveError.MIN_VALUE = 0;
  SerialReceiveError.MAX_VALUE = 8;

  SerialReceiveError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
      return true;
    }
    return false;
  };

  SerialReceiveError.toKnownEnumValue = function(value) {
    return value;
  };

  SerialReceiveError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SerialDataBits = {};
  SerialDataBits.NONE = 0;
  SerialDataBits.SEVEN = 1;
  SerialDataBits.EIGHT = 2;
  SerialDataBits.MIN_VALUE = 0;
  SerialDataBits.MAX_VALUE = 2;

  SerialDataBits.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SerialDataBits.toKnownEnumValue = function(value) {
    return value;
  };

  SerialDataBits.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SerialParityBit = {};
  SerialParityBit.NONE = 0;
  SerialParityBit.NO_PARITY = 1;
  SerialParityBit.ODD = 2;
  SerialParityBit.EVEN = 3;
  SerialParityBit.MIN_VALUE = 0;
  SerialParityBit.MAX_VALUE = 3;

  SerialParityBit.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  SerialParityBit.toKnownEnumValue = function(value) {
    return value;
  };

  SerialParityBit.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SerialStopBits = {};
  SerialStopBits.NONE = 0;
  SerialStopBits.ONE = 1;
  SerialStopBits.TWO = 2;
  SerialStopBits.MIN_VALUE = 0;
  SerialStopBits.MAX_VALUE = 2;

  SerialStopBits.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SerialStopBits.toKnownEnumValue = function(value) {
    return value;
  };

  SerialStopBits.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SerialPortFlushMode = {};
  SerialPortFlushMode.kReceiveAndTransmit = 0;
  SerialPortFlushMode.kReceive = 1;
  SerialPortFlushMode.kTransmit = 2;
  SerialPortFlushMode.MIN_VALUE = 0;
  SerialPortFlushMode.MAX_VALUE = 2;

  SerialPortFlushMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SerialPortFlushMode.toKnownEnumValue = function(value) {
    return value;
  };

  SerialPortFlushMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SerialPortType = {};
  SerialPortType.PLATFORM_SERIAL = 0;
  SerialPortType.BLUETOOTH_CLASSIC_RFCOMM = 1;
  SerialPortType.MIN_VALUE = 0;
  SerialPortType.MAX_VALUE = 1;

  SerialPortType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  SerialPortType.toKnownEnumValue = function(value) {
    return value;
  };

  SerialPortType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SerialPortInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortInfo.prototype.initDefaults_ = function() {
    this.token = null;
    this.path = null;
    this.type = SerialPortType.PLATFORM_SERIAL;
    this.vendorId = 0;
    this.hasVendorId = false;
    this.hasProductId = false;
    this.connected = true;
    this.alternatePath = null;
    this.usbDriverName = null;
    this.productId = 0;
    this.bluetoothServiceClassId = null;
    this.displayName = null;
    this.serialNumber = null;
  };
  SerialPortInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortInfo.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortInfo.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortInfo.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, SerialPortType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortInfo.alternatePath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, file_path$.FilePath, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortInfo.usbDriverName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, true)
    if (err !== validator.validationError.NONE)
        return err;






    // validate SerialPortInfo.bluetoothServiceClassId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, uuid$.UUID, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortInfo.displayName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 56, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortInfo.serialNumber
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 64, true)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SerialPortInfo.encodedSize = codec.kStructHeaderSize + 72;

  SerialPortInfo.decode = function(decoder) {
    var packed;
    var val = new SerialPortInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.type =
        decoder.decodeStruct(new codec.Enum(SerialPortType));
    val.vendorId =
        decoder.decodeStruct(codec.Uint16);
    packed = decoder.readUint8();
    val.hasVendorId = (packed >> 0) & 1 ? true : false;
    val.hasProductId = (packed >> 1) & 1 ? true : false;
    val.connected = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    val.alternatePath =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.usbDriverName =
        decoder.decodeStruct(codec.String);
    val.productId =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.bluetoothServiceClassId =
        decoder.decodeStructPointer(uuid$.UUID);
    val.displayName =
        decoder.decodeStruct(codec.String);
    val.serialNumber =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SerialPortInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.token);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Uint16, val.vendorId);
    packed = 0;
    packed |= (val.hasVendorId & 1) << 0
    packed |= (val.hasProductId & 1) << 1
    packed |= (val.connected & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStructPointer(file_path$.FilePath, val.alternatePath);
    encoder.encodeStruct(codec.String, val.usbDriverName);
    encoder.encodeStruct(codec.Uint16, val.productId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(uuid$.UUID, val.bluetoothServiceClassId);
    encoder.encodeStruct(codec.String, val.displayName);
    encoder.encodeStruct(codec.String, val.serialNumber);
  };
  function SerialConnectionOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialConnectionOptions.prototype.initDefaults_ = function() {
    this.bitrate = 0;
    this.dataBits = SerialDataBits.NONE;
    this.parityBit = SerialParityBit.NONE;
    this.stopBits = SerialStopBits.NONE;
    this.ctsFlowControl = false;
    this.hasCtsFlowControl = false;
  };
  SerialConnectionOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialConnectionOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SerialConnectionOptions.dataBits
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, SerialDataBits);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialConnectionOptions.parityBit
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, SerialParityBit);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialConnectionOptions.stopBits
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, SerialStopBits);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SerialConnectionOptions.encodedSize = codec.kStructHeaderSize + 24;

  SerialConnectionOptions.decode = function(decoder) {
    var packed;
    var val = new SerialConnectionOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bitrate =
        decoder.decodeStruct(codec.Uint32);
    val.dataBits =
        decoder.decodeStruct(new codec.Enum(SerialDataBits));
    val.parityBit =
        decoder.decodeStruct(new codec.Enum(SerialParityBit));
    val.stopBits =
        decoder.decodeStruct(new codec.Enum(SerialStopBits));
    packed = decoder.readUint8();
    val.ctsFlowControl = (packed >> 0) & 1 ? true : false;
    val.hasCtsFlowControl = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SerialConnectionOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialConnectionOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.bitrate);
    encoder.encodeStruct(codec.Int32, val.dataBits);
    encoder.encodeStruct(codec.Int32, val.parityBit);
    encoder.encodeStruct(codec.Int32, val.stopBits);
    packed = 0;
    packed |= (val.ctsFlowControl & 1) << 0
    packed |= (val.hasCtsFlowControl & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SerialConnectionInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialConnectionInfo.prototype.initDefaults_ = function() {
    this.bitrate = 0;
    this.dataBits = SerialDataBits.NONE;
    this.parityBit = SerialParityBit.NONE;
    this.stopBits = SerialStopBits.NONE;
    this.ctsFlowControl = false;
  };
  SerialConnectionInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialConnectionInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SerialConnectionInfo.dataBits
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, SerialDataBits);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialConnectionInfo.parityBit
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, SerialParityBit);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialConnectionInfo.stopBits
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, SerialStopBits);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SerialConnectionInfo.encodedSize = codec.kStructHeaderSize + 24;

  SerialConnectionInfo.decode = function(decoder) {
    var packed;
    var val = new SerialConnectionInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bitrate =
        decoder.decodeStruct(codec.Uint32);
    val.dataBits =
        decoder.decodeStruct(new codec.Enum(SerialDataBits));
    val.parityBit =
        decoder.decodeStruct(new codec.Enum(SerialParityBit));
    val.stopBits =
        decoder.decodeStruct(new codec.Enum(SerialStopBits));
    packed = decoder.readUint8();
    val.ctsFlowControl = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SerialConnectionInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialConnectionInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.bitrate);
    encoder.encodeStruct(codec.Int32, val.dataBits);
    encoder.encodeStruct(codec.Int32, val.parityBit);
    encoder.encodeStruct(codec.Int32, val.stopBits);
    packed = 0;
    packed |= (val.ctsFlowControl & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SerialHostControlSignals(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialHostControlSignals.prototype.initDefaults_ = function() {
    this.dtr = false;
    this.hasDtr = false;
    this.rts = false;
    this.hasRts = false;
    this.brk = false;
    this.hasBrk = false;
  };
  SerialHostControlSignals.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialHostControlSignals.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;







    return validator.validationError.NONE;
  };

  SerialHostControlSignals.encodedSize = codec.kStructHeaderSize + 8;

  SerialHostControlSignals.decode = function(decoder) {
    var packed;
    var val = new SerialHostControlSignals();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.dtr = (packed >> 0) & 1 ? true : false;
    val.hasDtr = (packed >> 1) & 1 ? true : false;
    val.rts = (packed >> 2) & 1 ? true : false;
    val.hasRts = (packed >> 3) & 1 ? true : false;
    val.brk = (packed >> 4) & 1 ? true : false;
    val.hasBrk = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SerialHostControlSignals.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialHostControlSignals.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.dtr & 1) << 0
    packed |= (val.hasDtr & 1) << 1
    packed |= (val.rts & 1) << 2
    packed |= (val.hasRts & 1) << 3
    packed |= (val.brk & 1) << 4
    packed |= (val.hasBrk & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SerialPortControlSignals(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortControlSignals.prototype.initDefaults_ = function() {
    this.dcd = false;
    this.cts = false;
    this.ri = false;
    this.dsr = false;
  };
  SerialPortControlSignals.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortControlSignals.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  SerialPortControlSignals.encodedSize = codec.kStructHeaderSize + 8;

  SerialPortControlSignals.decode = function(decoder) {
    var packed;
    var val = new SerialPortControlSignals();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.dcd = (packed >> 0) & 1 ? true : false;
    val.cts = (packed >> 1) & 1 ? true : false;
    val.ri = (packed >> 2) & 1 ? true : false;
    val.dsr = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SerialPortControlSignals.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortControlSignals.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.dcd & 1) << 0
    packed |= (val.cts & 1) << 1
    packed |= (val.ri & 1) << 2
    packed |= (val.dsr & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SerialPortManager_SetClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortManager_SetClient_Params.prototype.initDefaults_ = function() {
    this.client = new SerialPortManagerClientPtr();
  };
  SerialPortManager_SetClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortManager_SetClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortManager_SetClient_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPortManager_SetClient_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialPortManager_SetClient_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPortManager_SetClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(SerialPortManagerClientPtr));
    return val;
  };

  SerialPortManager_SetClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortManager_SetClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(SerialPortManagerClientPtr), val.client);
  };
  function SerialPortManager_GetDevices_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortManager_GetDevices_Params.prototype.initDefaults_ = function() {
  };
  SerialPortManager_GetDevices_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortManager_GetDevices_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPortManager_GetDevices_Params.encodedSize = codec.kStructHeaderSize + 0;

  SerialPortManager_GetDevices_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPortManager_GetDevices_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SerialPortManager_GetDevices_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortManager_GetDevices_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SerialPortManager_GetDevices_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortManager_GetDevices_ResponseParams.prototype.initDefaults_ = function() {
    this.devices = null;
  };
  SerialPortManager_GetDevices_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortManager_GetDevices_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortManager_GetDevices_ResponseParams.devices
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SerialPortInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPortManager_GetDevices_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SerialPortManager_GetDevices_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialPortManager_GetDevices_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.devices =
        decoder.decodeArrayPointer(new codec.PointerTo(SerialPortInfo));
    return val;
  };

  SerialPortManager_GetDevices_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortManager_GetDevices_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SerialPortInfo), val.devices);
  };
  function SerialPortManager_OpenPort_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortManager_OpenPort_Params.prototype.initDefaults_ = function() {
    this.token = null;
    this.useAlternatePath = false;
    this.options = null;
    this.client = new SerialPortClientPtr();
    this.watcher = new SerialPortConnectionWatcherPtr();
  };
  SerialPortManager_OpenPort_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortManager_OpenPort_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortManager_OpenPort_Params.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SerialPortManager_OpenPort_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, SerialConnectionOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortManager_OpenPort_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 24, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortManager_OpenPort_Params.watcher
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 32, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPortManager_OpenPort_Params.encodedSize = codec.kStructHeaderSize + 40;

  SerialPortManager_OpenPort_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPortManager_OpenPort_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    packed = decoder.readUint8();
    val.useAlternatePath = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.options =
        decoder.decodeStructPointer(SerialConnectionOptions);
    val.client =
        decoder.decodeStruct(new codec.Interface(SerialPortClientPtr));
    val.watcher =
        decoder.decodeStruct(new codec.NullableInterface(SerialPortConnectionWatcherPtr));
    return val;
  };

  SerialPortManager_OpenPort_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortManager_OpenPort_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.token);
    packed = 0;
    packed |= (val.useAlternatePath & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(SerialConnectionOptions, val.options);
    encoder.encodeStruct(new codec.Interface(SerialPortClientPtr), val.client);
    encoder.encodeStruct(new codec.NullableInterface(SerialPortConnectionWatcherPtr), val.watcher);
  };
  function SerialPortManager_OpenPort_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortManager_OpenPort_ResponseParams.prototype.initDefaults_ = function() {
    this.port = new SerialPortPtr();
  };
  SerialPortManager_OpenPort_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortManager_OpenPort_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortManager_OpenPort_ResponseParams.port
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPortManager_OpenPort_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SerialPortManager_OpenPort_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialPortManager_OpenPort_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.port =
        decoder.decodeStruct(new codec.NullableInterface(SerialPortPtr));
    return val;
  };

  SerialPortManager_OpenPort_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortManager_OpenPort_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.NullableInterface(SerialPortPtr), val.port);
  };
  function SerialPortManagerClient_OnPortAdded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortManagerClient_OnPortAdded_Params.prototype.initDefaults_ = function() {
    this.portInfo = null;
  };
  SerialPortManagerClient_OnPortAdded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortManagerClient_OnPortAdded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortManagerClient_OnPortAdded_Params.portInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SerialPortInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPortManagerClient_OnPortAdded_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialPortManagerClient_OnPortAdded_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPortManagerClient_OnPortAdded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.portInfo =
        decoder.decodeStructPointer(SerialPortInfo);
    return val;
  };

  SerialPortManagerClient_OnPortAdded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortManagerClient_OnPortAdded_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SerialPortInfo, val.portInfo);
  };
  function SerialPortManagerClient_OnPortRemoved_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortManagerClient_OnPortRemoved_Params.prototype.initDefaults_ = function() {
    this.portInfo = null;
  };
  SerialPortManagerClient_OnPortRemoved_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortManagerClient_OnPortRemoved_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortManagerClient_OnPortRemoved_Params.portInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SerialPortInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPortManagerClient_OnPortRemoved_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialPortManagerClient_OnPortRemoved_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPortManagerClient_OnPortRemoved_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.portInfo =
        decoder.decodeStructPointer(SerialPortInfo);
    return val;
  };

  SerialPortManagerClient_OnPortRemoved_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortManagerClient_OnPortRemoved_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SerialPortInfo, val.portInfo);
  };
  function SerialPortManagerClient_OnPortConnectedStateChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortManagerClient_OnPortConnectedStateChanged_Params.prototype.initDefaults_ = function() {
    this.portInfo = null;
  };
  SerialPortManagerClient_OnPortConnectedStateChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortManagerClient_OnPortConnectedStateChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortManagerClient_OnPortConnectedStateChanged_Params.portInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SerialPortInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPortManagerClient_OnPortConnectedStateChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialPortManagerClient_OnPortConnectedStateChanged_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPortManagerClient_OnPortConnectedStateChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.portInfo =
        decoder.decodeStructPointer(SerialPortInfo);
    return val;
  };

  SerialPortManagerClient_OnPortConnectedStateChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortManagerClient_OnPortConnectedStateChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SerialPortInfo, val.portInfo);
  };
  function SerialPort_StartWriting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_StartWriting_Params.prototype.initDefaults_ = function() {
    this.consumer = null;
  };
  SerialPort_StartWriting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_StartWriting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPort_StartWriting_Params.consumer
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_StartWriting_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialPort_StartWriting_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPort_StartWriting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.consumer =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SerialPort_StartWriting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_StartWriting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Handle, val.consumer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SerialPort_StartReading_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_StartReading_Params.prototype.initDefaults_ = function() {
    this.producer = null;
  };
  SerialPort_StartReading_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_StartReading_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPort_StartReading_Params.producer
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_StartReading_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialPort_StartReading_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPort_StartReading_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.producer =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SerialPort_StartReading_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_StartReading_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Handle, val.producer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SerialPort_Flush_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_Flush_Params.prototype.initDefaults_ = function() {
    this.mode = 0;
  };
  SerialPort_Flush_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_Flush_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPort_Flush_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SerialPortFlushMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_Flush_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialPort_Flush_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPort_Flush_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(SerialPortFlushMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SerialPort_Flush_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_Flush_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SerialPort_Flush_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_Flush_ResponseParams.prototype.initDefaults_ = function() {
  };
  SerialPort_Flush_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_Flush_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_Flush_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  SerialPort_Flush_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialPort_Flush_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SerialPort_Flush_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_Flush_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function SerialPort_Drain_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_Drain_Params.prototype.initDefaults_ = function() {
  };
  SerialPort_Drain_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_Drain_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_Drain_Params.encodedSize = codec.kStructHeaderSize + 0;

  SerialPort_Drain_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPort_Drain_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SerialPort_Drain_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_Drain_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SerialPort_Drain_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_Drain_ResponseParams.prototype.initDefaults_ = function() {
  };
  SerialPort_Drain_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_Drain_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_Drain_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  SerialPort_Drain_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialPort_Drain_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SerialPort_Drain_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_Drain_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function SerialPort_GetControlSignals_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_GetControlSignals_Params.prototype.initDefaults_ = function() {
  };
  SerialPort_GetControlSignals_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_GetControlSignals_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_GetControlSignals_Params.encodedSize = codec.kStructHeaderSize + 0;

  SerialPort_GetControlSignals_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPort_GetControlSignals_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SerialPort_GetControlSignals_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_GetControlSignals_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SerialPort_GetControlSignals_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_GetControlSignals_ResponseParams.prototype.initDefaults_ = function() {
    this.signals = null;
  };
  SerialPort_GetControlSignals_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_GetControlSignals_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPort_GetControlSignals_ResponseParams.signals
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SerialPortControlSignals, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_GetControlSignals_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SerialPort_GetControlSignals_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialPort_GetControlSignals_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.signals =
        decoder.decodeStructPointer(SerialPortControlSignals);
    return val;
  };

  SerialPort_GetControlSignals_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_GetControlSignals_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SerialPortControlSignals, val.signals);
  };
  function SerialPort_SetControlSignals_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_SetControlSignals_Params.prototype.initDefaults_ = function() {
    this.signals = null;
  };
  SerialPort_SetControlSignals_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_SetControlSignals_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPort_SetControlSignals_Params.signals
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SerialHostControlSignals, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_SetControlSignals_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialPort_SetControlSignals_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPort_SetControlSignals_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.signals =
        decoder.decodeStructPointer(SerialHostControlSignals);
    return val;
  };

  SerialPort_SetControlSignals_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_SetControlSignals_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SerialHostControlSignals, val.signals);
  };
  function SerialPort_SetControlSignals_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_SetControlSignals_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  SerialPort_SetControlSignals_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_SetControlSignals_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SerialPort_SetControlSignals_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SerialPort_SetControlSignals_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialPort_SetControlSignals_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SerialPort_SetControlSignals_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_SetControlSignals_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SerialPort_ConfigurePort_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_ConfigurePort_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  SerialPort_ConfigurePort_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_ConfigurePort_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPort_ConfigurePort_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SerialConnectionOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_ConfigurePort_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialPort_ConfigurePort_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPort_ConfigurePort_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(SerialConnectionOptions);
    return val;
  };

  SerialPort_ConfigurePort_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_ConfigurePort_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SerialConnectionOptions, val.options);
  };
  function SerialPort_ConfigurePort_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_ConfigurePort_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  SerialPort_ConfigurePort_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_ConfigurePort_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SerialPort_ConfigurePort_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SerialPort_ConfigurePort_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialPort_ConfigurePort_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SerialPort_ConfigurePort_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_ConfigurePort_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SerialPort_GetPortInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_GetPortInfo_Params.prototype.initDefaults_ = function() {
  };
  SerialPort_GetPortInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_GetPortInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_GetPortInfo_Params.encodedSize = codec.kStructHeaderSize + 0;

  SerialPort_GetPortInfo_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPort_GetPortInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SerialPort_GetPortInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_GetPortInfo_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SerialPort_GetPortInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_GetPortInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.info = null;
  };
  SerialPort_GetPortInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_GetPortInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPort_GetPortInfo_ResponseParams.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SerialConnectionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_GetPortInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SerialPort_GetPortInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialPort_GetPortInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(SerialConnectionInfo);
    return val;
  };

  SerialPort_GetPortInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_GetPortInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SerialConnectionInfo, val.info);
  };
  function SerialPort_Close_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_Close_Params.prototype.initDefaults_ = function() {
    this.flush = false;
  };
  SerialPort_Close_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_Close_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SerialPort_Close_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialPort_Close_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPort_Close_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.flush = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SerialPort_Close_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_Close_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.flush & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SerialPort_Close_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPort_Close_ResponseParams.prototype.initDefaults_ = function() {
  };
  SerialPort_Close_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPort_Close_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPort_Close_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  SerialPort_Close_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SerialPort_Close_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SerialPort_Close_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPort_Close_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function SerialPortClient_OnReadError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortClient_OnReadError_Params.prototype.initDefaults_ = function() {
    this.error = 0;
  };
  SerialPortClient_OnReadError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortClient_OnReadError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortClient_OnReadError_Params.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SerialReceiveError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPortClient_OnReadError_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialPortClient_OnReadError_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPortClient_OnReadError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(SerialReceiveError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SerialPortClient_OnReadError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortClient_OnReadError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SerialPortClient_OnSendError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SerialPortClient_OnSendError_Params.prototype.initDefaults_ = function() {
    this.error = 0;
  };
  SerialPortClient_OnSendError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SerialPortClient_OnSendError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SerialPortClient_OnSendError_Params.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SerialSendError);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SerialPortClient_OnSendError_Params.encodedSize = codec.kStructHeaderSize + 8;

  SerialPortClient_OnSendError_Params.decode = function(decoder) {
    var packed;
    var val = new SerialPortClient_OnSendError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(SerialSendError));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SerialPortClient_OnSendError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SerialPortClient_OnSendError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kSerialPortManager_SetClient_Name = 0;
  var kSerialPortManager_GetDevices_Name = 1;
  var kSerialPortManager_OpenPort_Name = 2;

  function SerialPortManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SerialPortManager,
                                                   handleOrPtrInfo);
  }

  function SerialPortManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SerialPortManager, associatedInterfacePtrInfo);
  }

  SerialPortManagerAssociatedPtr.prototype =
      Object.create(SerialPortManagerPtr.prototype);
  SerialPortManagerAssociatedPtr.prototype.constructor =
      SerialPortManagerAssociatedPtr;

  function SerialPortManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  SerialPortManagerPtr.prototype.setClient = function() {
    return SerialPortManagerProxy.prototype.setClient
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortManagerProxy.prototype.setClient = function(client) {
    var params_ = new SerialPortManager_SetClient_Params();
    params_.client = client;
    var builder = new codec.MessageV0Builder(
        kSerialPortManager_SetClient_Name,
        codec.align(SerialPortManager_SetClient_Params.encodedSize));
    builder.encodeStruct(SerialPortManager_SetClient_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SerialPortManagerPtr.prototype.getDevices = function() {
    return SerialPortManagerProxy.prototype.getDevices
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortManagerProxy.prototype.getDevices = function() {
    var params_ = new SerialPortManager_GetDevices_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialPortManager_GetDevices_Name,
          codec.align(SerialPortManager_GetDevices_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialPortManager_GetDevices_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialPortManager_GetDevices_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SerialPortManagerPtr.prototype.openPort = function() {
    return SerialPortManagerProxy.prototype.openPort
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortManagerProxy.prototype.openPort = function(token, useAlternatePath, options, client, watcher) {
    var params_ = new SerialPortManager_OpenPort_Params();
    params_.token = token;
    params_.useAlternatePath = useAlternatePath;
    params_.options = options;
    params_.client = client;
    params_.watcher = watcher;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialPortManager_OpenPort_Name,
          codec.align(SerialPortManager_OpenPort_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialPortManager_OpenPort_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialPortManager_OpenPort_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SerialPortManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  SerialPortManagerStub.prototype.setClient = function(client) {
    return this.delegate_ && this.delegate_.setClient && this.delegate_.setClient(client);
  }
  SerialPortManagerStub.prototype.getDevices = function() {
    return this.delegate_ && this.delegate_.getDevices && this.delegate_.getDevices();
  }
  SerialPortManagerStub.prototype.openPort = function(token, useAlternatePath, options, client, watcher) {
    return this.delegate_ && this.delegate_.openPort && this.delegate_.openPort(token, useAlternatePath, options, client, watcher);
  }

  SerialPortManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSerialPortManager_SetClient_Name:
      var params = reader.decodeStruct(SerialPortManager_SetClient_Params);
      this.setClient(params.client);
      return true;
    default:
      return false;
    }
  };

  SerialPortManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSerialPortManager_GetDevices_Name:
      var params = reader.decodeStruct(SerialPortManager_GetDevices_Params);
      this.getDevices().then(function(response) {
        var responseParams =
            new SerialPortManager_GetDevices_ResponseParams();
        responseParams.devices = response.devices;
        var builder = new codec.MessageV1Builder(
            kSerialPortManager_GetDevices_Name,
            codec.align(SerialPortManager_GetDevices_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialPortManager_GetDevices_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSerialPortManager_OpenPort_Name:
      var params = reader.decodeStruct(SerialPortManager_OpenPort_Params);
      this.openPort(params.token, params.useAlternatePath, params.options, params.client, params.watcher).then(function(response) {
        var responseParams =
            new SerialPortManager_OpenPort_ResponseParams();
        responseParams.port = response.port;
        var builder = new codec.MessageV1Builder(
            kSerialPortManager_OpenPort_Name,
            codec.align(SerialPortManager_OpenPort_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialPortManager_OpenPort_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSerialPortManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSerialPortManager_SetClient_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SerialPortManager_SetClient_Params;
      break;
      case kSerialPortManager_GetDevices_Name:
        if (message.expectsResponse())
          paramsClass = SerialPortManager_GetDevices_Params;
      break;
      case kSerialPortManager_OpenPort_Name:
        if (message.expectsResponse())
          paramsClass = SerialPortManager_OpenPort_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSerialPortManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSerialPortManager_GetDevices_Name:
        if (message.isResponse())
          paramsClass = SerialPortManager_GetDevices_ResponseParams;
        break;
      case kSerialPortManager_OpenPort_Name:
        if (message.isResponse())
          paramsClass = SerialPortManager_OpenPort_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SerialPortManager = {
    name: 'device.mojom.SerialPortManager',
    kVersion: 0,
    ptrClass: SerialPortManagerPtr,
    proxyClass: SerialPortManagerProxy,
    stubClass: SerialPortManagerStub,
    validateRequest: validateSerialPortManagerRequest,
    validateResponse: validateSerialPortManagerResponse,
  };
  SerialPortManagerStub.prototype.validator = validateSerialPortManagerRequest;
  SerialPortManagerProxy.prototype.validator = validateSerialPortManagerResponse;
  var kSerialPortManagerClient_OnPortAdded_Name = 0;
  var kSerialPortManagerClient_OnPortRemoved_Name = 1;
  var kSerialPortManagerClient_OnPortConnectedStateChanged_Name = 2;

  function SerialPortManagerClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SerialPortManagerClient,
                                                   handleOrPtrInfo);
  }

  function SerialPortManagerClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SerialPortManagerClient, associatedInterfacePtrInfo);
  }

  SerialPortManagerClientAssociatedPtr.prototype =
      Object.create(SerialPortManagerClientPtr.prototype);
  SerialPortManagerClientAssociatedPtr.prototype.constructor =
      SerialPortManagerClientAssociatedPtr;

  function SerialPortManagerClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  SerialPortManagerClientPtr.prototype.onPortAdded = function() {
    return SerialPortManagerClientProxy.prototype.onPortAdded
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortManagerClientProxy.prototype.onPortAdded = function(portInfo) {
    var params_ = new SerialPortManagerClient_OnPortAdded_Params();
    params_.portInfo = portInfo;
    var builder = new codec.MessageV0Builder(
        kSerialPortManagerClient_OnPortAdded_Name,
        codec.align(SerialPortManagerClient_OnPortAdded_Params.encodedSize));
    builder.encodeStruct(SerialPortManagerClient_OnPortAdded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SerialPortManagerClientPtr.prototype.onPortRemoved = function() {
    return SerialPortManagerClientProxy.prototype.onPortRemoved
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortManagerClientProxy.prototype.onPortRemoved = function(portInfo) {
    var params_ = new SerialPortManagerClient_OnPortRemoved_Params();
    params_.portInfo = portInfo;
    var builder = new codec.MessageV0Builder(
        kSerialPortManagerClient_OnPortRemoved_Name,
        codec.align(SerialPortManagerClient_OnPortRemoved_Params.encodedSize));
    builder.encodeStruct(SerialPortManagerClient_OnPortRemoved_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SerialPortManagerClientPtr.prototype.onPortConnectedStateChanged = function() {
    return SerialPortManagerClientProxy.prototype.onPortConnectedStateChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortManagerClientProxy.prototype.onPortConnectedStateChanged = function(portInfo) {
    var params_ = new SerialPortManagerClient_OnPortConnectedStateChanged_Params();
    params_.portInfo = portInfo;
    var builder = new codec.MessageV0Builder(
        kSerialPortManagerClient_OnPortConnectedStateChanged_Name,
        codec.align(SerialPortManagerClient_OnPortConnectedStateChanged_Params.encodedSize));
    builder.encodeStruct(SerialPortManagerClient_OnPortConnectedStateChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SerialPortManagerClientStub(delegate) {
    this.delegate_ = delegate;
  }
  SerialPortManagerClientStub.prototype.onPortAdded = function(portInfo) {
    return this.delegate_ && this.delegate_.onPortAdded && this.delegate_.onPortAdded(portInfo);
  }
  SerialPortManagerClientStub.prototype.onPortRemoved = function(portInfo) {
    return this.delegate_ && this.delegate_.onPortRemoved && this.delegate_.onPortRemoved(portInfo);
  }
  SerialPortManagerClientStub.prototype.onPortConnectedStateChanged = function(portInfo) {
    return this.delegate_ && this.delegate_.onPortConnectedStateChanged && this.delegate_.onPortConnectedStateChanged(portInfo);
  }

  SerialPortManagerClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSerialPortManagerClient_OnPortAdded_Name:
      var params = reader.decodeStruct(SerialPortManagerClient_OnPortAdded_Params);
      this.onPortAdded(params.portInfo);
      return true;
    case kSerialPortManagerClient_OnPortRemoved_Name:
      var params = reader.decodeStruct(SerialPortManagerClient_OnPortRemoved_Params);
      this.onPortRemoved(params.portInfo);
      return true;
    case kSerialPortManagerClient_OnPortConnectedStateChanged_Name:
      var params = reader.decodeStruct(SerialPortManagerClient_OnPortConnectedStateChanged_Params);
      this.onPortConnectedStateChanged(params.portInfo);
      return true;
    default:
      return false;
    }
  };

  SerialPortManagerClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSerialPortManagerClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSerialPortManagerClient_OnPortAdded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SerialPortManagerClient_OnPortAdded_Params;
      break;
      case kSerialPortManagerClient_OnPortRemoved_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SerialPortManagerClient_OnPortRemoved_Params;
      break;
      case kSerialPortManagerClient_OnPortConnectedStateChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SerialPortManagerClient_OnPortConnectedStateChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSerialPortManagerClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SerialPortManagerClient = {
    name: 'device.mojom.SerialPortManagerClient',
    kVersion: 0,
    ptrClass: SerialPortManagerClientPtr,
    proxyClass: SerialPortManagerClientProxy,
    stubClass: SerialPortManagerClientStub,
    validateRequest: validateSerialPortManagerClientRequest,
    validateResponse: null,
  };
  SerialPortManagerClientStub.prototype.validator = validateSerialPortManagerClientRequest;
  SerialPortManagerClientProxy.prototype.validator = null;
  var kSerialPort_StartWriting_Name = 0;
  var kSerialPort_StartReading_Name = 1;
  var kSerialPort_Flush_Name = 2;
  var kSerialPort_Drain_Name = 3;
  var kSerialPort_GetControlSignals_Name = 4;
  var kSerialPort_SetControlSignals_Name = 5;
  var kSerialPort_ConfigurePort_Name = 6;
  var kSerialPort_GetPortInfo_Name = 7;
  var kSerialPort_Close_Name = 8;

  function SerialPortPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SerialPort,
                                                   handleOrPtrInfo);
  }

  function SerialPortAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SerialPort, associatedInterfacePtrInfo);
  }

  SerialPortAssociatedPtr.prototype =
      Object.create(SerialPortPtr.prototype);
  SerialPortAssociatedPtr.prototype.constructor =
      SerialPortAssociatedPtr;

  function SerialPortProxy(receiver) {
    this.receiver_ = receiver;
  }
  SerialPortPtr.prototype.startWriting = function() {
    return SerialPortProxy.prototype.startWriting
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortProxy.prototype.startWriting = function(consumer) {
    var params_ = new SerialPort_StartWriting_Params();
    params_.consumer = consumer;
    var builder = new codec.MessageV0Builder(
        kSerialPort_StartWriting_Name,
        codec.align(SerialPort_StartWriting_Params.encodedSize));
    builder.encodeStruct(SerialPort_StartWriting_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SerialPortPtr.prototype.startReading = function() {
    return SerialPortProxy.prototype.startReading
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortProxy.prototype.startReading = function(producer) {
    var params_ = new SerialPort_StartReading_Params();
    params_.producer = producer;
    var builder = new codec.MessageV0Builder(
        kSerialPort_StartReading_Name,
        codec.align(SerialPort_StartReading_Params.encodedSize));
    builder.encodeStruct(SerialPort_StartReading_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SerialPortPtr.prototype.flush = function() {
    return SerialPortProxy.prototype.flush
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortProxy.prototype.flush = function(mode) {
    var params_ = new SerialPort_Flush_Params();
    params_.mode = mode;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialPort_Flush_Name,
          codec.align(SerialPort_Flush_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialPort_Flush_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialPort_Flush_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SerialPortPtr.prototype.drain = function() {
    return SerialPortProxy.prototype.drain
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortProxy.prototype.drain = function() {
    var params_ = new SerialPort_Drain_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialPort_Drain_Name,
          codec.align(SerialPort_Drain_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialPort_Drain_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialPort_Drain_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SerialPortPtr.prototype.getControlSignals = function() {
    return SerialPortProxy.prototype.getControlSignals
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortProxy.prototype.getControlSignals = function() {
    var params_ = new SerialPort_GetControlSignals_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialPort_GetControlSignals_Name,
          codec.align(SerialPort_GetControlSignals_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialPort_GetControlSignals_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialPort_GetControlSignals_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SerialPortPtr.prototype.setControlSignals = function() {
    return SerialPortProxy.prototype.setControlSignals
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortProxy.prototype.setControlSignals = function(signals) {
    var params_ = new SerialPort_SetControlSignals_Params();
    params_.signals = signals;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialPort_SetControlSignals_Name,
          codec.align(SerialPort_SetControlSignals_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialPort_SetControlSignals_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialPort_SetControlSignals_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SerialPortPtr.prototype.configurePort = function() {
    return SerialPortProxy.prototype.configurePort
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortProxy.prototype.configurePort = function(options) {
    var params_ = new SerialPort_ConfigurePort_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialPort_ConfigurePort_Name,
          codec.align(SerialPort_ConfigurePort_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialPort_ConfigurePort_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialPort_ConfigurePort_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SerialPortPtr.prototype.getPortInfo = function() {
    return SerialPortProxy.prototype.getPortInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortProxy.prototype.getPortInfo = function() {
    var params_ = new SerialPort_GetPortInfo_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialPort_GetPortInfo_Name,
          codec.align(SerialPort_GetPortInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialPort_GetPortInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialPort_GetPortInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SerialPortPtr.prototype.close = function() {
    return SerialPortProxy.prototype.close
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortProxy.prototype.close = function(flush) {
    var params_ = new SerialPort_Close_Params();
    params_.flush = flush;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSerialPort_Close_Name,
          codec.align(SerialPort_Close_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SerialPort_Close_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SerialPort_Close_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SerialPortStub(delegate) {
    this.delegate_ = delegate;
  }
  SerialPortStub.prototype.startWriting = function(consumer) {
    return this.delegate_ && this.delegate_.startWriting && this.delegate_.startWriting(consumer);
  }
  SerialPortStub.prototype.startReading = function(producer) {
    return this.delegate_ && this.delegate_.startReading && this.delegate_.startReading(producer);
  }
  SerialPortStub.prototype.flush = function(mode) {
    return this.delegate_ && this.delegate_.flush && this.delegate_.flush(mode);
  }
  SerialPortStub.prototype.drain = function() {
    return this.delegate_ && this.delegate_.drain && this.delegate_.drain();
  }
  SerialPortStub.prototype.getControlSignals = function() {
    return this.delegate_ && this.delegate_.getControlSignals && this.delegate_.getControlSignals();
  }
  SerialPortStub.prototype.setControlSignals = function(signals) {
    return this.delegate_ && this.delegate_.setControlSignals && this.delegate_.setControlSignals(signals);
  }
  SerialPortStub.prototype.configurePort = function(options) {
    return this.delegate_ && this.delegate_.configurePort && this.delegate_.configurePort(options);
  }
  SerialPortStub.prototype.getPortInfo = function() {
    return this.delegate_ && this.delegate_.getPortInfo && this.delegate_.getPortInfo();
  }
  SerialPortStub.prototype.close = function(flush) {
    return this.delegate_ && this.delegate_.close && this.delegate_.close(flush);
  }

  SerialPortStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSerialPort_StartWriting_Name:
      var params = reader.decodeStruct(SerialPort_StartWriting_Params);
      this.startWriting(params.consumer);
      return true;
    case kSerialPort_StartReading_Name:
      var params = reader.decodeStruct(SerialPort_StartReading_Params);
      this.startReading(params.producer);
      return true;
    default:
      return false;
    }
  };

  SerialPortStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSerialPort_Flush_Name:
      var params = reader.decodeStruct(SerialPort_Flush_Params);
      this.flush(params.mode).then(function(response) {
        var responseParams =
            new SerialPort_Flush_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kSerialPort_Flush_Name,
            codec.align(SerialPort_Flush_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialPort_Flush_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSerialPort_Drain_Name:
      var params = reader.decodeStruct(SerialPort_Drain_Params);
      this.drain().then(function(response) {
        var responseParams =
            new SerialPort_Drain_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kSerialPort_Drain_Name,
            codec.align(SerialPort_Drain_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialPort_Drain_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSerialPort_GetControlSignals_Name:
      var params = reader.decodeStruct(SerialPort_GetControlSignals_Params);
      this.getControlSignals().then(function(response) {
        var responseParams =
            new SerialPort_GetControlSignals_ResponseParams();
        responseParams.signals = response.signals;
        var builder = new codec.MessageV1Builder(
            kSerialPort_GetControlSignals_Name,
            codec.align(SerialPort_GetControlSignals_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialPort_GetControlSignals_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSerialPort_SetControlSignals_Name:
      var params = reader.decodeStruct(SerialPort_SetControlSignals_Params);
      this.setControlSignals(params.signals).then(function(response) {
        var responseParams =
            new SerialPort_SetControlSignals_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kSerialPort_SetControlSignals_Name,
            codec.align(SerialPort_SetControlSignals_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialPort_SetControlSignals_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSerialPort_ConfigurePort_Name:
      var params = reader.decodeStruct(SerialPort_ConfigurePort_Params);
      this.configurePort(params.options).then(function(response) {
        var responseParams =
            new SerialPort_ConfigurePort_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kSerialPort_ConfigurePort_Name,
            codec.align(SerialPort_ConfigurePort_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialPort_ConfigurePort_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSerialPort_GetPortInfo_Name:
      var params = reader.decodeStruct(SerialPort_GetPortInfo_Params);
      this.getPortInfo().then(function(response) {
        var responseParams =
            new SerialPort_GetPortInfo_ResponseParams();
        responseParams.info = response.info;
        var builder = new codec.MessageV1Builder(
            kSerialPort_GetPortInfo_Name,
            codec.align(SerialPort_GetPortInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialPort_GetPortInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSerialPort_Close_Name:
      var params = reader.decodeStruct(SerialPort_Close_Params);
      this.close(params.flush).then(function(response) {
        var responseParams =
            new SerialPort_Close_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kSerialPort_Close_Name,
            codec.align(SerialPort_Close_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SerialPort_Close_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSerialPortRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSerialPort_StartWriting_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SerialPort_StartWriting_Params;
      break;
      case kSerialPort_StartReading_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SerialPort_StartReading_Params;
      break;
      case kSerialPort_Flush_Name:
        if (message.expectsResponse())
          paramsClass = SerialPort_Flush_Params;
      break;
      case kSerialPort_Drain_Name:
        if (message.expectsResponse())
          paramsClass = SerialPort_Drain_Params;
      break;
      case kSerialPort_GetControlSignals_Name:
        if (message.expectsResponse())
          paramsClass = SerialPort_GetControlSignals_Params;
      break;
      case kSerialPort_SetControlSignals_Name:
        if (message.expectsResponse())
          paramsClass = SerialPort_SetControlSignals_Params;
      break;
      case kSerialPort_ConfigurePort_Name:
        if (message.expectsResponse())
          paramsClass = SerialPort_ConfigurePort_Params;
      break;
      case kSerialPort_GetPortInfo_Name:
        if (message.expectsResponse())
          paramsClass = SerialPort_GetPortInfo_Params;
      break;
      case kSerialPort_Close_Name:
        if (message.expectsResponse())
          paramsClass = SerialPort_Close_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSerialPortResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSerialPort_Flush_Name:
        if (message.isResponse())
          paramsClass = SerialPort_Flush_ResponseParams;
        break;
      case kSerialPort_Drain_Name:
        if (message.isResponse())
          paramsClass = SerialPort_Drain_ResponseParams;
        break;
      case kSerialPort_GetControlSignals_Name:
        if (message.isResponse())
          paramsClass = SerialPort_GetControlSignals_ResponseParams;
        break;
      case kSerialPort_SetControlSignals_Name:
        if (message.isResponse())
          paramsClass = SerialPort_SetControlSignals_ResponseParams;
        break;
      case kSerialPort_ConfigurePort_Name:
        if (message.isResponse())
          paramsClass = SerialPort_ConfigurePort_ResponseParams;
        break;
      case kSerialPort_GetPortInfo_Name:
        if (message.isResponse())
          paramsClass = SerialPort_GetPortInfo_ResponseParams;
        break;
      case kSerialPort_Close_Name:
        if (message.isResponse())
          paramsClass = SerialPort_Close_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SerialPort = {
    name: 'device.mojom.SerialPort',
    kVersion: 0,
    ptrClass: SerialPortPtr,
    proxyClass: SerialPortProxy,
    stubClass: SerialPortStub,
    validateRequest: validateSerialPortRequest,
    validateResponse: validateSerialPortResponse,
  };
  SerialPortStub.prototype.validator = validateSerialPortRequest;
  SerialPortProxy.prototype.validator = validateSerialPortResponse;
  var kSerialPortClient_OnReadError_Name = 0;
  var kSerialPortClient_OnSendError_Name = 1;

  function SerialPortClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SerialPortClient,
                                                   handleOrPtrInfo);
  }

  function SerialPortClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SerialPortClient, associatedInterfacePtrInfo);
  }

  SerialPortClientAssociatedPtr.prototype =
      Object.create(SerialPortClientPtr.prototype);
  SerialPortClientAssociatedPtr.prototype.constructor =
      SerialPortClientAssociatedPtr;

  function SerialPortClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  SerialPortClientPtr.prototype.onReadError = function() {
    return SerialPortClientProxy.prototype.onReadError
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortClientProxy.prototype.onReadError = function(error) {
    var params_ = new SerialPortClient_OnReadError_Params();
    params_.error = error;
    var builder = new codec.MessageV0Builder(
        kSerialPortClient_OnReadError_Name,
        codec.align(SerialPortClient_OnReadError_Params.encodedSize));
    builder.encodeStruct(SerialPortClient_OnReadError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SerialPortClientPtr.prototype.onSendError = function() {
    return SerialPortClientProxy.prototype.onSendError
        .apply(this.ptr.getProxy(), arguments);
  };

  SerialPortClientProxy.prototype.onSendError = function(error) {
    var params_ = new SerialPortClient_OnSendError_Params();
    params_.error = error;
    var builder = new codec.MessageV0Builder(
        kSerialPortClient_OnSendError_Name,
        codec.align(SerialPortClient_OnSendError_Params.encodedSize));
    builder.encodeStruct(SerialPortClient_OnSendError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SerialPortClientStub(delegate) {
    this.delegate_ = delegate;
  }
  SerialPortClientStub.prototype.onReadError = function(error) {
    return this.delegate_ && this.delegate_.onReadError && this.delegate_.onReadError(error);
  }
  SerialPortClientStub.prototype.onSendError = function(error) {
    return this.delegate_ && this.delegate_.onSendError && this.delegate_.onSendError(error);
  }

  SerialPortClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSerialPortClient_OnReadError_Name:
      var params = reader.decodeStruct(SerialPortClient_OnReadError_Params);
      this.onReadError(params.error);
      return true;
    case kSerialPortClient_OnSendError_Name:
      var params = reader.decodeStruct(SerialPortClient_OnSendError_Params);
      this.onSendError(params.error);
      return true;
    default:
      return false;
    }
  };

  SerialPortClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSerialPortClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSerialPortClient_OnReadError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SerialPortClient_OnReadError_Params;
      break;
      case kSerialPortClient_OnSendError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SerialPortClient_OnSendError_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSerialPortClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SerialPortClient = {
    name: 'device.mojom.SerialPortClient',
    kVersion: 0,
    ptrClass: SerialPortClientPtr,
    proxyClass: SerialPortClientProxy,
    stubClass: SerialPortClientStub,
    validateRequest: validateSerialPortClientRequest,
    validateResponse: null,
  };
  SerialPortClientStub.prototype.validator = validateSerialPortClientRequest;
  SerialPortClientProxy.prototype.validator = null;

  function SerialPortConnectionWatcherPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SerialPortConnectionWatcher,
                                                   handleOrPtrInfo);
  }

  function SerialPortConnectionWatcherAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SerialPortConnectionWatcher, associatedInterfacePtrInfo);
  }

  SerialPortConnectionWatcherAssociatedPtr.prototype =
      Object.create(SerialPortConnectionWatcherPtr.prototype);
  SerialPortConnectionWatcherAssociatedPtr.prototype.constructor =
      SerialPortConnectionWatcherAssociatedPtr;

  function SerialPortConnectionWatcherProxy(receiver) {
    this.receiver_ = receiver;
  }

  function SerialPortConnectionWatcherStub(delegate) {
    this.delegate_ = delegate;
  }

  SerialPortConnectionWatcherStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SerialPortConnectionWatcherStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSerialPortConnectionWatcherRequest(messageValidator) {
    return validator.validationError.NONE;
  }

  function validateSerialPortConnectionWatcherResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SerialPortConnectionWatcher = {
    name: 'device.mojom.SerialPortConnectionWatcher',
    kVersion: 0,
    ptrClass: SerialPortConnectionWatcherPtr,
    proxyClass: SerialPortConnectionWatcherProxy,
    stubClass: SerialPortConnectionWatcherStub,
    validateRequest: validateSerialPortConnectionWatcherRequest,
    validateResponse: null,
  };
  SerialPortConnectionWatcherStub.prototype.validator = validateSerialPortConnectionWatcherRequest;
  SerialPortConnectionWatcherProxy.prototype.validator = null;
  exports.SerialSendError = SerialSendError;
  exports.SerialReceiveError = SerialReceiveError;
  exports.SerialDataBits = SerialDataBits;
  exports.SerialParityBit = SerialParityBit;
  exports.SerialStopBits = SerialStopBits;
  exports.SerialPortFlushMode = SerialPortFlushMode;
  exports.SerialPortType = SerialPortType;
  exports.SerialPortInfo = SerialPortInfo;
  exports.SerialConnectionOptions = SerialConnectionOptions;
  exports.SerialConnectionInfo = SerialConnectionInfo;
  exports.SerialHostControlSignals = SerialHostControlSignals;
  exports.SerialPortControlSignals = SerialPortControlSignals;
  exports.SerialPortManager = SerialPortManager;
  exports.SerialPortManagerPtr = SerialPortManagerPtr;
  exports.SerialPortManagerAssociatedPtr = SerialPortManagerAssociatedPtr;
  exports.SerialPortManagerClient = SerialPortManagerClient;
  exports.SerialPortManagerClientPtr = SerialPortManagerClientPtr;
  exports.SerialPortManagerClientAssociatedPtr = SerialPortManagerClientAssociatedPtr;
  exports.SerialPort = SerialPort;
  exports.SerialPortPtr = SerialPortPtr;
  exports.SerialPortAssociatedPtr = SerialPortAssociatedPtr;
  exports.SerialPortClient = SerialPortClient;
  exports.SerialPortClientPtr = SerialPortClientPtr;
  exports.SerialPortClientAssociatedPtr = SerialPortClientAssociatedPtr;
  exports.SerialPortConnectionWatcher = SerialPortConnectionWatcher;
  exports.SerialPortConnectionWatcherPtr = SerialPortConnectionWatcherPtr;
  exports.SerialPortConnectionWatcherAssociatedPtr = SerialPortConnectionWatcherAssociatedPtr;
})();