// services/device/public/mojom/screen_orientation.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SCREEN_ORIENTATION_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SCREEN_ORIENTATION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/screen_orientation.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/screen_orientation.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/screen_orientation.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/device/public/mojom/screen_orientation_lock_types.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {

class ScreenOrientationProxy;

template <typename ImplRefTraits>
class ScreenOrientationStub;

class ScreenOrientationRequestValidator;
class ScreenOrientationResponseValidator;


class BLINK_PLATFORM_EXPORT ScreenOrientation
    : public ScreenOrientationInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.ScreenOrientation";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ScreenOrientationInterfaceBase;
  using Proxy_ = ScreenOrientationProxy;

  template <typename ImplRefTraits>
  using Stub_ = ScreenOrientationStub<ImplRefTraits>;

  using RequestValidator_ = ScreenOrientationRequestValidator;
  using ResponseValidator_ = ScreenOrientationResponseValidator;
  enum MethodMinVersions : uint32_t {
    kLockOrientationMinVersion = 0,
    kUnlockOrientationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct LockOrientation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnlockOrientation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ScreenOrientation() = default;

  using LockOrientationCallback = base::OnceCallback<void(::device::mojom::blink::ScreenOrientationLockResult)>;
  using LockOrientationMojoCallback = base::OnceCallback<void(::device::mojom::blink::ScreenOrientationLockResult)>;

  virtual void LockOrientation(::device::mojom::blink::ScreenOrientationLockType orientation, LockOrientationCallback callback) = 0;

  virtual void UnlockOrientation() = 0;
};

class ScreenOrientationListenerProxy;

template <typename ImplRefTraits>
class ScreenOrientationListenerStub;

class ScreenOrientationListenerRequestValidator;
class ScreenOrientationListenerResponseValidator;


class BLINK_PLATFORM_EXPORT ScreenOrientationListener
    : public ScreenOrientationListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.ScreenOrientationListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ScreenOrientationListenerInterfaceBase;
  using Proxy_ = ScreenOrientationListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ScreenOrientationListenerStub<ImplRefTraits>;

  using RequestValidator_ = ScreenOrientationListenerRequestValidator;
  using ResponseValidator_ = ScreenOrientationListenerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kIsAutoRotateEnabledByUserMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct IsAutoRotateEnabledByUser_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ScreenOrientationListener() = default;

  using IsAutoRotateEnabledByUserCallback = base::OnceCallback<void(bool)>;
  using IsAutoRotateEnabledByUserMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsAutoRotateEnabledByUser(IsAutoRotateEnabledByUserCallback callback) = 0;
};



class BLINK_PLATFORM_EXPORT ScreenOrientationProxy
    : public ScreenOrientation {
 public:
  using InterfaceType = ScreenOrientation;

  explicit ScreenOrientationProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void LockOrientation(::device::mojom::blink::ScreenOrientationLockType orientation, LockOrientationCallback callback) final;
  
  void UnlockOrientation() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT ScreenOrientationListenerProxy
    : public ScreenOrientationListener {
 public:
  using InterfaceType = ScreenOrientationListener;

  explicit ScreenOrientationListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void IsAutoRotateEnabledByUser(IsAutoRotateEnabledByUserCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT ScreenOrientationStubDispatch {
 public:
  static bool Accept(ScreenOrientation* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ScreenOrientation* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ScreenOrientation>>
class ScreenOrientationStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ScreenOrientationStub() = default;
  ~ScreenOrientationStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScreenOrientationStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScreenOrientationStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ScreenOrientationListenerStubDispatch {
 public:
  static bool Accept(ScreenOrientationListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ScreenOrientationListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ScreenOrientationListener>>
class ScreenOrientationListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ScreenOrientationListenerStub() = default;
  ~ScreenOrientationListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScreenOrientationListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScreenOrientationListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ScreenOrientationRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT ScreenOrientationListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT ScreenOrientationResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT ScreenOrientationListenerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // device::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SCREEN_ORIENTATION_MOJOM_BLINK_H_