// services/device/public/mojom/public_ip_address_geolocation_provider.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  MutablePartialNetworkTrafficAnnotationTag as network_mojom_MutablePartialNetworkTrafficAnnotationTag,
  MutablePartialNetworkTrafficAnnotationTagSpec as network_mojom_MutablePartialNetworkTrafficAnnotationTagSpec
} from '../../../network/public/mojom/mutable_partial_network_traffic_annotation_tag.mojom.m.js';

import {
  GeolocationRemote as device_mojom_GeolocationRemote,
  GeolocationPendingReceiver as device_mojom_GeolocationPendingReceiver
} from './geolocation.mojom.m.js';

import {
  GeolocationClientId as device_mojom_GeolocationClientId,
  GeolocationClientIdSpec as device_mojom_GeolocationClientIdSpec
} from './geolocation_client_id.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PublicIpAddressGeolocationProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.PublicIpAddressGeolocationProvider', scope);
  }
}

/** @interface */
export class PublicIpAddressGeolocationProviderInterface {
  
  /**
   * @param { !network_mojom_MutablePartialNetworkTrafficAnnotationTag } tag
   * @param { !device_mojom_GeolocationPendingReceiver } receiver
   * @param { !device_mojom_GeolocationClientId } clientId
   */

  createGeolocation(tag, receiver, clientId) {}
}

/**
 * @implements { PublicIpAddressGeolocationProviderInterface }
 */
export class PublicIpAddressGeolocationProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PublicIpAddressGeolocationProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PublicIpAddressGeolocationProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PublicIpAddressGeolocationProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_MutablePartialNetworkTrafficAnnotationTag } tag
   * @param { !device_mojom_GeolocationPendingReceiver } receiver
   * @param { !device_mojom_GeolocationClientId } clientId
   */

  createGeolocation(
      tag,
      receiver,
      clientId) {
    this.proxy.sendMessage(
        0,
        PublicIpAddressGeolocationProvider_CreateGeolocation_ParamsSpec.$,
        null,
        [
          tag,
          receiver,
          clientId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PublicIpAddressGeolocationProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PublicIpAddressGeolocationProviderReceiver {
  /**
   * @param {!PublicIpAddressGeolocationProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PublicIpAddressGeolocationProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PublicIpAddressGeolocationProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PublicIpAddressGeolocationProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PublicIpAddressGeolocationProvider_CreateGeolocation_ParamsSpec.$,
        null,
        impl.createGeolocation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PublicIpAddressGeolocationProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.PublicIpAddressGeolocationProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PublicIpAddressGeolocationProviderRemote}
   */
  static getRemote() {
    let remote = new PublicIpAddressGeolocationProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PublicIpAddressGeolocationProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PublicIpAddressGeolocationProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PublicIpAddressGeolocationProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PublicIpAddressGeolocationProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createGeolocation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PublicIpAddressGeolocationProvider_CreateGeolocation_ParamsSpec.$,
        null,
        this.createGeolocation.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PublicIpAddressGeolocationProvider_CreateGeolocation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PublicIpAddressGeolocationProvider_CreateGeolocation_ParamsSpec.$,
    'PublicIpAddressGeolocationProvider_CreateGeolocation_Params',
    [
      mojo.internal.StructField(
        'tag', 0,
        0,
        network_mojom_MutablePartialNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(device_mojom_GeolocationPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientId', 12,
        0,
        device_mojom_GeolocationClientIdSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PublicIpAddressGeolocationProvider_CreateGeolocation_Params {
  constructor() {
    /** @type { !network_mojom_MutablePartialNetworkTrafficAnnotationTag } */
    this.tag;
    /** @type { !device_mojom_GeolocationPendingReceiver } */
    this.receiver;
    /** @type { !device_mojom_GeolocationClientId } */
    this.clientId;
  }
}

