// services/device/public/mojom/pressure_update.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/pressure_update.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/pressure_update.mojom-params-data.h"
#include "services/device/public/mojom/pressure_update.mojom-shared-message-ids.h"

#include "services/device/public/mojom/pressure_update.mojom-blink-import-headers.h"
#include "services/device/public/mojom/pressure_update.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
PressureUpdate::PressureUpdate()
    : source(),
      data(),
      timestamp() {}

PressureUpdate::PressureUpdate(
    PressureSource source_in,
    PressureDataPtr data_in,
    ::base::TimeTicks timestamp_in)
    : source(std::move(source_in)),
      data(std::move(data_in)),
      timestamp(std::move(timestamp_in)) {}

PressureUpdate::~PressureUpdate() = default;

void PressureUpdate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PressureSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PressureDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PressureUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PressureData::PressureData()
    : cpu_utilization(0),
      own_contribution_estimate(kDefaultOwnContributionEstimate) {}

PressureData::PressureData(
    double cpu_utilization_in,
    double own_contribution_estimate_in)
    : cpu_utilization(std::move(cpu_utilization_in)),
      own_contribution_estimate(std::move(own_contribution_estimate_in)) {}

PressureData::~PressureData() = default;
size_t PressureData::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->cpu_utilization);
  seed = mojo::internal::WTFHash(seed, this->own_contribution_estimate);
  return seed;
}

void PressureData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cpu_utilization"), this->cpu_utilization,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "own_contribution_estimate"), this->own_contribution_estimate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PressureData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // device::mojom::blink


namespace mojo {


// static
bool StructTraits<::device::mojom::blink::PressureUpdate::DataView, ::device::mojom::blink::PressureUpdatePtr>::Read(
    ::device::mojom::blink::PressureUpdate::DataView input,
    ::device::mojom::blink::PressureUpdatePtr* output) {
  bool success = true;
  ::device::mojom::blink::PressureUpdatePtr result(::device::mojom::blink::PressureUpdate::New());
  
      if (success && !input.ReadSource(&result->source))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::PressureData::DataView, ::device::mojom::blink::PressureDataPtr>::Read(
    ::device::mojom::blink::PressureData::DataView input,
    ::device::mojom::blink::PressureDataPtr* output) {
  bool success = true;
  ::device::mojom::blink::PressureDataPtr result(::device::mojom::blink::PressureData::New());
  
      if (success)
        result->cpu_utilization = input.cpu_utilization();
      if (success)
        result->own_contribution_estimate = input.own_contribution_estimate();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {




}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif