// services/device/public/mojom/pressure_manager.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('device.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.PressureManagerAddClientResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.PressureManagerAddClientResult = {
  
  kNotSupported: 0,
  kOk: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.PressureManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.PressureManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.PressureManagerInterface }
 */
device.mojom.PressureManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.PressureManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.PressureManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.PressureManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } token
   * @param { !device.mojom.PressureSource } source
   * @param { !device.mojom.VirtualPressureSourceMetadata } metadata
   * @return {!Promise}
   */

  addVirtualPressureSource(
      token,
      source,
      metadata) {
    return this.proxy.sendMessage(
        0,
        device.mojom.PressureManager_AddVirtualPressureSource_ParamsSpec.$,
        device.mojom.PressureManager_AddVirtualPressureSource_ResponseParamsSpec.$,
        [
          token,
          source,
          metadata
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } token
   * @param { !device.mojom.PressureSource } source
   * @return {!Promise}
   */

  removeVirtualPressureSource(
      token,
      source) {
    return this.proxy.sendMessage(
        1,
        device.mojom.PressureManager_RemoveVirtualPressureSource_ParamsSpec.$,
        device.mojom.PressureManager_RemoveVirtualPressureSource_ResponseParamsSpec.$,
        [
          token,
          source
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } token
   * @param { !device.mojom.PressureSource } source
   * @param { !device.mojom.PressureState } state
   * @param { !number } ownContributionEstimate
   * @return {!Promise}
   */

  updateVirtualPressureSourceData(
      token,
      source,
      state,
      ownContributionEstimate) {
    return this.proxy.sendMessage(
        2,
        device.mojom.PressureManager_UpdateVirtualPressureSourceData_ParamsSpec.$,
        device.mojom.PressureManager_UpdateVirtualPressureSourceData_ResponseParamsSpec.$,
        [
          token,
          source,
          state,
          ownContributionEstimate
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.PressureSource } source
   * @param { ?mojoBase.mojom.UnguessableToken } token
   * @param { !Object } client
   * @return {!Promise<{
        result: !device.mojom.PressureManagerAddClientResult,
   *  }>}
   */

  addClient(
      source,
      token,
      client) {
    return this.proxy.sendMessage(
        3,
        device.mojom.PressureManager_AddClient_ParamsSpec.$,
        device.mojom.PressureManager_AddClient_ResponseParamsSpec.$,
        [
          source,
          token,
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PressureManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.PressureManagerReceiver = class {
  /**
   * @param {!device.mojom.PressureManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.PressureManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.PressureManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.PressureManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.PressureManager_AddVirtualPressureSource_ParamsSpec.$,
        device.mojom.PressureManager_AddVirtualPressureSource_ResponseParamsSpec.$,
        impl.addVirtualPressureSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.PressureManager_RemoveVirtualPressureSource_ParamsSpec.$,
        device.mojom.PressureManager_RemoveVirtualPressureSource_ResponseParamsSpec.$,
        impl.removeVirtualPressureSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.PressureManager_UpdateVirtualPressureSourceData_ParamsSpec.$,
        device.mojom.PressureManager_UpdateVirtualPressureSourceData_ResponseParamsSpec.$,
        impl.updateVirtualPressureSourceData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.PressureManager_AddClient_ParamsSpec.$,
        device.mojom.PressureManager_AddClient_ResponseParamsSpec.$,
        impl.addClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.PressureManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.PressureManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.PressureManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.PressureManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PressureManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.PressureManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.PressureManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.PressureManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addVirtualPressureSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.PressureManager_AddVirtualPressureSource_ParamsSpec.$,
        device.mojom.PressureManager_AddVirtualPressureSource_ResponseParamsSpec.$,
        this.addVirtualPressureSource.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeVirtualPressureSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.PressureManager_RemoveVirtualPressureSource_ParamsSpec.$,
        device.mojom.PressureManager_RemoveVirtualPressureSource_ResponseParamsSpec.$,
        this.removeVirtualPressureSource.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateVirtualPressureSourceData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.PressureManager_UpdateVirtualPressureSourceData_ParamsSpec.$,
        device.mojom.PressureManager_UpdateVirtualPressureSourceData_ResponseParamsSpec.$,
        this.updateVirtualPressureSourceData.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.PressureManager_AddClient_ParamsSpec.$,
        device.mojom.PressureManager_AddClient_ResponseParamsSpec.$,
        this.addClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.PressureClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.PressureClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.PressureClientInterface }
 */
device.mojom.PressureClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.PressureClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.PressureClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.PressureClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.PressureUpdate } update
   */

  onPressureUpdated(
      update) {
    this.proxy.sendMessage(
        0,
        device.mojom.PressureClient_OnPressureUpdated_ParamsSpec.$,
        null,
        [
          update
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PressureClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.PressureClientReceiver = class {
  /**
   * @param {!device.mojom.PressureClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.PressureClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.PressureClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.PressureClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.PressureClient_OnPressureUpdated_ParamsSpec.$,
        null,
        impl.onPressureUpdated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.PressureClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.PressureClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.PressureClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.PressureClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PressureClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.PressureClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.PressureClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.PressureClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPressureUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.PressureClient_OnPressureUpdated_ParamsSpec.$,
        null,
        this.onPressureUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.VirtualPressureSourceMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.PressureManager_AddVirtualPressureSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.PressureManager_AddVirtualPressureSource_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.PressureManager_RemoveVirtualPressureSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.PressureManager_RemoveVirtualPressureSource_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.PressureManager_UpdateVirtualPressureSourceData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.PressureManager_UpdateVirtualPressureSourceData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.PressureManager_AddClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.PressureManager_AddClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.PressureClient_OnPressureUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.VirtualPressureSourceMetadataSpec.$,
    'VirtualPressureSourceMetadata',
    [
      mojo.internal.StructField(
        'available', 0,
        0,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.VirtualPressureSourceMetadata = class {
  constructor() {
    /** @export { !boolean } */
    this.available;
  }
};



mojo.internal.Struct(
    device.mojom.PressureManager_AddVirtualPressureSource_ParamsSpec.$,
    'PressureManager_AddVirtualPressureSource_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        device.mojom.PressureSourceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metadata', 16,
        0,
        device.mojom.VirtualPressureSourceMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
device.mojom.PressureManager_AddVirtualPressureSource_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.token;
    /** @export { !device.mojom.PressureSource } */
    this.source;
    /** @export { !device.mojom.VirtualPressureSourceMetadata } */
    this.metadata;
  }
};



mojo.internal.Struct(
    device.mojom.PressureManager_AddVirtualPressureSource_ResponseParamsSpec.$,
    'PressureManager_AddVirtualPressureSource_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.PressureManager_AddVirtualPressureSource_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.PressureManager_RemoveVirtualPressureSource_ParamsSpec.$,
    'PressureManager_RemoveVirtualPressureSource_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        device.mojom.PressureSourceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
device.mojom.PressureManager_RemoveVirtualPressureSource_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.token;
    /** @export { !device.mojom.PressureSource } */
    this.source;
  }
};



mojo.internal.Struct(
    device.mojom.PressureManager_RemoveVirtualPressureSource_ResponseParamsSpec.$,
    'PressureManager_RemoveVirtualPressureSource_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.PressureManager_RemoveVirtualPressureSource_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.PressureManager_UpdateVirtualPressureSourceData_ParamsSpec.$,
    'PressureManager_UpdateVirtualPressureSourceData_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        device.mojom.PressureSourceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'state', 12,
        0,
        device.mojom.PressureStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ownContributionEstimate', 16,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
device.mojom.PressureManager_UpdateVirtualPressureSourceData_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.token;
    /** @export { !device.mojom.PressureSource } */
    this.source;
    /** @export { !device.mojom.PressureState } */
    this.state;
    /** @export { !number } */
    this.ownContributionEstimate;
  }
};



mojo.internal.Struct(
    device.mojom.PressureManager_UpdateVirtualPressureSourceData_ResponseParamsSpec.$,
    'PressureManager_UpdateVirtualPressureSourceData_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.PressureManager_UpdateVirtualPressureSourceData_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.PressureManager_AddClient_ParamsSpec.$,
    'PressureManager_AddClient_Params',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        device.mojom.PressureSourceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'token', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 16,
        0,
        mojo.internal.AssociatedInterfaceProxy(device.mojom.PressureClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
device.mojom.PressureManager_AddClient_Params = class {
  constructor() {
    /** @export { !device.mojom.PressureSource } */
    this.source;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.token;
    /** @export { !Object } */
    this.client;
  }
};



mojo.internal.Struct(
    device.mojom.PressureManager_AddClient_ResponseParamsSpec.$,
    'PressureManager_AddClient_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.PressureManagerAddClientResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.PressureManager_AddClient_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.PressureManagerAddClientResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.PressureClient_OnPressureUpdated_ParamsSpec.$,
    'PressureClient_OnPressureUpdated_Params',
    [
      mojo.internal.StructField(
        'update', 0,
        0,
        device.mojom.PressureUpdateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.PressureClient_OnPressureUpdated_Params = class {
  constructor() {
    /** @export { !device.mojom.PressureUpdate } */
    this.update;
  }
};

