// services/device/public/mojom/pressure_manager.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_PRESSURE_MANAGER_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_PRESSURE_MANAGER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/pressure_manager.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/pressure_manager.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/pressure_manager.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/device/public/mojom/pressure_update.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {

class PressureManagerProxy;

template <typename ImplRefTraits>
class PressureManagerStub;

class PressureManagerRequestValidator;
class PressureManagerResponseValidator;


class BLINK_PLATFORM_EXPORT PressureManager
    : public PressureManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.PressureManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PressureManagerInterfaceBase;
  using Proxy_ = PressureManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PressureManagerStub<ImplRefTraits>;

  using RequestValidator_ = PressureManagerRequestValidator;
  using ResponseValidator_ = PressureManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAddVirtualPressureSourceMinVersion = 0,
    kRemoveVirtualPressureSourceMinVersion = 0,
    kUpdateVirtualPressureSourceDataMinVersion = 0,
    kAddClientMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddVirtualPressureSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveVirtualPressureSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateVirtualPressureSourceData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PressureManager() = default;

  using AddVirtualPressureSourceCallback = base::OnceCallback<void()>;
  using AddVirtualPressureSourceMojoCallback = base::OnceCallback<void()>;

  virtual void AddVirtualPressureSource(const ::base::UnguessableToken& token, ::device::mojom::blink::PressureSource source, VirtualPressureSourceMetadataPtr metadata, AddVirtualPressureSourceCallback callback) = 0;

  using RemoveVirtualPressureSourceCallback = base::OnceCallback<void()>;
  using RemoveVirtualPressureSourceMojoCallback = base::OnceCallback<void()>;

  virtual void RemoveVirtualPressureSource(const ::base::UnguessableToken& token, ::device::mojom::blink::PressureSource source, RemoveVirtualPressureSourceCallback callback) = 0;

  using UpdateVirtualPressureSourceDataCallback = base::OnceCallback<void()>;
  using UpdateVirtualPressureSourceDataMojoCallback = base::OnceCallback<void()>;

  virtual void UpdateVirtualPressureSourceData(const ::base::UnguessableToken& token, ::device::mojom::blink::PressureSource source, ::device::mojom::blink::PressureState state, double own_contribution_estimate, UpdateVirtualPressureSourceDataCallback callback) = 0;

  using AddClientCallback = base::OnceCallback<void(PressureManagerAddClientResult)>;
  using AddClientMojoCallback = base::OnceCallback<void(PressureManagerAddClientResult)>;

  virtual void AddClient(::device::mojom::blink::PressureSource source, const std::optional<::base::UnguessableToken>& token, ::mojo::PendingAssociatedRemote<PressureClient> client, AddClientCallback callback) = 0;
};

class PressureClientProxy;

template <typename ImplRefTraits>
class PressureClientStub;

class PressureClientRequestValidator;


class BLINK_PLATFORM_EXPORT PressureClient
    : public PressureClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.PressureClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PressureClientInterfaceBase;
  using Proxy_ = PressureClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = PressureClientStub<ImplRefTraits>;

  using RequestValidator_ = PressureClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnPressureUpdatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnPressureUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PressureClient() = default;

  virtual void OnPressureUpdated(::device::mojom::blink::PressureUpdatePtr update) = 0;
};



class BLINK_PLATFORM_EXPORT PressureManagerProxy
    : public PressureManager {
 public:
  using InterfaceType = PressureManager;

  explicit PressureManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddVirtualPressureSource(const ::base::UnguessableToken& token, ::device::mojom::blink::PressureSource source, VirtualPressureSourceMetadataPtr metadata, AddVirtualPressureSourceCallback callback) final;
  
  void RemoveVirtualPressureSource(const ::base::UnguessableToken& token, ::device::mojom::blink::PressureSource source, RemoveVirtualPressureSourceCallback callback) final;
  
  void UpdateVirtualPressureSourceData(const ::base::UnguessableToken& token, ::device::mojom::blink::PressureSource source, ::device::mojom::blink::PressureState state, double own_contribution_estimate, UpdateVirtualPressureSourceDataCallback callback) final;
  
  void AddClient(::device::mojom::blink::PressureSource source, const std::optional<::base::UnguessableToken>& token, ::mojo::PendingAssociatedRemote<PressureClient> client, AddClientCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT PressureClientProxy
    : public PressureClient {
 public:
  using InterfaceType = PressureClient;

  explicit PressureClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPressureUpdated(::device::mojom::blink::PressureUpdatePtr update) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT PressureManagerStubDispatch {
 public:
  static bool Accept(PressureManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PressureManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PressureManager>>
class PressureManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PressureManagerStub() = default;
  ~PressureManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PressureManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PressureManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT PressureClientStubDispatch {
 public:
  static bool Accept(PressureClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PressureClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PressureClient>>
class PressureClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PressureClientStub() = default;
  ~PressureClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PressureClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PressureClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT PressureManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT PressureClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT PressureManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_PLATFORM_EXPORT VirtualPressureSourceMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VirtualPressureSourceMetadata, T>::value>;
  using DataView = VirtualPressureSourceMetadataDataView;
  using Data_ = internal::VirtualPressureSourceMetadata_Data;

  template <typename... Args>
  static VirtualPressureSourceMetadataPtr New(Args&&... args) {
    return VirtualPressureSourceMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VirtualPressureSourceMetadataPtr From(const U& u) {
    return mojo::TypeConverter<VirtualPressureSourceMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VirtualPressureSourceMetadata>::Convert(*this);
  }


  VirtualPressureSourceMetadata();

  explicit VirtualPressureSourceMetadata(
      bool available);


  ~VirtualPressureSourceMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VirtualPressureSourceMetadataPtr>
  VirtualPressureSourceMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VirtualPressureSourceMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VirtualPressureSourceMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VirtualPressureSourceMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VirtualPressureSourceMetadata::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VirtualPressureSourceMetadata::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VirtualPressureSourceMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VirtualPressureSourceMetadata_UnserializedMessageContext<
            UserType, VirtualPressureSourceMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VirtualPressureSourceMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VirtualPressureSourceMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VirtualPressureSourceMetadata_UnserializedMessageContext<
            UserType, VirtualPressureSourceMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VirtualPressureSourceMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool available;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VirtualPressureSourceMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VirtualPressureSourceMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VirtualPressureSourceMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VirtualPressureSourceMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
VirtualPressureSourceMetadataPtr VirtualPressureSourceMetadata::Clone() const {
  return New(
      mojo::Clone(available)
  );
}

template <typename T, VirtualPressureSourceMetadata::EnableIfSame<T>*>
bool VirtualPressureSourceMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->available, other_struct.available))
    return false;
  return true;
}

template <typename T, VirtualPressureSourceMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.available < rhs.available)
    return true;
  if (rhs.available < lhs.available)
    return false;
  return false;
}


}  // device::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::VirtualPressureSourceMetadata::DataView,
                                         ::device::mojom::blink::VirtualPressureSourceMetadataPtr> {
  static bool IsNull(const ::device::mojom::blink::VirtualPressureSourceMetadataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::VirtualPressureSourceMetadataPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::VirtualPressureSourceMetadata::available) available(
      const ::device::mojom::blink::VirtualPressureSourceMetadataPtr& input) {
    return input->available;
  }

  static bool Read(::device::mojom::blink::VirtualPressureSourceMetadata::DataView input, ::device::mojom::blink::VirtualPressureSourceMetadataPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_PRESSURE_MANAGER_MOJOM_BLINK_H_